/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataOutput;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.models.AdminRoles;
import org.keycloak.representations.KeyStoreConfig;
import org.keycloak.representations.idm.AuthenticationExecutionInfoRepresentation;
import org.keycloak.representations.idm.AuthenticationExecutionRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.AuthenticatorConfigRepresentation;
import org.keycloak.representations.idm.ClientInitialAccessCreatePresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientTemplateRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.IdentityProviderMapperRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.PartialImportRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmEventsConfigRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderSimpleRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserFederationMapperRepresentation;
import org.keycloak.representations.idm.UserFederationProviderRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.services.resources.admin.RealmAuth;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.AuthServerTestEnricher;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.CredentialBuilder;
import org.keycloak.testsuite.util.FederatedIdentityBuilder;
import org.keycloak.testsuite.util.GreenMailRule;
import org.keycloak.testsuite.util.IdentityProviderBuilder;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.UserBuilder;

public class PermissionsTest
extends AbstractKeycloakTest {
    private static final String REALM_NAME = "permissions-test";
    private Map<String, Keycloak> clients = new HashMap<String, Keycloak>();
    @Rule
    public GreenMailRule greenMailRule = new GreenMailRule();

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmBuilder builder = RealmBuilder.create().name(REALM_NAME).testMail();
        builder.client(ClientBuilder.create().clientId("test-client").publicClient().directAccessGrants());
        builder.user(UserBuilder.create().username(AdminRoles.REALM_ADMIN).role("realm-management", AdminRoles.REALM_ADMIN).addPassword("password"));
        this.clients.put(AdminRoles.REALM_ADMIN, Keycloak.getInstance((String)(AuthServerTestEnricher.getAuthServerContextRoot() + "/auth"), (String)REALM_NAME, (String)AdminRoles.REALM_ADMIN, (String)"password", (String)"test-client", (String)"secret"));
        builder.user(UserBuilder.create().username("none").addPassword("password"));
        this.clients.put("none", Keycloak.getInstance((String)(AuthServerTestEnricher.getAuthServerContextRoot() + "/auth"), (String)REALM_NAME, (String)"none", (String)"password", (String)"test-client", (String)"secret"));
        for (String role : AdminRoles.ALL_REALM_ROLES) {
            builder.user(UserBuilder.create().username(role).role("realm-management", role).addPassword("password"));
            this.clients.put(role, Keycloak.getInstance((String)(AuthServerTestEnricher.getAuthServerContextRoot() + "/auth"), (String)REALM_NAME, (String)role, (String)"password", (String)"test-client"));
        }
        testRealms.add(builder.build());
        RealmBuilder builder2 = RealmBuilder.create().name("realm2");
        builder2.client(ClientBuilder.create().clientId("test-client").publicClient().directAccessGrants());
        builder2.user(UserBuilder.create().username("admin").role("realm-management", AdminRoles.REALM_ADMIN).addPassword("password"));
        testRealms.add(builder2.build());
        this.clients.put("REALM2", Keycloak.getInstance((String)(AuthServerTestEnricher.getAuthServerContextRoot() + "/auth"), (String)"realm2", (String)"admin", (String)"password", (String)"test-client"));
    }

    @Override
    public void beforeAbstractKeycloakTest() throws Exception {
        super.beforeAbstractKeycloakTest();
        this.clients.put("master-admin", this.adminClient);
        RealmResource master = this.adminClient.realm("master");
        Response response = master.users().create(UserBuilder.create().username("permissions-test-master-none").build());
        String userId = ApiUtil.getCreatedId(response);
        response.close();
        master.users().get(userId).resetPassword(CredentialBuilder.create().password("password").build());
        this.clients.put("master-none", Keycloak.getInstance((String)(AuthServerTestEnricher.getAuthServerContextRoot() + "/auth"), (String)"master", (String)"permissions-test-master-none", (String)"password", (String)"admin-cli"));
        for (String role : AdminRoles.ALL_REALM_ROLES) {
            Response response2 = master.users().create(UserBuilder.create().username("permissions-test-master-" + role).build());
            String userId2 = ApiUtil.getCreatedId(response2);
            response2.close();
            master.users().get(userId2).resetPassword(CredentialBuilder.create().password("password").build());
            String clientId = ((ClientRepresentation)master.clients().findByClientId("permissions-test-realm").get(0)).getId();
            RoleRepresentation roleRep = master.clients().get(clientId).roles().get(role).toRepresentation();
            master.users().get(userId2).roles().clientLevel(clientId).add(Collections.singletonList(roleRep));
            this.clients.put("master-" + role, Keycloak.getInstance((String)(AuthServerTestEnricher.getAuthServerContextRoot() + "/auth"), (String)"master", (String)("permissions-test-master-" + role), (String)"password", (String)"admin-cli"));
        }
    }

    @Override
    public void afterAbstractKeycloakTest() {
        for (UserRepresentation u : this.adminClient.realm("master").users().search("permissions-test-master-", Integer.valueOf(0), Integer.valueOf(100))) {
            this.adminClient.realm("master").users().get(u.getId()).remove();
        }
        super.afterAbstractKeycloakTest();
    }

    @Test
    public void realms() {
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                ((Keycloak)PermissionsTest.this.clients.get("master-none")).realms().findAll();
            }
        }, this.clients.get("none"), false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                ((Keycloak)PermissionsTest.this.clients.get("none")).realms().findAll();
            }
        }, this.clients.get("none"), false);
        Assert.assertNames(this.clients.get("master-admin").realms().findAll(), "master", REALM_NAME, "realm2");
        Assert.assertNames(this.clients.get(AdminRoles.REALM_ADMIN).realms().findAll(), REALM_NAME);
        Assert.assertNames(this.clients.get("REALM2").realms().findAll(), "realm2");
        List realms = this.clients.get(AdminRoles.VIEW_USERS).realms().findAll();
        Assert.assertNames(realms, REALM_NAME);
        this.assertGettersEmpty((RealmRepresentation)realms.get(0));
        realms = this.clients.get(AdminRoles.VIEW_REALM).realms().findAll();
        Assert.assertNames(realms, REALM_NAME);
        org.junit.Assert.assertNotNull((Object)((RealmRepresentation)realms.get(0)).getAccessTokenLifespan());
        realms = this.clients.get("master-" + AdminRoles.VIEW_USERS).realms().findAll();
        Assert.assertNames(realms, REALM_NAME);
        this.assertGettersEmpty((RealmRepresentation)realms.get(0));
        realms = this.clients.get("master-" + AdminRoles.VIEW_REALM).realms().findAll();
        Assert.assertNames(realms, REALM_NAME);
        org.junit.Assert.assertNotNull((Object)((RealmRepresentation)realms.get(0)).getAccessTokenLifespan());
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                ((Keycloak)PermissionsTest.this.clients.get("master-admin")).realms().create(RealmBuilder.create().name("master").build());
            }
        }, this.adminClient, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                ((Keycloak)PermissionsTest.this.clients.get("master-" + AdminRoles.MANAGE_USERS)).realms().create(RealmBuilder.create().name("master").build());
            }
        }, this.adminClient, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                ((Keycloak)PermissionsTest.this.clients.get(AdminRoles.REALM_ADMIN)).realms().create(RealmBuilder.create().name("master").build());
            }
        }, this.adminClient, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.toRepresentation();
            }
        }, RealmAuth.Resource.REALM, false, true);
        this.assertGettersEmpty(this.clients.get(AdminRoles.VIEW_USERS).realm(REALM_NAME).toRepresentation());
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.update(new RealmRepresentation());
            }
        }, RealmAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.pushRevocation();
            }
        }, RealmAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.deleteSession("nosuch");
            }
        }, RealmAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.getClientSessionStats();
            }
        }, RealmAuth.Resource.REALM, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.getDefaultGroups();
            }
        }, RealmAuth.Resource.REALM, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.addDefaultGroup("nosuch");
            }
        }, RealmAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.removeDefaultGroup("nosuch");
            }
        }, RealmAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.getGroupByPath("nosuch");
            }
        }, RealmAuth.Resource.REALM, false);
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                response.set(realm.testLDAPConnection("nosuch", "nosuch", "nosuch", "nosuch", "nosuch"));
            }
        }, RealmAuth.Resource.REALM, true);
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                response.set(realm.partialImport(new PartialImportRepresentation()));
            }
        }, RealmAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clearRealmCache();
            }
        }, RealmAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clearUserCache();
            }
        }, RealmAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                ((Keycloak)PermissionsTest.this.clients.get("master-admin")).realms().realm("nosuch").remove();
            }
        }, this.adminClient, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                ((Keycloak)PermissionsTest.this.clients.get("REALM2")).realms().realm(PermissionsTest.REALM_NAME).remove();
            }
        }, this.adminClient, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                ((Keycloak)PermissionsTest.this.clients.get(AdminRoles.MANAGE_USERS)).realms().realm(PermissionsTest.REALM_NAME).remove();
            }
        }, this.adminClient, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                ((Keycloak)PermissionsTest.this.clients.get(AdminRoles.REALM_ADMIN)).realms().realm(PermissionsTest.REALM_NAME).remove();
            }
        }, this.adminClient, true);
    }

    @Test
    public void realmLogoutAll() {
        Invocation invocation = new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.logoutAll();
            }
        };
        this.invoke(invocation, this.clients.get("master-none"), false);
        this.invoke(invocation, this.clients.get("master-view-realm"), false);
        this.invoke(invocation, this.clients.get("REALM2"), false);
        this.invoke(invocation, this.clients.get("none"), false);
        this.invoke(invocation, this.clients.get("view-users"), false);
        this.invoke(invocation, this.clients.get("manage-realm"), false);
        this.invoke(invocation, this.clients.get("master-manage-realm"), false);
        this.invoke(invocation, this.clients.get("manage-users"), true);
        this.invoke(invocation, this.clients.get("master-manage-users"), true);
    }

    @Test
    public void events() {
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.getRealmEventsConfig();
            }
        }, RealmAuth.Resource.EVENTS, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.updateRealmEventsConfig(new RealmEventsConfigRepresentation());
            }
        }, RealmAuth.Resource.EVENTS, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.getEvents();
            }
        }, RealmAuth.Resource.EVENTS, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.getAdminEvents();
            }
        }, RealmAuth.Resource.EVENTS, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clearEvents();
            }
        }, RealmAuth.Resource.EVENTS, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clearAdminEvents();
            }
        }, RealmAuth.Resource.EVENTS, true);
    }

    @Test
    public void attackDetection() {
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.attackDetection().bruteForceUserStatus("nosuch");
            }
        }, RealmAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.attackDetection().clearBruteForceForUser("nosuch");
            }
        }, RealmAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.attackDetection().clearAllBruteForce();
            }
        }, RealmAuth.Resource.USER, true);
    }

    @Test
    public void clients() {
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().findAll();
            }
        }, RealmAuth.Resource.CLIENT, false, true);
        List l = this.clients.get(AdminRoles.VIEW_USERS).realm(REALM_NAME).clients().findAll();
        this.assertGettersEmpty((ClientRepresentation)l.get(0));
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.convertClientDescription("blahblah");
            }
        }, RealmAuth.Resource.CLIENT, true);
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                response.set(realm.clients().create(ClientBuilder.create().clientId("foo").build()));
            }
        }, RealmAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").toRepresentation();
            }
        }, RealmAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").getInstallationProvider("nosuch");
            }
        }, RealmAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").update(new ClientRepresentation());
            }
        }, RealmAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").remove();
            }
        }, RealmAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").generateNewSecret();
            }
        }, RealmAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").regenerateRegistrationAccessToken();
            }
        }, RealmAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").getSecret();
            }
        }, RealmAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").getServiceAccountUser();
            }
        }, RealmAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").pushRevocation();
            }
        }, RealmAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").getApplicationSessionCount();
            }
        }, RealmAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").getUserSessions(Integer.valueOf(0), Integer.valueOf(100));
            }
        }, RealmAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").getOfflineSessionCount();
            }
        }, RealmAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").getOfflineUserSessions(Integer.valueOf(0), Integer.valueOf(100));
            }
        }, RealmAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").registerNode(Collections.emptyMap());
            }
        }, RealmAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").unregisterNode("nosuch");
            }
        }, RealmAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").testNodesAvailable();
            }
        }, RealmAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").getCertficateResource("nosuch").generate();
            }
        }, RealmAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").getCertficateResource("nosuch").generateAndGetKeystore(new KeyStoreConfig());
            }
        }, RealmAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").getCertficateResource("nosuch").getKeyInfo();
            }
        }, RealmAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").getCertficateResource("nosuch").getKeystore(new KeyStoreConfig());
            }
        }, RealmAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").getCertficateResource("nosuch").uploadJks(new MultipartFormDataOutput());
            }
        }, RealmAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").getCertficateResource("nosuch").uploadJksCertificate(new MultipartFormDataOutput());
            }
        }, RealmAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").getProtocolMappers().createMapper(Collections.EMPTY_LIST);
            }
        }, RealmAuth.Resource.CLIENT, true);
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                response.set(realm.clients().get("nosuch").getProtocolMappers().createMapper(new ProtocolMapperRepresentation()));
            }
        }, RealmAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").getProtocolMappers().getMapperById("nosuch");
            }
        }, RealmAuth.Resource.CLIENT, false, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").getProtocolMappers().getMappers();
            }
        }, RealmAuth.Resource.CLIENT, false, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").getProtocolMappers().getMappersPerProtocol("nosuch");
            }
        }, RealmAuth.Resource.CLIENT, false, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").getProtocolMappers().update("nosuch", new ProtocolMapperRepresentation());
            }
        }, RealmAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").getProtocolMappers().delete("nosuch");
            }
        }, RealmAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").getScopeMappings().getAll();
            }
        }, RealmAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").getScopeMappings().realmLevel().listAll();
            }
        }, RealmAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").getScopeMappings().realmLevel().listEffective();
            }
        }, RealmAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").getScopeMappings().realmLevel().listAvailable();
            }
        }, RealmAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").getScopeMappings().realmLevel().add(Collections.emptyList());
            }
        }, RealmAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").getScopeMappings().realmLevel().remove(Collections.emptyList());
            }
        }, RealmAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").roles().list();
            }
        }, RealmAuth.Resource.CLIENT, false, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").roles().create(new RoleRepresentation());
            }
        }, RealmAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").roles().get("nosuch").toRepresentation();
            }
        }, RealmAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").roles().deleteRole("nosuch");
            }
        }, RealmAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").roles().get("nosuch").update(new RoleRepresentation());
            }
        }, RealmAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").roles().get("nosuch").addComposites(Collections.emptyList());
            }
        }, RealmAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").roles().get("nosuch").deleteComposites(Collections.emptyList());
            }
        }, RealmAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").roles().get("nosuch").getRoleComposites();
            }
        }, RealmAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").roles().get("nosuch").getRealmRoleComposites();
            }
        }, RealmAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get("nosuch").roles().get("nosuch").getClientRoleComposites("nosuch");
            }
        }, RealmAuth.Resource.CLIENT, false);
    }

    @Test
    public void clientTemplates() {
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clientTemplates().findAll();
            }
        }, RealmAuth.Resource.CLIENT, false);
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                response.set(realm.clientTemplates().create(new ClientTemplateRepresentation()));
            }
        }, RealmAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clientTemplates().get("nosuch").toRepresentation();
            }
        }, RealmAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clientTemplates().get("nosuch").update(new ClientTemplateRepresentation());
            }
        }, RealmAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clientTemplates().get("nosuch").remove();
            }
        }, RealmAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clientTemplates().get("nosuch").getProtocolMappers().getMappers();
            }
        }, RealmAuth.Resource.CLIENT, false, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clientTemplates().get("nosuch").getProtocolMappers().getMappersPerProtocol("nosuch");
            }
        }, RealmAuth.Resource.CLIENT, false, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clientTemplates().get("nosuch").getProtocolMappers().getMapperById("nosuch");
            }
        }, RealmAuth.Resource.CLIENT, false, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clientTemplates().get("nosuch").getProtocolMappers().update("nosuch", new ProtocolMapperRepresentation());
            }
        }, RealmAuth.Resource.CLIENT, true);
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                response.set(realm.clientTemplates().get("nosuch").getProtocolMappers().createMapper(new ProtocolMapperRepresentation()));
            }
        }, RealmAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clientTemplates().get("nosuch").getProtocolMappers().createMapper(Collections.emptyList());
            }
        }, RealmAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clientTemplates().get("nosuch").getProtocolMappers().delete("nosuch");
            }
        }, RealmAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clientTemplates().get("nosuch").getScopeMappings().getAll();
            }
        }, RealmAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clientTemplates().get("nosuch").getScopeMappings().realmLevel().listAll();
            }
        }, RealmAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clientTemplates().get("nosuch").getScopeMappings().realmLevel().listAvailable();
            }
        }, RealmAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clientTemplates().get("nosuch").getScopeMappings().realmLevel().listEffective();
            }
        }, RealmAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clientTemplates().get("nosuch").getScopeMappings().realmLevel().add(Collections.emptyList());
            }
        }, RealmAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clientTemplates().get("nosuch").getScopeMappings().realmLevel().remove(Collections.emptyList());
            }
        }, RealmAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clientTemplates().get("nosuch").getScopeMappings().clientLevel("nosuch").listAll();
            }
        }, RealmAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clientTemplates().get("nosuch").getScopeMappings().clientLevel("nosuch").listAvailable();
            }
        }, RealmAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clientTemplates().get("nosuch").getScopeMappings().clientLevel("nosuch").listEffective();
            }
        }, RealmAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clientTemplates().get("nosuch").getScopeMappings().clientLevel("nosuch").add(Collections.emptyList());
            }
        }, RealmAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clientTemplates().get("nosuch").getScopeMappings().clientLevel("nosuch").remove(Collections.emptyList());
            }
        }, RealmAuth.Resource.CLIENT, true);
    }

    @Test
    public void clientInitialAccess() {
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clientInitialAccess().list();
            }
        }, RealmAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clientInitialAccess().create(new ClientInitialAccessCreatePresentation());
            }
        }, RealmAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clientInitialAccess().delete("nosuch");
            }
        }, RealmAuth.Resource.CLIENT, true);
    }

    @Test
    public void roles() {
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.roles().list();
            }
        }, RealmAuth.Resource.REALM, false, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.roles().get("nosuch").toRepresentation();
            }
        }, RealmAuth.Resource.REALM, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.roles().get("nosuch").update(new RoleRepresentation());
            }
        }, RealmAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.roles().create(new RoleRepresentation());
            }
        }, RealmAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.roles().deleteRole("nosuch");
            }
        }, RealmAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.roles().get("nosuch").getRoleComposites();
            }
        }, RealmAuth.Resource.REALM, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.roles().get("nosuch").addComposites(Collections.emptyList());
            }
        }, RealmAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.roles().get("nosuch").deleteComposites(Collections.emptyList());
            }
        }, RealmAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.roles().get("nosuch").getRoleComposites();
            }
        }, RealmAuth.Resource.REALM, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.roles().get("nosuch").getRealmRoleComposites();
            }
        }, RealmAuth.Resource.REALM, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.roles().get("nosuch").getClientRoleComposites("nosuch");
            }
        }, RealmAuth.Resource.REALM, false);
    }

    @Test
    public void flows() {
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().getFormProviders();
            }
        }, RealmAuth.Resource.REALM, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().getAuthenticatorProviders();
            }
        }, RealmAuth.Resource.REALM, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().getClientAuthenticatorProviders();
            }
        }, RealmAuth.Resource.REALM, false, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().getFormActionProviders();
            }
        }, RealmAuth.Resource.REALM, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().getFlows();
            }
        }, RealmAuth.Resource.REALM, false, true);
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                response.set(realm.flows().createFlow(new AuthenticationFlowRepresentation()));
            }
        }, RealmAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().getFlow("nosuch");
            }
        }, RealmAuth.Resource.REALM, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().deleteFlow("nosuch");
            }
        }, RealmAuth.Resource.REALM, true);
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                response.set(realm.flows().copy("nosuch", Collections.emptyMap()));
            }
        }, RealmAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().addExecutionFlow("nosuch", Collections.emptyMap());
            }
        }, RealmAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().addExecution("nosuch", Collections.emptyMap());
            }
        }, RealmAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().getExecutions("nosuch");
            }
        }, RealmAuth.Resource.REALM, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().updateExecutions("nosuch", new AuthenticationExecutionInfoRepresentation());
            }
        }, RealmAuth.Resource.REALM, true);
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                AuthenticationExecutionRepresentation rep = new AuthenticationExecutionRepresentation();
                rep.setAuthenticator("auth-cookie");
                rep.setRequirement("OPTIONAL");
                response.set(realm.flows().addExecution(rep));
            }
        }, RealmAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().raisePriority("nosuch");
            }
        }, RealmAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().lowerPriority("nosuch");
            }
        }, RealmAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().removeExecution("nosuch");
            }
        }, RealmAuth.Resource.REALM, true);
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                response.set(realm.flows().newExecutionConfig("nosuch", new AuthenticatorConfigRepresentation()));
            }
        }, RealmAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().getAuthenticatorConfig("nosuch");
            }
        }, RealmAuth.Resource.REALM, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().getUnregisteredRequiredActions();
            }
        }, RealmAuth.Resource.REALM, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().registerRequiredAction(new RequiredActionProviderSimpleRepresentation());
            }
        }, RealmAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().getRequiredActions();
            }
        }, RealmAuth.Resource.REALM, false, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().getRequiredAction("nosuch");
            }
        }, RealmAuth.Resource.REALM, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().removeRequiredAction("nosuch");
            }
        }, RealmAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().updateRequiredAction("nosuch", new RequiredActionProviderRepresentation());
            }
        }, RealmAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().getAuthenticatorConfigDescription("nosuch");
            }
        }, RealmAuth.Resource.REALM, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().getPerClientConfigDescription();
            }
        }, RealmAuth.Resource.REALM, false, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().getAuthenticatorConfig("nosuch");
            }
        }, RealmAuth.Resource.REALM, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().removeAuthenticatorConfig("nosuch");
            }
        }, RealmAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().updateAuthenticatorConfig("nosuch", new AuthenticatorConfigRepresentation());
            }
        }, RealmAuth.Resource.REALM, true);
    }

    @Test
    public void rolesById() {
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.rolesById().getRole("nosuch");
            }
        }, RealmAuth.Resource.REALM, false, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.rolesById().updateRole("nosuch", new RoleRepresentation());
            }
        }, RealmAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.rolesById().deleteRole("nosuch");
            }
        }, RealmAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.rolesById().getRoleComposites("nosuch");
            }
        }, RealmAuth.Resource.REALM, false, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.rolesById().addComposites("nosuch", Collections.emptyList());
            }
        }, RealmAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.rolesById().deleteComposites("nosuch", Collections.emptyList());
            }
        }, RealmAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.rolesById().getRoleComposites("nosuch");
            }
        }, RealmAuth.Resource.REALM, false, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.rolesById().getRealmRoleComposites("nosuch");
            }
        }, RealmAuth.Resource.REALM, false, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.rolesById().getClientRoleComposites("nosuch", "nosuch");
            }
        }, RealmAuth.Resource.REALM, false, true);
    }

    @Test
    public void groups() {
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.groups().groups();
            }
        }, RealmAuth.Resource.USER, false);
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                response.set(realm.groups().add(new GroupRepresentation()));
            }
        }, RealmAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.groups().group("nosuch").toRepresentation();
            }
        }, RealmAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.groups().group("nosuch").update(new GroupRepresentation());
            }
        }, RealmAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.groups().group("nosuch").remove();
            }
        }, RealmAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.groups().group("nosuch").members(Integer.valueOf(0), Integer.valueOf(100));
            }
        }, RealmAuth.Resource.USER, false);
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                response.set(realm.groups().group("nosuch").subGroup(new GroupRepresentation()));
            }
        }, RealmAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.groups().group("nosuch").roles().getAll();
            }
        }, RealmAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.groups().group("nosuch").roles().realmLevel().listAll();
            }
        }, RealmAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.groups().group("nosuch").roles().realmLevel().listEffective();
            }
        }, RealmAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.groups().group("nosuch").roles().realmLevel().listAvailable();
            }
        }, RealmAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.groups().group("nosuch").roles().realmLevel().add(Collections.emptyList());
            }
        }, RealmAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.groups().group("nosuch").roles().realmLevel().remove(Collections.emptyList());
            }
        }, RealmAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.groups().group("nosuch").roles().clientLevel("nosuch").listAll();
            }
        }, RealmAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.groups().group("nosuch").roles().clientLevel("nosuch").listEffective();
            }
        }, RealmAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.groups().group("nosuch").roles().clientLevel("nosuch").listAvailable();
            }
        }, RealmAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.groups().group("nosuch").roles().clientLevel("nosuch").add(Collections.emptyList());
            }
        }, RealmAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.groups().group("nosuch").roles().clientLevel("nosuch").remove(Collections.emptyList());
            }
        }, RealmAuth.Resource.USER, true);
    }

    @Test
    public void users() {
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get("nosuch").toRepresentation();
            }
        }, RealmAuth.Resource.USER, false);
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                response.set(realm.users().create(UserBuilder.create().username("testuser").build()));
            }
        }, RealmAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get("nosuch").update(UserBuilder.create().enabled(true).build());
            }
        }, RealmAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().search("foo", Integer.valueOf(0), Integer.valueOf(1));
            }
        }, RealmAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().count();
            }
        }, RealmAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get("nosuch").getUserSessions();
            }
        }, RealmAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get("nosuch").getOfflineSessions("nosuch");
            }
        }, RealmAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get("nosuch").getFederatedIdentity();
            }
        }, RealmAuth.Resource.USER, false);
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                response.set(realm.users().get("nosuch").addFederatedIdentity("nosuch", FederatedIdentityBuilder.create().identityProvider("nosuch").userId("nosuch").userName("nosuch").build()));
            }
        }, RealmAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get("nosuch").removeFederatedIdentity("nosuch");
            }
        }, RealmAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get("nosuch").getConsents();
            }
        }, RealmAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get("nosuch").revokeConsent("testclient");
            }
        }, RealmAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get("nosuch").logout();
            }
        }, RealmAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get("nosuch").remove();
            }
        }, RealmAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get("nosuch").resetPassword(CredentialBuilder.create().password("password").build());
            }
        }, RealmAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get("nosuch").removeTotp();
            }
        }, RealmAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get("nosuch").resetPasswordEmail();
            }
        }, RealmAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get("nosuch").executeActionsEmail(Collections.emptyList());
            }
        }, RealmAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get("nosuch").sendVerifyEmail();
            }
        }, RealmAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get("nosuch").groups();
            }
        }, RealmAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get("nosuch").leaveGroup("nosuch");
            }
        }, RealmAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get("nosuch").joinGroup("nosuch");
            }
        }, RealmAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get("nosuch").roles().getAll();
            }
        }, RealmAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get("nosuch").roles().realmLevel().listAll();
            }
        }, RealmAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get("nosuch").roles().realmLevel().listAvailable();
            }
        }, RealmAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get("nosuch").roles().realmLevel().listEffective();
            }
        }, RealmAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get("nosuch").roles().realmLevel().add(Collections.emptyList());
            }
        }, RealmAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get("nosuch").roles().realmLevel().remove(Collections.emptyList());
            }
        }, RealmAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get("nosuch").roles().clientLevel("nosuch").listAll();
            }
        }, RealmAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get("nosuch").roles().clientLevel("nosuch").listAvailable();
            }
        }, RealmAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get("nosuch").roles().clientLevel("nosuch").listEffective();
            }
        }, RealmAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get("nosuch").roles().clientLevel("nosuch").add(Collections.emptyList());
            }
        }, RealmAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get("nosuch").roles().clientLevel("nosuch").remove(Collections.emptyList());
            }
        }, RealmAuth.Resource.USER, true);
    }

    @Test
    public void identityProviders() {
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.identityProviders().findAll();
            }
        }, RealmAuth.Resource.IDENTITY_PROVIDER, false);
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                response.set(realm.identityProviders().create(IdentityProviderBuilder.create().providerId("nosuch").alias("foo").build()));
            }
        }, RealmAuth.Resource.IDENTITY_PROVIDER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.identityProviders().get("nosuch").toRepresentation();
            }
        }, RealmAuth.Resource.IDENTITY_PROVIDER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.identityProviders().get("nosuch").update(new IdentityProviderRepresentation());
            }
        }, RealmAuth.Resource.IDENTITY_PROVIDER, true);
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                response.set(realm.identityProviders().get("nosuch").export("saml"));
            }
        }, RealmAuth.Resource.IDENTITY_PROVIDER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.identityProviders().get("nosuch").remove();
            }
        }, RealmAuth.Resource.IDENTITY_PROVIDER, true);
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                response.set(realm.identityProviders().get("nosuch").addMapper(new IdentityProviderMapperRepresentation()));
            }
        }, RealmAuth.Resource.IDENTITY_PROVIDER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.identityProviders().get("nosuch").delete("nosuch");
            }
        }, RealmAuth.Resource.IDENTITY_PROVIDER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.identityProviders().get("nosuch").getMappers();
            }
        }, RealmAuth.Resource.IDENTITY_PROVIDER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.identityProviders().get("nosuch").getMapperById("nosuch");
            }
        }, RealmAuth.Resource.IDENTITY_PROVIDER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.identityProviders().get("nosuch").getMapperTypes();
            }
        }, RealmAuth.Resource.IDENTITY_PROVIDER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.identityProviders().importFrom(Collections.emptyMap());
            }
        }, RealmAuth.Resource.IDENTITY_PROVIDER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.identityProviders().importFrom(new MultipartFormDataOutput());
            }
        }, RealmAuth.Resource.IDENTITY_PROVIDER, true);
    }

    @Test
    public void userFederation() {
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.userFederation().getProviderInstances();
            }
        }, RealmAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.userFederation().getProviderFactories();
            }
        }, RealmAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.userFederation().getProviderFactory("nosuch");
            }
        }, RealmAuth.Resource.USER, false);
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                UserFederationProviderRepresentation rep = new UserFederationProviderRepresentation();
                rep.setProviderName("ldap");
                response.set(realm.userFederation().create(rep));
            }
        }, RealmAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.userFederation().get("nosuch").toRepresentation();
            }
        }, RealmAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.userFederation().get("nosuch").update(new UserFederationProviderRepresentation());
            }
        }, RealmAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.userFederation().get("nosuch").remove();
            }
        }, RealmAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.userFederation().get("nosuch").syncUsers("nosuch");
            }
        }, RealmAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.userFederation().get("nosuch").getMapperTypes();
            }
        }, RealmAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.userFederation().get("nosuch").getMappers();
            }
        }, RealmAuth.Resource.USER, false);
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                response.set(realm.userFederation().get("nosuch").addMapper(new UserFederationMapperRepresentation()));
            }
        }, RealmAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.userFederation().get("nosuch").getMapperById("nosuch");
            }
        }, RealmAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.userFederation().get("nosuch").syncMapperData("nosuch", "nosuch");
            }
        }, RealmAuth.Resource.USER, true);
    }

    private void invoke(final Invocation invocation, RealmAuth.Resource resource, boolean manage) {
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                invocation.invoke(realm);
            }
        }, resource, manage);
    }

    private void invoke(final Invocation invocation, RealmAuth.Resource resource, boolean manage, boolean skipDifferentRole) {
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                invocation.invoke(realm);
            }
        }, resource, manage, skipDifferentRole);
    }

    private void invoke(InvocationWithResponse invocation, RealmAuth.Resource resource, boolean manage) {
        this.invoke(invocation, resource, manage, false);
    }

    private void invoke(InvocationWithResponse invocation, RealmAuth.Resource resource, boolean manage, boolean skipDifferentRole) {
        String viewRole = this.getViewRole(resource);
        String manageRole = this.getManageRole(resource);
        String differentViewRole = this.getDifferentViewRole(resource);
        String differentManageRole = this.getDifferentManageRole(resource);
        this.invoke(invocation, this.clients.get("master-none"), false);
        this.invoke(invocation, this.clients.get("master-admin"), true);
        this.invoke(invocation, this.clients.get("master-" + viewRole), !manage);
        this.invoke(invocation, this.clients.get("master-" + manageRole), true);
        if (!skipDifferentRole) {
            this.invoke(invocation, this.clients.get("master-" + differentViewRole), false);
            this.invoke(invocation, this.clients.get("master-" + differentManageRole), false);
        }
        this.invoke(invocation, this.clients.get("none"), false);
        this.invoke(invocation, this.clients.get(AdminRoles.REALM_ADMIN), true);
        this.invoke(invocation, this.clients.get(viewRole), !manage);
        this.invoke(invocation, this.clients.get(manageRole), true);
        if (!skipDifferentRole) {
            this.invoke(invocation, this.clients.get(differentViewRole), false);
            this.invoke(invocation, this.clients.get(differentManageRole), false);
        }
        this.invoke(invocation, this.clients.get("REALM2"), false);
    }

    private void invoke(final Invocation invocation, Keycloak client, boolean expectSuccess) {
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                invocation.invoke(realm);
            }
        }, client, expectSuccess);
    }

    private void invoke(InvocationWithResponse invocation, Keycloak client, boolean expectSuccess) {
        int statusCode;
        try {
            AtomicReference<Response> responseReference = new AtomicReference<Response>();
            invocation.invoke(client.realm(REALM_NAME), responseReference);
            Response response = responseReference.get();
            statusCode = response != null ? response.getStatus() : 200;
        }
        catch (ClientErrorException e) {
            statusCode = e.getResponse().getStatus();
        }
        if (expectSuccess) {
            if (statusCode != 200 && statusCode != 201 && statusCode != 204 && statusCode != 404 && statusCode != 409 && statusCode != 400) {
                org.junit.Assert.fail((String)("Expected permitted, but was " + statusCode));
            }
        } else if (statusCode != 403) {
            org.junit.Assert.fail((String)("Expected 403, but was " + statusCode));
        }
    }

    private String getViewRole(RealmAuth.Resource resource) {
        switch (resource) {
            case CLIENT: {
                return AdminRoles.VIEW_CLIENTS;
            }
            case USER: {
                return AdminRoles.VIEW_USERS;
            }
            case REALM: {
                return AdminRoles.VIEW_REALM;
            }
            case EVENTS: {
                return AdminRoles.VIEW_EVENTS;
            }
            case IDENTITY_PROVIDER: {
                return AdminRoles.VIEW_IDENTITY_PROVIDERS;
            }
        }
        throw new RuntimeException("Unexpected resouce");
    }

    private String getManageRole(RealmAuth.Resource resource) {
        switch (resource) {
            case CLIENT: {
                return AdminRoles.MANAGE_CLIENTS;
            }
            case USER: {
                return AdminRoles.MANAGE_USERS;
            }
            case REALM: {
                return AdminRoles.MANAGE_REALM;
            }
            case EVENTS: {
                return AdminRoles.MANAGE_EVENTS;
            }
            case IDENTITY_PROVIDER: {
                return AdminRoles.MANAGE_IDENTITY_PROVIDERS;
            }
        }
        throw new RuntimeException("Unexpected resouce");
    }

    private String getDifferentViewRole(RealmAuth.Resource resource) {
        switch (resource) {
            case CLIENT: {
                return AdminRoles.VIEW_USERS;
            }
            case USER: {
                return AdminRoles.VIEW_CLIENTS;
            }
            case REALM: {
                return AdminRoles.VIEW_EVENTS;
            }
            case EVENTS: {
                return AdminRoles.VIEW_IDENTITY_PROVIDERS;
            }
            case IDENTITY_PROVIDER: {
                return AdminRoles.VIEW_REALM;
            }
        }
        throw new RuntimeException("Unexpected resouce");
    }

    private String getDifferentManageRole(RealmAuth.Resource resource) {
        switch (resource) {
            case CLIENT: {
                return AdminRoles.MANAGE_USERS;
            }
            case USER: {
                return AdminRoles.MANAGE_CLIENTS;
            }
            case REALM: {
                return AdminRoles.MANAGE_EVENTS;
            }
            case EVENTS: {
                return AdminRoles.MANAGE_IDENTITY_PROVIDERS;
            }
            case IDENTITY_PROVIDER: {
                return AdminRoles.MANAGE_REALM;
            }
        }
        throw new RuntimeException("Unexpected resouce");
    }

    private void assertGettersEmpty(RealmRepresentation rep) {
        this.assertGettersEmpty(rep, "getRealm");
    }

    private void assertGettersEmpty(ClientRepresentation rep) {
        this.assertGettersEmpty(rep, "getId", "getClientId", "getDescription");
    }

    private void assertGettersEmpty(Object rep, String ... ignore) {
        List<String> ignoreList = Arrays.asList(ignore);
        for (Method m : rep.getClass().getDeclaredMethods()) {
            if (m.getParameters().length != 0 || !m.getName().startsWith("get") || ignoreList.contains(m.getName())) continue;
            try {
                Object o = m.invoke(rep, new Object[0]);
                org.junit.Assert.assertNull((String)("Expected " + m.getName() + " to be null"), (Object)o);
            }
            catch (Exception e) {
                org.junit.Assert.fail((String)e.getMessage());
            }
        }
    }

    public static interface InvocationWithResponse {
        public void invoke(RealmResource var1, AtomicReference<Response> var2);
    }

    public static interface Invocation {
        public void invoke(RealmResource var1);
    }
}

