/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.RoleByIdResource;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.util.AdminEventPaths;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.RoleBuilder;

public class RoleByIdResourceTest
extends AbstractAdminTest {
    private RoleByIdResource resource;
    private Map<String, String> ids = new HashMap<String, String>();
    private String clientUuid;

    @Before
    public void before() {
        this.adminClient.realm("admin-client-test").roles().create(RoleBuilder.create().name("role-a").description("Role A").build());
        this.adminClient.realm("admin-client-test").roles().create(RoleBuilder.create().name("role-b").description("Role B").build());
        Response response = this.adminClient.realm("admin-client-test").clients().create(ClientBuilder.create().clientId("client-a").build());
        this.clientUuid = ApiUtil.getCreatedId(response);
        this.adminClient.realm("admin-client-test").clients().get(this.clientUuid).roles().create(RoleBuilder.create().name("role-c").description("Role C").build());
        for (RoleRepresentation r : this.adminClient.realm("admin-client-test").roles().list()) {
            this.ids.put(r.getName(), r.getId());
        }
        for (RoleRepresentation r : this.adminClient.realm("admin-client-test").clients().get(this.clientUuid).roles().list()) {
            this.ids.put(r.getName(), r.getId());
        }
        this.resource = this.adminClient.realm("admin-client-test").rolesById();
        this.assertAdminEvents.clear();
    }

    @Test
    public void getRole() {
        RoleRepresentation role = this.resource.getRole(this.ids.get("role-a"));
        org.junit.Assert.assertNotNull((Object)role);
        org.junit.Assert.assertEquals((Object)"role-a", (Object)role.getName());
        org.junit.Assert.assertEquals((Object)"Role A", (Object)role.getDescription());
        org.junit.Assert.assertFalse((boolean)role.isComposite());
    }

    @Test
    public void updateRole() {
        RoleRepresentation role = this.resource.getRole(this.ids.get("role-a"));
        role.setName("role-a-new");
        role.setDescription("Role A New");
        this.resource.updateRole(this.ids.get("role-a"), role);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, AdminEventPaths.roleByIdResourcePath(this.ids.get("role-a")), (Object)role, ResourceType.REALM_ROLE);
        role = this.resource.getRole(this.ids.get("role-a"));
        org.junit.Assert.assertNotNull((Object)role);
        org.junit.Assert.assertEquals((Object)"role-a-new", (Object)role.getName());
        org.junit.Assert.assertEquals((Object)"Role A New", (Object)role.getDescription());
        org.junit.Assert.assertFalse((boolean)role.isComposite());
    }

    @Test
    public void deleteRole() {
        org.junit.Assert.assertNotNull((Object)this.resource.getRole(this.ids.get("role-a")));
        this.resource.deleteRole(this.ids.get("role-a"));
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.DELETE, AdminEventPaths.roleByIdResourcePath(this.ids.get("role-a")), ResourceType.REALM_ROLE);
        try {
            this.resource.getRole(this.ids.get("role-a"));
            org.junit.Assert.fail((String)"Expected 404");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void composites() {
        org.junit.Assert.assertFalse((boolean)this.resource.getRole(this.ids.get("role-a")).isComposite());
        org.junit.Assert.assertEquals((long)0L, (long)this.resource.getRoleComposites(this.ids.get("role-a")).size());
        LinkedList<RoleRepresentation> l = new LinkedList<RoleRepresentation>();
        l.add(RoleBuilder.create().id(this.ids.get("role-b")).build());
        l.add(RoleBuilder.create().id(this.ids.get("role-c")).build());
        this.resource.addComposites(this.ids.get("role-a"), l);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.roleByIdResourceCompositesPath(this.ids.get("role-a")), l, ResourceType.REALM_ROLE);
        Set composites = this.resource.getRoleComposites(this.ids.get("role-a"));
        org.junit.Assert.assertTrue((boolean)this.resource.getRole(this.ids.get("role-a")).isComposite());
        Assert.assertNames(composites, "role-b", "role-c");
        Set realmComposites = this.resource.getRealmRoleComposites(this.ids.get("role-a"));
        Assert.assertNames(realmComposites, "role-b");
        Set clientComposites = this.resource.getClientRoleComposites(this.ids.get("role-a"), this.clientUuid);
        Assert.assertNames(clientComposites, "role-c");
        this.resource.deleteComposites(this.ids.get("role-a"), l);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.DELETE, AdminEventPaths.roleByIdResourceCompositesPath(this.ids.get("role-a")), l, ResourceType.REALM_ROLE);
        org.junit.Assert.assertFalse((boolean)this.resource.getRole(this.ids.get("role-a")).isComposite());
        org.junit.Assert.assertEquals((long)0L, (long)this.resource.getRoleComposites(this.ids.get("role-a")).size());
    }
}

