/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin;

import javax.ws.rs.core.Response;
import org.junit.ClassRule;
import org.junit.Test;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.util.LDAPRule;

public class UserFederationLdapConnectionTest
extends AbstractAdminTest {
    @ClassRule
    public static LDAPRule ldapRule = new LDAPRule();

    @Test
    public void testLdapConnections1() {
        Response response = this.realm.testLDAPConnection("unknown", "ldap://localhost:10389", "foo", "bar", "false");
        this.assertStatus(response, 400);
        response = this.realm.testLDAPConnection("testConnection", "ldap://localhostt:10389", "foo", "bar", "false");
        this.assertStatus(response, 400);
        response = this.realm.testLDAPConnection("testConnection", "ldap://localhost:10389", "foo", "bar", "false");
        this.assertStatus(response, 204);
        response = this.realm.testLDAPConnection("testAuthentication", "ldap://localhost:10389", "foo", "bar", "false");
        this.assertStatus(response, 400);
        response = this.realm.testLDAPConnection("testAuthentication", "ldap://localhost:10389", "uid=admin,ou=system", "secret", "false");
        this.assertStatus(response, 204);
    }

    @Test
    public void testLdapConnectionsSsl() {
        Response response = this.realm.testLDAPConnection("testConnection", "ldaps://localhost:10636", "foo", "bar", "false");
        this.assertStatus(response, 204);
        response = this.realm.testLDAPConnection("testConnection", "ldaps://localhostt:10636", "foo", "bar", "false");
        this.assertStatus(response, 400);
        response = this.realm.testLDAPConnection("testAuthentication", "ldaps://localhost:10636", "foo", "bar", "false");
        this.assertStatus(response, 400);
        response = this.realm.testLDAPConnection("testAuthentication", "ldaps://localhost:10636", "uid=admin,ou=system", "secret", "true");
        this.assertStatus(response, 204);
    }

    private void assertStatus(Response response, int status) {
        Assert.assertEquals((long)status, (long)response.getStatus());
        response.close();
    }
}

