/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.UserFederationProviderResource;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.ConfigPropertyRepresentation;
import org.keycloak.representations.idm.UserFederationMapperRepresentation;
import org.keycloak.representations.idm.UserFederationMapperTypeRepresentation;
import org.keycloak.representations.idm.UserFederationProviderRepresentation;
import org.keycloak.representations.idm.UserFederationSyncResultRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.util.AdminEventPaths;
import org.keycloak.testsuite.util.UserFederationProviderBuilder;

public class UserFederationMapperTest
extends AbstractAdminTest {
    private String ldapProviderId;
    private String dummyProviderId;

    @Before
    public void initFederationProviders() {
        UserFederationProviderRepresentation ldapRep = UserFederationProviderBuilder.create().displayName("ldap-1").providerName("ldap").priority(1).build();
        Response resp = this.realm.userFederation().create(ldapRep);
        this.ldapProviderId = ApiUtil.getCreatedId(resp);
        resp.close();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.userFederationResourcePath(this.ldapProviderId), (Object)ldapRep, ResourceType.USER_FEDERATION_PROVIDER);
        UserFederationProviderRepresentation dummyRep = UserFederationProviderBuilder.create().displayName("dummy-1").providerName("dummy").priority(2).build();
        resp = this.realm.userFederation().create(dummyRep);
        this.dummyProviderId = ApiUtil.getCreatedId(resp);
        resp.close();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.userFederationResourcePath(this.dummyProviderId), (Object)dummyRep, ResourceType.USER_FEDERATION_PROVIDER);
    }

    @After
    public void cleanFederationProviders() {
        this.realm.userFederation().get(this.ldapProviderId).remove();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.DELETE, AdminEventPaths.userFederationResourcePath(this.ldapProviderId), ResourceType.USER_FEDERATION_PROVIDER);
        this.realm.userFederation().get(this.dummyProviderId).remove();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.DELETE, AdminEventPaths.userFederationResourcePath(this.dummyProviderId), ResourceType.USER_FEDERATION_PROVIDER);
    }

    @Test
    public void testProviderFactories() {
        Map mapperTypes = this.realm.userFederation().get(this.dummyProviderId).getMapperTypes();
        Assert.assertEquals((long)1L, (long)mapperTypes.size());
        Assert.assertEquals((Object)"Dummy", (Object)((UserFederationMapperTypeRepresentation)mapperTypes.get("dummy-mapper")).getName());
        mapperTypes = this.ldapProviderResource().getMapperTypes();
        Assert.assertTrue((boolean)mapperTypes.keySet().containsAll(Arrays.asList("user-attribute-ldap-mapper", "full-name-ldap-mapper", "role-ldap-mapper")));
        UserFederationMapperTypeRepresentation attrMapper = (UserFederationMapperTypeRepresentation)mapperTypes.get("user-attribute-ldap-mapper");
        Assert.assertEquals((Object)"User Attribute", (Object)attrMapper.getName());
        Assert.assertFalse((boolean)attrMapper.getSyncConfig().isFedToKeycloakSyncSupported());
        Assert.assertFalse((boolean)attrMapper.getSyncConfig().isKeycloakToFedSyncSupported());
        Set<String> propNames = this.getConfigPropertyNames(attrMapper);
        Assert.assertTrue((boolean)propNames.containsAll(Arrays.asList("user.model.attribute", "ldap.attribute", "read.only")));
        Assert.assertEquals((Object)"false", attrMapper.getDefaultConfig().get("always.read.value.from.ldap"));
        UserFederationMapperTypeRepresentation roleMapper = (UserFederationMapperTypeRepresentation)mapperTypes.get("role-ldap-mapper");
        Assert.assertEquals((Object)"Role mappings", (Object)roleMapper.getName());
        Assert.assertTrue((boolean)roleMapper.getSyncConfig().isFedToKeycloakSyncSupported());
        Assert.assertTrue((boolean)roleMapper.getSyncConfig().isKeycloakToFedSyncSupported());
        Assert.assertEquals((Object)"sync-ldap-roles-to-keycloak", (Object)roleMapper.getSyncConfig().getFedToKeycloakSyncMessage());
        Assert.assertEquals((Object)"sync-keycloak-roles-to-ldap", (Object)roleMapper.getSyncConfig().getKeycloakToFedSyncMessage());
        propNames = this.getConfigPropertyNames(roleMapper);
        Assert.assertTrue((boolean)propNames.containsAll(Arrays.asList("roles.dn", "role.name.ldap.attribute", "role.object.classes")));
        Assert.assertEquals((Object)"cn", roleMapper.getDefaultConfig().get("role.name.ldap.attribute"));
    }

    private Set<String> getConfigPropertyNames(UserFederationMapperTypeRepresentation mapper) {
        List cfg = mapper.getProperties();
        HashSet<String> result = new HashSet<String>();
        for (ConfigPropertyRepresentation rep : cfg) {
            result.add(rep.getName());
        }
        return result;
    }

    @Test
    public void testUserAttributeMapperCRUD() {
        UserFederationMapperRepresentation attrMapper = this.createMapperRep("email-mapper", "user-attribute-ldap-mapper", new String[0]);
        Response response = this.ldapProviderResource().addMapper(attrMapper);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        response.close();
        attrMapper.getConfig().put("user.model.attribute", "email");
        response = this.ldapProviderResource().addMapper(attrMapper);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        response.close();
        attrMapper.getConfig().put("ldap.attribute", "mail");
        String mapperId = this.createMapper(this.ldapProviderId, attrMapper);
        UserFederationMapperRepresentation mapperRep = this.ldapProviderResource().getMapperById(mapperId);
        this.assertMapper(mapperRep, mapperId, "email-mapper", "user-attribute-ldap-mapper", "user.model.attribute", "email", "ldap.attribute", "mail");
        mapperRep.getConfig().put("ldap.attribute", "mail-updated");
        mapperRep.getConfig().remove("user.model.attribute");
        try {
            this.ldapProviderResource().updateMapper(mapperId, mapperRep);
            Assert.fail((String)"Not expected update to success");
        }
        catch (BadRequestException badRequestException) {
            // empty catch block
        }
        mapperRep = this.ldapProviderResource().getMapperById(mapperId);
        this.assertMapper(mapperRep, mapperId, "email-mapper", "user-attribute-ldap-mapper", "user.model.attribute", "email", "ldap.attribute", "mail");
        mapperRep.getConfig().put("user.model.attribute", "email-updated");
        mapperRep.getConfig().put("ldap.attribute", "mail-updated");
        this.ldapProviderResource().updateMapper(mapperId, mapperRep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, AdminEventPaths.userFederationMapperResourcePath(this.ldapProviderId, mapperId), (Object)mapperRep, ResourceType.USER_FEDERATION_MAPPER);
        mapperRep = this.ldapProviderResource().getMapperById(mapperId);
        this.assertMapper(mapperRep, mapperId, "email-mapper", "user-attribute-ldap-mapper", "user.model.attribute", "email-updated", "ldap.attribute", "mail-updated");
        this.ldapProviderResource().removeMapper(mapperId);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.DELETE, AdminEventPaths.userFederationMapperResourcePath(this.ldapProviderId, mapperId), ResourceType.USER_FEDERATION_MAPPER);
        try {
            this.ldapProviderResource().getMapperById(mapperId);
            Assert.fail((String)"Not expected find to success as mapper was removed");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private String createMapper(String userFederationProviderId, UserFederationMapperRepresentation mapper) {
        Response response = this.realm.userFederation().get(userFederationProviderId).addMapper(mapper);
        Assert.assertEquals((long)201L, (long)response.getStatus());
        response.close();
        String mapperId = ApiUtil.getCreatedId(response);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.userFederationMapperResourcePath(userFederationProviderId, mapperId), (Object)mapper, ResourceType.USER_FEDERATION_MAPPER);
        return mapperId;
    }

    @Test
    public void testRoleMapper() {
        UserFederationMapperRepresentation roleMapper = this.createMapperRep("role-mapper", "role-ldap-mapper", "roles.dn", "ou=roles,dc=keycloak,dc=org", "mode", "READ_ONLY");
        Response response = this.ldapProviderResource().addMapper(roleMapper);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        response.close();
        roleMapper.getConfig().put("use.realm.roles.mapping", "true");
        String roleMapperId = this.createMapper(this.ldapProviderId, roleMapper);
        List mappers = this.ldapProviderResource().getMappers();
        Assert.assertNotNull((Object)this.findMapperByName(mappers, "email"));
        Assert.assertNotNull((Object)this.findMapperByName(mappers, "first name"));
        Assert.assertNull((Object)this.findMapperByName(mappers, "non-existent"));
        roleMapper = this.findMapperByName(mappers, "role-mapper");
        this.assertMapper(roleMapper, roleMapperId, "role-mapper", "role-ldap-mapper", "roles.dn", "ou=roles,dc=keycloak,dc=org", "mode", "READ_ONLY", "use.realm.roles.mapping", "true");
        this.ldapProviderResource().removeMapper(roleMapperId);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.DELETE, AdminEventPaths.userFederationMapperResourcePath(this.ldapProviderId, roleMapperId), ResourceType.USER_FEDERATION_MAPPER);
        mappers = this.ldapProviderResource().getMappers();
        Assert.assertNull((Object)this.findMapperByName(mappers, "role-mapper"));
    }

    @Test
    public void testSyncMapper() {
        UserFederationMapperRepresentation dummyMapperRep = new UserFederationMapperRepresentation();
        dummyMapperRep.setName("some-dummy");
        dummyMapperRep.setFederationMapperType("dummy-mapper");
        dummyMapperRep.setFederationProviderDisplayName("dummy-1");
        String mapperId = this.createMapper(this.dummyProviderId, dummyMapperRep);
        try {
            this.ldapProviderResource().syncMapperData(mapperId, "unknown");
            Assert.fail((String)"Not expected to pass");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        UserFederationSyncResultRepresentation result = this.ldapProviderResource().syncMapperData(mapperId, "fedToKeycloak");
        Assert.assertEquals((Object)"dummyFedToKeycloakSuccess mapper=some-dummy", (Object)result.getStatus());
        HashMap<String, String> eventRep = new HashMap<String, String>();
        eventRep.put("action", "fedToKeycloak");
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.ACTION, AdminEventPaths.userFederationMapperResourcePath(this.ldapProviderId, mapperId) + "/sync", eventRep, ResourceType.USER_FEDERATION_PROVIDER);
        result = this.ldapProviderResource().syncMapperData(mapperId, "keycloakToFed");
        Assert.assertEquals((Object)"dummyKeycloakToFedSuccess mapper=some-dummy", (Object)result.getStatus());
        eventRep.put("action", "keycloakToFed");
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.ACTION, AdminEventPaths.userFederationMapperResourcePath(this.ldapProviderId, mapperId) + "/sync", ResourceType.USER_FEDERATION_PROVIDER);
    }

    private UserFederationProviderResource ldapProviderResource() {
        return this.realm.userFederation().get(this.ldapProviderId);
    }

    private UserFederationMapperRepresentation createMapperRep(String name, String type, String ... config) {
        UserFederationMapperRepresentation rep = new UserFederationMapperRepresentation();
        rep.setName(name);
        rep.setFederationMapperType(type);
        rep.setFederationProviderDisplayName("ldap-1");
        HashMap<String, String> cfg = new HashMap<String, String>();
        for (int i = 0; i < config.length; i += 2) {
            cfg.put(config[i], config[i + 1]);
        }
        rep.setConfig(cfg);
        return rep;
    }

    private void assertMapper(UserFederationMapperRepresentation rep, String id, String name, String federationMapperType, String ... config) {
        Assert.assertEquals((Object)id, (Object)rep.getId());
        Assert.assertEquals((Object)name, (Object)rep.getName());
        Assert.assertEquals((Object)"ldap-1", (Object)rep.getFederationProviderDisplayName());
        Assert.assertEquals((Object)federationMapperType, (Object)rep.getFederationMapperType());
        Assert.assertMap(rep.getConfig(), config);
    }

    private UserFederationMapperRepresentation findMapperByName(List<UserFederationMapperRepresentation> mappers, String name) {
        for (UserFederationMapperRepresentation rep : mappers) {
            if (!rep.getName().equals(name)) continue;
            return rep;
        }
        return null;
    }
}

