/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.junit.Test;
import org.keycloak.admin.client.resource.UserFederationProvidersResource;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.representations.idm.AuthenticationExecutionInfoRepresentation;
import org.keycloak.representations.idm.ConfigPropertyRepresentation;
import org.keycloak.representations.idm.UserFederationProviderFactoryRepresentation;
import org.keycloak.representations.idm.UserFederationProviderRepresentation;
import org.keycloak.representations.idm.UserFederationSyncResultRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.admin.authentication.AbstractAuthenticationTest;
import org.keycloak.testsuite.util.AdminEventPaths;
import org.keycloak.testsuite.util.UserFederationProviderBuilder;

public class UserFederationTest
extends AbstractAdminTest {
    @Test
    public void testProviderFactories() {
        List providerFactories = this.userFederation().getProviderFactories();
        Assert.assertNames(providerFactories, "ldap", "kerberos", "dummy", "dummy-configurable");
        UserFederationProviderFactoryRepresentation ldapProvider = this.userFederation().getProviderFactory("ldap");
        Assert.assertEquals((Object)ldapProvider.getId(), (Object)"ldap");
        Assert.assertEquals((long)0L, (long)ldapProvider.getOptions().size());
        UserFederationProviderFactoryRepresentation dummyProvider = this.userFederation().getProviderFactory("dummy");
        Assert.assertEquals((Object)dummyProvider.getId(), (Object)"dummy");
        Assert.assertNames(new LinkedList(dummyProvider.getOptions()), "important.config");
        UserFederationProviderFactoryRepresentation dummyConfiguredProvider = this.userFederation().getProviderFactory("dummy-configurable");
        Assert.assertEquals((Object)dummyConfiguredProvider.getId(), (Object)"dummy-configurable");
        Assert.assertTrue((dummyConfiguredProvider.getOptions() == null || dummyConfiguredProvider.getOptions().isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((Object)"Dummy User Federation Provider Help Text", (Object)dummyConfiguredProvider.getHelpText());
        Assert.assertEquals((long)2L, (long)dummyConfiguredProvider.getProperties().size());
        Assert.assertProviderConfigProperty((ConfigPropertyRepresentation)dummyConfiguredProvider.getProperties().get(0), "prop1", "Prop1", "prop1Default", "Prop1 HelpText", "String");
        Assert.assertProviderConfigProperty((ConfigPropertyRepresentation)dummyConfiguredProvider.getProperties().get(1), "prop2", "Prop2", "true", "Prop2 HelpText", "boolean");
        try {
            this.userFederation().getProviderFactory("not-existent");
            Assert.fail((String)"Not expected to find not-existent provider");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private UserFederationProvidersResource userFederation() {
        return this.realm.userFederation();
    }

    @Test
    public void testCreateProvider() {
        UserFederationProviderRepresentation dummyRep1 = UserFederationProviderBuilder.create().providerName("dummy").displayName("").priority(2).fullSyncPeriod(1000).changedSyncPeriod(500).lastSync(123).build();
        String id1 = this.createUserFederationProvider(dummyRep1);
        UserFederationProviderRepresentation dummyRep2 = UserFederationProviderBuilder.create().providerName("dummy").displayName("dn1").priority(1).configProperty("prop1", "prop1Val").configProperty("prop2", "true").build();
        String id2 = this.createUserFederationProvider(dummyRep2);
        this.assertFederationProvider(this.userFederation().get(id1).toRepresentation(), id1, id1, "dummy", 2, 1000, 500, 123, new String[0]);
        this.assertFederationProvider(this.userFederation().get(id2).toRepresentation(), id2, "dn1", "dummy", 1, -1, -1, -1, "prop1", "prop1Val", "prop2", "true");
        List providerInstances = this.userFederation().getProviderInstances();
        Assert.assertEquals((long)providerInstances.size(), (long)2L);
        this.assertFederationProvider((UserFederationProviderRepresentation)providerInstances.get(0), id2, "dn1", "dummy", 1, -1, -1, -1, "prop1", "prop1Val", "prop2", "true");
        this.assertFederationProvider((UserFederationProviderRepresentation)providerInstances.get(1), id1, id1, "dummy", 2, 1000, 500, 123, new String[0]);
        this.removeUserFederationProvider(id1);
        this.removeUserFederationProvider(id2);
    }

    @Test
    public void testValidateAndCreateLdapProvider() {
        UserFederationProviderRepresentation ldapRep = UserFederationProviderBuilder.create().displayName("ldap1").providerName("ldap").priority(1).configProperty("customUserSearchFilter", "dc=something").build();
        Response resp = this.userFederation().create(ldapRep);
        Assert.assertEquals((long)400L, (long)resp.getStatus());
        resp.close();
        ldapRep.getConfig().put("customUserSearchFilter", "(dc=something");
        resp = this.userFederation().create(ldapRep);
        Assert.assertEquals((long)400L, (long)resp.getStatus());
        resp.close();
        ldapRep.getConfig().put("customUserSearchFilter", "dc=something)");
        resp = this.userFederation().create(ldapRep);
        Assert.assertEquals((long)400L, (long)resp.getStatus());
        resp.close();
        Assert.assertTrue((boolean)this.userFederation().getProviderInstances().isEmpty());
        this.assertAdminEvents.assertEmpty();
        ldapRep.getConfig().put("customUserSearchFilter", "(dc=something)");
        String id1 = this.createUserFederationProvider(ldapRep);
        UserFederationProviderRepresentation ldapRep2 = UserFederationProviderBuilder.create().displayName("ldap2").providerName("ldap").priority(2).configProperty("bindDn", "cn=manager").configProperty("bindCredential", "password").build();
        String id2 = this.createUserFederationProvider(ldapRep2);
        List providerInstances = this.userFederation().getProviderInstances();
        Assert.assertEquals((long)providerInstances.size(), (long)2L);
        this.assertFederationProvider((UserFederationProviderRepresentation)providerInstances.get(0), id1, "ldap1", "ldap", 1, -1, -1, -1, "customUserSearchFilter", "(dc=something)");
        this.assertFederationProvider((UserFederationProviderRepresentation)providerInstances.get(1), id2, "ldap2", "ldap", 2, -1, -1, -1, "bindDn", "cn=manager", "bindCredential", "password");
        this.removeUserFederationProvider(id1);
        this.removeUserFederationProvider(id2);
    }

    @Test
    public void testUpdateProvider() {
        UserFederationProviderRepresentation ldapRep = UserFederationProviderBuilder.create().providerName("ldap").priority(2).configProperty("bindDn", "cn=manager").configProperty("bindCredential", "password").build();
        String id = this.createUserFederationProvider(ldapRep);
        this.assertFederationProvider(this.userFederation().get(id).toRepresentation(), id, id, "ldap", 2, -1, -1, -1, "bindDn", "cn=manager", "bindCredential", "password");
        ldapRep = this.userFederation().get(id).toRepresentation();
        ldapRep.setDisplayName("");
        ldapRep.getConfig().put("customUserSearchFilter", "(dc=something2");
        ldapRep.getConfig().put("bindDn", "cn=manager-updated");
        try {
            this.userFederation().get(id).update(ldapRep);
            Assert.fail((String)"Not expected to successfull update");
        }
        catch (BadRequestException badRequestException) {
            // empty catch block
        }
        this.assertFederationProvider(this.userFederation().get(id).toRepresentation(), id, id, "ldap", 2, -1, -1, -1, "bindDn", "cn=manager", "bindCredential", "password");
        ldapRep.getConfig().put("customUserSearchFilter", "(dc=something2)");
        this.userFederation().get(id).update(ldapRep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, AdminEventPaths.userFederationResourcePath(id), (Object)ldapRep, ResourceType.USER_FEDERATION_PROVIDER);
        ldapRep = this.userFederation().get(id).toRepresentation();
        this.assertFederationProvider(ldapRep, id, id, "ldap", 2, -1, -1, -1, "bindDn", "cn=manager-updated", "bindCredential", "password", "customUserSearchFilter", "(dc=something2)");
        ldapRep.setDisplayName("ldap2");
        this.userFederation().get(id).update(ldapRep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, AdminEventPaths.userFederationResourcePath(id), (Object)ldapRep, ResourceType.USER_FEDERATION_PROVIDER);
        this.assertFederationProvider(this.userFederation().get(id).toRepresentation(), id, "ldap2", "ldap", 2, -1, -1, -1, "bindDn", "cn=manager-updated", "bindCredential", "password", "customUserSearchFilter", "(dc=something2)");
        this.removeUserFederationProvider(id);
    }

    @Test
    public void testKerberosAuthenticatorEnabledAutomatically() {
        AuthenticationExecutionInfoRepresentation kerberosExecution = this.findKerberosExecution();
        Assert.assertEquals((Object)kerberosExecution.getRequirement(), (Object)AuthenticationExecutionModel.Requirement.DISABLED.toString());
        UserFederationProviderRepresentation ldapRep = UserFederationProviderBuilder.create().displayName("ldap2").providerName("ldap").priority(2).configProperty("allowKerberosAuthentication", "true").build();
        String id = this.createUserFederationProvider(ldapRep);
        kerberosExecution = this.findKerberosExecution();
        Assert.assertEquals((Object)kerberosExecution.getRequirement(), (Object)AuthenticationExecutionModel.Requirement.ALTERNATIVE.toString());
        kerberosExecution.setRequirement(AuthenticationExecutionModel.Requirement.DISABLED.toString());
        this.realm.flows().updateExecutions("browser", kerberosExecution);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, AdminEventPaths.authUpdateExecutionPath("browser"), (Object)kerberosExecution, ResourceType.AUTH_EXECUTION);
        ldapRep = this.userFederation().get(id).toRepresentation();
        this.userFederation().get(id).update(ldapRep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, AdminEventPaths.userFederationResourcePath(id), (Object)ldapRep, ResourceType.USER_FEDERATION_PROVIDER);
        kerberosExecution = this.findKerberosExecution();
        Assert.assertEquals((Object)kerberosExecution.getRequirement(), (Object)AuthenticationExecutionModel.Requirement.ALTERNATIVE.toString());
        kerberosExecution.setRequirement(AuthenticationExecutionModel.Requirement.DISABLED.toString());
        this.realm.flows().updateExecutions("browser", kerberosExecution);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, AdminEventPaths.authUpdateExecutionPath("browser"), (Object)kerberosExecution, ResourceType.AUTH_EXECUTION);
        this.removeUserFederationProvider(id);
    }

    @Test
    public void testKerberosAuthenticatorChangedOnlyIfDisabled() {
        AuthenticationExecutionInfoRepresentation kerberosExecution = this.findKerberosExecution();
        kerberosExecution.setRequirement(AuthenticationExecutionModel.Requirement.REQUIRED.toString());
        this.realm.flows().updateExecutions("browser", kerberosExecution);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, AdminEventPaths.authUpdateExecutionPath("browser"), (Object)kerberosExecution, ResourceType.AUTH_EXECUTION);
        UserFederationProviderRepresentation ldapRep = UserFederationProviderBuilder.create().displayName("ldap2").providerName("ldap").priority(2).configProperty("allowKerberosAuthentication", "true").build();
        String id = this.createUserFederationProvider(ldapRep);
        kerberosExecution = this.findKerberosExecution();
        Assert.assertEquals((Object)kerberosExecution.getRequirement(), (Object)AuthenticationExecutionModel.Requirement.REQUIRED.toString());
        ldapRep = this.userFederation().get(id).toRepresentation();
        this.userFederation().get(id).update(ldapRep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, AdminEventPaths.userFederationResourcePath(id), (Object)ldapRep, ResourceType.USER_FEDERATION_PROVIDER);
        kerberosExecution = this.findKerberosExecution();
        Assert.assertEquals((Object)kerberosExecution.getRequirement(), (Object)AuthenticationExecutionModel.Requirement.REQUIRED.toString());
        kerberosExecution.setRequirement(AuthenticationExecutionModel.Requirement.DISABLED.toString());
        this.realm.flows().updateExecutions("browser", kerberosExecution);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, AdminEventPaths.authUpdateExecutionPath("browser"), (Object)kerberosExecution, ResourceType.AUTH_EXECUTION);
        this.removeUserFederationProvider(id);
    }

    @Test(expected=NotFoundException.class)
    public void testLookupNotExistentProvider() {
        this.userFederation().get("not-existent").toRepresentation();
    }

    @Test
    public void testSyncFederationProvider() {
        UserFederationProviderRepresentation dummyRep1 = UserFederationProviderBuilder.create().providerName("dummy").build();
        String id1 = this.createUserFederationProvider(dummyRep1);
        try {
            this.userFederation().get(id1).syncUsers("unknown");
            Assert.fail((String)"Not expected to sync with unknown action");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        Assert.assertEquals((long)-1L, (long)this.userFederation().get(id1).toRepresentation().getLastSync());
        UserFederationSyncResultRepresentation syncResult = this.userFederation().get(id1).syncUsers("triggerFullSync");
        Assert.assertEquals((Object)"0 imported users, 0 updated users", (Object)syncResult.getStatus());
        HashMap<String, String> eventRep = new HashMap<String, String>();
        eventRep.put("action", "triggerFullSync");
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.ACTION, AdminEventPaths.userFederationResourcePath(id1) + "/sync", eventRep, ResourceType.USER_FEDERATION_PROVIDER);
        int fullSyncTime = this.userFederation().get(id1).toRepresentation().getLastSync();
        Assert.assertTrue((fullSyncTime > 0 ? 1 : 0) != 0);
        this.setTimeOffset(50);
        syncResult = this.userFederation().get(id1).syncUsers("triggerChangedUsersSync");
        eventRep.put("action", "triggerChangedUsersSync");
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.ACTION, AdminEventPaths.userFederationResourcePath(id1) + "/sync", eventRep, ResourceType.USER_FEDERATION_PROVIDER);
        Assert.assertEquals((Object)"0 imported users, 0 updated users", (Object)syncResult.getStatus());
        int changedSyncTime = this.userFederation().get(id1).toRepresentation().getLastSync();
        Assert.assertTrue((fullSyncTime + 50 <= changedSyncTime ? 1 : 0) != 0);
        this.resetTimeOffset();
        this.removeUserFederationProvider(id1);
    }

    private String createUserFederationProvider(UserFederationProviderRepresentation rep) {
        Response resp = this.userFederation().create(rep);
        Assert.assertEquals((long)201L, (long)resp.getStatus());
        resp.close();
        String federationProviderId = ApiUtil.getCreatedId(resp);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.userFederationResourcePath(federationProviderId), (Object)rep, ResourceType.USER_FEDERATION_PROVIDER);
        return federationProviderId;
    }

    private void removeUserFederationProvider(String id) {
        this.userFederation().get(id).remove();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.DELETE, AdminEventPaths.userFederationResourcePath(id), ResourceType.USER_FEDERATION_PROVIDER);
    }

    private void assertFederationProvider(UserFederationProviderRepresentation rep, String id, String displayName, String providerName, int priority, int fullSyncPeriod, int changeSyncPeriod, int lastSync, String ... config) {
        Assert.assertEquals((Object)id, (Object)rep.getId());
        Assert.assertEquals((Object)displayName, (Object)rep.getDisplayName());
        Assert.assertEquals((Object)providerName, (Object)rep.getProviderName());
        Assert.assertEquals((long)priority, (long)rep.getPriority());
        Assert.assertEquals((long)fullSyncPeriod, (long)rep.getFullSyncPeriod());
        Assert.assertEquals((long)changeSyncPeriod, (long)rep.getChangedSyncPeriod());
        Assert.assertEquals((long)lastSync, (long)rep.getLastSync());
        Assert.assertMap(rep.getConfig(), config);
    }

    private AuthenticationExecutionInfoRepresentation findKerberosExecution() {
        AuthenticationExecutionInfoRepresentation kerberosExecution = null;
        List executionReps = this.realm.flows().getExecutions("browser");
        kerberosExecution = AbstractAuthenticationTest.findExecutionByProvider("auth-spnego", executionReps);
        Assert.assertNotNull((Object)kerberosExecution);
        return kerberosExecution;
    }
}

