/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.IdentityProviderResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RoleMappingResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.ClientMappingsRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.ErrorRepresentation;
import org.keycloak.representations.idm.FederatedIdentityRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.MappingsRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.page.LoginPasswordUpdatePage;
import org.keycloak.testsuite.pages.InfoPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.util.AdminEventPaths;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.GreenMailRule;
import org.keycloak.testsuite.util.MailUtils;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.RoleBuilder;
import org.keycloak.testsuite.util.UserBuilder;
import org.openqa.selenium.WebDriver;

public class UserTest
extends AbstractAdminTest {
    @Rule
    public GreenMailRule greenMail = new GreenMailRule();
    @Drone
    protected WebDriver driver;
    @Page
    protected LoginPasswordUpdatePage passwordUpdatePage;
    @ArquillianResource
    protected OAuthClient oAuthClient;
    @Page
    protected InfoPage infoPage;
    @Page
    protected LoginPage loginPage;

    public String createUser() {
        return this.createUser("user1", "user1@localhost");
    }

    public String createUser(String username, String email) {
        UserRepresentation user = new UserRepresentation();
        user.setUsername(username);
        user.setEmail(email);
        user.setRequiredActions(Collections.emptyList());
        user.setEnabled(Boolean.valueOf(true));
        return this.createUser(user);
    }

    private String createUser(UserRepresentation userRep) {
        Response response = this.realm.users().create(userRep);
        String createdId = ApiUtil.getCreatedId(response);
        response.close();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.userResourcePath(createdId), (Object)userRep, ResourceType.USER);
        return createdId;
    }

    private void updateUser(UserResource user, UserRepresentation userRep) {
        user.update(userRep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, AdminEventPaths.userResourcePath(userRep.getId()), (Object)userRep, ResourceType.USER);
    }

    @Test
    public void verifyCreateUser() {
        this.createUser();
    }

    @Test
    public void createDuplicatedUser1() {
        this.createUser();
        UserRepresentation user = new UserRepresentation();
        user.setUsername("user1");
        Response response = this.realm.users().create(user);
        org.junit.Assert.assertEquals((long)409L, (long)response.getStatus());
        this.assertAdminEvents.assertEmpty();
        ErrorRepresentation error = (ErrorRepresentation)response.readEntity(ErrorRepresentation.class);
        org.junit.Assert.assertEquals((Object)"User exists with same username", (Object)error.getErrorMessage());
        response.close();
    }

    @Test
    public void createDuplicatedUser2() {
        this.createUser();
        UserRepresentation user = new UserRepresentation();
        user.setUsername("user2");
        user.setEmail("user1@localhost");
        Response response = this.realm.users().create(user);
        org.junit.Assert.assertEquals((long)409L, (long)response.getStatus());
        response.close();
    }

    @Test
    public void createDuplicatedUser3() {
        this.createUser();
        UserRepresentation user = new UserRepresentation();
        user.setUsername("User1");
        Response response = this.realm.users().create(user);
        org.junit.Assert.assertEquals((long)409L, (long)response.getStatus());
        response.close();
    }

    @Test
    public void createDuplicatedUser4() {
        this.createUser();
        UserRepresentation user = new UserRepresentation();
        user.setUsername("USER1");
        Response response = this.realm.users().create(user);
        org.junit.Assert.assertEquals((long)409L, (long)response.getStatus());
        response.close();
    }

    @Test
    public void createDuplicatedUser5() {
        this.createUser();
        UserRepresentation user = new UserRepresentation();
        user.setUsername("user2");
        user.setEmail("User1@localhost");
        Response response = this.realm.users().create(user);
        org.junit.Assert.assertEquals((long)409L, (long)response.getStatus());
        response.close();
    }

    @Test
    public void createDuplicatedUser6() {
        this.createUser();
        UserRepresentation user = new UserRepresentation();
        user.setUsername("user2");
        user.setEmail("user1@LOCALHOST");
        Response response = this.realm.users().create(user);
        org.junit.Assert.assertEquals((long)409L, (long)response.getStatus());
        response.close();
    }

    @Test
    public void createDuplicatedUser7() {
        this.createUser("user1", "USer1@Localhost");
        UserRepresentation user = new UserRepresentation();
        user.setUsername("user2");
        user.setEmail("user1@localhost");
        Response response = this.realm.users().create(user);
        org.junit.Assert.assertEquals((long)409L, (long)response.getStatus());
        response.close();
        this.assertAdminEvents.assertEmpty();
    }

    private void createUsers() {
        for (int i = 1; i < 10; ++i) {
            UserRepresentation user = new UserRepresentation();
            user.setUsername("username" + i);
            user.setEmail("user" + i + "@localhost");
            user.setFirstName("First" + i);
            user.setLastName("Last" + i);
            this.createUser(user);
        }
    }

    @Test
    public void searchByEmail() {
        this.createUsers();
        List users = this.realm.users().search(null, null, null, "user1@localhost", null, null);
        org.junit.Assert.assertEquals((long)1L, (long)users.size());
        users = this.realm.users().search(null, null, null, "@localhost", null, null);
        org.junit.Assert.assertEquals((long)9L, (long)users.size());
    }

    @Test
    public void searchByUsername() {
        this.createUsers();
        List users = this.realm.users().search("username1", null, null, null, null, null);
        org.junit.Assert.assertEquals((long)1L, (long)users.size());
        users = this.realm.users().search("user", null, null, null, null, null);
        org.junit.Assert.assertEquals((long)9L, (long)users.size());
    }

    @Test
    public void search() {
        this.createUsers();
        List users = this.realm.users().search("username1", null, null);
        org.junit.Assert.assertEquals((long)1L, (long)users.size());
        users = this.realm.users().search("first1", null, null);
        org.junit.Assert.assertEquals((long)1L, (long)users.size());
        users = this.realm.users().search("last", null, null);
        org.junit.Assert.assertEquals((long)9L, (long)users.size());
    }

    @Test
    public void count() {
        this.createUsers();
        Integer count = this.realm.users().count();
        org.junit.Assert.assertEquals((long)9L, (long)count.intValue());
    }

    @Test
    public void delete() {
        String userId = this.createUser();
        Response response = this.realm.users().delete(userId);
        org.junit.Assert.assertEquals((long)204L, (long)response.getStatus());
        response.close();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.DELETE, AdminEventPaths.userResourcePath(userId), ResourceType.USER);
    }

    @Test
    public void deleteNonExistent() {
        Response response = this.realm.users().delete("does-not-exist");
        org.junit.Assert.assertEquals((long)404L, (long)response.getStatus());
        response.close();
        this.assertAdminEvents.assertEmpty();
    }

    @Test
    public void searchPaginated() {
        this.createUsers();
        List users = this.realm.users().search("username", Integer.valueOf(0), Integer.valueOf(1));
        org.junit.Assert.assertEquals((long)1L, (long)users.size());
        org.junit.Assert.assertEquals((Object)"username1", (Object)((UserRepresentation)users.get(0)).getUsername());
        users = this.realm.users().search("username", Integer.valueOf(5), Integer.valueOf(2));
        org.junit.Assert.assertEquals((long)2L, (long)users.size());
        org.junit.Assert.assertEquals((Object)"username6", (Object)((UserRepresentation)users.get(0)).getUsername());
        org.junit.Assert.assertEquals((Object)"username7", (Object)((UserRepresentation)users.get(1)).getUsername());
        users = this.realm.users().search("username", Integer.valueOf(7), Integer.valueOf(20));
        org.junit.Assert.assertEquals((long)2L, (long)users.size());
        org.junit.Assert.assertEquals((Object)"username8", (Object)((UserRepresentation)users.get(0)).getUsername());
        org.junit.Assert.assertEquals((Object)"username9", (Object)((UserRepresentation)users.get(1)).getUsername());
        users = this.realm.users().search("username", Integer.valueOf(0), Integer.valueOf(20));
        org.junit.Assert.assertEquals((long)9L, (long)users.size());
    }

    @Test
    public void getFederatedIdentities() {
        this.addSampleIdentityProvider();
        String id = this.createUser();
        UserResource user = this.realm.users().get(id);
        org.junit.Assert.assertEquals((long)0L, (long)user.getFederatedIdentity().size());
        FederatedIdentityRepresentation link = new FederatedIdentityRepresentation();
        link.setUserId("social-user-id");
        link.setUserName("social-username");
        Response response = user.addFederatedIdentity("social-provider-id", link);
        org.junit.Assert.assertEquals((long)204L, (long)response.getStatus());
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.userFederatedIdentityLink(id, "social-provider-id"), (Object)link, ResourceType.USER);
        user = this.realm.users().get(id);
        List federatedIdentities = user.getFederatedIdentity();
        org.junit.Assert.assertEquals((long)1L, (long)federatedIdentities.size());
        link = (FederatedIdentityRepresentation)federatedIdentities.get(0);
        org.junit.Assert.assertEquals((Object)"social-provider-id", (Object)link.getIdentityProvider());
        org.junit.Assert.assertEquals((Object)"social-user-id", (Object)link.getUserId());
        org.junit.Assert.assertEquals((Object)"social-username", (Object)link.getUserName());
        user.removeFederatedIdentity("social-provider-id");
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.DELETE, AdminEventPaths.userFederatedIdentityLink(id, "social-provider-id"), ResourceType.USER);
        org.junit.Assert.assertEquals((long)0L, (long)user.getFederatedIdentity().size());
        this.removeSampleIdentityProvider();
    }

    private void addSampleIdentityProvider() {
        List providers = this.realm.identityProviders().findAll();
        org.junit.Assert.assertEquals((long)0L, (long)providers.size());
        IdentityProviderRepresentation rep = new IdentityProviderRepresentation();
        rep.setAlias("social-provider-id");
        rep.setProviderId("social-provider-type");
        this.realm.identityProviders().create(rep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.identityProviderPath(rep.getAlias()), (Object)rep, ResourceType.IDENTITY_PROVIDER);
    }

    private void removeSampleIdentityProvider() {
        IdentityProviderResource resource = this.realm.identityProviders().get("social-provider-id");
        org.junit.Assert.assertNotNull((Object)resource);
        resource.remove();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.DELETE, AdminEventPaths.identityProviderPath("social-provider-id"), ResourceType.IDENTITY_PROVIDER);
    }

    @Test
    public void addRequiredAction() {
        String id = this.createUser();
        UserResource user = this.realm.users().get(id);
        org.junit.Assert.assertTrue((boolean)user.toRepresentation().getRequiredActions().isEmpty());
        UserRepresentation userRep = user.toRepresentation();
        userRep.getRequiredActions().add("UPDATE_PASSWORD");
        this.updateUser(user, userRep);
        org.junit.Assert.assertEquals((long)1L, (long)user.toRepresentation().getRequiredActions().size());
        org.junit.Assert.assertEquals((Object)"UPDATE_PASSWORD", user.toRepresentation().getRequiredActions().get(0));
    }

    @Test
    public void removeRequiredAction() {
        String id = this.createUser();
        UserResource user = this.realm.users().get(id);
        org.junit.Assert.assertTrue((boolean)user.toRepresentation().getRequiredActions().isEmpty());
        UserRepresentation userRep = user.toRepresentation();
        userRep.getRequiredActions().add("UPDATE_PASSWORD");
        this.updateUser(user, userRep);
        user = this.realm.users().get(id);
        userRep = user.toRepresentation();
        userRep.getRequiredActions().clear();
        this.updateUser(user, userRep);
        org.junit.Assert.assertTrue((boolean)user.toRepresentation().getRequiredActions().isEmpty());
    }

    @Test
    public void attributes() {
        UserRepresentation user1 = new UserRepresentation();
        user1.setUsername("user1");
        user1.singleAttribute("attr1", "value1user1");
        user1.singleAttribute("attr2", "value2user1");
        String user1Id = this.createUser(user1);
        UserRepresentation user2 = new UserRepresentation();
        user2.setUsername("user2");
        user2.singleAttribute("attr1", "value1user2");
        List vals = new ArrayList<String>();
        vals.add("value2user2");
        vals.add("value2user2_2");
        user2.getAttributesAsListValues().put("attr2", vals);
        String user2Id = this.createUser(user2);
        user1 = this.realm.users().get(user1Id).toRepresentation();
        org.junit.Assert.assertEquals((long)2L, (long)user1.getAttributesAsListValues().size());
        this.assertAttributeValue("value1user1", (List)user1.getAttributesAsListValues().get("attr1"));
        this.assertAttributeValue("value2user1", (List)user1.getAttributesAsListValues().get("attr2"));
        user2 = this.realm.users().get(user2Id).toRepresentation();
        org.junit.Assert.assertEquals((long)2L, (long)user2.getAttributesAsListValues().size());
        this.assertAttributeValue("value1user2", (List)user2.getAttributesAsListValues().get("attr1"));
        vals = (List)user2.getAttributesAsListValues().get("attr2");
        org.junit.Assert.assertEquals((long)2L, (long)vals.size());
        org.junit.Assert.assertTrue((vals.contains("value2user2") && vals.contains("value2user2_2") ? 1 : 0) != 0);
        user1.singleAttribute("attr1", "value3user1");
        user1.singleAttribute("attr3", "value4user1");
        this.updateUser(this.realm.users().get(user1Id), user1);
        user1 = this.realm.users().get(user1Id).toRepresentation();
        org.junit.Assert.assertEquals((long)3L, (long)user1.getAttributesAsListValues().size());
        this.assertAttributeValue("value3user1", (List)user1.getAttributesAsListValues().get("attr1"));
        this.assertAttributeValue("value2user1", (List)user1.getAttributesAsListValues().get("attr2"));
        this.assertAttributeValue("value4user1", (List)user1.getAttributesAsListValues().get("attr3"));
        user1.getAttributes().remove("attr1");
        this.updateUser(this.realm.users().get(user1Id), user1);
        user1 = this.realm.users().get(user1Id).toRepresentation();
        org.junit.Assert.assertEquals((long)2L, (long)user1.getAttributesAsListValues().size());
        this.assertAttributeValue("value2user1", (List)user1.getAttributesAsListValues().get("attr2"));
        this.assertAttributeValue("value4user1", (List)user1.getAttributesAsListValues().get("attr3"));
        user1.getAttributes().clear();
        this.updateUser(this.realm.users().get(user1Id), user1);
        user1 = this.realm.users().get(user1Id).toRepresentation();
        org.junit.Assert.assertNull((Object)user1.getAttributes());
    }

    private void assertAttributeValue(String expectedValue, List<String> attrValues) {
        org.junit.Assert.assertEquals((long)1L, (long)attrValues.size());
        org.junit.Assert.assertEquals((Object)expectedValue, (Object)attrValues.get(0));
    }

    @Test
    public void sendResetPasswordEmail() {
        ErrorRepresentation error;
        UserRepresentation userRep = new UserRepresentation();
        userRep.setUsername("user1");
        String id = this.createUser(userRep);
        UserResource user = this.realm.users().get(id);
        LinkedList actions = new LinkedList();
        try {
            user.executeActionsEmail(actions);
            org.junit.Assert.fail((String)"Expected failure");
        }
        catch (ClientErrorException e) {
            org.junit.Assert.assertEquals((long)400L, (long)e.getResponse().getStatus());
            error = (ErrorRepresentation)e.getResponse().readEntity(ErrorRepresentation.class);
            org.junit.Assert.assertEquals((Object)"User email missing", (Object)error.getErrorMessage());
        }
        try {
            userRep = user.toRepresentation();
            userRep.setEmail("user1@localhost");
            userRep.setEnabled(Boolean.valueOf(false));
            this.updateUser(user, userRep);
            user.executeActionsEmail(actions);
            org.junit.Assert.fail((String)"Expected failure");
        }
        catch (ClientErrorException e) {
            org.junit.Assert.assertEquals((long)400L, (long)e.getResponse().getStatus());
            error = (ErrorRepresentation)e.getResponse().readEntity(ErrorRepresentation.class);
            org.junit.Assert.assertEquals((Object)"User is disabled", (Object)error.getErrorMessage());
        }
        try {
            userRep.setEnabled(Boolean.valueOf(true));
            this.updateUser(user, userRep);
            user.executeActionsEmail("invalidClientId", actions);
            org.junit.Assert.fail((String)"Expected failure");
        }
        catch (ClientErrorException e) {
            org.junit.Assert.assertEquals((long)400L, (long)e.getResponse().getStatus());
            error = (ErrorRepresentation)e.getResponse().readEntity(ErrorRepresentation.class);
            org.junit.Assert.assertEquals((Object)"invalidClientId not enabled", (Object)error.getErrorMessage());
        }
    }

    @Test
    public void sendResetPasswordEmailSuccess() throws IOException, MessagingException {
        UserRepresentation userRep = new UserRepresentation();
        userRep.setEnabled(Boolean.valueOf(true));
        userRep.setUsername("user1");
        userRep.setEmail("user1@test.com");
        String id = this.createUser(userRep);
        UserResource user = this.realm.users().get(id);
        LinkedList<String> actions = new LinkedList<String>();
        actions.add(UserModel.RequiredAction.UPDATE_PASSWORD.name());
        user.executeActionsEmail("account", actions);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.ACTION, AdminEventPaths.userResourcePath(id) + "/execute-actions-email", ResourceType.USER);
        org.junit.Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getReceivedMessages()[0];
        String link = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
        this.driver.navigate().to(link);
        org.junit.Assert.assertTrue((boolean)this.passwordUpdatePage.isCurrent());
        this.passwordUpdatePage.changePassword("new-pass", "new-pass");
        org.junit.Assert.assertEquals((Object)"Your account has been updated.", (Object)this.driver.getTitle());
        this.driver.navigate().to(link);
        org.junit.Assert.assertEquals((Object)"We're sorry...", (Object)this.driver.getTitle());
    }

    @Test
    public void sendVerifyEmail() throws IOException, MessagingException {
        ErrorRepresentation error;
        UserRepresentation userRep = new UserRepresentation();
        userRep.setUsername("user1");
        String id = this.createUser(userRep);
        UserResource user = this.realm.users().get(id);
        try {
            user.sendVerifyEmail();
            org.junit.Assert.fail((String)"Expected failure");
        }
        catch (ClientErrorException e) {
            org.junit.Assert.assertEquals((long)400L, (long)e.getResponse().getStatus());
            error = (ErrorRepresentation)e.getResponse().readEntity(ErrorRepresentation.class);
            org.junit.Assert.assertEquals((Object)"User email missing", (Object)error.getErrorMessage());
        }
        try {
            userRep = user.toRepresentation();
            userRep.setEmail("user1@localhost");
            userRep.setEnabled(Boolean.valueOf(false));
            this.updateUser(user, userRep);
            user.sendVerifyEmail();
            org.junit.Assert.fail((String)"Expected failure");
        }
        catch (ClientErrorException e) {
            org.junit.Assert.assertEquals((long)400L, (long)e.getResponse().getStatus());
            error = (ErrorRepresentation)e.getResponse().readEntity(ErrorRepresentation.class);
            org.junit.Assert.assertEquals((Object)"User is disabled", (Object)error.getErrorMessage());
        }
        try {
            userRep.setEnabled(Boolean.valueOf(true));
            this.updateUser(user, userRep);
            user.sendVerifyEmail("invalidClientId");
            org.junit.Assert.fail((String)"Expected failure");
        }
        catch (ClientErrorException e) {
            org.junit.Assert.assertEquals((long)400L, (long)e.getResponse().getStatus());
            error = (ErrorRepresentation)e.getResponse().readEntity(ErrorRepresentation.class);
            org.junit.Assert.assertEquals((Object)"invalidClientId not enabled", (Object)error.getErrorMessage());
        }
        user.sendVerifyEmail();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.ACTION, AdminEventPaths.userResourcePath(id) + "/send-verify-email", ResourceType.USER);
        org.junit.Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        String link = MailUtils.getPasswordResetEmailLink((MimeMessage)this.greenMail.getReceivedMessages()[0]);
        this.driver.navigate().to(link);
        org.junit.Assert.assertEquals((Object)"Your account has been updated.", (Object)this.infoPage.getInfo());
    }

    @Test
    public void updateUserWithNewUsername() {
        this.switchEditUsernameAllowedOn();
        String id = this.createUser();
        UserResource user = this.realm.users().get(id);
        UserRepresentation userRep = user.toRepresentation();
        userRep.setUsername("user11");
        this.updateUser(user, userRep);
        userRep = this.realm.users().get(id).toRepresentation();
        org.junit.Assert.assertEquals((Object)"user11", (Object)userRep.getUsername());
    }

    @Test
    public void updateUserWithoutUsername() {
        this.switchEditUsernameAllowedOn();
        String id = this.createUser();
        UserResource user = this.realm.users().get(id);
        UserRepresentation rep = new UserRepresentation();
        rep.setFirstName("Firstname");
        user.update(rep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, AdminEventPaths.userResourcePath(id), (Object)rep, ResourceType.USER);
        rep = new UserRepresentation();
        rep.setLastName("Lastname");
        user.update(rep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, AdminEventPaths.userResourcePath(id), (Object)rep, ResourceType.USER);
        rep = this.realm.users().get(id).toRepresentation();
        org.junit.Assert.assertEquals((Object)"user1", (Object)rep.getUsername());
        org.junit.Assert.assertEquals((Object)"user1@localhost", (Object)rep.getEmail());
        org.junit.Assert.assertEquals((Object)"Firstname", (Object)rep.getFirstName());
        org.junit.Assert.assertEquals((Object)"Lastname", (Object)rep.getLastName());
    }

    @Test
    public void updateUserWithNewUsernameNotPossible() {
        String id = this.createUser();
        UserResource user = this.realm.users().get(id);
        UserRepresentation userRep = user.toRepresentation();
        userRep.setUsername("user11");
        this.updateUser(user, userRep);
        userRep = this.realm.users().get(id).toRepresentation();
        org.junit.Assert.assertEquals((Object)"user1", (Object)userRep.getUsername());
    }

    @Test
    public void updateUserWithNewUsernameAccessingViaOldUsername() {
        this.switchEditUsernameAllowedOn();
        this.createUser();
        try {
            UserResource user = this.realm.users().get("user1");
            UserRepresentation userRep = user.toRepresentation();
            userRep.setUsername("user1");
            this.updateUser(user, userRep);
            this.realm.users().get("user11").toRepresentation();
            org.junit.Assert.fail((String)"Expected failure");
        }
        catch (ClientErrorException e) {
            org.junit.Assert.assertEquals((long)404L, (long)e.getResponse().getStatus());
        }
    }

    @Test
    public void updateUserWithExistingUsername() {
        this.switchEditUsernameAllowedOn();
        this.enableBruteForce();
        this.createUser();
        UserRepresentation userRep = new UserRepresentation();
        userRep.setUsername("user2");
        String createdId = this.createUser(userRep);
        try {
            UserResource user = this.realm.users().get(createdId);
            userRep = user.toRepresentation();
            userRep.setUsername("user1");
            user.update(userRep);
            org.junit.Assert.fail((String)"Expected failure");
        }
        catch (ClientErrorException e) {
            org.junit.Assert.assertEquals((long)409L, (long)e.getResponse().getStatus());
            this.assertAdminEvents.poll();
        }
    }

    @Test
    public void resetUserPassword() {
        String userId = this.createUser("user1", "user1@localhost");
        CredentialRepresentation cred = new CredentialRepresentation();
        cred.setType("password");
        cred.setValue("password");
        cred.setTemporary(Boolean.valueOf(false));
        this.realm.users().get(userId).resetPassword(cred);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.ACTION, AdminEventPaths.userResetPasswordPath(userId), ResourceType.USER);
        String accountUrl = RealmsResource.accountUrl((UriBuilder)UriBuilder.fromUri((URI)this.getAuthServerRoot())).build(new Object[]{"admin-client-test"}).toString();
        this.driver.navigate().to(accountUrl);
        org.junit.Assert.assertEquals((Object)"Log in to admin-client-test", (Object)this.driver.getTitle());
        this.loginPage.login("user1", "password");
        org.junit.Assert.assertTrue((boolean)this.driver.getTitle().contains("Account Management"));
    }

    @Test
    public void resetUserInvalidPassword() {
        String userId = this.createUser("user1", "user1@localhost");
        try {
            CredentialRepresentation cred = new CredentialRepresentation();
            cred.setType("password");
            cred.setValue(" ");
            cred.setTemporary(Boolean.valueOf(false));
            this.realm.users().get(userId).resetPassword(cred);
            org.junit.Assert.fail((String)"Expected failure");
        }
        catch (ClientErrorException e) {
            org.junit.Assert.assertEquals((long)400L, (long)e.getResponse().getStatus());
            e.getResponse().close();
            this.assertAdminEvents.assertEmpty();
        }
    }

    @Test
    public void testDefaultRequiredActionAdded() {
        RequiredActionProviderRepresentation updatePasswordReqAction = this.realm.flows().getRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD.toString());
        updatePasswordReqAction.setDefaultAction(true);
        this.realm.flows().updateRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD.toString(), updatePasswordReqAction);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, AdminEventPaths.authRequiredActionPath(UserModel.RequiredAction.UPDATE_PASSWORD.toString()), (Object)updatePasswordReqAction, ResourceType.REQUIRED_ACTION);
        String userId = this.createUser("user1", "user1@localhost");
        UserRepresentation userRep = this.realm.users().get(userId).toRepresentation();
        org.junit.Assert.assertEquals((long)1L, (long)userRep.getRequiredActions().size());
        org.junit.Assert.assertEquals((Object)UserModel.RequiredAction.UPDATE_PASSWORD.toString(), userRep.getRequiredActions().get(0));
        updatePasswordReqAction = this.realm.flows().getRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD.toString());
        updatePasswordReqAction.setDefaultAction(true);
        this.realm.flows().updateRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD.toString(), updatePasswordReqAction);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, AdminEventPaths.authRequiredActionPath(UserModel.RequiredAction.UPDATE_PASSWORD.toString()), (Object)updatePasswordReqAction, ResourceType.REQUIRED_ACTION);
    }

    @Test
    public void roleMappings() {
        RealmResource realm = this.adminClient.realms().realm("test");
        RealmRepresentation realmRep = RealmBuilder.edit(realm.toRepresentation()).testEventListener().build();
        realm.update(realmRep);
        realm.roles().create(RoleBuilder.create().name("realm-role").build());
        realm.roles().create(RoleBuilder.create().name("realm-composite").build());
        realm.roles().create(RoleBuilder.create().name("realm-child").build());
        realm.roles().get("realm-composite").addComposites(Collections.singletonList(realm.roles().get("realm-child").toRepresentation()));
        Response response = realm.clients().create(ClientBuilder.create().clientId("myclient").build());
        String clientUuid = ApiUtil.getCreatedId(response);
        response.close();
        realm.clients().get(clientUuid).roles().create(RoleBuilder.create().name("client-role").build());
        realm.clients().get(clientUuid).roles().create(RoleBuilder.create().name("client-role2").build());
        realm.clients().get(clientUuid).roles().create(RoleBuilder.create().name("client-composite").build());
        realm.clients().get(clientUuid).roles().create(RoleBuilder.create().name("client-child").build());
        realm.clients().get(clientUuid).roles().get("client-composite").addComposites(Collections.singletonList(realm.clients().get(clientUuid).roles().get("client-child").toRepresentation()));
        response = realm.users().create(UserBuilder.create().username("myuser").build());
        String userId = ApiUtil.getCreatedId(response);
        response.close();
        this.assertAdminEvents.clear();
        RoleMappingResource roles = realm.users().get(userId).roles();
        Assert.assertNames(roles.realmLevel().listAll(), "user", "offline_access", "uma_authorization");
        LinkedList<RoleRepresentation> l = new LinkedList<RoleRepresentation>();
        l.add(realm.roles().get("realm-role").toRepresentation());
        l.add(realm.roles().get("realm-composite").toRepresentation());
        roles.realmLevel().add(l);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.userRealmRoleMappingsPath(userId), l, ResourceType.REALM_ROLE_MAPPING);
        List<RoleRepresentation> list = Collections.singletonList(realm.clients().get(clientUuid).roles().get("client-role").toRepresentation());
        roles.clientLevel(clientUuid).add(list);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.userClientRoleMappingsPath(userId, clientUuid), list, ResourceType.CLIENT_ROLE_MAPPING);
        list = Collections.singletonList(realm.clients().get(clientUuid).roles().get("client-composite").toRepresentation());
        roles.clientLevel(clientUuid).add(list);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.userClientRoleMappingsPath(userId, clientUuid), ResourceType.CLIENT_ROLE_MAPPING);
        Assert.assertNames(roles.realmLevel().listAll(), "realm-role", "realm-composite", "user", "offline_access", "uma_authorization");
        Assert.assertNames(roles.realmLevel().listAvailable(), "admin");
        Assert.assertNames(roles.realmLevel().listEffective(), "realm-role", "realm-composite", "realm-child", "user", "offline_access", "uma_authorization");
        Assert.assertNames(roles.clientLevel(clientUuid).listAll(), "client-role", "client-composite");
        Assert.assertNames(roles.clientLevel(clientUuid).listAvailable(), "client-role2");
        Assert.assertNames(roles.clientLevel(clientUuid).listEffective(), "client-role", "client-composite", "client-child");
        MappingsRepresentation all = roles.getAll();
        Assert.assertNames(all.getRealmMappings(), "realm-role", "realm-composite", "user", "offline_access", "uma_authorization");
        org.junit.Assert.assertEquals((long)2L, (long)all.getClientMappings().size());
        Assert.assertNames(((ClientMappingsRepresentation)all.getClientMappings().get("myclient")).getMappings(), "client-role", "client-composite");
        Assert.assertNames(((ClientMappingsRepresentation)all.getClientMappings().get("account")).getMappings(), "manage-account", "view-profile");
        RoleRepresentation realmRoleRep = realm.roles().get("realm-role").toRepresentation();
        roles.realmLevel().remove(Collections.singletonList(realmRoleRep));
        this.assertAdminEvents.assertEvent("test", OperationType.DELETE, AdminEventPaths.userRealmRoleMappingsPath(userId), Collections.singletonList(realmRoleRep), ResourceType.REALM_ROLE_MAPPING);
        Assert.assertNames(roles.realmLevel().listAll(), "realm-composite", "user", "offline_access", "uma_authorization");
        RoleRepresentation clientRoleRep = realm.clients().get(clientUuid).roles().get("client-role").toRepresentation();
        roles.clientLevel(clientUuid).remove(Collections.singletonList(clientRoleRep));
        this.assertAdminEvents.assertEvent("test", OperationType.DELETE, AdminEventPaths.userClientRoleMappingsPath(userId, clientUuid), Collections.singletonList(clientRoleRep), ResourceType.CLIENT_ROLE_MAPPING);
        Assert.assertNames(roles.clientLevel(clientUuid).listAll(), "client-composite");
    }

    private void switchEditUsernameAllowedOn() {
        RealmRepresentation rep = this.realm.toRepresentation();
        rep.setEditUsernameAllowed(Boolean.valueOf(true));
        this.realm.update(rep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, (Matcher<String>)Matchers.nullValue(String.class), (Object)rep, ResourceType.REALM);
    }

    private void enableBruteForce() {
        RealmRepresentation rep = this.realm.toRepresentation();
        rep.setBruteForceProtected(Boolean.valueOf(true));
        this.realm.update(rep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, (Matcher<String>)Matchers.nullValue(String.class), (Object)rep, ResourceType.REALM);
    }
}

