/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.authentication;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import javax.ws.rs.core.Response;
import org.junit.Before;
import org.junit.Rule;
import org.keycloak.admin.client.resource.AuthenticationManagementResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.AuthenticationExecutionExportRepresentation;
import org.keycloak.representations.idm.AuthenticationExecutionInfoRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.AuthenticatorConfigRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.util.AdminEventPaths;
import org.keycloak.testsuite.util.AssertAdminEvents;
import org.keycloak.testsuite.util.RealmBuilder;

public abstract class AbstractAuthenticationTest
extends AbstractKeycloakTest {
    static final String REALM_NAME = "test";
    static final String REQUIRED = "REQUIRED";
    static final String OPTIONAL = "OPTIONAL";
    static final String DISABLED = "DISABLED";
    static final String ALTERNATIVE = "ALTERNATIVE";
    RealmResource realmResource;
    AuthenticationManagementResource authMgmtResource;
    @Rule
    public AssertAdminEvents assertAdminEvents = new AssertAdminEvents(this);

    @Before
    public void before() {
        this.realmResource = this.adminClient.realms().realm(REALM_NAME);
        this.authMgmtResource = this.realmResource.flows();
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation testRealmRep = RealmBuilder.create().name(REALM_NAME).testEventListener().build();
        testRealmRep.setId(REALM_NAME);
        testRealms.add(testRealmRep);
    }

    public static AuthenticationExecutionInfoRepresentation findExecutionByProvider(String provider, List<AuthenticationExecutionInfoRepresentation> executions) {
        for (AuthenticationExecutionInfoRepresentation exec : executions) {
            if (!provider.equals(exec.getProviderId())) continue;
            return exec;
        }
        return null;
    }

    AuthenticationFlowRepresentation findFlowByAlias(String alias, List<AuthenticationFlowRepresentation> flows) {
        for (AuthenticationFlowRepresentation flow : flows) {
            if (!alias.equals(flow.getAlias())) continue;
            return flow;
        }
        return null;
    }

    void compareExecution(AuthenticationExecutionInfoRepresentation expected, AuthenticationExecutionInfoRepresentation actual) {
        org.junit.Assert.assertEquals((String)("Execution requirement - " + actual.getProviderId()), (Object)expected.getRequirement(), (Object)actual.getRequirement());
        org.junit.Assert.assertEquals((String)("Execution display name - " + actual.getProviderId()), (Object)expected.getDisplayName(), (Object)actual.getDisplayName());
        org.junit.Assert.assertEquals((String)("Execution configurable - " + actual.getProviderId()), (Object)expected.getConfigurable(), (Object)actual.getConfigurable());
        org.junit.Assert.assertEquals((String)("Execution provider id - " + actual.getProviderId()), (Object)expected.getProviderId(), (Object)actual.getProviderId());
        org.junit.Assert.assertEquals((String)("Execution level - " + actual.getProviderId()), (long)expected.getLevel(), (long)actual.getLevel());
        org.junit.Assert.assertEquals((String)("Execution index - " + actual.getProviderId()), (long)expected.getIndex(), (long)actual.getIndex());
        org.junit.Assert.assertEquals((String)("Execution authentication flow - " + actual.getProviderId()), (Object)expected.getAuthenticationFlow(), (Object)actual.getAuthenticationFlow());
        org.junit.Assert.assertEquals((String)("Execution requirement choices - " + actual.getProviderId()), (Object)expected.getRequirementChoices(), (Object)actual.getRequirementChoices());
    }

    void compareExecution(AuthenticationExecutionExportRepresentation expected, AuthenticationExecutionExportRepresentation actual) {
        org.junit.Assert.assertEquals((String)("Execution flowAlias - " + actual.getAuthenticator()), (Object)expected.getFlowAlias(), (Object)actual.getFlowAlias());
        org.junit.Assert.assertEquals((String)("Execution authenticator - " + actual.getAuthenticator()), (Object)expected.getAuthenticator(), (Object)actual.getAuthenticator());
        org.junit.Assert.assertEquals((String)("Execution userSetupAllowed - " + actual.getAuthenticator()), (Object)expected.isUserSetupAllowed(), (Object)actual.isUserSetupAllowed());
        org.junit.Assert.assertEquals((String)("Execution authenticatorFlow - " + actual.getAuthenticator()), (Object)expected.isAutheticatorFlow(), (Object)actual.isAutheticatorFlow());
        org.junit.Assert.assertEquals((String)("Execution authenticatorConfig - " + actual.getAuthenticator()), (Object)expected.getAuthenticatorConfig(), (Object)actual.getAuthenticatorConfig());
        org.junit.Assert.assertEquals((String)("Execution priority - " + actual.getAuthenticator()), (long)expected.getPriority(), (long)actual.getPriority());
        org.junit.Assert.assertEquals((String)("Execution requirement - " + actual.getAuthenticator()), (Object)expected.getRequirement(), (Object)actual.getRequirement());
    }

    void compareExecutions(List<AuthenticationExecutionExportRepresentation> expected, List<AuthenticationExecutionExportRepresentation> actual) {
        org.junit.Assert.assertNotNull((String)"Executions should not be null", actual);
        org.junit.Assert.assertEquals((String)"Size", (long)expected.size(), (long)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            this.compareExecution(expected.get(i), actual.get(i));
        }
    }

    void compareFlows(AuthenticationFlowRepresentation expected, AuthenticationFlowRepresentation actual) {
        org.junit.Assert.assertEquals((String)"Flow alias", (Object)expected.getAlias(), (Object)actual.getAlias());
        org.junit.Assert.assertEquals((String)"Flow description", (Object)expected.getDescription(), (Object)actual.getDescription());
        org.junit.Assert.assertEquals((String)"Flow providerId", (Object)expected.getProviderId(), (Object)actual.getProviderId());
        org.junit.Assert.assertEquals((String)"Flow top level", (Object)expected.isTopLevel(), (Object)actual.isTopLevel());
        org.junit.Assert.assertEquals((String)"Flow built-in", (Object)expected.isBuiltIn(), (Object)actual.isBuiltIn());
        List expectedExecs = expected.getAuthenticationExecutions();
        List actualExecs = actual.getAuthenticationExecutions();
        if (expectedExecs == null) {
            org.junit.Assert.assertTrue((String)"Executions should be null or empty", (actualExecs == null || actualExecs.size() == 0 ? 1 : 0) != 0);
        } else {
            this.compareExecutions(expectedExecs, actualExecs);
        }
    }

    AuthenticationFlowRepresentation newFlow(String alias, String description, String providerId, boolean topLevel, boolean builtIn) {
        AuthenticationFlowRepresentation flow = new AuthenticationFlowRepresentation();
        flow.setAlias(alias);
        flow.setDescription(description);
        flow.setProviderId(providerId);
        flow.setTopLevel(topLevel);
        flow.setBuiltIn(builtIn);
        return flow;
    }

    AuthenticationExecutionInfoRepresentation newExecInfo(String displayName, String providerId, Boolean configurable, int level, int index, String requirement, Boolean authFlow, String[] choices) {
        AuthenticationExecutionInfoRepresentation execution = new AuthenticationExecutionInfoRepresentation();
        execution.setRequirement(requirement);
        execution.setDisplayName(displayName);
        execution.setConfigurable(configurable);
        execution.setProviderId(providerId);
        execution.setLevel(level);
        execution.setIndex(index);
        execution.setAuthenticationFlow(authFlow);
        if (choices != null) {
            execution.setRequirementChoices(Arrays.asList(choices));
        }
        return execution;
    }

    void addExecInfo(List<AuthenticationExecutionInfoRepresentation> target, String displayName, String providerId, Boolean configurable, int level, int index, String requirement, Boolean authFlow, String[] choices) {
        AuthenticationExecutionInfoRepresentation exec = this.newExecInfo(displayName, providerId, configurable, level, index, requirement, authFlow, choices);
        target.add(exec);
    }

    AuthenticatorConfigRepresentation newConfig(String alias, String[] keyvalues) {
        AuthenticatorConfigRepresentation config = new AuthenticatorConfigRepresentation();
        config.setAlias(alias);
        if (keyvalues == null) {
            throw new IllegalArgumentException("keyvalues == null");
        }
        if (keyvalues.length % 2 != 0) {
            throw new IllegalArgumentException("keyvalues should have even number of elements");
        }
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        for (int i = 0; i < keyvalues.length; i += 2) {
            params.put(keyvalues[i], keyvalues[i + 1]);
        }
        config.setConfig(params);
        return config;
    }

    void createFlow(AuthenticationFlowRepresentation flowRep) {
        Response response = this.authMgmtResource.createFlow(flowRep);
        Assert.assertEquals((long)201L, (long)response.getStatus());
        response.close();
        this.assertAdminEvents.assertEvent(REALM_NAME, OperationType.CREATE, AssertAdminEvents.isExpectedPrefixFollowedByUuid(AdminEventPaths.authFlowsPath()), (Object)flowRep, ResourceType.AUTH_FLOW);
    }
}

