/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.authentication;

import java.util.HashMap;
import java.util.List;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.AuthenticationExecutionInfoRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.AuthenticatorConfigRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.admin.authentication.AbstractAuthenticationTest;
import org.keycloak.testsuite.util.AdminEventPaths;

public class AuthenticatorConfigTest
extends AbstractAuthenticationTest {
    private String executionId;

    @Before
    public void beforeConfigTest() {
        AuthenticationFlowRepresentation flowRep = this.newFlow("firstBrokerLogin2", "firstBrokerLogin2", "basic-flow", true, false);
        this.createFlow(flowRep);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("provider", "idp-create-user-if-unique");
        this.authMgmtResource.addExecution("firstBrokerLogin2", params);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.authAddExecutionPath("firstBrokerLogin2"), params, ResourceType.AUTH_EXECUTION);
        List executionReps = this.authMgmtResource.getExecutions("firstBrokerLogin2");
        AuthenticationExecutionInfoRepresentation exec = AuthenticatorConfigTest.findExecutionByProvider("idp-create-user-if-unique", executionReps);
        Assert.assertNotNull((Object)exec);
        this.executionId = exec.getId();
    }

    @Test
    public void testCreateConfig() {
        AuthenticatorConfigRepresentation cfg = this.newConfig("foo", "require.password.update.after.registration", "true");
        Response response = this.authMgmtResource.newExecutionConfig("exec-id-doesnt-exists", cfg);
        Assert.assertEquals((long)404L, (long)response.getStatus());
        response.close();
        String cfgId = this.createConfig(this.executionId, cfg);
        AuthenticatorConfigRepresentation cfgRep = this.authMgmtResource.getAuthenticatorConfig(cfgId);
        this.assertConfig(cfgRep, cfgId, "foo", "require.password.update.after.registration", "true");
        this.authMgmtResource.removeAuthenticatorConfig(cfgId);
        this.assertAdminEvents.assertEvent("test", OperationType.DELETE, AdminEventPaths.authExecutionConfigPath(cfgId), ResourceType.AUTHENTICATOR_CONFIG);
    }

    @Test
    public void testUpdateConfig() {
        AuthenticatorConfigRepresentation cfg = this.newConfig("foo", "require.password.update.after.registration", "true");
        String cfgId = this.createConfig(this.executionId, cfg);
        AuthenticatorConfigRepresentation cfgRep = this.authMgmtResource.getAuthenticatorConfig(cfgId);
        try {
            this.authMgmtResource.updateAuthenticatorConfig("not-existent", cfgRep);
            Assert.fail((String)"Config didn't found");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        cfgRep = this.authMgmtResource.getAuthenticatorConfig(cfgId);
        this.assertConfig(cfgRep, cfgId, "foo", "require.password.update.after.registration", "true");
        cfgRep.setAlias("foo2");
        cfgRep.getConfig().put("configKey2", "configValue2");
        this.authMgmtResource.updateAuthenticatorConfig(cfgRep.getId(), cfgRep);
        this.assertAdminEvents.assertEvent("test", OperationType.UPDATE, AdminEventPaths.authExecutionConfigPath(cfgId), (Object)cfgRep, ResourceType.AUTHENTICATOR_CONFIG);
        cfgRep = this.authMgmtResource.getAuthenticatorConfig(cfgRep.getId());
        this.assertConfig(cfgRep, cfgId, "foo2", "require.password.update.after.registration", "true", "configKey2", "configValue2");
    }

    @Test
    public void testRemoveConfig() {
        AuthenticatorConfigRepresentation cfg = this.newConfig("foo", "require.password.update.after.registration", "true");
        String cfgId = this.createConfig(this.executionId, cfg);
        AuthenticatorConfigRepresentation cfgRep = this.authMgmtResource.getAuthenticatorConfig(cfgId);
        AuthenticationExecutionInfoRepresentation execution = AuthenticatorConfigTest.findExecutionByProvider("idp-create-user-if-unique", this.authMgmtResource.getExecutions("firstBrokerLogin2"));
        Assert.assertEquals((Object)cfgRep.getId(), (Object)execution.getAuthenticationConfig());
        try {
            this.authMgmtResource.removeAuthenticatorConfig("not-existent");
            Assert.fail((String)"Config didn't found");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.authMgmtResource.removeAuthenticatorConfig(cfgId);
        this.assertAdminEvents.assertEvent("test", OperationType.DELETE, AdminEventPaths.authExecutionConfigPath(cfgId), ResourceType.AUTHENTICATOR_CONFIG);
        try {
            this.authMgmtResource.getAuthenticatorConfig(cfgRep.getId());
            Assert.fail((String)"Not expected to find config");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        execution = AuthenticatorConfigTest.findExecutionByProvider("idp-create-user-if-unique", this.authMgmtResource.getExecutions("firstBrokerLogin2"));
        Assert.assertNull((Object)execution.getAuthenticationConfig());
    }

    private String createConfig(String executionId, AuthenticatorConfigRepresentation cfg) {
        Response resp = this.authMgmtResource.newExecutionConfig(executionId, cfg);
        Assert.assertEquals((long)201L, (long)resp.getStatus());
        String cfgId = ApiUtil.getCreatedId(resp);
        Assert.assertNotNull((Object)cfgId);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.authAddExecutionConfigPath(executionId), (Object)cfg, ResourceType.AUTH_EXECUTION);
        return cfgId;
    }

    private AuthenticatorConfigRepresentation newConfig(String alias, String cfgKey, String cfgValue) {
        AuthenticatorConfigRepresentation cfg = new AuthenticatorConfigRepresentation();
        cfg.setAlias(alias);
        HashMap<String, String> cfgMap = new HashMap<String, String>();
        cfgMap.put(cfgKey, cfgValue);
        cfg.setConfig(cfgMap);
        return cfg;
    }

    private void assertConfig(AuthenticatorConfigRepresentation cfgRep, String id, String alias, String ... fields) {
        Assert.assertEquals((Object)id, (Object)cfgRep.getId());
        Assert.assertEquals((Object)alias, (Object)cfgRep.getAlias());
        Assert.assertMap(cfgRep.getConfig(), fields);
    }
}

