/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.authentication;

import java.util.HashMap;
import java.util.List;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.AuthenticationExecutionExportRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.testsuite.admin.authentication.AbstractAuthenticationTest;
import org.keycloak.testsuite.util.AdminEventPaths;

public class FlowTest
extends AbstractAuthenticationTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddRemoveFlow() {
        List flows = this.authMgmtResource.getFlows();
        for (AuthenticationFlowRepresentation flow : flows) {
            try {
                this.authMgmtResource.deleteFlow(flow.getId());
                Assert.fail((String)"deleteFlow should fail for built in flow");
            }
            catch (BadRequestException e) {
                break;
            }
        }
        try (Response response = this.authMgmtResource.createFlow(this.newFlow("browser", "Browser flow", "basic-flow", true, false));){
            Assert.assertEquals((String)"createFlow using the alias of existing flow should fail", (long)409L, (long)response.getStatus());
        }
        response = this.authMgmtResource.createFlow(this.newFlow(null, "Browser flow", "basic-flow", true, false));
        try {
            Assert.assertEquals((String)"createFlow using the alias of existing flow should fail", (long)409L, (long)response.getStatus());
        }
        finally {
            response.close();
        }
        AuthenticationFlowRepresentation newFlow = this.newFlow("browser-2", "Browser flow", "basic-flow", true, false);
        this.createFlow(newFlow);
        flows = this.authMgmtResource.getFlows();
        AuthenticationFlowRepresentation found = this.findFlowByAlias("browser-2", flows);
        Assert.assertNotNull((String)"created flow visible in parent", (Object)found);
        this.compareFlows(newFlow, found);
        try {
            this.authMgmtResource.getFlow("id-123-notExistent");
            Assert.fail((String)"Not expected to find unexistent flow");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        AuthenticationFlowRepresentation found2 = this.authMgmtResource.getFlow(found.getId());
        Assert.assertNotNull((String)"created flow visible directly", (Object)found2);
        this.compareFlows(newFlow, found2);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("alias", "SomeFlow");
        data.put("type", "basic-flow");
        data.put("description", "Test flow");
        data.put("provider", "registration-page-form");
        try {
            this.authMgmtResource.addExecutionFlow("inexistent-parent-flow-alias", data);
            Assert.fail((String)"addExecutionFlow for inexistent parent should have failed");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            data.put("alias", "browser");
            this.authMgmtResource.addExecutionFlow("browser-2", data);
            Assert.fail((String)"addExecutionFlow should have failed as browser flow already exists");
        }
        catch (Exception exception) {
            // empty catch block
        }
        data.put("alias", "SomeFlow");
        this.authMgmtResource.addExecutionFlow("browser-2", data);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.authAddExecutionFlowPath("browser-2"), data, ResourceType.AUTH_EXECUTION_FLOW);
        flows = this.authMgmtResource.getFlows();
        found2 = this.findFlowByAlias("browser-2", flows);
        Assert.assertNotNull((String)"created flow visible in parent", (Object)found2);
        List execs = found2.getAuthenticationExecutions();
        Assert.assertNotNull((Object)execs);
        Assert.assertEquals((String)"Size one", (long)1L, (long)execs.size());
        AuthenticationExecutionExportRepresentation expected = new AuthenticationExecutionExportRepresentation();
        expected.setFlowAlias("SomeFlow");
        expected.setUserSetupAllowed(false);
        expected.setAuthenticator("registration-page-form");
        expected.setAutheticatorFlow(true);
        expected.setRequirement("DISABLED");
        expected.setPriority(0);
        this.compareExecution(expected, (AuthenticationExecutionExportRepresentation)execs.get(0));
        this.authMgmtResource.deleteFlow(found.getId());
        this.assertAdminEvents.assertEvent("test", OperationType.DELETE, AdminEventPaths.authFlowPath(found.getId()), ResourceType.AUTH_FLOW);
        flows = this.authMgmtResource.getFlows();
        found = this.findFlowByAlias("browser-2", flows);
        Assert.assertNull((String)"flow deleted", (Object)found);
        try {
            this.authMgmtResource.deleteFlow("id-123-notExistent");
            Assert.fail((String)"Not expected to delete flow, which doesn't exists");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyFlow() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("newName", "clients");
        try (Response response = this.authMgmtResource.copy("browser", params);){
            Assert.assertEquals((String)"Copy flow using the new alias of existing flow should fail", (long)409L, (long)response.getStatus());
        }
        params.clear();
        response = this.authMgmtResource.copy("non-existent", params);
        try {
            Assert.assertEquals((String)"Copy non-existing flow", (long)404L, (long)response.getStatus());
        }
        finally {
            response.close();
        }
        params.put("newName", "Copy of browser");
        response = this.authMgmtResource.copy("browser", params);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.authCopyFlowPath("browser"), params, ResourceType.AUTH_FLOW);
        try {
            Assert.assertEquals((String)"Copy flow", (long)201L, (long)response.getStatus());
        }
        finally {
            response.close();
        }
        List flows = this.authMgmtResource.getFlows();
        AuthenticationFlowRepresentation browser = this.findFlowByAlias("browser", flows);
        AuthenticationFlowRepresentation copyOfBrowser = this.findFlowByAlias("Copy of browser", flows);
        Assert.assertNotNull((Object)browser);
        Assert.assertNotNull((Object)copyOfBrowser);
        browser.setAlias("Copy of browser");
        browser.setBuiltIn(false);
        ((AuthenticationExecutionExportRepresentation)browser.getAuthenticationExecutions().get(2)).setFlowAlias("Copy of browser forms");
        this.compareFlows(browser, copyOfBrowser);
        copyOfBrowser = this.authMgmtResource.getFlow(copyOfBrowser.getId());
        Assert.assertNotNull((Object)copyOfBrowser);
        this.compareFlows(browser, copyOfBrowser);
    }

    @Test
    public void addExecutionFlow() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("newName", "parent");
        Response response = this.authMgmtResource.copy("browser", params);
        Assert.assertEquals((long)201L, (long)response.getStatus());
        response.close();
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.authCopyFlowPath("browser"), params, ResourceType.AUTH_FLOW);
        params = new HashMap();
        params.put("alias", "child");
        params.put("description", "Description");
        params.put("provider", "registration-page-form");
        params.put("type", "basic-flow");
        this.authMgmtResource.addExecutionFlow("parent", params);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.authAddExecutionFlowPath("parent"), params, ResourceType.AUTH_EXECUTION_FLOW);
    }
}

