/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.authentication;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.representations.idm.AuthenticationExecutionExportRepresentation;
import org.keycloak.representations.idm.AuthenticationExecutionInfoRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.AuthenticatorConfigRepresentation;
import org.keycloak.testsuite.admin.authentication.AbstractAuthenticationTest;

public class InitialFlowsTest
extends AbstractAuthenticationTest {
    private HashMap<String, AuthenticatorConfigRepresentation> configs = new HashMap();
    private HashMap<String, AuthenticatorConfigRepresentation> expectedConfigs = new HashMap();

    public InitialFlowsTest() {
        this.expectedConfigs.put("idp-review-profile", this.newConfig("review profile config", new String[]{"update.profile.on.first.login", "missing"}));
        this.expectedConfigs.put("idp-create-user-if-unique", this.newConfig("create unique user config", new String[]{"require.password.update.after.registration", "false"}));
    }

    @Test
    public void testInitialFlows() {
        LinkedList<FlowExecutions> result = new LinkedList<FlowExecutions>();
        List flows = this.authMgmtResource.getFlows();
        for (AuthenticationFlowRepresentation flow : flows) {
            List executionReps = this.authMgmtResource.getExecutions(flow.getAlias());
            for (AuthenticationExecutionInfoRepresentation exec : executionReps) {
                String configId = exec.getAuthenticationConfig();
                if (configId == null || this.configs.containsKey(configId)) continue;
                this.configs.put(configId, this.authMgmtResource.getAuthenticatorConfig(configId));
            }
            result.add(new FlowExecutions(flow, executionReps));
        }
        this.compare(this.expectedFlows(), this.orderAlphabetically(result));
    }

    private void compare(List<FlowExecutions> expected, List<FlowExecutions> actual) {
        Assert.assertEquals((String)"Flow count", (long)expected.size(), (long)actual.size());
        Iterator<FlowExecutions> it1 = expected.iterator();
        Iterator<FlowExecutions> it2 = actual.iterator();
        while (it1.hasNext()) {
            FlowExecutions fe1 = it1.next();
            FlowExecutions fe2 = it2.next();
            this.compareFlows(fe1.flow, fe2.flow);
            this.compareExecutionsInfo(fe1.executions, fe2.executions);
        }
    }

    private void compareExecutionsInfo(List<AuthenticationExecutionInfoRepresentation> expected, List<AuthenticationExecutionInfoRepresentation> actual) {
        Assert.assertEquals((String)"Executions count", (long)expected.size(), (long)actual.size());
        Iterator<AuthenticationExecutionInfoRepresentation> it1 = expected.iterator();
        Iterator<AuthenticationExecutionInfoRepresentation> it2 = actual.iterator();
        while (it1.hasNext()) {
            AuthenticationExecutionInfoRepresentation exe1 = it1.next();
            AuthenticationExecutionInfoRepresentation exe2 = it2.next();
            this.compareExecutionWithConfig(exe1, exe2);
        }
    }

    private void compareExecutionWithConfig(AuthenticationExecutionInfoRepresentation expected, AuthenticationExecutionInfoRepresentation actual) {
        super.compareExecution(expected, actual);
        this.compareAuthConfig(expected, actual);
    }

    private void compareAuthConfig(AuthenticationExecutionInfoRepresentation expected, AuthenticationExecutionInfoRepresentation actual) {
        AuthenticatorConfigRepresentation cfg1 = this.expectedConfigs.get(expected.getProviderId());
        AuthenticatorConfigRepresentation cfg2 = this.configs.get(actual.getAuthenticationConfig());
        if (cfg1 == null && cfg2 == null) {
            return;
        }
        Assert.assertEquals((String)"Execution configuration alias", (Object)cfg1.getAlias(), (Object)cfg2.getAlias());
        Assert.assertEquals((String)"Execution configuration params", (Object)cfg1.getConfig(), (Object)cfg2.getConfig());
    }

    private List<FlowExecutions> orderAlphabetically(List<FlowExecutions> result) {
        ArrayList<FlowExecutions> sorted = new ArrayList<FlowExecutions>(result);
        Collections.sort(sorted);
        return sorted;
    }

    private LinkedList<FlowExecutions> expectedFlows() {
        LinkedList<FlowExecutions> expected = new LinkedList<FlowExecutions>();
        AuthenticationFlowRepresentation flow = this.newFlow("browser", "browser based authentication", "basic-flow", true, true);
        this.addExecExport(flow, null, false, "auth-cookie", false, null, "ALTERNATIVE", 10);
        this.addExecExport(flow, null, false, "auth-spnego", false, null, "DISABLED", 20);
        this.addExecExport(flow, "forms", false, null, true, null, "ALTERNATIVE", 30);
        LinkedList<Object> execs = new LinkedList<AuthenticationExecutionInfoRepresentation>();
        this.addExecInfo(execs, "Cookie", "auth-cookie", false, 0, 0, "ALTERNATIVE", null, new String[]{"ALTERNATIVE", "DISABLED"});
        this.addExecInfo(execs, "Kerberos", "auth-spnego", false, 0, 1, "DISABLED", null, new String[]{"ALTERNATIVE", "REQUIRED", "DISABLED"});
        this.addExecInfo(execs, "forms", null, false, 0, 2, "ALTERNATIVE", true, new String[]{"ALTERNATIVE", "REQUIRED", "DISABLED"});
        this.addExecInfo(execs, "Username Password Form", "auth-username-password-form", false, 1, 0, "REQUIRED", null, new String[]{"REQUIRED"});
        this.addExecInfo(execs, "OTP Form", "auth-otp-form", false, 1, 1, "OPTIONAL", null, new String[]{"REQUIRED", "OPTIONAL", "DISABLED"});
        expected.add(new FlowExecutions(flow, execs));
        flow = this.newFlow("clients", "Base authentication for clients", "client-flow", true, true);
        this.addExecExport(flow, null, false, "client-secret", false, null, "ALTERNATIVE", 10);
        this.addExecExport(flow, null, false, "client-jwt", false, null, "ALTERNATIVE", 20);
        execs = new LinkedList();
        this.addExecInfo(execs, "Client Id and Secret", "client-secret", false, 0, 0, "ALTERNATIVE", null, new String[]{"ALTERNATIVE", "DISABLED"});
        this.addExecInfo(execs, "Signed Jwt", "client-jwt", false, 0, 1, "ALTERNATIVE", null, new String[]{"ALTERNATIVE", "DISABLED"});
        expected.add(new FlowExecutions(flow, execs));
        flow = this.newFlow("direct grant", "OpenID Connect Resource Owner Grant", "basic-flow", true, true);
        this.addExecExport(flow, null, false, "direct-grant-validate-username", false, null, "REQUIRED", 10);
        this.addExecExport(flow, null, false, "direct-grant-validate-password", false, null, "REQUIRED", 20);
        this.addExecExport(flow, null, false, "direct-grant-validate-otp", false, null, "OPTIONAL", 30);
        execs = new LinkedList();
        this.addExecInfo(execs, "Username Validation", "direct-grant-validate-username", false, 0, 0, "REQUIRED", null, new String[]{"REQUIRED"});
        this.addExecInfo(execs, "Password", "direct-grant-validate-password", false, 0, 1, "REQUIRED", null, new String[]{"REQUIRED", "DISABLED"});
        this.addExecInfo(execs, "OTP", "direct-grant-validate-otp", false, 0, 2, "OPTIONAL", null, new String[]{"REQUIRED", "OPTIONAL", "DISABLED"});
        expected.add(new FlowExecutions(flow, execs));
        flow = this.newFlow("first broker login", "Actions taken after first broker login with identity provider account, which is not yet linked to any Keycloak account", "basic-flow", true, true);
        this.addExecExport(flow, null, false, "idp-review-profile", false, "review profile config", "REQUIRED", 10);
        this.addExecExport(flow, null, false, "idp-create-user-if-unique", false, "create unique user config", "ALTERNATIVE", 20);
        this.addExecExport(flow, "Handle Existing Account", false, null, true, null, "ALTERNATIVE", 30);
        execs = new LinkedList();
        this.addExecInfo(execs, "Review Profile", "idp-review-profile", true, 0, 0, "REQUIRED", null, new String[]{"REQUIRED", "DISABLED"});
        this.addExecInfo(execs, "Create User If Unique", "idp-create-user-if-unique", true, 0, 1, "ALTERNATIVE", null, new String[]{"ALTERNATIVE", "REQUIRED", "DISABLED"});
        this.addExecInfo(execs, "Handle Existing Account", null, false, 0, 2, "ALTERNATIVE", true, new String[]{"ALTERNATIVE", "REQUIRED", "DISABLED"});
        this.addExecInfo(execs, "Confirm link existing account", "idp-confirm-link", false, 1, 0, "REQUIRED", null, new String[]{"REQUIRED", "DISABLED"});
        this.addExecInfo(execs, "Verify existing account by Email", "idp-email-verification", false, 1, 1, "ALTERNATIVE", null, new String[]{"ALTERNATIVE", "REQUIRED", "DISABLED"});
        this.addExecInfo(execs, "Verify Existing Account by Re-authentication", null, false, 1, 2, "ALTERNATIVE", true, new String[]{"ALTERNATIVE", "REQUIRED", "DISABLED"});
        this.addExecInfo(execs, "Username Password Form for identity provider reauthentication", "idp-username-password-form", false, 2, 0, "REQUIRED", null, new String[]{"REQUIRED"});
        this.addExecInfo(execs, "OTP Form", "auth-otp-form", false, 2, 1, "OPTIONAL", null, new String[]{"REQUIRED", "OPTIONAL", "DISABLED"});
        expected.add(new FlowExecutions(flow, execs));
        flow = this.newFlow("registration", "registration flow", "basic-flow", true, true);
        this.addExecExport(flow, "registration form", false, "registration-page-form", true, null, "REQUIRED", 10);
        execs = new LinkedList();
        this.addExecInfo(execs, "registration form", "registration-page-form", false, 0, 0, "REQUIRED", true, new String[]{"REQUIRED", "DISABLED"});
        this.addExecInfo(execs, "Registration User Creation", "registration-user-creation", false, 1, 0, "REQUIRED", null, new String[]{"REQUIRED", "DISABLED"});
        this.addExecInfo(execs, "Profile Validation", "registration-profile-action", false, 1, 1, "REQUIRED", null, new String[]{"REQUIRED", "DISABLED"});
        this.addExecInfo(execs, "Password Validation", "registration-password-action", false, 1, 2, "REQUIRED", null, new String[]{"REQUIRED", "DISABLED"});
        this.addExecInfo(execs, "Recaptcha", "registration-recaptcha-action", true, 1, 3, "DISABLED", null, new String[]{"REQUIRED", "DISABLED"});
        expected.add(new FlowExecutions(flow, execs));
        flow = this.newFlow("reset credentials", "Reset credentials for a user if they forgot their password or something", "basic-flow", true, true);
        this.addExecExport(flow, null, false, "reset-credentials-choose-user", false, null, "REQUIRED", 10);
        this.addExecExport(flow, null, false, "reset-credential-email", false, null, "REQUIRED", 20);
        this.addExecExport(flow, null, false, "reset-password", false, null, "REQUIRED", 30);
        this.addExecExport(flow, null, false, "reset-otp", false, null, "OPTIONAL", 40);
        execs = new LinkedList();
        this.addExecInfo(execs, "Choose User", "reset-credentials-choose-user", false, 0, 0, "REQUIRED", null, new String[]{"REQUIRED"});
        this.addExecInfo(execs, "Send Reset Email", "reset-credential-email", false, 0, 1, "REQUIRED", null, new String[]{"REQUIRED"});
        this.addExecInfo(execs, "Reset Password", "reset-password", false, 0, 2, "REQUIRED", null, new String[]{"REQUIRED", "OPTIONAL", "DISABLED"});
        this.addExecInfo(execs, "Reset OTP", "reset-otp", false, 0, 3, "OPTIONAL", null, new String[]{"REQUIRED", "OPTIONAL", "DISABLED"});
        expected.add(new FlowExecutions(flow, execs));
        flow = this.newFlow("saml ecp", "SAML ECP Profile Authentication Flow", "basic-flow", true, true);
        this.addExecExport(flow, null, false, "http-basic-authenticator", false, null, "REQUIRED", 10);
        execs = new LinkedList();
        this.addExecInfo(execs, "HTTP Basic Authentication", "http-basic-authenticator", false, 0, 0, "REQUIRED", null, new String[0]);
        expected.add(new FlowExecutions(flow, execs));
        return expected;
    }

    private void addExecExport(AuthenticationFlowRepresentation flow, String flowAlias, boolean userSetupAllowed, String authenticator, boolean authenticatorFlow, String authenticatorConfig, String requirement, int priority) {
        AuthenticationExecutionExportRepresentation rep = this.newExecutionExportRepresentation(flowAlias, userSetupAllowed, authenticator, authenticatorFlow, authenticatorConfig, requirement, priority);
        ArrayList<AuthenticationExecutionExportRepresentation> execs = flow.getAuthenticationExecutions();
        if (execs == null) {
            execs = new ArrayList<AuthenticationExecutionExportRepresentation>();
            flow.setAuthenticationExecutions(execs);
        }
        execs.add(rep);
    }

    private AuthenticationExecutionExportRepresentation newExecutionExportRepresentation(String flowAlias, boolean userSetupAllowed, String authenticator, boolean authenticatorFlow, String authenticatorConfig, String requirement, int priority) {
        AuthenticationExecutionExportRepresentation rep = new AuthenticationExecutionExportRepresentation();
        rep.setFlowAlias(flowAlias);
        rep.setUserSetupAllowed(userSetupAllowed);
        rep.setAuthenticator(authenticator);
        rep.setAutheticatorFlow(authenticatorFlow);
        rep.setAuthenticatorConfig(authenticatorConfig);
        rep.setRequirement(requirement);
        rep.setPriority(priority);
        return rep;
    }

    private static class FlowExecutions
    implements Comparable<FlowExecutions> {
        AuthenticationFlowRepresentation flow;
        List<AuthenticationExecutionInfoRepresentation> executions;

        FlowExecutions(AuthenticationFlowRepresentation flow, List<AuthenticationExecutionInfoRepresentation> executions) {
            this.flow = flow;
            this.executions = executions;
        }

        @Override
        public int compareTo(FlowExecutions o) {
            return this.flow.getAlias().compareTo(o.flow.getAlias());
        }
    }
}

