/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.authentication;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.NotFoundException;
import org.junit.Test;
import org.keycloak.representations.idm.AuthenticatorConfigInfoRepresentation;
import org.keycloak.representations.idm.ConfigPropertyRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.authentication.AbstractAuthenticationTest;

public class ProvidersTest
extends AbstractAuthenticationTest {
    @Test
    public void testFormProviders() {
        List result = this.authMgmtResource.getFormProviders();
        Assert.assertNotNull((String)"null result", (Object)result);
        Assert.assertEquals((String)"size", (long)1L, (long)result.size());
        Map item = (Map)result.get(0);
        Assert.assertEquals((String)"id", (Object)"registration-page-form", item.get("id"));
        Assert.assertEquals((String)"displayName", (Object)"Registration Page", item.get("displayName"));
        Assert.assertEquals((String)"description", (Object)"This is the controller for the registration page", item.get("description"));
    }

    @Test
    public void testFormActionProviders() {
        List result = this.authMgmtResource.getFormActionProviders();
        LinkedList<Map<String, Object>> expected = new LinkedList<Map<String, Object>>();
        this.addProviderInfo(expected, "registration-profile-action", "Profile Validation", "Validates email, first name, and last name attributes and stores them in user data.");
        this.addProviderInfo(expected, "registration-recaptcha-action", "Recaptcha", "Adds Google Recaptcha button.  Recaptchas verify that the entity that is registering is a human.  This can only be used on the internet and must be configured after you add it.");
        this.addProviderInfo(expected, "registration-password-action", "Password Validation", "Validates that password matches password confirmation field.  It also will store password in user's credential store.");
        this.addProviderInfo(expected, "registration-user-creation", "Registration User Creation", "This action must always be first! Validates the username of the user in validation phase.  In success phase, this will create the user in the database.");
        this.compareProviders(expected, result);
    }

    @Test
    public void testClientAuthenticatorProviders() {
        List result = this.authMgmtResource.getClientAuthenticatorProviders();
        LinkedList<Map<String, Object>> expected = new LinkedList<Map<String, Object>>();
        this.addProviderInfo(expected, "client-jwt", "Signed Jwt", "Validates client based on signed JWT issued by client and signed with the Client private key");
        this.addProviderInfo(expected, "client-secret", "Client Id and Secret", "Validates client based on 'client_id' and 'client_secret' sent either in request parameters or in 'Authorization: Basic' header");
        this.addProviderInfo(expected, "testsuite-client-passthrough", "Testsuite Dummy Client Validation", "Testsuite dummy authenticator, which automatically authenticates hardcoded client (like 'test-app' )");
        this.compareProviders(expected, result);
    }

    @Test
    public void testPerClientConfigDescriptions() {
        Map configs = this.authMgmtResource.getPerClientConfigDescription();
        Assert.assertTrue((boolean)configs.containsKey("client-jwt"));
        Assert.assertTrue((boolean)configs.containsKey("client-secret"));
        Assert.assertTrue((boolean)configs.containsKey("testsuite-client-passthrough"));
        Assert.assertTrue((boolean)((List)configs.get("client-jwt")).isEmpty());
        Assert.assertTrue((boolean)((List)configs.get("client-secret")).isEmpty());
        List cfg = (List)configs.get("testsuite-client-passthrough");
        Assert.assertProviderConfigProperty((ConfigPropertyRepresentation)cfg.get(0), "passthroughauth.foo", "Foo Property", null, "Foo Property of this authenticator, which does nothing", "String");
        Assert.assertProviderConfigProperty((ConfigPropertyRepresentation)cfg.get(1), "passthroughauth.bar", "Bar Property", null, "Bar Property of this authenticator, which does nothing", "boolean");
    }

    @Test
    public void testAuthenticatorConfigDescription() {
        try {
            this.authMgmtResource.getAuthenticatorConfigDescription("not-existent");
            Assert.fail((String)"Don't expected to find provider 'not-existent'");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        AuthenticatorConfigInfoRepresentation infoRep = this.authMgmtResource.getAuthenticatorConfigDescription("idp-create-user-if-unique");
        Assert.assertEquals((Object)"Create User If Unique", (Object)infoRep.getName());
        Assert.assertEquals((Object)"idp-create-user-if-unique", (Object)infoRep.getProviderId());
        Assert.assertEquals((Object)"Detect if there is existing Keycloak account with same email like identity provider. If no, create new user", (Object)infoRep.getHelpText());
        Assert.assertEquals((long)1L, (long)infoRep.getProperties().size());
        Assert.assertProviderConfigProperty((ConfigPropertyRepresentation)infoRep.getProperties().get(0), "require.password.update.after.registration", "Require Password Update After Registration", null, "If this option is true and new user is successfully imported from Identity Provider to Keycloak (there is no duplicated email or username detected in Keycloak DB), then this user is required to update his password", "boolean");
    }

    @Test
    public void testInitialAuthenticationProviders() {
        List<Map<String, Object>> providers = this.authMgmtResource.getAuthenticatorProviders();
        providers = this.sortProviders(providers);
        this.compareProviders(this.expectedAuthProviders(), providers);
    }

    private List<Map<String, Object>> expectedAuthProviders() {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        this.addProviderInfo(result, "auth-conditional-otp-form", "Conditional OTP Form", "Validates a OTP on a separate OTP form. Only shown if required based on the configured conditions.");
        this.addProviderInfo(result, "auth-cookie", "Cookie", "Validates the SSO cookie set by the auth server.");
        this.addProviderInfo(result, "auth-otp-form", "OTP Form", "Validates a OTP on a separate OTP form.");
        this.addProviderInfo(result, "auth-script-based", "Script-based Authentication", "Script based authentication.");
        this.addProviderInfo(result, "auth-spnego", "Kerberos", "Initiates the SPNEGO protocol.  Most often used with Kerberos.");
        this.addProviderInfo(result, "auth-username-password-form", "Username Password Form", "Validates a username and password from login form.");
        this.addProviderInfo(result, "direct-grant-validate-otp", "OTP", "Validates the one time password supplied as a 'totp' form parameter in direct grant request");
        this.addProviderInfo(result, "direct-grant-validate-password", "Password", "Validates the password supplied as a 'password' form parameter in direct grant request");
        this.addProviderInfo(result, "direct-grant-validate-username", "Username Validation", "Validates the username supplied as a 'username' form parameter in direct grant request");
        this.addProviderInfo(result, "http-basic-authenticator", "HTTP Basic Authentication", "Validates username and password from Authorization HTTP header");
        this.addProviderInfo(result, "idp-confirm-link", "Confirm link existing account", "Show the form where user confirms if he wants to link identity provider with existing account or rather edit user profile data retrieved from identity provider to avoid conflict");
        this.addProviderInfo(result, "idp-create-user-if-unique", "Create User If Unique", "Detect if there is existing Keycloak account with same email like identity provider. If no, create new user");
        this.addProviderInfo(result, "idp-email-verification", "Verify existing account by Email", "Email verification of existing Keycloak user, that wants to link his user account with identity provider");
        this.addProviderInfo(result, "idp-review-profile", "Review Profile", "User reviews and updates profile data retrieved from Identity Provider in the displayed form");
        this.addProviderInfo(result, "idp-username-password-form", "Username Password Form for identity provider reauthentication", "Validates a password from login form. Username is already known from identity provider authentication");
        this.addProviderInfo(result, "reset-credential-email", "Send Reset Email", "Send email to user and wait for response.");
        this.addProviderInfo(result, "reset-credentials-choose-user", "Choose User", "Choose a user to reset credentials for");
        this.addProviderInfo(result, "reset-otp", "Reset OTP", "Sets the Configure OTP required action if execution is REQUIRED.  Will also set it if execution is OPTIONAL and the OTP is currently configured for it.");
        this.addProviderInfo(result, "reset-password", "Reset Password", "Sets the Update Password required action if execution is REQUIRED.  Will also set it if execution is OPTIONAL and the password is currently configured for it.");
        this.addProviderInfo(result, "testsuite-dummy-passthrough", "Testsuite Dummy Pass Thru", "Testsuite Dummy authenticator.  Just passes through and is hardcoded to a specific user");
        this.addProviderInfo(result, "testsuite-dummy-registration", "Testsuite Dummy Pass Thru", "Testsuite Dummy authenticator.  Just passes through and is hardcoded to a specific user");
        return result;
    }

    private List<Map<String, Object>> sortProviders(List<Map<String, Object>> providers) {
        ArrayList<Map<String, Object>> sorted = new ArrayList<Map<String, Object>>(providers);
        Collections.sort(sorted, new ProviderComparator());
        return sorted;
    }

    private void compareProviders(List<Map<String, Object>> expected, List<Map<String, Object>> actual) {
        Assert.assertEquals((String)"Providers count", (long)expected.size(), (long)actual.size());
        Assert.assertEquals(this.normalizeResults(expected), this.normalizeResults(actual));
    }

    private List<Map<String, Object>> normalizeResults(List<Map<String, Object>> list) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> item : list) {
            result.add(new HashMap<String, Object>(item));
        }
        return result;
    }

    private void addProviderInfo(List<Map<String, Object>> list, String id, String displayName, String description) {
        HashMap<String, String> item = new HashMap<String, String>();
        item.put("id", id);
        item.put("displayName", displayName);
        item.put("description", description);
        list.add(item);
    }

    private static class ProviderComparator
    implements Comparator<Map<String, Object>> {
        private ProviderComparator() {
        }

        @Override
        public int compare(Map<String, Object> o1, Map<String, Object> o2) {
            return String.valueOf(o1.get("id")).compareTo(String.valueOf(o2.get("id")));
        }
    }
}

