/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.authentication;

import java.util.HashMap;
import javax.ws.rs.BadRequestException;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.testsuite.admin.authentication.AbstractAuthenticationTest;
import org.keycloak.testsuite.util.AdminEventPaths;

public class RegistrationFlowTest
extends AbstractAuthenticationTest {
    @Test
    public void testAddExecution() {
        AuthenticationFlowRepresentation flowRep = this.newFlow("registration2", "RegistrationFlow2", "basic-flow", true, false);
        this.createFlow(flowRep);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("alias", "registrationForm2");
        data.put("type", "form-flow");
        data.put("description", "registrationForm2 flow");
        data.put("provider", "registration-page-form");
        this.authMgmtResource.addExecutionFlow("registration2", data);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.authAddExecutionFlowPath("registration2"), data, ResourceType.AUTH_EXECUTION_FLOW);
        HashMap<String, String> data2 = new HashMap<String, String>();
        data2.put("provider", "registration-profile-action");
        try {
            this.authMgmtResource.addExecution("registration2", data2);
            Assert.fail((String)"Not expected to add execution of type 'registration-profile-action' under top flow");
        }
        catch (BadRequestException bre) {
            String errorMessage = (String)bre.getResponse().readEntity(String.class);
            Assert.assertEquals((Object)"No authentication provider found for id: registration-profile-action", (Object)errorMessage);
        }
        this.authMgmtResource.addExecution("registrationForm2", data2);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.authAddExecutionPath("registrationForm2"), data2, ResourceType.AUTH_EXECUTION);
    }
}

