/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.authentication;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.NotFoundException;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.RequiredActionProviderRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderSimpleRepresentation;
import org.keycloak.testsuite.admin.authentication.AbstractAuthenticationTest;
import org.keycloak.testsuite.util.AdminEventPaths;

public class RequiredActionsTest
extends AbstractAuthenticationTest {
    @Test
    public void testRequiredActions() {
        List result = this.authMgmtResource.getRequiredActions();
        ArrayList<RequiredActionProviderRepresentation> expected = new ArrayList<RequiredActionProviderRepresentation>();
        this.addRequiredAction(expected, "CONFIGURE_TOTP", "Configure OTP", true, false, null);
        this.addRequiredAction(expected, "UPDATE_PASSWORD", "Update Password", true, false, null);
        this.addRequiredAction(expected, "UPDATE_PROFILE", "Update Profile", true, false, null);
        this.addRequiredAction(expected, "VERIFY_EMAIL", "Verify Email", true, false, null);
        this.addRequiredAction(expected, "terms_and_conditions", "Terms and Conditions", false, false, null);
        this.compareRequiredActions(expected, this.sort(result));
        RequiredActionProviderRepresentation forUpdate = this.newRequiredAction("VERIFY_EMAIL", "Verify Email", false, false, null);
        try {
            this.authMgmtResource.updateRequiredAction(forUpdate.getAlias(), forUpdate);
            Assert.fail((String)"updateRequiredAction should fail due to null config");
        }
        catch (Exception exception) {
            // empty catch block
        }
        forUpdate.setConfig(Collections.emptyMap());
        this.authMgmtResource.updateRequiredAction(forUpdate.getAlias(), forUpdate);
        this.assertAdminEvents.assertEvent("test", OperationType.UPDATE, AdminEventPaths.authRequiredActionPath(forUpdate.getAlias()), ResourceType.REQUIRED_ACTION);
        result = this.authMgmtResource.getRequiredActions();
        RequiredActionProviderRepresentation updated = this.findRequiredActionByAlias(forUpdate.getAlias(), result);
        Assert.assertNotNull((String)"Required Action still there", (Object)updated);
        this.compareRequiredAction(forUpdate, updated);
    }

    @Test
    public void testCRUDRequiredAction() {
        List result = this.authMgmtResource.getUnregisteredRequiredActions();
        Assert.assertEquals((long)1L, (long)result.size());
        RequiredActionProviderSimpleRepresentation action = (RequiredActionProviderSimpleRepresentation)result.get(0);
        Assert.assertEquals((Object)"dummy-action", (Object)action.getProviderId());
        Assert.assertEquals((Object)"Dummy Action", (Object)action.getName());
        this.authMgmtResource.registerRequiredAction(action);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.authMgmtBasePath() + "/register-required-action", (Object)action, ResourceType.REQUIRED_ACTION);
        try {
            this.authMgmtResource.getRequiredAction("not-existent");
            Assert.fail((String)"Didn't expect to find requiredAction of alias 'not-existent'");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        RequiredActionProviderRepresentation rep = this.authMgmtResource.getRequiredAction("dummy-action");
        this.compareRequiredAction(rep, this.newRequiredAction("dummy-action", "Dummy Action", true, false, Collections.emptyMap()));
        try {
            this.authMgmtResource.updateRequiredAction("not-existent", rep);
            Assert.fail((String)"Not expected to update not-existent requiredAction");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        rep.setDefaultAction(true);
        this.authMgmtResource.updateRequiredAction("dummy-action", rep);
        this.assertAdminEvents.assertEvent("test", OperationType.UPDATE, AdminEventPaths.authRequiredActionPath(rep.getAlias()), (Object)rep, ResourceType.REQUIRED_ACTION);
        this.compareRequiredAction(rep, this.newRequiredAction("dummy-action", "Dummy Action", true, true, Collections.emptyMap()));
        try {
            this.authMgmtResource.removeRequiredAction("not-existent");
            Assert.fail((String)"Not expected to remove not-existent requiredAction");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.authMgmtResource.removeRequiredAction("dummy-action");
        this.assertAdminEvents.assertEvent("test", OperationType.DELETE, AdminEventPaths.authRequiredActionPath(rep.getAlias()), ResourceType.REQUIRED_ACTION);
    }

    private RequiredActionProviderRepresentation findRequiredActionByAlias(String alias, List<RequiredActionProviderRepresentation> list) {
        for (RequiredActionProviderRepresentation a : list) {
            if (!alias.equals(a.getAlias())) continue;
            return a;
        }
        return null;
    }

    private List<RequiredActionProviderRepresentation> sort(List<RequiredActionProviderRepresentation> list) {
        ArrayList<RequiredActionProviderRepresentation> sorted = new ArrayList<RequiredActionProviderRepresentation>(list);
        Collections.sort(sorted, new RequiredActionProviderComparator());
        return sorted;
    }

    private void compareRequiredActions(List<RequiredActionProviderRepresentation> expected, List<RequiredActionProviderRepresentation> actual) {
        Assert.assertNotNull((String)"Actual null", actual);
        Assert.assertEquals((String)"Required actions count", (long)expected.size(), (long)actual.size());
        Iterator<RequiredActionProviderRepresentation> ite = expected.iterator();
        Iterator<RequiredActionProviderRepresentation> ita = actual.iterator();
        while (ite.hasNext()) {
            this.compareRequiredAction(ite.next(), ita.next());
        }
    }

    private void compareRequiredAction(RequiredActionProviderRepresentation expected, RequiredActionProviderRepresentation actual) {
        Assert.assertEquals((String)("alias - " + expected.getAlias()), (Object)expected.getAlias(), (Object)actual.getAlias());
        Assert.assertEquals((String)("name - " + expected.getAlias()), (Object)expected.getName(), (Object)actual.getName());
        Assert.assertEquals((String)("enabled - " + expected.getAlias()), (Object)expected.isEnabled(), (Object)actual.isEnabled());
        Assert.assertEquals((String)("defaultAction - " + expected.getAlias()), (Object)expected.isDefaultAction(), (Object)actual.isDefaultAction());
        Assert.assertEquals((String)("config - " + expected.getAlias()), (Object)(expected.getConfig() != null ? expected.getConfig() : Collections.emptyMap()), (Object)actual.getConfig());
    }

    private void addRequiredAction(List<RequiredActionProviderRepresentation> target, String alias, String name, boolean enabled, boolean defaultAction, Map conf) {
        target.add(this.newRequiredAction(alias, name, enabled, defaultAction, conf));
    }

    private RequiredActionProviderRepresentation newRequiredAction(String alias, String name, boolean enabled, boolean defaultAction, Map conf) {
        RequiredActionProviderRepresentation action = new RequiredActionProviderRepresentation();
        action.setAlias(alias);
        action.setName(name);
        action.setEnabled(enabled);
        action.setDefaultAction(defaultAction);
        action.setConfig(conf);
        return action;
    }

    private static class RequiredActionProviderComparator
    implements Comparator<RequiredActionProviderRepresentation> {
        private RequiredActionProviderComparator() {
        }

        @Override
        public int compare(RequiredActionProviderRepresentation o1, RequiredActionProviderRepresentation o2) {
            return o1.getAlias().compareTo(o2.getAlias());
        }
    }
}

