/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.authentication;

import java.util.HashMap;
import java.util.List;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.AuthenticationExecutionInfoRepresentation;
import org.keycloak.testsuite.admin.authentication.AbstractAuthenticationTest;
import org.keycloak.testsuite.util.AdminEventPaths;

public class ShiftExecutionTest
extends AbstractAuthenticationTest {
    @Test
    public void testShiftExecution() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("newName", "Copy of browser");
        Response response = this.authMgmtResource.copy("browser", params);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.authCopyFlowPath("browser"), params, ResourceType.AUTH_FLOW);
        try {
            Assert.assertEquals((String)"Copy flow", (long)201L, (long)response.getStatus());
        }
        finally {
            response.close();
        }
        List executions = this.authMgmtResource.getExecutions("Copy of browser");
        AuthenticationExecutionInfoRepresentation last = (AuthenticationExecutionInfoRepresentation)executions.get(executions.size() - 1);
        AuthenticationExecutionInfoRepresentation oneButLast = (AuthenticationExecutionInfoRepresentation)executions.get(executions.size() - 2);
        try {
            this.authMgmtResource.raisePriority("not-existent");
            Assert.fail((String)"Not expected to raise priority of not existent flow");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.authMgmtResource.raisePriority(last.getId());
        this.assertAdminEvents.assertEvent("test", OperationType.UPDATE, AdminEventPaths.authRaiseExecutionPath(last.getId()), ResourceType.AUTH_EXECUTION);
        List executions2 = this.authMgmtResource.getExecutions("Copy of browser");
        AuthenticationExecutionInfoRepresentation last2 = (AuthenticationExecutionInfoRepresentation)executions2.get(executions.size() - 1);
        AuthenticationExecutionInfoRepresentation oneButLast2 = (AuthenticationExecutionInfoRepresentation)executions2.get(executions.size() - 2);
        Assert.assertEquals((String)"Execution shifted up - N", (Object)last.getId(), (Object)oneButLast2.getId());
        Assert.assertEquals((String)"Execution shifted up - N-1", (Object)oneButLast.getId(), (Object)last2.getId());
        try {
            this.authMgmtResource.lowerPriority("not-existent");
            Assert.fail((String)"Not expected to raise priority of not existent flow");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.authMgmtResource.lowerPriority(oneButLast2.getId());
        this.assertAdminEvents.assertEvent("test", OperationType.UPDATE, AdminEventPaths.authLowerExecutionPath(oneButLast2.getId()), ResourceType.AUTH_EXECUTION);
        executions2 = this.authMgmtResource.getExecutions("Copy of browser");
        last2 = (AuthenticationExecutionInfoRepresentation)executions2.get(executions.size() - 1);
        oneButLast2 = (AuthenticationExecutionInfoRepresentation)executions2.get(executions.size() - 2);
        Assert.assertEquals((String)"Execution shifted down - N", (Object)last.getId(), (Object)last2.getId());
        Assert.assertEquals((String)"Execution shifted down - N-1", (Object)oneButLast.getId(), (Object)oneButLast2.getId());
    }

    @Test
    public void testBuiltinShiftNotAllowed() {
        List executions = this.authMgmtResource.getExecutions("browser");
        AuthenticationExecutionInfoRepresentation last = (AuthenticationExecutionInfoRepresentation)executions.get(executions.size() - 1);
        AuthenticationExecutionInfoRepresentation oneButLast = (AuthenticationExecutionInfoRepresentation)executions.get(executions.size() - 2);
        try {
            this.authMgmtResource.raisePriority(last.getId());
            Assert.fail((String)"Not expected to raise priority of builtin flow");
        }
        catch (BadRequestException badRequestException) {
            // empty catch block
        }
        try {
            this.authMgmtResource.lowerPriority(oneButLast.getId());
            Assert.fail((String)"Not expected to lower priority of builtin flow");
        }
        catch (BadRequestException badRequestException) {
            // empty catch block
        }
    }
}

