/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.client;

import java.util.List;
import javax.ws.rs.core.Response;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractAuthTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.util.AdminEventPaths;
import org.keycloak.testsuite.util.AssertAdminEvents;
import org.keycloak.testsuite.util.RealmBuilder;

public abstract class AbstractClientTest
extends AbstractAuthTest {
    @Rule
    public AssertAdminEvents assertAdminEvents = new AssertAdminEvents(this);

    @Before
    public void setupAdminEvents() {
        RealmRepresentation realm = this.testRealmResource().toRepresentation();
        if (realm.getEventsListeners() == null || !realm.getEventsListeners().contains("event-queue")) {
            realm = RealmBuilder.edit(this.testRealmResource().toRepresentation()).testEventListener().build();
            this.testRealmResource().update(realm);
        }
    }

    @After
    public void tearDownAdminEvents() {
        RealmRepresentation realm = RealmBuilder.edit(this.testRealmResource().toRepresentation()).removeTestEventListener().build();
        this.testRealmResource().update(realm);
    }

    protected RealmRepresentation realmRep() {
        return this.testRealmResource().toRepresentation();
    }

    protected String getRealmId() {
        return "master";
    }

    protected UserRepresentation getFullUserRep(String userName) {
        List results = this.testRealmResource().users().search(userName, null, null, null, null, null);
        if (results.size() != 1) {
            throw new RuntimeException("Did not find single user with username " + userName);
        }
        return (UserRepresentation)results.get(0);
    }

    protected String createOidcClient(String name) {
        ClientRepresentation clientRep = new ClientRepresentation();
        clientRep.setClientId(name);
        clientRep.setName(name);
        clientRep.setRootUrl("foo");
        clientRep.setProtocol("openid-connect");
        return this.createClient(clientRep);
    }

    protected String createSamlClient(String name) {
        ClientRepresentation clientRep = new ClientRepresentation();
        clientRep.setClientId(name);
        clientRep.setName(name);
        clientRep.setProtocol("saml");
        clientRep.setAdminUrl("samlEndpoint");
        return this.createClient(clientRep);
    }

    protected String createClient(ClientRepresentation clientRep) {
        Response resp = this.testRealmResource().clients().create(clientRep);
        resp.close();
        String id = ApiUtil.getCreatedId(resp);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientResourcePath(id), (Object)clientRep, ResourceType.CLIENT);
        return id;
    }

    protected void removeClient(String clientDbId) {
        this.testRealmResource().clients().get(clientDbId).remove();
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.DELETE, AdminEventPaths.clientResourcePath(clientDbId), ResourceType.CLIENT);
    }

    protected ClientRepresentation findClientRepresentation(String name) {
        ClientResource clientRsc = this.findClientResource(name);
        if (clientRsc == null) {
            return null;
        }
        return this.findClientResource(name).toRepresentation();
    }

    protected ClientResource findClientResource(String name) {
        return ApiUtil.findClientResourceByName(this.testRealmResource(), name);
    }

    protected ClientResource findClientResourceById(String id) {
        return ApiUtil.findClientResourceByClientId(this.testRealmResource(), id);
    }
}

