/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.client;

import java.util.LinkedList;
import java.util.Set;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RolesResource;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.client.AbstractClientTest;
import org.keycloak.testsuite.util.AdminEventPaths;

public class ClientRolesTest
extends AbstractClientTest {
    private ClientResource clientRsc;
    private String clientDbId;
    private RolesResource rolesRsc;

    @Before
    public void init() {
        this.clientDbId = this.createOidcClient("roleClient");
        this.clientRsc = this.findClientResource("roleClient");
        this.rolesRsc = this.clientRsc.roles();
    }

    @After
    public void tearDown() {
        this.clientRsc.remove();
    }

    private RoleRepresentation makeRole(String name) {
        RoleRepresentation role = new RoleRepresentation();
        role.setName(name);
        return role;
    }

    private boolean hasRole(RolesResource rolesRsc, String name) {
        for (RoleRepresentation role : rolesRsc.list()) {
            if (!role.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Test
    public void testAddRole() {
        RoleRepresentation role1 = this.makeRole("role1");
        this.rolesRsc.create(role1);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientRoleResourcePath(this.clientDbId, "role1"), (Object)role1, ResourceType.CLIENT_ROLE);
        org.junit.Assert.assertTrue((boolean)this.hasRole(this.rolesRsc, "role1"));
    }

    @Test
    public void testRemoveRole() {
        RoleRepresentation role2 = this.makeRole("role2");
        this.rolesRsc.create(role2);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientRoleResourcePath(this.clientDbId, "role2"), (Object)role2, ResourceType.CLIENT_ROLE);
        this.rolesRsc.deleteRole("role2");
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.DELETE, AdminEventPaths.clientRoleResourcePath(this.clientDbId, "role2"), ResourceType.CLIENT_ROLE);
        org.junit.Assert.assertFalse((boolean)this.hasRole(this.rolesRsc, "role2"));
    }

    @Test
    public void testComposites() {
        RoleRepresentation roleA = this.makeRole("role-a");
        this.rolesRsc.create(roleA);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientRoleResourcePath(this.clientDbId, "role-a"), (Object)roleA, ResourceType.CLIENT_ROLE);
        org.junit.Assert.assertFalse((boolean)this.rolesRsc.get("role-a").toRepresentation().isComposite());
        org.junit.Assert.assertEquals((long)0L, (long)this.rolesRsc.get("role-a").getRoleComposites().size());
        RoleRepresentation roleB = this.makeRole("role-b");
        this.rolesRsc.create(roleB);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientRoleResourcePath(this.clientDbId, "role-b"), (Object)roleB, ResourceType.CLIENT_ROLE);
        RoleRepresentation roleC = this.makeRole("role-c");
        this.testRealmResource().roles().create(roleC);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.roleResourcePath("role-c"), (Object)roleC, ResourceType.REALM_ROLE);
        LinkedList<RoleRepresentation> l = new LinkedList<RoleRepresentation>();
        l.add(this.rolesRsc.get("role-b").toRepresentation());
        l.add(this.testRealmResource().roles().get("role-c").toRepresentation());
        this.rolesRsc.get("role-a").addComposites(l);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientRoleResourceCompositesPath(this.clientDbId, "role-a"), l, ResourceType.CLIENT_ROLE);
        Set composites = this.rolesRsc.get("role-a").getRoleComposites();
        org.junit.Assert.assertTrue((boolean)this.rolesRsc.get("role-a").toRepresentation().isComposite());
        Assert.assertNames(composites, "role-b", "role-c");
        Set realmComposites = this.rolesRsc.get("role-a").getRealmRoleComposites();
        Assert.assertNames(realmComposites, "role-c");
        Set clientComposites = this.rolesRsc.get("role-a").getClientRoleComposites(this.clientRsc.toRepresentation().getId());
        Assert.assertNames(clientComposites, "role-b");
        this.rolesRsc.get("role-a").deleteComposites(l);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.DELETE, AdminEventPaths.clientRoleResourceCompositesPath(this.clientDbId, "role-a"), l, ResourceType.CLIENT_ROLE);
        org.junit.Assert.assertFalse((boolean)this.rolesRsc.get("role-a").toRepresentation().isComposite());
        org.junit.Assert.assertEquals((long)0L, (long)this.rolesRsc.get("role-a").getRoleComposites().size());
    }
}

