/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.client;

import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.keycloak.admin.client.resource.ClientTemplatesResource;
import org.keycloak.admin.client.resource.ProtocolMappersResource;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.ClientTemplateRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.admin.client.AbstractProtocolMapperTest;
import org.keycloak.testsuite.util.AdminEventPaths;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class ClientTemplateProtocolMapperTest
extends AbstractProtocolMapperTest {
    private String oidcClientTemplateId;
    private ProtocolMappersResource oidcMappersRsc;
    private String samlClientTemplateId;
    private ProtocolMappersResource samlMappersRsc;

    @Before
    public void init() {
        this.oidcClientTemplateId = this.createTemplate("oidcMapperClient-template", "openid-connect");
        this.oidcMappersRsc = this.clientTemplates().get(this.oidcClientTemplateId).getProtocolMappers();
        this.samlClientTemplateId = this.createTemplate("samlMapperClient-template", "saml");
        this.samlMappersRsc = this.clientTemplates().get(this.samlClientTemplateId).getProtocolMappers();
        super.initBuiltinMappers();
    }

    @After
    public void tearDown() {
        this.removeTemplate(this.oidcClientTemplateId);
        this.removeTemplate(this.samlClientTemplateId);
    }

    @Test
    public void test01GetMappersList() {
        Assert.assertTrue((boolean)this.oidcMappersRsc.getMappers().isEmpty());
        Assert.assertTrue((boolean)this.samlMappersRsc.getMappers().isEmpty());
    }

    @Test
    public void test02CreateOidcMappersFromList() {
        this.testAddAllBuiltinMappers(this.oidcMappersRsc, "openid-connect", AdminEventPaths.clientTemplateProtocolMappersPath(this.oidcClientTemplateId));
    }

    @Test
    public void test03CreateSamlMappersFromList() {
        this.testAddAllBuiltinMappers(this.samlMappersRsc, "saml", AdminEventPaths.clientTemplateProtocolMappersPath(this.samlClientTemplateId));
    }

    @Test
    public void test04CreateSamlProtocolMapper() {
        ProtocolMapperRepresentation rep = this.makeSamlMapper("saml-role-name-mapper");
        int totalMappers = this.samlMappersRsc.getMappers().size();
        int totalSamlMappers = this.samlMappersRsc.getMappersPerProtocol("saml").size();
        Response resp = this.samlMappersRsc.createMapper(rep);
        resp.close();
        String createdId = ApiUtil.getCreatedId(resp);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientTemplateProtocolMapperPath(this.samlClientTemplateId, createdId), (Object)rep, ResourceType.PROTOCOL_MAPPER);
        Assert.assertEquals((long)(totalMappers + 1), (long)this.samlMappersRsc.getMappers().size());
        Assert.assertEquals((long)(totalSamlMappers + 1), (long)this.samlMappersRsc.getMappersPerProtocol("saml").size());
        ProtocolMapperRepresentation created = this.samlMappersRsc.getMapperById(createdId);
        this.assertEqualMappers(rep, created);
    }

    @Test
    public void test05CreateOidcProtocolMapper() {
        ProtocolMapperRepresentation rep = this.makeOidcMapper("oidc-hardcoded-role-mapper");
        int totalMappers = this.oidcMappersRsc.getMappers().size();
        int totalOidcMappers = this.oidcMappersRsc.getMappersPerProtocol("openid-connect").size();
        Response resp = this.oidcMappersRsc.createMapper(rep);
        resp.close();
        String createdId = ApiUtil.getCreatedId(resp);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientTemplateProtocolMapperPath(this.oidcClientTemplateId, createdId), (Object)rep, ResourceType.PROTOCOL_MAPPER);
        Assert.assertEquals((long)(totalMappers + 1), (long)this.oidcMappersRsc.getMappers().size());
        Assert.assertEquals((long)(totalOidcMappers + 1), (long)this.oidcMappersRsc.getMappersPerProtocol("openid-connect").size());
        ProtocolMapperRepresentation created = this.oidcMappersRsc.getMapperById(createdId);
        this.assertEqualMappers(rep, created);
    }

    @Test
    public void test06UpdateSamlMapper() {
        ProtocolMapperRepresentation rep = this.makeSamlMapper("saml-role-name-mapper2");
        Response resp = this.samlMappersRsc.createMapper(rep);
        resp.close();
        String createdId = ApiUtil.getCreatedId(resp);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientTemplateProtocolMapperPath(this.samlClientTemplateId, createdId), (Object)rep, ResourceType.PROTOCOL_MAPPER);
        rep.getConfig().put("role", "account.manage-account");
        rep.setId(createdId);
        rep.setConsentRequired(false);
        this.samlMappersRsc.update(createdId, rep);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.UPDATE, AdminEventPaths.clientTemplateProtocolMapperPath(this.samlClientTemplateId, createdId), (Object)rep, ResourceType.PROTOCOL_MAPPER);
        ProtocolMapperRepresentation updated = this.samlMappersRsc.getMapperById(createdId);
        this.assertEqualMappers(rep, updated);
    }

    @Test
    public void test07UpdateOidcMapper() {
        ProtocolMapperRepresentation rep = this.makeOidcMapper("oidc-hardcoded-role-mapper2");
        Response resp = this.oidcMappersRsc.createMapper(rep);
        resp.close();
        String createdId = ApiUtil.getCreatedId(resp);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientTemplateProtocolMapperPath(this.oidcClientTemplateId, createdId), (Object)rep, ResourceType.PROTOCOL_MAPPER);
        rep.getConfig().put("role", "myotherrole");
        rep.setId(createdId);
        rep.setConsentRequired(false);
        this.oidcMappersRsc.update(createdId, rep);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.UPDATE, AdminEventPaths.clientTemplateProtocolMapperPath(this.oidcClientTemplateId, createdId), (Object)rep, ResourceType.PROTOCOL_MAPPER);
        ProtocolMapperRepresentation updated = this.oidcMappersRsc.getMapperById(createdId);
        this.assertEqualMappers(rep, updated);
    }

    @Test
    public void testDeleteSamlMapper() {
        ProtocolMapperRepresentation rep = this.makeSamlMapper("saml-role-name-mapper3");
        Response resp = this.samlMappersRsc.createMapper(rep);
        resp.close();
        String createdId = ApiUtil.getCreatedId(resp);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientTemplateProtocolMapperPath(this.samlClientTemplateId, createdId), (Object)rep, ResourceType.PROTOCOL_MAPPER);
        this.samlMappersRsc.delete(createdId);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.DELETE, AdminEventPaths.clientTemplateProtocolMapperPath(this.samlClientTemplateId, createdId), ResourceType.PROTOCOL_MAPPER);
        try {
            this.samlMappersRsc.getMapperById(createdId);
            Assert.fail((String)"Not expected to find mapper");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testDeleteOidcMapper() {
        ProtocolMapperRepresentation rep = this.makeOidcMapper("oidc-hardcoded-role-mapper3");
        Response resp = this.oidcMappersRsc.createMapper(rep);
        resp.close();
        String createdId = ApiUtil.getCreatedId(resp);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientTemplateProtocolMapperPath(this.oidcClientTemplateId, createdId), (Object)rep, ResourceType.PROTOCOL_MAPPER);
        this.oidcMappersRsc.delete(createdId);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.DELETE, AdminEventPaths.clientTemplateProtocolMapperPath(this.oidcClientTemplateId, createdId), ResourceType.PROTOCOL_MAPPER);
        try {
            this.oidcMappersRsc.getMapperById(createdId);
            Assert.fail((String)"Not expected to find mapper");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private ClientTemplatesResource clientTemplates() {
        return this.testRealmResource().clientTemplates();
    }

    private String createTemplate(String templateName, String protocol) {
        ClientTemplateRepresentation rep = new ClientTemplateRepresentation();
        rep.setName(templateName);
        rep.setFullScopeAllowed(Boolean.valueOf(false));
        rep.setProtocol(protocol);
        Response resp = this.clientTemplates().create(rep);
        Assert.assertEquals((long)201L, (long)resp.getStatus());
        resp.close();
        String templateId = ApiUtil.getCreatedId(resp);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientTemplateResourcePath(templateId), (Object)rep, ResourceType.CLIENT_TEMPLATE);
        return templateId;
    }

    private void removeTemplate(String templateId) {
        this.clientTemplates().get(templateId).remove();
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.DELETE, AdminEventPaths.clientTemplateResourcePath(templateId), ResourceType.CLIENT_TEMPLATE);
    }
}

