/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientTemplatesResource;
import org.keycloak.admin.client.resource.RoleMappingResource;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.ClientMappingsRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientTemplateRepresentation;
import org.keycloak.representations.idm.ErrorRepresentation;
import org.keycloak.representations.idm.MappingsRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.admin.client.AbstractClientTest;
import org.keycloak.testsuite.util.AdminEventPaths;

public class ClientTemplateTest
extends AbstractClientTest {
    @Test
    public void testAddDuplicatedTemplate() {
        ClientTemplateRepresentation templateRep = new ClientTemplateRepresentation();
        templateRep.setName("template1");
        String templateId = this.createTemplate(templateRep);
        templateRep = new ClientTemplateRepresentation();
        templateRep.setName("template1");
        Response response = this.clientTemplates().create(templateRep);
        Assert.assertEquals((long)409L, (long)response.getStatus());
        ErrorRepresentation error = (ErrorRepresentation)response.readEntity(ErrorRepresentation.class);
        Assert.assertEquals((Object)"Client Template template1 already exists", (Object)error.getErrorMessage());
        this.removeTemplate(templateId);
    }

    @Test(expected=NotFoundException.class)
    public void testGetUnknownTemplate() {
        this.clientTemplates().get("unknown-id").toRepresentation();
    }

    @Test
    public void testRemoveTemplate() {
        ClientTemplateRepresentation templateRep = new ClientTemplateRepresentation();
        templateRep.setName("template1");
        String template1Id = this.createTemplate(templateRep);
        List clientTemplates = this.clientTemplates().findAll();
        Assert.assertEquals((long)1L, (long)clientTemplates.size());
        Assert.assertEquals((Object)"template1", (Object)((ClientTemplateRepresentation)clientTemplates.get(0)).getName());
        templateRep = new ClientTemplateRepresentation();
        templateRep.setName("template2");
        String template2Id = this.createTemplate(templateRep);
        clientTemplates = this.clientTemplates().findAll();
        Assert.assertEquals((long)2L, (long)clientTemplates.size());
        this.removeTemplate(template1Id);
        clientTemplates = this.clientTemplates().findAll();
        Assert.assertEquals((long)1L, (long)clientTemplates.size());
        Assert.assertEquals((Object)"template2", (Object)((ClientTemplateRepresentation)clientTemplates.get(0)).getName());
        this.removeTemplate(template2Id);
        clientTemplates = this.clientTemplates().findAll();
        Assert.assertEquals((long)0L, (long)clientTemplates.size());
    }

    @Test
    public void testUpdateTemplate() {
        ClientTemplateRepresentation templateRep = new ClientTemplateRepresentation();
        templateRep.setName("template1");
        templateRep.setDescription("template1-desc");
        templateRep.setProtocol("openid-connect");
        templateRep.setFullScopeAllowed(Boolean.valueOf(true));
        String template1Id = this.createTemplate(templateRep);
        templateRep = this.clientTemplates().get(template1Id).toRepresentation();
        Assert.assertEquals((Object)"template1", (Object)templateRep.getName());
        Assert.assertEquals((Object)"template1-desc", (Object)templateRep.getDescription());
        Assert.assertEquals((Object)"openid-connect", (Object)templateRep.getProtocol());
        Assert.assertEquals((Object)true, (Object)templateRep.isFullScopeAllowed());
        templateRep.setName("template1-updated");
        templateRep.setDescription("template1-desc-updated");
        templateRep.setProtocol("saml");
        templateRep.setFullScopeAllowed(Boolean.valueOf(false));
        this.clientTemplates().get(template1Id).update(templateRep);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.UPDATE, AdminEventPaths.clientTemplateResourcePath(template1Id), (Object)templateRep, ResourceType.CLIENT_TEMPLATE);
        templateRep = this.clientTemplates().get(template1Id).toRepresentation();
        Assert.assertEquals((Object)"template1-updated", (Object)templateRep.getName());
        Assert.assertEquals((Object)"template1-desc-updated", (Object)templateRep.getDescription());
        Assert.assertEquals((Object)"saml", (Object)templateRep.getProtocol());
        Assert.assertEquals((Object)false, (Object)templateRep.isFullScopeAllowed());
        this.clientTemplates().get(template1Id).remove();
    }

    @Test
    public void testScopes() {
        RoleRepresentation roleRep1 = this.createRealmRole("role1");
        RoleRepresentation roleRep2 = this.createRealmRole("role2");
        this.testRealmResource().roles().get("role1").addComposites(Collections.singletonList(roleRep2));
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.roleResourceCompositesPath("role1"), Collections.singletonList(roleRep2), ResourceType.REALM_ROLE);
        ClientTemplateRepresentation templateRep = new ClientTemplateRepresentation();
        templateRep.setName("bar-template");
        templateRep.setFullScopeAllowed(Boolean.valueOf(false));
        String templateId = this.createTemplate(templateRep);
        String accountMgmtId = ((ClientRepresentation)this.testRealmResource().clients().findByClientId("account").get(0)).getId();
        RoleRepresentation viewAccountRoleRep = this.testRealmResource().clients().get(accountMgmtId).roles().get("view-profile").toRepresentation();
        RoleMappingResource scopesResource = this.clientTemplates().get(templateId).getScopeMappings();
        scopesResource.realmLevel().add(Collections.singletonList(roleRep1));
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientTemplateScopeMappingsRealmLevelPath(templateId), Collections.singletonList(roleRep1), ResourceType.REALM_SCOPE_MAPPING);
        scopesResource.clientLevel(accountMgmtId).add(Collections.singletonList(viewAccountRoleRep));
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientTemplateScopeMappingsClientLevelPath(templateId, accountMgmtId), Collections.singletonList(viewAccountRoleRep), ResourceType.CLIENT_SCOPE_MAPPING);
        List allRealm = scopesResource.realmLevel().listAll();
        List availableRealm = scopesResource.realmLevel().listAvailable();
        List effectiveRealm = scopesResource.realmLevel().listEffective();
        List accountRoles = scopesResource.clientLevel(accountMgmtId).listAll();
        this.assertRolesPresent(allRealm, "role1");
        this.assertRolesNotPresent(availableRealm, "role1", "role2");
        this.assertRolesPresent(effectiveRealm, "role1", "role2");
        this.assertRolesPresent(accountRoles, "view-profile");
        MappingsRepresentation mappingsRep = this.clientTemplates().get(templateId).getScopeMappings().getAll();
        this.assertRolesPresent(mappingsRep.getRealmMappings(), "role1");
        this.assertRolesPresent(((ClientMappingsRepresentation)mappingsRep.getClientMappings().get("account")).getMappings(), "view-profile");
        scopesResource.realmLevel().remove(Collections.singletonList(roleRep1));
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.DELETE, AdminEventPaths.clientTemplateScopeMappingsRealmLevelPath(templateId), Collections.singletonList(roleRep1), ResourceType.REALM_SCOPE_MAPPING);
        scopesResource.clientLevel(accountMgmtId).remove(Collections.singletonList(viewAccountRoleRep));
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.DELETE, AdminEventPaths.clientTemplateScopeMappingsClientLevelPath(templateId, accountMgmtId), Collections.singletonList(viewAccountRoleRep), ResourceType.CLIENT_SCOPE_MAPPING);
        allRealm = scopesResource.realmLevel().listAll();
        availableRealm = scopesResource.realmLevel().listAvailable();
        effectiveRealm = scopesResource.realmLevel().listEffective();
        accountRoles = scopesResource.clientLevel(accountMgmtId).listAll();
        this.assertRolesNotPresent(allRealm, "role1");
        this.assertRolesPresent(availableRealm, "role1", "role2");
        this.assertRolesNotPresent(effectiveRealm, "role1", "role2");
        this.assertRolesNotPresent(accountRoles, "view-profile");
        this.removeTemplate(templateId);
    }

    private void assertRolesPresent(List<RoleRepresentation> roles, String ... expectedRoleNames) {
        List<String> expectedList = Arrays.asList(expectedRoleNames);
        HashSet<String> presentRoles = new HashSet<String>();
        for (RoleRepresentation roleRep : roles) {
            presentRoles.add(roleRep.getName());
        }
        for (String expected : expectedList) {
            if (presentRoles.contains(expected)) continue;
            Assert.fail((String)("Expected role " + expected + " not available"));
        }
    }

    private void assertRolesNotPresent(List<RoleRepresentation> roles, String ... notExpectedRoleNames) {
        List<String> notExpectedList = Arrays.asList(notExpectedRoleNames);
        for (RoleRepresentation roleRep : roles) {
            if (!notExpectedList.contains(roleRep.getName())) continue;
            Assert.fail((String)("Role " + roleRep.getName() + " wasn't expected to be available"));
        }
    }

    @Test
    public void testRemoveScopedRole() {
        RoleRepresentation roleRep = this.createRealmRole("foo-role");
        ClientTemplateRepresentation templateRep = new ClientTemplateRepresentation();
        templateRep.setName("bar-template");
        templateRep.setFullScopeAllowed(Boolean.valueOf(false));
        String templateId = this.createTemplate(templateRep);
        this.clientTemplates().get(templateId).getScopeMappings().realmLevel().add(Collections.singletonList(roleRep));
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientTemplateScopeMappingsRealmLevelPath(templateId), Collections.singletonList(roleRep), ResourceType.REALM_SCOPE_MAPPING);
        List roleReps = this.clientTemplates().get(templateId).getScopeMappings().realmLevel().listAll();
        Assert.assertEquals((long)1L, (long)roleReps.size());
        Assert.assertEquals((Object)"foo-role", (Object)((RoleRepresentation)roleReps.get(0)).getName());
        this.testRealmResource().roles().deleteRole("foo-role");
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.DELETE, AdminEventPaths.roleResourcePath("foo-role"), ResourceType.REALM_ROLE);
        roleReps = this.clientTemplates().get(templateId).getScopeMappings().realmLevel().listAll();
        Assert.assertEquals((long)0L, (long)roleReps.size());
        this.removeTemplate(templateId);
    }

    private RoleRepresentation createRealmRole(String roleName) {
        RoleRepresentation roleRep = new RoleRepresentation();
        roleRep.setName(roleName);
        this.testRealmResource().roles().create(roleRep);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.roleResourcePath(roleName), (Object)roleRep, ResourceType.REALM_ROLE);
        return this.testRealmResource().roles().get(roleName).toRepresentation();
    }

    @Test
    public void testRemoveTemplateInUse() {
        ClientTemplateRepresentation templateRep = new ClientTemplateRepresentation();
        templateRep.setName("foo-template");
        templateRep.setFullScopeAllowed(Boolean.valueOf(false));
        String templateId = this.createTemplate(templateRep);
        ClientRepresentation clientRep = new ClientRepresentation();
        clientRep.setClientId("bar-client");
        clientRep.setName("bar-client");
        clientRep.setRootUrl("foo");
        clientRep.setProtocol("openid-connect");
        clientRep.setClientTemplate("foo-template");
        String clientDbId = this.createClient(clientRep);
        try {
            this.clientTemplates().get(templateId).remove();
        }
        catch (BadRequestException bre) {
            ErrorRepresentation error = (ErrorRepresentation)bre.getResponse().readEntity(ErrorRepresentation.class);
            Assert.assertEquals((Object)"Cannot remove client template, it is currently in use", (Object)error.getErrorMessage());
            this.assertAdminEvents.assertEmpty();
        }
        this.removeClient(clientDbId);
        this.removeTemplate(templateId);
    }

    private ClientTemplatesResource clientTemplates() {
        return this.testRealmResource().clientTemplates();
    }

    private String createTemplate(ClientTemplateRepresentation templateRep) {
        Response resp = this.clientTemplates().create(templateRep);
        Assert.assertEquals((long)201L, (long)resp.getStatus());
        resp.close();
        String templateId = ApiUtil.getCreatedId(resp);
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.CREATE, AdminEventPaths.clientTemplateResourcePath(templateId), (Object)templateRep, ResourceType.CLIENT_TEMPLATE);
        return templateId;
    }

    private void removeTemplate(String templateId) {
        this.clientTemplates().get(templateId).remove();
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.DELETE, AdminEventPaths.clientTemplateResourcePath(templateId), ResourceType.CLIENT_TEMPLATE);
    }
}

