/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.client;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.testsuite.admin.client.AbstractClientTest;
import org.keycloak.testsuite.util.AdminEventPaths;

public class ClientTest
extends AbstractClientTest {
    public static void assertEqualClients(ClientRepresentation expected, ClientRepresentation actual) {
        Assert.assertEquals((Object)expected.getClientId(), (Object)actual.getClientId());
        Assert.assertEquals((Object)expected.getName(), (Object)actual.getName());
        Assert.assertEquals((Object)expected.getDescription(), (Object)actual.getDescription());
        Assert.assertEquals((Object)expected.getBaseUrl(), (Object)actual.getBaseUrl());
        Assert.assertTrue((boolean)expected.getRedirectUris().containsAll(actual.getRedirectUris()));
        Assert.assertTrue((boolean)expected.getWebOrigins().containsAll(actual.getWebOrigins()));
        Assert.assertEquals((Object)expected.getRegisteredNodes(), (Object)actual.getRegisteredNodes());
    }

    @Test
    public void testCreateClient() {
        this.createOidcClient("foo");
        ClientRepresentation found = this.findClientRepresentation("foo");
        Assert.assertEquals((Object)"foo", (Object)found.getName());
    }

    @Test
    public void testDeleteClient() {
        String clientDbId = this.createOidcClient("deleteMe");
        ClientResource clientRsc = this.findClientResource("deleteMe");
        Assert.assertNotNull((Object)clientRsc);
        clientRsc.remove();
        Assert.assertNull((Object)this.findClientResource("deleteMe"));
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.DELETE, AdminEventPaths.clientResourcePath(clientDbId), ResourceType.CLIENT);
    }

    @Test
    public void testUpdateClient() {
        this.createOidcClient("updateMe");
        ClientRepresentation clientRep = this.findClientRepresentation("updateMe");
        Assert.assertEquals((Object)"updateMe", (Object)clientRep.getName());
        clientRep.setName("iWasUpdated");
        this.findClientResource("updateMe").update(clientRep);
        ClientRepresentation updatedClient = this.findClientRepresentation("iWasUpdated");
        Assert.assertNotNull((Object)updatedClient);
        Assert.assertEquals((Object)"updateMe", (Object)updatedClient.getClientId());
        Assert.assertEquals((Object)"iWasUpdated", (Object)updatedClient.getName());
        ClientRepresentation expectedClientRep = new ClientRepresentation();
        expectedClientRep.setClientId("updateMe");
        expectedClientRep.setName("iWasUpdated");
        this.assertAdminEvents.assertEvent(this.getRealmId(), OperationType.UPDATE, AdminEventPaths.clientResourcePath(clientRep.getId()), (Object)expectedClientRep, ResourceType.CLIENT);
    }

    @Test
    public void testGetAllClients() {
        List allClients = this.testRealmResource().clients().findAll();
        Assert.assertNotNull((Object)allClients);
        Assert.assertFalse((boolean)allClients.isEmpty());
    }

    @Test
    public void getClientByIdTest() {
        this.createOidcClient("byidclient");
        ClientRepresentation rep = this.findClientRepresentation("byidclient");
        ClientRepresentation gotById = this.testRealmResource().clients().get(rep.getId()).toRepresentation();
        ClientTest.assertEqualClients(rep, gotById);
    }
}

