/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.client;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.admin.client.AbstractClientTest;
import org.keycloak.testsuite.arquillian.AuthServerTestEnricher;

public class InstallationTest
extends AbstractClientTest {
    private static final String OIDC_NAME = "oidcInstallationClient";
    private static final String SAML_NAME = "samlInstallationClient";
    private ClientResource oidcClient;
    private String oidcClientId;
    private ClientResource samlClient;
    private String samlClientId;

    @Before
    public void createClients() {
        this.oidcClientId = this.createOidcClient(OIDC_NAME);
        this.oidcClient = this.findClientResource(OIDC_NAME);
        this.samlClientId = this.createSamlClient(SAML_NAME);
        this.samlClient = this.findClientResource(SAML_NAME);
    }

    @After
    public void tearDown() {
        this.removeClient(this.oidcClientId);
        this.removeClient(this.samlClientId);
    }

    private String authServerUrl() {
        return AuthServerTestEnricher.getAuthServerContextRoot() + "/auth";
    }

    private String samlUrl(RealmRepresentation realmRep) {
        return this.authServerUrl() + "/realms/" + realmRep.getId() + "/protocol/saml";
    }

    @Test
    public void testOidcJBossXml() {
        String xml = this.oidcClient.getInstallationProvider("keycloak-oidc-jboss-subsystem");
        this.assertOidcInstallationConfig(xml);
        Assert.assertTrue((boolean)xml.contains("<secure-deployment"));
    }

    @Test
    public void testOidcJson() {
        String json = this.oidcClient.getInstallationProvider("keycloak-oidc-keycloak-json");
        this.assertOidcInstallationConfig(json);
    }

    private void assertOidcInstallationConfig(String config) {
        RealmRepresentation realmRep = this.realmRep();
        Assert.assertTrue((boolean)config.contains(realmRep.getId()));
        Assert.assertTrue((boolean)config.contains(realmRep.getPublicKey()));
        Assert.assertTrue((boolean)config.contains(this.authServerUrl()));
    }

    @Test
    public void testSamlMetadataIdpDescriptor() {
        String xml = this.samlClient.getInstallationProvider("saml-idp-descriptor");
        RealmRepresentation realmRep = this.realmRep();
        Assert.assertTrue((boolean)xml.contains("<EntityDescriptor"));
        Assert.assertTrue((boolean)xml.contains("<IDPSSODescriptor"));
        Assert.assertTrue((boolean)xml.contains(realmRep.getCertificate()));
        Assert.assertTrue((boolean)xml.contains(this.samlUrl(realmRep)));
    }

    @Test
    public void testSamlAdapterXml() {
        String xml = this.samlClient.getInstallationProvider("keycloak-saml");
        RealmRepresentation realmRep = this.realmRep();
        Assert.assertTrue((boolean)xml.contains("<keycloak-saml-adapter>"));
        Assert.assertTrue((boolean)xml.contains(SAML_NAME));
        Assert.assertTrue((boolean)xml.contains(realmRep.getCertificate()));
        Assert.assertTrue((boolean)xml.contains(this.samlUrl(realmRep)));
    }

    @Test
    public void testSamlMetadataSpDescriptor() {
        String xml = this.samlClient.getInstallationProvider("saml-sp-descriptor");
        Assert.assertTrue((boolean)xml.contains("<EntityDescriptor"));
        Assert.assertTrue((boolean)xml.contains("<SPSSODescriptor"));
        Assert.assertTrue((boolean)xml.contains(SAML_NAME));
    }

    @Test
    public void testSamlJBossXml() {
        String xml = this.samlClient.getInstallationProvider("keycloak-saml-subsystem");
        RealmRepresentation realmRep = this.realmRep();
        Assert.assertTrue((boolean)xml.contains("<secure-deployment"));
        Assert.assertTrue((boolean)xml.contains(SAML_NAME));
        Assert.assertTrue((boolean)xml.contains(realmRep.getCertificate()));
        Assert.assertTrue((boolean)xml.contains(this.samlUrl(realmRep)));
    }
}

