/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.client.authorization;

import javax.ws.rs.core.Response;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ResourceScopeResource;
import org.keycloak.admin.client.resource.ResourceScopesResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;
import org.keycloak.testsuite.admin.client.AbstractClientTest;

public abstract class AbstractAuthorizationTest
extends AbstractClientTest {
    protected static final String RESOURCE_SERVER_CLIENT_ID = "test-resource-server";

    @Before
    public void onBeforeAuthzTests() {
        this.createOidcClient(RESOURCE_SERVER_CLIENT_ID);
        ClientRepresentation resourceServer = this.getResourceServer();
        Assert.assertEquals((Object)RESOURCE_SERVER_CLIENT_ID, (Object)resourceServer.getName());
        Assert.assertFalse((boolean)resourceServer.getAuthorizationServicesEnabled());
    }

    @After
    public void onAfterAuthzTests() {
        this.getClientResource().remove();
    }

    protected ClientResource getClientResource() {
        return this.findClientResource(RESOURCE_SERVER_CLIENT_ID);
    }

    protected ClientRepresentation getResourceServer() {
        return this.findClientRepresentation(RESOURCE_SERVER_CLIENT_ID);
    }

    protected void enableAuthorizationServices() {
        ClientRepresentation resourceServer = this.getResourceServer();
        resourceServer.setAuthorizationServicesEnabled(Boolean.valueOf(true));
        resourceServer.setServiceAccountsEnabled(Boolean.valueOf(true));
        this.getClientResource().update(resourceServer);
    }

    protected ResourceScopeResource createDefaultScope() {
        return this.createScope("Test Scope", "Scope Icon");
    }

    protected ResourceScopeResource createScope(String name, String iconUri) {
        ScopeRepresentation newScope = new ScopeRepresentation();
        newScope.setName(name);
        newScope.setIconUri(iconUri);
        ResourceScopesResource resources = this.getClientResource().authorization().scopes();
        Response response = resources.create(newScope);
        Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)response.getStatus());
        ScopeRepresentation stored = (ScopeRepresentation)response.readEntity(ScopeRepresentation.class);
        return resources.scope(stored.getId());
    }
}

