/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.client.authorization;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.PoliciesResource;
import org.keycloak.admin.client.resource.PolicyResource;
import org.keycloak.admin.client.resource.ResourceResource;
import org.keycloak.admin.client.resource.ResourceScopeResource;
import org.keycloak.admin.client.resource.ResourceScopesResource;
import org.keycloak.admin.client.resource.ResourcesResource;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.Logic;
import org.keycloak.representations.idm.authorization.PolicyProviderRepresentation;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;
import org.keycloak.testsuite.admin.client.authorization.AbstractAuthorizationTest;

public class GenericPolicyManagementTest
extends AbstractAuthorizationTest {
    private static final String[] EXPECTED_BUILTIN_POLICY_PROVIDERS = new String[]{"test", "user", "role", "drools", "js", "time", "aggregate", "scope", "resource"};

    @Override
    @Before
    public void onBeforeAuthzTests() {
        super.onBeforeAuthzTests();
        this.enableAuthorizationServices();
    }

    @Override
    @After
    public void onAfterAuthzTests() {
        super.onAfterAuthzTests();
    }

    @Test
    public void testCreate() {
        PolicyRepresentation newPolicy = this.createTestingPolicy().toRepresentation();
        Assert.assertEquals((Object)"Test Generic Policy", (Object)newPolicy.getName());
        Assert.assertEquals((Object)"test", (Object)newPolicy.getType());
        Assert.assertEquals((Object)Logic.POSITIVE, (Object)newPolicy.getLogic());
        Assert.assertEquals((Object)DecisionStrategy.UNANIMOUS, (Object)newPolicy.getDecisionStrategy());
        Assert.assertEquals((Object)"configuration for A", newPolicy.getConfig().get("configA"));
        Assert.assertEquals((Object)"configuration for B", newPolicy.getConfig().get("configB"));
        Assert.assertEquals((Object)"configuration for C", newPolicy.getConfig().get("configC"));
        List policies = this.getClientResource().authorization().policies().policies();
        Assert.assertEquals((long)6L, (long)policies.size());
        this.assertAssociatedPolicy("Test Associated A", newPolicy);
        this.assertAssociatedPolicy("Test Associated B", newPolicy);
        this.assertAssociatedPolicy("Test Associated C", newPolicy);
        this.assertAssociatedResource("Test Resource A", newPolicy);
        this.assertAssociatedResource("Test Resource B", newPolicy);
        this.assertAssociatedResource("Test Resource C", newPolicy);
        this.assertAssociatedScope("Test Scope A", newPolicy);
        this.assertAssociatedScope("Test Scope B", newPolicy);
        this.assertAssociatedScope("Test Scope C", newPolicy);
    }

    @Test
    public void testUpdate() {
        PolicyResource policyResource = this.createTestingPolicy();
        PolicyRepresentation resource = policyResource.toRepresentation();
        resource.setName("changed");
        resource.setLogic(Logic.NEGATIVE);
        resource.setDecisionStrategy(DecisionStrategy.AFFIRMATIVE);
        resource.getConfig().put("configA", "changed configuration for A");
        resource.getConfig().remove("configB");
        resource.getConfig().put("configC", "changed configuration for C");
        policyResource.update(resource);
        resource = policyResource.toRepresentation();
        Assert.assertEquals((Object)"changed", (Object)resource.getName());
        Assert.assertEquals((Object)Logic.NEGATIVE, (Object)resource.getLogic());
        Assert.assertEquals((Object)DecisionStrategy.AFFIRMATIVE, (Object)resource.getDecisionStrategy());
        Assert.assertEquals((Object)"changed configuration for A", resource.getConfig().get("configA"));
        Assert.assertNull(resource.getConfig().get("configB"));
        Assert.assertEquals((Object)"changed configuration for C", resource.getConfig().get("configC"));
        Map config = resource.getConfig();
        config.put("applyPolicies", this.buildConfigOption(this.findPolicyByName("Test Associated C").getId()));
        config.put("resources", this.buildConfigOption(this.findResourceByName("Test Resource B").getId()));
        config.put("scopes", this.buildConfigOption(this.findScopeByName("Test Scope A").getId()));
        policyResource.update(resource);
        resource = policyResource.toRepresentation();
        config = resource.getConfig();
        this.assertAssociatedPolicy("Test Associated C", resource);
        Assert.assertFalse((boolean)((String)config.get("applyPolicies")).contains(this.findPolicyByName("Test Associated A").getId()));
        Assert.assertFalse((boolean)((String)config.get("applyPolicies")).contains(this.findPolicyByName("Test Associated B").getId()));
        this.assertAssociatedResource("Test Resource B", resource);
        Assert.assertFalse((boolean)((String)config.get("resources")).contains(this.findResourceByName("Test Resource A").getId()));
        Assert.assertFalse((boolean)((String)config.get("resources")).contains(this.findResourceByName("Test Resource C").getId()));
        this.assertAssociatedScope("Test Scope A", resource);
        Assert.assertFalse((boolean)((String)config.get("scopes")).contains(this.findScopeByName("Test Scope B").getId()));
        Assert.assertFalse((boolean)((String)config.get("scopes")).contains(this.findScopeByName("Test Scope C").getId()));
    }

    @Test
    public void testDefaultPolicyProviders() {
        List providers = this.getClientResource().authorization().policies().policyProviders().stream().map(PolicyProviderRepresentation::getType).collect(Collectors.toList());
        Assert.assertFalse((boolean)providers.isEmpty());
        Assert.assertTrue((boolean)providers.containsAll(Arrays.asList(EXPECTED_BUILTIN_POLICY_PROVIDERS)));
    }

    private PolicyResource createTestingPolicy() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("configA", "configuration for A");
        config.put("configB", "configuration for B");
        config.put("configC", "configuration for C");
        config.put("applyPolicies", this.buildConfigOption(this.createPolicy("Test Associated A", new HashMap<String, String>()).toRepresentation().getId(), this.createPolicy("Test Associated B", new HashMap<String, String>()).toRepresentation().getId(), this.createPolicy("Test Associated C", new HashMap<String, String>()).toRepresentation().getId()));
        config.put("resources", this.buildConfigOption(this.createResource("Test Resource A").toRepresentation().getId(), this.createResource("Test Resource B").toRepresentation().getId(), this.createResource("Test Resource C").toRepresentation().getId()));
        config.put("scopes", this.buildConfigOption(this.createScope("Test Scope A").toRepresentation().getId(), this.createScope("Test Scope B").toRepresentation().getId(), this.createScope("Test Scope C").toRepresentation().getId()));
        return this.createPolicy("Test Generic Policy", config);
    }

    private PolicyResource createPolicy(String name, Map<String, String> config) {
        PolicyRepresentation newPolicy = new PolicyRepresentation();
        newPolicy.setName(name);
        newPolicy.setType("test");
        newPolicy.setConfig(config);
        PoliciesResource policies = this.getClientResource().authorization().policies();
        Response response = policies.create(newPolicy);
        Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)response.getStatus());
        PolicyRepresentation stored = (PolicyRepresentation)response.readEntity(PolicyRepresentation.class);
        return policies.policy(stored.getId());
    }

    private ResourceResource createResource(String name) {
        ResourceRepresentation newResource = new ResourceRepresentation();
        newResource.setName(name);
        ResourcesResource resources = this.getClientResource().authorization().resources();
        Response response = resources.create(newResource);
        Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)response.getStatus());
        ResourceRepresentation stored = (ResourceRepresentation)response.readEntity(ResourceRepresentation.class);
        return resources.resource(stored.getId());
    }

    private ResourceScopeResource createScope(String name) {
        ScopeRepresentation newScope = new ScopeRepresentation();
        newScope.setName(name);
        ResourceScopesResource scopes = this.getClientResource().authorization().scopes();
        Response response = scopes.create(newScope);
        Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)response.getStatus());
        ScopeRepresentation stored = (ScopeRepresentation)response.readEntity(ScopeRepresentation.class);
        return scopes.scope(stored.getId());
    }

    private String buildConfigOption(String ... values) {
        StringBuilder builder = new StringBuilder();
        for (String value : values) {
            if (builder.length() > 0) {
                builder.append(",");
            }
            builder.append("\"" + value + "\"");
        }
        return builder.insert(0, "[").append("]").toString();
    }

    private PolicyRepresentation findPolicyByName(String name) {
        return this.getClientResource().authorization().policies().policies().stream().filter(policyRepresentation -> policyRepresentation.getName().equals(name)).findFirst().orElse(null);
    }

    private ResourceRepresentation findResourceByName(String name) {
        return this.getClientResource().authorization().resources().resources().stream().filter(resource -> resource.getName().equals(name)).findFirst().orElse(null);
    }

    private ScopeRepresentation findScopeByName(String name) {
        return this.getClientResource().authorization().scopes().scopes().stream().filter(scope -> scope.getName().equals(name)).findFirst().orElse(null);
    }

    private void assertAssociatedPolicy(String associatedPolicyName, PolicyRepresentation dependentPolicy) {
        PolicyRepresentation associatedPolicy = this.findPolicyByName(associatedPolicyName);
        Assert.assertNotNull((Object)associatedPolicy);
        Assert.assertTrue((boolean)((String)dependentPolicy.getConfig().get("applyPolicies")).contains(associatedPolicy.getId()));
        Assert.assertEquals((long)1L, (long)associatedPolicy.getDependentPolicies().size());
        Assert.assertEquals((Object)dependentPolicy.getId(), (Object)((PolicyRepresentation)associatedPolicy.getDependentPolicies().get(0)).getId());
    }

    private void assertAssociatedResource(String resourceName, PolicyRepresentation policy) {
        ResourceRepresentation resource = this.findResourceByName(resourceName);
        Assert.assertNotNull((Object)resource);
        Assert.assertTrue((boolean)((String)policy.getConfig().get("resources")).contains(resource.getId()));
        Assert.assertEquals((long)1L, (long)resource.getPolicies().size());
        Assert.assertTrue((boolean)resource.getPolicies().stream().map(PolicyRepresentation::getId).collect(Collectors.toList()).contains(policy.getId()));
    }

    private void assertAssociatedScope(String scopeName, PolicyRepresentation policy) {
        ScopeRepresentation scope = this.findScopeByName(scopeName);
        Assert.assertNotNull((Object)scope);
        Assert.assertTrue((boolean)((String)policy.getConfig().get("scopes")).contains(scope.getId()));
        Assert.assertEquals((long)1L, (long)scope.getPolicies().size());
        Assert.assertTrue((boolean)scope.getPolicies().stream().map(PolicyRepresentation::getId).collect(Collectors.toList()).contains(policy.getId()));
    }
}

