/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.client.authorization;

import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.ResourceResource;
import org.keycloak.admin.client.resource.ResourcesResource;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;
import org.keycloak.testsuite.admin.client.authorization.AbstractAuthorizationTest;

public class ResourceManagementTest
extends AbstractAuthorizationTest {
    @Override
    @Before
    public void onBeforeAuthzTests() {
        super.onBeforeAuthzTests();
        this.enableAuthorizationServices();
    }

    @Test
    public void testCreate() {
        ResourceRepresentation newResource = this.createResource().toRepresentation();
        Assert.assertEquals((Object)"Test Resource", (Object)newResource.getName());
        Assert.assertEquals((Object)"/test/*", (Object)newResource.getUri());
        Assert.assertEquals((Object)"test-resource", (Object)newResource.getType());
        Assert.assertEquals((Object)"icon-test-resource", (Object)newResource.getIconUri());
    }

    @Test
    public void testUpdate() {
        ResourceResource resourceResource = this.createResource();
        ResourceRepresentation resource = resourceResource.toRepresentation();
        resource.setType("changed");
        resource.setIconUri("changed");
        resource.setUri("changed");
        resourceResource.update(resource);
        resource = resourceResource.toRepresentation();
        Assert.assertEquals((Object)"changed", (Object)resource.getIconUri());
        Assert.assertEquals((Object)"changed", (Object)resource.getType());
        Assert.assertEquals((Object)"changed", (Object)resource.getUri());
    }

    @Test(expected=NotFoundException.class)
    public void testDelete() {
        ResourceResource resourceResource = this.createResource();
        resourceResource.remove();
        resourceResource.toRepresentation();
    }

    @Test
    public void testAssociateScopes() {
        ResourceResource resourceResource = this.createResourceWithDefaultScopes();
        ResourceRepresentation updated = resourceResource.toRepresentation();
        Assert.assertEquals((long)3L, (long)updated.getScopes().size());
        Assert.assertTrue((boolean)this.containsScope("Scope A", updated));
        Assert.assertTrue((boolean)this.containsScope("Scope B", updated));
        Assert.assertTrue((boolean)this.containsScope("Scope C", updated));
    }

    @Test
    public void testUpdateScopes() {
        ResourceResource resourceResource = this.createResourceWithDefaultScopes();
        ResourceRepresentation resource = resourceResource.toRepresentation();
        HashSet<ScopeRepresentation> scopes = new HashSet<ScopeRepresentation>(resource.getScopes());
        Assert.assertEquals((long)3L, (long)scopes.size());
        Assert.assertTrue((boolean)scopes.removeIf(scopeRepresentation -> scopeRepresentation.getName().equals("Scope B")));
        resource.setScopes(scopes);
        resourceResource.update(resource);
        ResourceRepresentation updated = resourceResource.toRepresentation();
        Assert.assertEquals((long)2L, (long)resource.getScopes().size());
        Assert.assertFalse((boolean)this.containsScope("Scope B", updated));
        Assert.assertTrue((boolean)this.containsScope("Scope A", updated));
        Assert.assertTrue((boolean)this.containsScope("Scope C", updated));
        scopes = new HashSet(updated.getScopes());
        Assert.assertTrue((boolean)scopes.removeIf(scopeRepresentation -> scopeRepresentation.getName().equals("Scope A")));
        Assert.assertTrue((boolean)scopes.removeIf(scopeRepresentation -> scopeRepresentation.getName().equals("Scope C")));
        updated.setScopes(scopes);
        resourceResource.update(updated);
        updated = resourceResource.toRepresentation();
        Assert.assertEquals((long)0L, (long)updated.getScopes().size());
    }

    private ResourceResource createResourceWithDefaultScopes() {
        ResourceResource resourceResource = this.createResource();
        ResourceRepresentation resource = resourceResource.toRepresentation();
        Assert.assertEquals((long)0L, (long)resource.getScopes().size());
        HashSet<ScopeRepresentation> scopes = new HashSet<ScopeRepresentation>();
        scopes.add(this.createScope("Scope A", "").toRepresentation());
        scopes.add(this.createScope("Scope B", "").toRepresentation());
        scopes.add(this.createScope("Scope C", "").toRepresentation());
        resource.setScopes(scopes);
        resourceResource.update(resource);
        return resourceResource;
    }

    private boolean containsScope(String scopeName, ResourceRepresentation resource) {
        Set scopes = resource.getScopes();
        if (scopes != null) {
            for (ScopeRepresentation scope : scopes) {
                if (!scope.getName().equals(scopeName)) continue;
                return true;
            }
        }
        return false;
    }

    private ResourceResource createResource() {
        ResourceRepresentation newResource = new ResourceRepresentation();
        newResource.setName("Test Resource");
        newResource.setUri("/test/*");
        newResource.setType("test-resource");
        newResource.setIconUri("icon-test-resource");
        ResourcesResource resources = this.getClientResource().authorization().resources();
        Response response = resources.create(newResource);
        Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)response.getStatus());
        ResourceRepresentation stored = (ResourceRepresentation)response.readEntity(ResourceRepresentation.class);
        return resources.resource(stored.getId());
    }
}

