/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.client.authorization;

import javax.ws.rs.NotFoundException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.ResourceScopeResource;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;
import org.keycloak.testsuite.admin.client.authorization.AbstractAuthorizationTest;

public class ScopeManagementTest
extends AbstractAuthorizationTest {
    @Override
    @Before
    public void onBeforeAuthzTests() {
        super.onBeforeAuthzTests();
        this.enableAuthorizationServices();
    }

    @Test
    public void testCreate() {
        ScopeRepresentation newScope = this.createDefaultScope().toRepresentation();
        Assert.assertEquals((Object)"Test Scope", (Object)newScope.getName());
        Assert.assertEquals((Object)"Scope Icon", (Object)newScope.getIconUri());
    }

    @Test
    public void testUpdate() {
        ResourceScopeResource scopeResource = this.createDefaultScope();
        ScopeRepresentation scope = scopeResource.toRepresentation();
        scope.setName("changed");
        scope.setIconUri("changed");
        scopeResource.update(scope);
        scope = scopeResource.toRepresentation();
        Assert.assertEquals((Object)"changed", (Object)scope.getName());
        Assert.assertEquals((Object)"changed", (Object)scope.getIconUri());
    }

    @Test(expected=NotFoundException.class)
    public void testDelete() {
        ResourceScopeResource scopeResource = this.createDefaultScope();
        scopeResource.remove();
        scopeResource.toRepresentation();
    }
}

