/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.event;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.AuthDetailsRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.admin.event.AbstractEventTest;

public class AdminEventTest
extends AbstractEventTest {
    @Before
    public void initConfig() {
        this.enableEvents();
        this.testRealmResource().clearAdminEvents();
    }

    private List<AdminEventRepresentation> events() {
        return this.testRealmResource().getAdminEvents();
    }

    private void createUser(String username) {
        UserRepresentation user = AdminEventTest.createUserRepresentation(username, username + "@foo.com", "foo", "bar", true);
        ApiUtil.createUserWithAdminClient(this.testRealmResource(), user);
    }

    private void updateRealm() {
        RealmRepresentation realm = this.testRealmResource().toRepresentation();
        realm.setDisplayName("Fury Road");
        this.testRealmResource().update(realm);
    }

    @Test
    public void clearAdminEventsTest() {
        this.createUser("user0");
        Assert.assertEquals((long)1L, (long)this.events().size());
        this.testRealmResource().clearAdminEvents();
        Assert.assertEquals((Object)Collections.EMPTY_LIST, this.events());
    }

    @Test
    public void adminEventAttributeTest() {
        this.createUser("user5");
        List<AdminEventRepresentation> events = this.events();
        Assert.assertEquals((long)1L, (long)events.size());
        AdminEventRepresentation event = events.get(0);
        Assert.assertTrue((event.getTime() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.realmName(), (Object)event.getRealmId());
        Assert.assertEquals((Object)"CREATE", (Object)event.getOperationType());
        Assert.assertNotNull((Object)event.getResourcePath());
        Assert.assertNull((Object)event.getError());
        AuthDetailsRepresentation details = event.getAuthDetails();
        Assert.assertEquals((Object)this.realmName(), (Object)details.getRealmId());
        Assert.assertNotNull((Object)details.getClientId());
        Assert.assertNotNull((Object)details.getUserId());
        Assert.assertNotNull((Object)details.getIpAddress());
    }

    @Test
    public void retrieveAdminEventTest() {
        this.createUser("user1");
        List<AdminEventRepresentation> events = this.events();
        Assert.assertEquals((long)1L, (long)events.size());
        AdminEventRepresentation event = this.events().get(0);
        Assert.assertEquals((Object)"CREATE", (Object)event.getOperationType());
        Assert.assertEquals((Object)this.realmName(), (Object)event.getRealmId());
        Assert.assertEquals((Object)this.realmName(), (Object)event.getAuthDetails().getRealmId());
        Assert.assertNull((Object)event.getRepresentation());
    }

    @Test
    public void testGetRepresentation() {
        this.configRep.setAdminEventsDetailsEnabled(Boolean.TRUE);
        this.saveConfig();
        this.createUser("user2");
        AdminEventRepresentation event = this.events().get(0);
        Assert.assertNotNull((Object)event.getRepresentation());
        Assert.assertTrue((boolean)event.getRepresentation().contains("foo"));
        Assert.assertTrue((boolean)event.getRepresentation().contains("bar"));
    }

    @Test
    public void testFilterAdminEvents() {
        this.createUser("user3");
        this.createUser("user4");
        this.updateRealm();
        Assert.assertEquals((long)3L, (long)this.events().size());
        List events = this.testRealmResource().getAdminEvents(Arrays.asList("CREATE"), this.realmName(), null, null, null, null, null, null, null, null);
        Assert.assertEquals((long)2L, (long)events.size());
    }
}

