/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.event;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.testsuite.admin.event.AbstractEventTest;
import org.keycloak.testsuite.console.page.events.LoginEvents;

public class LoginEventsTest
extends AbstractEventTest {
    @Page
    private LoginEvents loginEventsPage;

    @Before
    public void init() {
        this.configRep.setEventsEnabled(true);
        this.saveConfig();
        this.testRealmResource().clearEvents();
    }

    private List<EventRepresentation> events() {
        return this.testRealmResource().getEvents();
    }

    private void badLogin() {
        this.loginEventsPage.navigateTo();
        this.loginPage.form().login("bad", "user");
    }

    private void pause(int seconds) {
        try {
            Thread.sleep((long)seconds * 1000L);
        }
        catch (InterruptedException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void eventAttributesTest() {
        this.badLogin();
        List<EventRepresentation> events = this.events();
        Assert.assertEquals((long)1L, (long)events.size());
        EventRepresentation event = events.get(0);
        Assert.assertTrue((event.getTime() > 0L ? 1 : 0) != 0);
        Assert.assertNotNull((Object)event.getIpAddress());
        Assert.assertEquals((Object)"LOGIN_ERROR", (Object)event.getType());
        Assert.assertEquals((Object)this.realmName(), (Object)event.getRealmId());
        Assert.assertNull((Object)event.getUserId());
        Assert.assertNull((Object)event.getSessionId());
        Assert.assertEquals((Object)"user_not_found", (Object)event.getError());
        Map details = event.getDetails();
        Assert.assertEquals((Object)"openid-connect", details.get("auth_method"));
        Assert.assertEquals((Object)"code", details.get("auth_type"));
        Assert.assertNotNull(details.get("redirect_uri"));
        Assert.assertNotNull(details.get("code_id"));
        Assert.assertEquals((Object)"bad", details.get("username"));
    }

    @Test
    public void clearEventsTest() {
        Assert.assertEquals((long)0L, (long)this.events().size());
        this.badLogin();
        this.badLogin();
        Assert.assertEquals((long)2L, (long)this.events().size());
        this.testRealmResource().clearEvents();
        Assert.assertEquals((long)0L, (long)this.events().size());
    }

    @Test
    public void loggingOfCertainTypeTest() {
        Assert.assertEquals((long)0L, (long)this.events().size());
        this.configRep.setEnabledEventTypes(Arrays.asList("REVOKE_GRANT"));
        this.saveConfig();
        this.badLogin();
        Assert.assertEquals((long)0L, (long)this.events().size());
        this.configRep.setEnabledEventTypes(Arrays.asList("LOGIN_ERROR"));
        this.saveConfig();
        this.badLogin();
        Assert.assertEquals((long)1L, (long)this.events().size());
    }

    @Test
    public void filterTest() {
        this.badLogin();
        this.badLogin();
        Assert.assertEquals((long)2L, (long)this.events().size());
        List filteredEvents = this.testRealmResource().getEvents(Arrays.asList("REVOKE_GRANT"), null, null, null, null, null, null, null);
        Assert.assertEquals((long)0L, (long)filteredEvents.size());
        filteredEvents = this.testRealmResource().getEvents(Arrays.asList("LOGIN_ERROR"), null, null, null, null, null, null, null);
        Assert.assertEquals((long)2L, (long)filteredEvents.size());
    }
}

