/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.group;

import java.security.PublicKey;
import java.util.List;
import org.junit.Rule;
import org.keycloak.RSATokenVerifier;
import org.keycloak.common.util.PemUtils;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.crypto.RSAProvider;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.RefreshToken;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.arquillian.AuthServerTestEnricher;
import org.keycloak.testsuite.util.AssertAdminEvents;
import org.keycloak.testsuite.util.IOUtil;
import org.keycloak.testsuite.util.OAuthClient;

public abstract class AbstractGroupTest
extends AbstractKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Rule
    public AssertAdminEvents assertAdminEvents = new AssertAdminEvents(this);

    AccessToken login(String login, String clientId, String clientSecret, String userId) throws Exception {
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doGrantAccessTokenRequest("test", login, "password", null, clientId, clientSecret);
        String accessToken = tokenResponse.getAccessToken();
        String refreshToken = tokenResponse.getRefreshToken();
        PublicKey publicKey = PemUtils.decodePublicKey((String)this.adminClient.realm("test").toRepresentation().getPublicKey());
        AccessToken accessTokenRepresentation = RSATokenVerifier.verifyToken((String)accessToken, (PublicKey)publicKey, (String)(AuthServerTestEnricher.getAuthServerContextRoot() + "/auth/realms/test"));
        JWSInput jws = new JWSInput(refreshToken);
        if (!RSAProvider.verify((JWSInput)jws, (PublicKey)publicKey)) {
            throw new RuntimeException("Invalid refresh token");
        }
        RefreshToken refreshTokenRepresentation = (RefreshToken)jws.readJsonContent(RefreshToken.class);
        this.events.expectLogin().client(clientId).user(userId).detail("grant_type", "password").detail("token_id", accessTokenRepresentation.getId()).detail("refresh_token_id", refreshTokenRepresentation.getId()).detail("username", login).removeDetail("code_id").removeDetail("redirect_uri").removeDetail("consent").assertEvent();
        return accessTokenRepresentation;
    }

    RealmRepresentation loadTestRealm(List<RealmRepresentation> testRealms) {
        RealmRepresentation result = IOUtil.loadRealm((String)"/testrealm.json");
        testRealms.add(result);
        return result;
    }
}

