/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.group;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.admin.group.AbstractGroupTest;

public class GroupMappersTest
extends AbstractGroupTest {
    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation testRealmRep = this.loadTestRealm(testRealms);
        testRealmRep.setEventsEnabled(true);
        ClientRepresentation client = this.getClientByAlias(testRealmRep, "test-app");
        Assert.assertNotNull((String)"test-app client exists", (Object)client);
        client.setDirectAccessGrantsEnabled(Boolean.valueOf(true));
        LinkedList<ProtocolMapperRepresentation> mappers = new LinkedList<ProtocolMapperRepresentation>();
        ProtocolMapperRepresentation mapper = new ProtocolMapperRepresentation();
        mapper.setName("groups");
        mapper.setProtocolMapper("oidc-group-membership-mapper");
        mapper.setProtocol("openid-connect");
        mapper.setConsentRequired(false);
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("claim.name", "groups");
        config.put("access.token.claim", "true");
        config.put("id.token.claim", "true");
        mapper.setConfig(config);
        mappers.add(mapper);
        mapper = new ProtocolMapperRepresentation();
        mapper.setName("topAttribute");
        mapper.setProtocolMapper("oidc-usermodel-attribute-mapper");
        mapper.setProtocol("openid-connect");
        mapper.setConsentRequired(false);
        config = new HashMap();
        config.put("user.attribute", "topAttribute");
        config.put("claim.name", "topAttribute");
        config.put("jsonType.label", "String");
        config.put("access.token.claim", "true");
        config.put("id.token.claim", "true");
        mapper.setConfig(config);
        mappers.add(mapper);
        mapper = new ProtocolMapperRepresentation();
        mapper.setName("level2Attribute");
        mapper.setProtocolMapper("oidc-usermodel-attribute-mapper");
        mapper.setProtocol("openid-connect");
        mapper.setConsentRequired(false);
        config = new HashMap();
        config.put("user.attribute", "level2Attribute");
        config.put("claim.name", "level2Attribute");
        config.put("jsonType.label", "String");
        config.put("access.token.claim", "true");
        config.put("id.token.claim", "true");
        mapper.setConfig(config);
        mappers.add(mapper);
        client.setProtocolMappers(mappers);
    }

    private ClientRepresentation getClientByAlias(RealmRepresentation testRealmRep, String alias) {
        for (ClientRepresentation client : testRealmRep.getClients()) {
            if (!alias.equals(client.getClientId())) continue;
            return client;
        }
        return null;
    }

    @Test
    public void testGroupMappers() throws Exception {
        RealmResource realm = this.adminClient.realms().realm("test");
        UserRepresentation user = (UserRepresentation)realm.users().search("topGroupUser", Integer.valueOf(-1), Integer.valueOf(-1)).get(0);
        AccessToken token = this.login(user.getUsername(), "test-app", "password", user.getId());
        Assert.assertTrue((boolean)token.getRealmAccess().getRoles().contains("user"));
        List groups = (List)token.getOtherClaims().get("groups");
        Assert.assertNotNull((Object)groups);
        Assert.assertTrue((groups.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"topGroup", groups.get(0));
        Assert.assertEquals((Object)"true", token.getOtherClaims().get("topAttribute"));
        user = (UserRepresentation)realm.users().search("level2GroupUser", Integer.valueOf(-1), Integer.valueOf(-1)).get(0);
        token = this.login(user.getUsername(), "test-app", "password", user.getId());
        Assert.assertTrue((boolean)token.getRealmAccess().getRoles().contains("user"));
        Assert.assertTrue((boolean)token.getRealmAccess().getRoles().contains("admin"));
        Assert.assertTrue((boolean)token.getResourceAccess("test-app").getRoles().contains("customer-user"));
        groups = (List)token.getOtherClaims().get("groups");
        Assert.assertNotNull((Object)groups);
        Assert.assertTrue((groups.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"level2group", groups.get(0));
        Assert.assertEquals((Object)"true", token.getOtherClaims().get("topAttribute"));
        Assert.assertEquals((Object)"true", token.getOtherClaims().get("level2Attribute"));
    }
}

