/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.group;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RoleMappingResource;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.ClientMappingsRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.MappingsRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.admin.group.AbstractGroupTest;
import org.keycloak.testsuite.util.AdminEventPaths;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.RoleBuilder;
import org.keycloak.testsuite.util.URLAssert;
import org.keycloak.testsuite.util.UserBuilder;
import org.keycloak.util.JsonSerialization;

public class GroupTest
extends AbstractGroupTest {
    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation testRealmRep = this.loadTestRealm(testRealms);
        testRealmRep.setEventsEnabled(true);
        List users = testRealmRep.getUsers();
        UserRepresentation user = new UserRepresentation();
        user.setUsername("direct-login");
        user.setEmail("direct-login@localhost");
        user.setEnabled(Boolean.valueOf(true));
        LinkedList<CredentialRepresentation> credentials = new LinkedList<CredentialRepresentation>();
        CredentialRepresentation credential = new CredentialRepresentation();
        credential.setType("password");
        credential.setValue("password");
        credentials.add(credential);
        user.setCredentials(credentials);
        users.add(user);
        List clients = testRealmRep.getClients();
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId("resource-owner");
        client.setDirectAccessGrantsEnabled(Boolean.valueOf(true));
        client.setSecret("secret");
        clients.add(client);
    }

    @Test
    public void testClientRemoveWithClientRoleGroupMapping() throws Exception {
        RealmResource realm = this.adminClient.realms().realm("test");
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId("foo");
        client.setRootUrl("http://foo");
        client.setProtocol("openid-connect");
        Response response = realm.clients().create(client);
        response.close();
        String clientUuid = ApiUtil.getCreatedId(response);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.clientResourcePath(clientUuid), (Object)client, ResourceType.CLIENT);
        client = (ClientRepresentation)realm.clients().findByClientId("foo").get(0);
        RoleRepresentation role = new RoleRepresentation();
        role.setName("foo-role");
        realm.clients().get(client.getId()).roles().create(role);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.clientRoleResourcePath(clientUuid, "foo-role"), (Object)role, ResourceType.CLIENT_ROLE);
        role = realm.clients().get(client.getId()).roles().get("foo-role").toRepresentation();
        GroupRepresentation group = new GroupRepresentation();
        group.setName("2716");
        group = this.createGroup(realm, group);
        LinkedList<RoleRepresentation> list = new LinkedList<RoleRepresentation>();
        list.add(role);
        realm.groups().group(group.getId()).roles().clientLevel(client.getId()).add(list);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.groupRolesClientRolesPath(group.getId(), clientUuid), list, ResourceType.CLIENT_ROLE_MAPPING);
        realm.clients().get(client.getId()).remove();
        this.assertAdminEvents.assertEvent("test", OperationType.DELETE, AdminEventPaths.clientResourcePath(clientUuid), ResourceType.CLIENT);
    }

    private GroupRepresentation createGroup(RealmResource realm, GroupRepresentation group) {
        Response response = realm.groups().add(group);
        String groupId = ApiUtil.getCreatedId(response);
        response.close();
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.groupPath(groupId), (Object)group, ResourceType.GROUP);
        group.setId(groupId);
        return group;
    }

    @Test
    public void createAndTestGroups() throws Exception {
        RealmResource realm = this.adminClient.realms().realm("test");
        RoleRepresentation groupRole = new RoleRepresentation();
        groupRole.setName("topRole");
        realm.roles().create(groupRole);
        RoleRepresentation topRole = realm.roles().get("topRole").toRepresentation();
        RoleRepresentation groupRole2 = new RoleRepresentation();
        groupRole2.setName("level2Role");
        realm.roles().create(groupRole2);
        RoleRepresentation level2Role = realm.roles().get("level2Role").toRepresentation();
        RoleRepresentation groupRole3 = new RoleRepresentation();
        groupRole3.setName("level3Role");
        realm.roles().create(groupRole3);
        RoleRepresentation level3Role = realm.roles().get("level3Role").toRepresentation();
        this.assertAdminEvents.clear();
        GroupRepresentation topGroup = new GroupRepresentation();
        topGroup.setName("top");
        topGroup = this.createGroup(realm, topGroup);
        LinkedList<RoleRepresentation> roles = new LinkedList<RoleRepresentation>();
        roles.add(topRole);
        realm.groups().group(topGroup.getId()).roles().realmLevel().add(roles);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.groupRolesRealmRolesPath(topGroup.getId()), roles, ResourceType.REALM_ROLE_MAPPING);
        GroupRepresentation level2Group = new GroupRepresentation();
        level2Group.setName("level2");
        Response response = realm.groups().group(topGroup.getId()).subGroup(level2Group);
        response.close();
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.groupSubgroupsPath(topGroup.getId()), (Object)level2Group, ResourceType.GROUP);
        URI location = response.getLocation();
        final String level2Id = ApiUtil.getCreatedId(response);
        GroupRepresentation level2GroupById = realm.groups().group(level2Id).toRepresentation();
        org.junit.Assert.assertEquals((Object)level2Id, (Object)level2GroupById.getId());
        org.junit.Assert.assertEquals((Object)level2Group.getName(), (Object)level2GroupById.getName());
        URLAssert.assertGetURL(location, this.adminClient.tokenManager().getAccessTokenString(), new URLAssert.AssertJSONResponseHandler(){

            @Override
            protected void assertResponseBody(String body) throws IOException {
                GroupRepresentation level2 = (GroupRepresentation)JsonSerialization.readValue((String)body, GroupRepresentation.class);
                org.junit.Assert.assertEquals((Object)level2Id, (Object)level2.getId());
            }
        });
        level2Group = realm.getGroupByPath("/top/level2");
        org.junit.Assert.assertNotNull((Object)level2Group);
        roles.clear();
        roles.add(level2Role);
        realm.groups().group(level2Group.getId()).roles().realmLevel().add(roles);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.groupRolesRealmRolesPath(level2Group.getId()), roles, ResourceType.REALM_ROLE_MAPPING);
        GroupRepresentation level3Group = new GroupRepresentation();
        level3Group.setName("level3");
        response = realm.groups().group(level2Group.getId()).subGroup(level3Group);
        response.close();
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.groupSubgroupsPath(level2Group.getId()), (Object)level3Group, ResourceType.GROUP);
        level3Group = realm.getGroupByPath("/top/level2/level3");
        org.junit.Assert.assertNotNull((Object)level3Group);
        roles.clear();
        roles.add(level3Role);
        realm.groups().group(level3Group.getId()).roles().realmLevel().add(roles);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.groupRolesRealmRolesPath(level3Group.getId()), roles, ResourceType.REALM_ROLE_MAPPING);
        topGroup = realm.getGroupByPath("/top");
        org.junit.Assert.assertEquals((long)1L, (long)topGroup.getRealmRoles().size());
        org.junit.Assert.assertTrue((boolean)topGroup.getRealmRoles().contains("topRole"));
        org.junit.Assert.assertEquals((long)1L, (long)topGroup.getSubGroups().size());
        level2Group = (GroupRepresentation)topGroup.getSubGroups().get(0);
        org.junit.Assert.assertEquals((Object)"level2", (Object)level2Group.getName());
        org.junit.Assert.assertEquals((long)1L, (long)level2Group.getRealmRoles().size());
        org.junit.Assert.assertTrue((boolean)level2Group.getRealmRoles().contains("level2Role"));
        org.junit.Assert.assertEquals((long)1L, (long)level2Group.getSubGroups().size());
        level3Group = (GroupRepresentation)level2Group.getSubGroups().get(0);
        org.junit.Assert.assertEquals((Object)"level3", (Object)level3Group.getName());
        org.junit.Assert.assertEquals((long)1L, (long)level3Group.getRealmRoles().size());
        org.junit.Assert.assertTrue((boolean)level3Group.getRealmRoles().contains("level3Role"));
        UserRepresentation user = (UserRepresentation)realm.users().search("direct-login", Integer.valueOf(-1), Integer.valueOf(-1)).get(0);
        realm.users().get(user.getId()).joinGroup(level3Group.getId());
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.userGroupPath(user.getId(), level3Group.getId()), ResourceType.GROUP_MEMBERSHIP);
        List membership = realm.users().get(user.getId()).groups();
        org.junit.Assert.assertEquals((long)1L, (long)membership.size());
        org.junit.Assert.assertEquals((Object)"level3", (Object)((GroupRepresentation)membership.get(0)).getName());
        AccessToken token = this.login("direct-login", "resource-owner", "secret", user.getId());
        org.junit.Assert.assertTrue((boolean)token.getRealmAccess().getRoles().contains("topRole"));
        org.junit.Assert.assertTrue((boolean)token.getRealmAccess().getRoles().contains("level2Role"));
        org.junit.Assert.assertTrue((boolean)token.getRealmAccess().getRoles().contains("level3Role"));
        realm.addDefaultGroup(level3Group.getId());
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.defaultGroupPath(level3Group.getId()), ResourceType.GROUP);
        List defaultGroups = realm.getDefaultGroups();
        org.junit.Assert.assertEquals((long)1L, (long)defaultGroups.size());
        org.junit.Assert.assertEquals((Object)((GroupRepresentation)defaultGroups.get(0)).getId(), (Object)level3Group.getId());
        UserRepresentation newUser = new UserRepresentation();
        newUser.setUsername("groupUser");
        newUser.setEmail("group@group.com");
        response = realm.users().create(newUser);
        String userId = ApiUtil.getCreatedId(response);
        response.close();
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.userResourcePath(userId), (Object)newUser, ResourceType.USER);
        membership = realm.users().get(userId).groups();
        org.junit.Assert.assertEquals((long)1L, (long)membership.size());
        org.junit.Assert.assertEquals((Object)"level3", (Object)((GroupRepresentation)membership.get(0)).getName());
        realm.removeDefaultGroup(level3Group.getId());
        this.assertAdminEvents.assertEvent("test", OperationType.DELETE, AdminEventPaths.defaultGroupPath(level3Group.getId()), ResourceType.GROUP);
        defaultGroups = realm.getDefaultGroups();
        org.junit.Assert.assertEquals((long)0L, (long)defaultGroups.size());
        realm.groups().group(topGroup.getId()).remove();
        this.assertAdminEvents.assertEvent("test", OperationType.DELETE, AdminEventPaths.groupPath(topGroup.getId()), ResourceType.GROUP);
        try {
            realm.getGroupByPath("/top/level2/level3");
            org.junit.Assert.fail((String)"Group should not have been found");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            realm.getGroupByPath("/top/level2");
            org.junit.Assert.fail((String)"Group should not have been found");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            realm.getGroupByPath("/top");
            org.junit.Assert.fail((String)"Group should not have been found");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        org.junit.Assert.assertNull((Object)this.login("direct-login", "resource-owner", "secret", user.getId()).getRealmAccess());
    }

    @Test
    public void updateGroup() {
        RealmResource realm = this.adminClient.realms().realm("test");
        GroupRepresentation group = new GroupRepresentation();
        group.setName("group");
        HashMap<String, List<String>> attrs = new HashMap<String, List<String>>();
        attrs.put("attr1", Collections.singletonList("attrval1"));
        attrs.put("attr2", Collections.singletonList("attrval2"));
        group.setAttributes(attrs);
        this.createGroup(realm, group);
        group = realm.getGroupByPath("/group");
        org.junit.Assert.assertNotNull((Object)group);
        org.junit.Assert.assertEquals((Object)"group", (Object)group.getName());
        org.junit.Assert.assertEquals((long)2L, (long)group.getAttributes().size());
        org.junit.Assert.assertEquals((long)1L, (long)((List)group.getAttributes().get("attr1")).size());
        org.junit.Assert.assertEquals((Object)"attrval1", ((List)group.getAttributes().get("attr1")).get(0));
        org.junit.Assert.assertEquals((long)1L, (long)((List)group.getAttributes().get("attr2")).size());
        org.junit.Assert.assertEquals((Object)"attrval2", ((List)group.getAttributes().get("attr2")).get(0));
        group.setName("group-new");
        group.getAttributes().remove("attr1");
        ((List)group.getAttributes().get("attr2")).add("attrval2-2");
        group.getAttributes().put("attr3", Collections.singletonList("attrval2"));
        realm.groups().group(group.getId()).update(group);
        this.assertAdminEvents.assertEvent("test", OperationType.UPDATE, AdminEventPaths.groupPath(group.getId()), (Object)group, ResourceType.GROUP);
        group = realm.getGroupByPath("/group-new");
        org.junit.Assert.assertEquals((Object)"group-new", (Object)group.getName());
        org.junit.Assert.assertEquals((long)2L, (long)group.getAttributes().size());
        org.junit.Assert.assertEquals((long)2L, (long)((List)group.getAttributes().get("attr2")).size());
        org.junit.Assert.assertEquals((long)1L, (long)((List)group.getAttributes().get("attr3")).size());
    }

    @Test
    public void groupMembership() {
        RealmResource realm = this.adminClient.realms().realm("test");
        GroupRepresentation group = new GroupRepresentation();
        group.setName("group");
        String groupId = this.createGroup(realm, group).getId();
        Response response = realm.users().create(UserBuilder.create().username("user-a").build());
        String userAId = ApiUtil.getCreatedId(response);
        response.close();
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.userResourcePath(userAId), ResourceType.USER);
        response = realm.users().create(UserBuilder.create().username("user-b").build());
        String userBId = ApiUtil.getCreatedId(response);
        response.close();
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.userResourcePath(userBId), ResourceType.USER);
        realm.users().get(userAId).joinGroup(groupId);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.userGroupPath(userAId, groupId), (Object)group, ResourceType.GROUP_MEMBERSHIP);
        List members = realm.groups().group(groupId).members(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertNames(members, "user-a");
        realm.users().get(userBId).joinGroup(groupId);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.userGroupPath(userBId, groupId), (Object)group, ResourceType.GROUP_MEMBERSHIP);
        members = realm.groups().group(groupId).members(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertNames(members, "user-a", "user-b");
        realm.users().get(userAId).leaveGroup(groupId);
        this.assertAdminEvents.assertEvent("test", OperationType.DELETE, AdminEventPaths.userGroupPath(userAId, groupId), (Object)group, ResourceType.GROUP_MEMBERSHIP);
        members = realm.groups().group(groupId).members(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertNames(members, "user-b");
    }

    @Test
    public void deleteRealmWithDefaultGroups() throws IOException {
        RealmRepresentation rep = new RealmRepresentation();
        rep.setRealm("foo");
        GroupRepresentation group = new GroupRepresentation();
        group.setName("default1");
        group.setPath("/default1");
        rep.setGroups(Collections.singletonList(group));
        rep.setDefaultGroups(Collections.singletonList("/default1"));
        this.adminClient.realms().create(rep);
        this.adminClient.realm(rep.getRealm()).remove();
    }

    @Test
    public void roleMappings() {
        RealmResource realm = this.adminClient.realms().realm("test");
        realm.roles().create(RoleBuilder.create().name("realm-role").build());
        realm.roles().create(RoleBuilder.create().name("realm-composite").build());
        realm.roles().create(RoleBuilder.create().name("realm-child").build());
        realm.roles().get("realm-composite").addComposites(Collections.singletonList(realm.roles().get("realm-child").toRepresentation()));
        Response response = realm.clients().create(ClientBuilder.create().clientId("myclient").build());
        String clientId = ApiUtil.getCreatedId(response);
        response.close();
        realm.clients().get(clientId).roles().create(RoleBuilder.create().name("client-role").build());
        realm.clients().get(clientId).roles().create(RoleBuilder.create().name("client-role2").build());
        realm.clients().get(clientId).roles().create(RoleBuilder.create().name("client-composite").build());
        realm.clients().get(clientId).roles().create(RoleBuilder.create().name("client-child").build());
        realm.clients().get(clientId).roles().get("client-composite").addComposites(Collections.singletonList(realm.clients().get(clientId).roles().get("client-child").toRepresentation()));
        this.assertAdminEvents.clear();
        GroupRepresentation group = new GroupRepresentation();
        group.setName("group");
        String groupId = this.createGroup(realm, group).getId();
        RoleMappingResource roles = realm.groups().group(groupId).roles();
        org.junit.Assert.assertEquals((long)0L, (long)roles.realmLevel().listAll().size());
        LinkedList<RoleRepresentation> l = new LinkedList<RoleRepresentation>();
        l.add(realm.roles().get("realm-role").toRepresentation());
        l.add(realm.roles().get("realm-composite").toRepresentation());
        roles.realmLevel().add(l);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.groupRolesRealmRolesPath(group.getId()), l, ResourceType.REALM_ROLE_MAPPING);
        RoleRepresentation clientRole = realm.clients().get(clientId).roles().get("client-role").toRepresentation();
        RoleRepresentation clientComposite = realm.clients().get(clientId).roles().get("client-composite").toRepresentation();
        roles.clientLevel(clientId).add(Collections.singletonList(clientRole));
        roles.clientLevel(clientId).add(Collections.singletonList(clientComposite));
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.groupRolesClientRolesPath(group.getId(), clientId), Collections.singletonList(clientRole), ResourceType.CLIENT_ROLE_MAPPING);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.groupRolesClientRolesPath(group.getId(), clientId), Collections.singletonList(clientComposite), ResourceType.CLIENT_ROLE_MAPPING);
        Assert.assertNames(roles.realmLevel().listAll(), "realm-role", "realm-composite");
        Assert.assertNames(roles.realmLevel().listAvailable(), "admin", "offline_access", "uma_authorization", "user");
        Assert.assertNames(roles.realmLevel().listEffective(), "realm-role", "realm-composite", "realm-child");
        Assert.assertNames(roles.clientLevel(clientId).listAll(), "client-role", "client-composite");
        Assert.assertNames(roles.clientLevel(clientId).listAvailable(), "client-role2");
        Assert.assertNames(roles.clientLevel(clientId).listEffective(), "client-role", "client-composite", "client-child");
        MappingsRepresentation all = roles.getAll();
        Assert.assertNames(all.getRealmMappings(), "realm-role", "realm-composite");
        org.junit.Assert.assertEquals((long)1L, (long)all.getClientMappings().size());
        Assert.assertNames(((ClientMappingsRepresentation)all.getClientMappings().get("myclient")).getMappings(), "client-role", "client-composite");
        RoleRepresentation realmRoleRep = realm.roles().get("realm-role").toRepresentation();
        roles.realmLevel().remove(Collections.singletonList(realmRoleRep));
        this.assertAdminEvents.assertEvent("test", OperationType.DELETE, AdminEventPaths.groupRolesRealmRolesPath(group.getId()), Collections.singletonList(realmRoleRep), ResourceType.REALM_ROLE_MAPPING);
        Assert.assertNames(roles.realmLevel().listAll(), "realm-composite");
        RoleRepresentation clientRoleRep = realm.clients().get(clientId).roles().get("client-role").toRepresentation();
        roles.clientLevel(clientId).remove(Collections.singletonList(clientRoleRep));
        this.assertAdminEvents.assertEvent("test", OperationType.DELETE, AdminEventPaths.groupRolesClientRolesPath(group.getId(), clientId), Collections.singletonList(clientRoleRep), ResourceType.CLIENT_ROLE_MAPPING);
        Assert.assertNames(roles.clientLevel(clientId).listAll(), "client-composite");
    }
}

