/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.partialimport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.IdentityProviderResource;
import org.keycloak.admin.client.resource.RoleResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.events.admin.OperationType;
import org.keycloak.partialimport.PartialImportResult;
import org.keycloak.partialimport.PartialImportResults;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.PartialImportRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.RolesRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractAuthTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.util.AssertAdminEvents;
import org.keycloak.testsuite.util.RealmBuilder;

public class PartialImportTest
extends AbstractAuthTest {
    @Rule
    public AssertAdminEvents assertAdminEvents = new AssertAdminEvents(this);
    private static final int NUM_RESOURCE_TYPES = 6;
    private static final String CLIENT_ROLES_CLIENT = "clientRolesClient";
    private static final String USER_PREFIX = "user";
    private static final String GROUP_PREFIX = "group";
    private static final String CLIENT_PREFIX = "client";
    private static final String REALM_ROLE_PREFIX = "realmRole";
    private static final String CLIENT_ROLE_PREFIX = "clientRole";
    private static final String[] IDP_ALIASES = new String[]{"twitter", "github", "facebook", "google", "linkedin", "microsoft", "stackoverflow"};
    private static final int NUM_ENTITIES = IDP_ALIASES.length;
    private PartialImportRepresentation piRep;
    private String realmId;

    @Before
    public void initAdminEvents() {
        RealmRepresentation realmRep = RealmBuilder.edit(this.testRealmResource().toRepresentation()).testEventListener().build();
        this.realmId = realmRep.getId();
        this.adminClient.realm(realmRep.getRealm()).update(realmRep);
        this.piRep = new PartialImportRepresentation();
    }

    @After
    public void tearDownAdminEvents() {
        RealmRepresentation realmRep = RealmBuilder.edit(this.testRealmResource().toRepresentation()).removeTestEventListener().build();
        this.adminClient.realm(realmRep.getRealm()).update(realmRep);
    }

    @Before
    public void createClientForClientRoles() {
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId(CLIENT_ROLES_CLIENT);
        client.setName(CLIENT_ROLES_CLIENT);
        client.setRootUrl("foo");
        client.setProtocol("openid-connect");
        Response resp = this.testRealmResource().clients().create(client);
        resp.readEntity(String.class);
    }

    @Before
    public void removeUsers() {
        List toRemove = this.testRealmResource().users().search(USER_PREFIX, Integer.valueOf(0), Integer.valueOf(NUM_ENTITIES));
        for (UserRepresentation user : toRemove) {
            this.testRealmResource().users().get(user.getId()).remove();
        }
    }

    @Before
    public void removeGroups() {
        List toRemove = this.testRealmResource().groups().groups();
        for (GroupRepresentation group : toRemove) {
            this.testRealmResource().groups().group(group.getId()).remove();
        }
    }

    @Before
    public void removeClients() {
        List toRemove = this.testRealmResource().clients().findAll();
        for (ClientRepresentation client : toRemove) {
            if (!client.getName().startsWith(CLIENT_PREFIX)) continue;
            this.testRealmResource().clients().get(client.getId()).remove();
        }
    }

    @Before
    public void removeProviders() {
        List toRemove = this.testRealmResource().identityProviders().findAll();
        for (IdentityProviderRepresentation idp : toRemove) {
            this.testRealmResource().identityProviders().get(idp.getInternalId()).remove();
        }
    }

    @Before
    public void removeRealmRoles() {
        List toRemove = this.testRealmResource().roles().list();
        for (RoleRepresentation role : toRemove) {
            if (!role.getName().startsWith(REALM_ROLE_PREFIX)) continue;
            this.testRealmResource().roles().get(role.getName()).remove();
        }
    }

    @Before
    public void removeClientRoles() {
        List toRemove = this.clientRolesClient().roles().list();
        for (RoleRepresentation role : toRemove) {
            if (!role.getName().startsWith(CLIENT_ROLE_PREFIX)) continue;
            this.testRealmResource().clients().get(CLIENT_ROLES_CLIENT).roles().get(role.getName()).remove();
        }
    }

    private ClientResource clientRolesClient() {
        return ApiUtil.findClientResourceByName(this.testRealmResource(), CLIENT_ROLES_CLIENT);
    }

    private void setFail() {
        this.piRep.setIfResourceExists(PartialImportRepresentation.Policy.FAIL.toString());
    }

    private void setSkip() {
        this.piRep.setIfResourceExists(PartialImportRepresentation.Policy.SKIP.toString());
    }

    private void setOverwrite() {
        this.piRep.setIfResourceExists(PartialImportRepresentation.Policy.OVERWRITE.toString());
    }

    private PartialImportResults doImport() {
        Response response = this.testRealmResource().partialImport(this.piRep);
        return (PartialImportResults)response.readEntity(PartialImportResults.class);
    }

    private void addUsers() {
        ArrayList<UserRepresentation> users = new ArrayList<UserRepresentation>();
        for (int i = 0; i < NUM_ENTITIES; ++i) {
            UserRepresentation user = PartialImportTest.createUserRepresentation(USER_PREFIX + i, USER_PREFIX + i + "@foo.com", "foo", "bar", true);
            users.add(user);
        }
        this.piRep.setUsers(users);
    }

    private void addGroups() {
        ArrayList<GroupRepresentation> groups = new ArrayList<GroupRepresentation>();
        for (int i = 0; i < NUM_ENTITIES; ++i) {
            GroupRepresentation group = new GroupRepresentation();
            group.setName(GROUP_PREFIX + i);
            group.setPath("/group" + i);
            groups.add(group);
        }
        this.piRep.setGroups(groups);
    }

    private void addClients() {
        ArrayList<ClientRepresentation> clients = new ArrayList<ClientRepresentation>();
        for (int i = 0; i < NUM_ENTITIES; ++i) {
            ClientRepresentation client = new ClientRepresentation();
            client.setClientId(CLIENT_PREFIX + i);
            client.setName(CLIENT_PREFIX + i);
            client.setRootUrl("foo");
            clients.add(client);
        }
        this.piRep.setClients(clients);
    }

    private void addProviders() {
        ArrayList<IdentityProviderRepresentation> providers = new ArrayList<IdentityProviderRepresentation>();
        for (String alias : IDP_ALIASES) {
            IdentityProviderRepresentation idpRep = new IdentityProviderRepresentation();
            idpRep.setAlias(alias);
            idpRep.setProviderId(alias);
            idpRep.setEnabled(true);
            idpRep.setAuthenticateByDefault(false);
            idpRep.setFirstBrokerLoginFlowAlias("first broker login");
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("clientSecret", "secret");
            config.put("clientId", alias);
            idpRep.setConfig(config);
            providers.add(idpRep);
        }
        this.piRep.setIdentityProviders(providers);
    }

    private List<RoleRepresentation> makeRoles(String prefix) {
        ArrayList<RoleRepresentation> roles = new ArrayList<RoleRepresentation>();
        for (int i = 0; i < NUM_ENTITIES; ++i) {
            RoleRepresentation role = new RoleRepresentation();
            role.setName(prefix + i);
            roles.add(role);
        }
        return roles;
    }

    private void addRealmRoles() {
        RolesRepresentation roles = this.piRep.getRoles();
        if (roles == null) {
            roles = new RolesRepresentation();
        }
        roles.setRealm(this.makeRoles(REALM_ROLE_PREFIX));
        this.piRep.setRoles(roles);
    }

    private void addClientRoles() {
        RolesRepresentation roles = this.piRep.getRoles();
        if (roles == null) {
            roles = new RolesRepresentation();
        }
        HashMap<String, List<RoleRepresentation>> clientRolesMap = new HashMap<String, List<RoleRepresentation>>();
        clientRolesMap.put(CLIENT_ROLES_CLIENT, this.makeRoles(CLIENT_ROLE_PREFIX));
        roles.setClient(clientRolesMap);
        this.piRep.setRoles(roles);
    }

    @Test
    public void testAddUsers() {
        this.assertAdminEvents.clear();
        this.setFail();
        this.addUsers();
        PartialImportResults results = this.doImport();
        org.junit.Assert.assertEquals((long)NUM_ENTITIES, (long)results.getAdded());
        HashSet<String> userIds = new HashSet<String>();
        for (int i = 0; i < NUM_ENTITIES; ++i) {
            AdminEventRepresentation adminEvent = this.assertAdminEvents.poll();
            Assert.assertEquals((Object)this.realmId, (Object)adminEvent.getRealmId());
            Assert.assertEquals((Object)OperationType.CREATE.name(), (Object)adminEvent.getOperationType());
            Assert.assertTrue((boolean)adminEvent.getResourcePath().startsWith("users/"));
            String userId = adminEvent.getResourcePath().substring(6);
            userIds.add(userId);
        }
        this.assertAdminEvents.assertEmpty();
        for (PartialImportResult result : results.getResults()) {
            String id = result.getId();
            UserResource userRsc = this.testRealmResource().users().get(id);
            UserRepresentation user = userRsc.toRepresentation();
            org.junit.Assert.assertTrue((boolean)user.getUsername().startsWith(USER_PREFIX));
            Assert.assertTrue((boolean)userIds.contains(id));
        }
    }

    @Test
    public void testAddClients() {
        this.setFail();
        this.addClients();
        PartialImportResults results = this.doImport();
        org.junit.Assert.assertEquals((long)NUM_ENTITIES, (long)results.getAdded());
        for (PartialImportResult result : results.getResults()) {
            String id = result.getId();
            ClientResource clientRsc = this.testRealmResource().clients().get(id);
            ClientRepresentation client = clientRsc.toRepresentation();
            org.junit.Assert.assertTrue((boolean)client.getName().startsWith(CLIENT_PREFIX));
        }
    }

    @Test
    public void testAddProviders() {
        this.setFail();
        this.addProviders();
        PartialImportResults results = this.doImport();
        org.junit.Assert.assertEquals((long)IDP_ALIASES.length, (long)results.getAdded());
        for (PartialImportResult result : results.getResults()) {
            String id = result.getId();
            IdentityProviderResource idpRsc = this.testRealmResource().identityProviders().get(id);
            IdentityProviderRepresentation idp = idpRsc.toRepresentation();
            Map config = idp.getConfig();
            org.junit.Assert.assertTrue((boolean)Arrays.asList(IDP_ALIASES).contains(config.get("clientId")));
        }
    }

    @Test
    public void testAddRealmRoles() {
        this.setFail();
        this.addRealmRoles();
        PartialImportResults results = this.doImport();
        org.junit.Assert.assertEquals((long)NUM_ENTITIES, (long)results.getAdded());
        for (PartialImportResult result : results.getResults()) {
            String name = result.getResourceName();
            RoleResource roleRsc = this.testRealmResource().roles().get(name);
            RoleRepresentation role = roleRsc.toRepresentation();
            org.junit.Assert.assertTrue((boolean)role.getName().startsWith(REALM_ROLE_PREFIX));
        }
    }

    @Test
    public void testAddClientRoles() {
        this.setFail();
        this.addClientRoles();
        PartialImportResults results = this.doImport();
        org.junit.Assert.assertEquals((long)NUM_ENTITIES, (long)results.getAdded());
        List clientRoles = this.clientRolesClient().roles().list();
        org.junit.Assert.assertEquals((long)NUM_ENTITIES, (long)clientRoles.size());
        for (RoleRepresentation roleRep : clientRoles) {
            org.junit.Assert.assertTrue((boolean)roleRep.getName().startsWith(CLIENT_ROLE_PREFIX));
        }
    }

    private void testFail() {
        this.setFail();
        PartialImportResults results = this.doImport();
        org.junit.Assert.assertNull((Object)results.getErrorMessage());
        results = this.doImport();
        org.junit.Assert.assertNotNull((Object)results.getErrorMessage());
    }

    @Test
    public void testAddUsersFail() {
        this.addUsers();
        this.testFail();
    }

    @Test
    public void testAddGroupsFail() {
        this.addGroups();
        this.testFail();
    }

    @Test
    public void testAddClientsFail() {
        this.addClients();
        this.testFail();
    }

    @Test
    public void testAddProvidersFail() {
        this.addProviders();
        this.testFail();
    }

    @Test
    public void testAddRealmRolesFail() {
        this.addRealmRoles();
        this.testFail();
    }

    @Test
    public void testAddClientRolesFail() {
        this.addClientRoles();
        this.testFail();
    }

    private void testSkip() {
        this.setSkip();
        PartialImportResults results = this.doImport();
        org.junit.Assert.assertEquals((long)NUM_ENTITIES, (long)results.getAdded());
        results = this.doImport();
        org.junit.Assert.assertEquals((long)NUM_ENTITIES, (long)results.getSkipped());
    }

    @Test
    public void testAddUsersSkip() {
        this.addUsers();
        this.testSkip();
    }

    @Test
    public void testAddGroupsSkip() {
        this.addGroups();
        this.testSkip();
    }

    @Test
    public void testAddClientsSkip() {
        this.addClients();
        this.testSkip();
    }

    @Test
    public void testAddProvidersSkip() {
        this.addProviders();
        this.testSkip();
    }

    @Test
    public void testAddRealmRolesSkip() {
        this.addRealmRoles();
        this.testSkip();
    }

    @Test
    public void testAddClientRolesSkip() {
        this.addClientRoles();
        this.testSkip();
    }

    private void testOverwrite() {
        this.setOverwrite();
        PartialImportResults results = this.doImport();
        org.junit.Assert.assertEquals((long)NUM_ENTITIES, (long)results.getAdded());
        results = this.doImport();
        org.junit.Assert.assertEquals((long)NUM_ENTITIES, (long)results.getOverwritten());
    }

    @Test
    public void testAddUsersOverwrite() {
        this.addUsers();
        this.testOverwrite();
    }

    @Test
    public void testAddGroupsOverwrite() {
        this.addGroups();
        this.testOverwrite();
    }

    @Test
    public void testAddClientsOverwrite() {
        this.addClients();
        this.testOverwrite();
    }

    @Test
    public void testAddProvidersOverwrite() {
        this.addProviders();
        this.testOverwrite();
    }

    @Test
    public void testAddRealmRolesOverwrite() {
        this.addRealmRoles();
        this.testOverwrite();
    }

    @Test
    public void testAddClientRolesOverwrite() {
        this.addClientRoles();
        this.testOverwrite();
    }

    private void importEverything() {
        this.addUsers();
        this.addGroups();
        this.addClients();
        this.addProviders();
        this.addRealmRoles();
        this.addClientRoles();
        PartialImportResults results = this.doImport();
        org.junit.Assert.assertNull((Object)results.getErrorMessage());
        org.junit.Assert.assertEquals((long)(NUM_ENTITIES * 6), (long)results.getAdded());
    }

    @Test
    public void testEverythingFail() {
        this.setFail();
        this.importEverything();
        PartialImportResults results = this.doImport();
        org.junit.Assert.assertNotNull((Object)results.getErrorMessage());
    }

    @Test
    public void testEverythingSkip() {
        this.setSkip();
        this.importEverything();
        PartialImportResults results = this.doImport();
        org.junit.Assert.assertEquals((long)(NUM_ENTITIES * 6), (long)results.getSkipped());
    }

    @Test
    public void testEverythingOverwrite() {
        this.setOverwrite();
        this.importEverything();
        PartialImportResults results = this.doImport();
        org.junit.Assert.assertEquals((long)(NUM_ENTITIES * 6), (long)results.getOverwritten());
    }
}

