/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.realm;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.RolesResource;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.util.AdminEventPaths;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.RoleBuilder;

public class RealmRolesTest
extends AbstractAdminTest {
    private RolesResource resource;
    private Map<String, String> ids = new HashMap<String, String>();
    private String clientUuid;

    @Before
    public void before() {
        RoleRepresentation roleA = RoleBuilder.create().name("role-a").description("Role A").build();
        RoleRepresentation roleB = RoleBuilder.create().name("role-b").description("Role B").build();
        this.adminClient.realm("admin-client-test").roles().create(roleA);
        this.adminClient.realm("admin-client-test").roles().create(roleB);
        ClientRepresentation clientRep = ClientBuilder.create().clientId("client-a").build();
        Response response = this.adminClient.realm("admin-client-test").clients().create(clientRep);
        this.clientUuid = ApiUtil.getCreatedId(response);
        RoleRepresentation roleC = RoleBuilder.create().name("role-c").description("Role C").build();
        this.adminClient.realm("admin-client-test").clients().get(this.clientUuid).roles().create(roleC);
        for (RoleRepresentation r : this.adminClient.realm("admin-client-test").roles().list()) {
            this.ids.put(r.getName(), r.getId());
        }
        for (RoleRepresentation r : this.adminClient.realm("admin-client-test").clients().get(this.clientUuid).roles().list()) {
            this.ids.put(r.getName(), r.getId());
        }
        this.resource = this.adminClient.realm("admin-client-test").roles();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.roleResourcePath("role-a"), (Object)roleA, ResourceType.REALM_ROLE);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.roleResourcePath("role-b"), (Object)roleB, ResourceType.REALM_ROLE);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.clientResourcePath(this.clientUuid), (Object)clientRep, ResourceType.CLIENT);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.clientRoleResourcePath(this.clientUuid, "role-c"), (Object)roleC, ResourceType.CLIENT_ROLE);
    }

    @Test
    public void getRole() {
        RoleRepresentation role = this.resource.get("role-a").toRepresentation();
        org.junit.Assert.assertNotNull((Object)role);
        org.junit.Assert.assertEquals((Object)"role-a", (Object)role.getName());
        org.junit.Assert.assertEquals((Object)"Role A", (Object)role.getDescription());
        org.junit.Assert.assertFalse((boolean)role.isComposite());
    }

    @Test
    public void updateRole() {
        RoleRepresentation role = this.resource.get("role-a").toRepresentation();
        role.setName("role-a-new");
        role.setDescription("Role A New");
        this.resource.get("role-a").update(role);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, AdminEventPaths.roleResourcePath("role-a"), (Object)role, ResourceType.REALM_ROLE);
        role = this.resource.get("role-a-new").toRepresentation();
        org.junit.Assert.assertNotNull((Object)role);
        org.junit.Assert.assertEquals((Object)"role-a-new", (Object)role.getName());
        org.junit.Assert.assertEquals((Object)"Role A New", (Object)role.getDescription());
        org.junit.Assert.assertFalse((boolean)role.isComposite());
    }

    @Test
    public void deleteRole() {
        org.junit.Assert.assertNotNull((Object)this.resource.get("role-a"));
        this.resource.deleteRole("role-a");
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.DELETE, AdminEventPaths.roleResourcePath("role-a"), ResourceType.REALM_ROLE);
        try {
            this.resource.get("role-a").toRepresentation();
            org.junit.Assert.fail((String)"Expected 404");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void composites() {
        org.junit.Assert.assertFalse((boolean)this.resource.get("role-a").toRepresentation().isComposite());
        org.junit.Assert.assertEquals((long)0L, (long)this.resource.get("role-a").getRoleComposites().size());
        LinkedList<RoleRepresentation> l = new LinkedList<RoleRepresentation>();
        l.add(RoleBuilder.create().id(this.ids.get("role-b")).build());
        l.add(RoleBuilder.create().id(this.ids.get("role-c")).build());
        this.resource.get("role-a").addComposites(l);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.roleResourceCompositesPath("role-a"), l, ResourceType.REALM_ROLE);
        Set composites = this.resource.get("role-a").getRoleComposites();
        org.junit.Assert.assertTrue((boolean)this.resource.get("role-a").toRepresentation().isComposite());
        Assert.assertNames(composites, "role-b", "role-c");
        Set realmComposites = this.resource.get("role-a").getRealmRoleComposites();
        Assert.assertNames(realmComposites, "role-b");
        Set clientComposites = this.resource.get("role-a").getClientRoleComposites(this.clientUuid);
        Assert.assertNames(clientComposites, "role-c");
        this.resource.get("role-a").deleteComposites(l);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.DELETE, AdminEventPaths.roleResourceCompositesPath("role-a"), l, ResourceType.REALM_ROLE);
        org.junit.Assert.assertFalse((boolean)this.resource.get("role-a").toRepresentation().isComposite());
        org.junit.Assert.assertEquals((long)0L, (long)this.resource.get("role-a").getRoleComposites().size());
    }
}

