/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.realm;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.ServerInfoResource;
import org.keycloak.common.util.StreamUtil;
import org.keycloak.common.util.Time;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.adapters.action.GlobalRequestResult;
import org.keycloak.representations.adapters.action.PushNotBeforeAction;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.AuthServerTestEnricher;
import org.keycloak.testsuite.util.AdminEventPaths;
import org.keycloak.testsuite.util.CredentialBuilder;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.UserBuilder;
import org.keycloak.util.JsonSerialization;

public class RealmTest
extends AbstractAdminTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    public static final String PRIVATE_KEY = "MIICXAIBAAKBgQCrVrCuTtArbgaZzL1hvh0xtL5mc7o0NqPVnYXkLvgcwiC3BjLGw1tGEGoJaXDuSaRllobm53JBhjx33UNv+5z/UMG4kytBWxheNVKnL6GgqlNabMaFfPLPCF8kAgKnsi79NMo+n6KnSY8YeUmec/p2vjO2NjsSAVcWEQMVhJ31LwIDAQABAoGAfmO8gVhyBxdqlxmIuglbz8bcjQbhXJLR2EoS8ngTXmN1bo2L90M0mUKSdc7qF10LgETBzqL8jYlQIbt+e6TH8fcEpKCjUlyq0Mf/vVbfZSNaVycY13nTzo27iPyWQHK5NLuJzn1xvxxrUeXI6A2WFpGEBLbHjwpx5WQG9A+2scECQQDvdn9NE75HPTVPxBqsEd2z10TKkl9CZxu10Qby3iQQmWLEJ9LNmy3acvKrE3gMiYNWb6xHPKiIqOR1as7L24aTAkEAtyvQOlCvr5kAjVqrEKXalj0Tzewjweuxc0pskvArTI2Oo070h65GpoIKLc9jf+UA69cRtquwP93aZKtW06U8dQJAF2Y44ks/mK5+eyDqik3koCI08qaC8HYq2wVl7G2QkJ6sbAaILtcvD92ToOvyGyeE0flvmDZxMYlvaZnaQ0lcSQJBAKZU6umJi3/xeEbkJqMfeLclD27XGEFoPeNrmdx0q10Azp4NfJAY+Z8KRyQCR2BEG+oNitBOZ+YXF9KCpH3cdmECQHEigJhYg+ykOvr1aiZUMFT72HU0jnmQe2FVekuG+LJUt2Tm7GtMjTFoGpf0JwrVuZN39fOYAlo+nTixgeW7X8Y=";
    public static final String PUBLIC_KEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCrVrCuTtArbgaZzL1hvh0xtL5mc7o0NqPVnYXkLvgcwiC3BjLGw1tGEGoJaXDuSaRllobm53JBhjx33UNv+5z/UMG4kytBWxheNVKnL6GgqlNabMaFfPLPCF8kAgKnsi79NMo+n6KnSY8YeUmec/p2vjO2NjsSAVcWEQMVhJ31LwIDAQAB";
    public static final String CERTIFICATE = "MIICsTCCAZkCBgFTLB5bhDANBgkqhkiG9w0BAQsFADAcMRowGAYDVQQDDBFhZG1pbi1jbGllbnQtdGVzdDAeFw0xNjAyMjkwODIwMDBaFw0yNjAyMjgwODIxNDBaMBwxGjAYBgNVBAMMEWFkbWluLWNsaWVudC10ZXN0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAquzJtpAlpTFnJzILjTOHW+SOWav1eIsCtlAqiFTvBskbod6b4BtVaR3FVrQm8rFiwDOIEWT3IG3ZIz0LKYxnqvuffyLHGHjiroqrR63kY9Wa9B790lSEWVaGeNOMnKleqKu5QUNfL3wVebUh/C/QfxZ29R1EIbxNe2ThN8yuIca8Ltn43D5VlyatptojffxpCYiYqAmIwQDaq1um2cQ+4rPBLxC5jM9UBvYOMUP4u0caNSaPI1o9lHVKgTtWcdQzUeMmAGsnLV26XGhA/OwRduUxksumR1kh/KSqowasjgSrpVqtF/uo5TY57s7drD+zKG58cdHLreclB9AQNvNwZwIDAQABMA0GCSqGSIb3DQEBCwUAA4IBAQBh4iwg8GnadeQP52pV5vKJ4Z8A1R2aYCzoW7Lc3FI/pXWX9Af5dKILX5O2j/daamPS+WtDWxIuwvZC5drrkvJn/r8e4KstnXQzPQggIJbI9v3wfIX3VlFvwvZVGiuE5PSLSWb0L57PEojZVpIU5bLchq4yRSD2zK4dWX8Y6I/D40a74KDvPOlEL8405/T1iW7ytKT9awNJW04N91owoI+kdUL+DMnnGzIxDAoYAeZI/1vcwoaH24zyTLGItkzpKxqLOdB05cnxn5jCWY2Hyd1zqtRkadhgZaqu4lcDHAHEMDp6dEjLZW8ym8bnlto+MD2y//CsyPCzyCLlA726vrli";

    @Test
    public void getRealms() {
        List realms = this.adminClient.realms().findAll();
        Assert.assertNames(realms, "master", "test", "admin-client-test");
        for (RealmRepresentation rep : realms) {
            org.junit.Assert.assertNull((Object)rep.getPrivateKey());
            org.junit.Assert.assertNull((Object)rep.getCodeSecret());
            org.junit.Assert.assertNotNull((Object)rep.getPublicKey());
            org.junit.Assert.assertNotNull((Object)rep.getCertificate());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void renameRealm() {
        RealmRepresentation rep = new RealmRepresentation();
        rep.setId("old");
        rep.setRealm("old");
        try {
            this.adminClient.realms().create(rep);
            rep.setRealm("new");
            this.adminClient.realm("old").update(rep);
            Assert.assertEquals((long)0L, (long)this.adminClient.realm("master").clients().findByClientId("old-realm").size());
            Assert.assertEquals((long)1L, (long)this.adminClient.realm("master").clients().findByClientId("new-realm").size());
            ClientRepresentation adminConsoleClient = (ClientRepresentation)this.adminClient.realm("new").clients().findByClientId("security-admin-console").get(0);
            org.junit.Assert.assertEquals((Object)"/auth/admin/new/console/index.html", (Object)adminConsoleClient.getBaseUrl());
            org.junit.Assert.assertEquals((Object)"/auth/admin/new/console/*", adminConsoleClient.getRedirectUris().get(0));
            ClientRepresentation accountClient = (ClientRepresentation)this.adminClient.realm("new").clients().findByClientId("account").get(0);
            org.junit.Assert.assertEquals((Object)"/auth/realms/new/account", (Object)accountClient.getBaseUrl());
            org.junit.Assert.assertEquals((Object)"/auth/realms/new/account/*", accountClient.getRedirectUris().get(0));
        }
        finally {
            this.adminClient.realms().realm(rep.getRealm()).remove();
        }
    }

    @Test
    public void createRealmEmpty() {
        RealmRepresentation rep = new RealmRepresentation();
        rep.setRealm("new-realm");
        this.adminClient.realms().create(rep);
        Assert.assertNames(this.adminClient.realms().findAll(), "master", "test", "admin-client-test", "new-realm");
        this.adminClient.realms().realm("new-realm").remove();
        Assert.assertNames(this.adminClient.realms().findAll(), "master", "test", "admin-client-test");
    }

    @Test
    public void createRealmCheckDefaultPasswordPolicy() {
        RealmRepresentation rep = new RealmRepresentation();
        rep.setRealm("new-realm");
        this.adminClient.realms().create(rep);
        org.junit.Assert.assertEquals((Object)"hashIterations(20000)", (Object)this.adminClient.realm("new-realm").toRepresentation().getPasswordPolicy());
        this.adminClient.realms().realm("new-realm").remove();
        rep.setPasswordPolicy("length(8)");
        this.adminClient.realms().create(rep);
        org.junit.Assert.assertEquals((Object)"length(8)", (Object)this.adminClient.realm("new-realm").toRepresentation().getPasswordPolicy());
        this.adminClient.realms().realm("new-realm").remove();
    }

    @Test
    public void createRealmFromJson() {
        RealmRepresentation rep = RealmTest.loadJson(this.getClass().getResourceAsStream("/admin-test/testrealm.json"), RealmRepresentation.class);
        this.adminClient.realms().create(rep);
        RealmRepresentation created = this.adminClient.realms().realm("admin-test-1").toRepresentation();
        RealmTest.assertRealm(rep, created);
        this.adminClient.realms().realm("admin-test-1").remove();
    }

    @Test
    public void removeRealm() {
        this.realm.remove();
        Assert.assertNames(this.adminClient.realms().findAll(), "master", "test");
    }

    @Test
    public void loginAfterRemoveRealm() {
        this.realm.remove();
        ServerInfoResource serverInfoResource = Keycloak.getInstance((String)(AuthServerTestEnricher.getAuthServerContextRoot() + "/auth"), (String)"master", (String)"admin", (String)"admin", (String)"admin-cli").serverInfo();
        serverInfoResource.getInfo();
    }

    @Test
    public void renameRealmTest() throws Exception {
        RealmRepresentation realm1 = new RealmRepresentation();
        realm1.setRealm("test-immutable");
        this.adminClient.realms().create(realm1);
        realm1 = this.adminClient.realms().realm("test-immutable").toRepresentation();
        realm1.setRealm("test-immutable-old");
        this.adminClient.realms().realm("test-immutable").update(realm1);
        realm1 = this.adminClient.realms().realm("test-immutable-old").toRepresentation();
        RealmRepresentation realm2 = new RealmRepresentation();
        realm2.setRealm("test-immutable");
        this.adminClient.realms().create(realm2);
        realm2 = this.adminClient.realms().realm("test-immutable").toRepresentation();
        this.adminClient.realms().realm("test-immutable-old").remove();
        this.adminClient.realms().realm("test-immutable").remove();
    }

    @Test
    public void updateRealm() {
        RealmRepresentation rep = this.realm.toRepresentation();
        rep.setSsoSessionIdleTimeout(Integer.valueOf(123));
        rep.setSsoSessionMaxLifespan(Integer.valueOf(12));
        rep.setAccessCodeLifespanLogin(Integer.valueOf(1234));
        rep.setRegistrationAllowed(Boolean.valueOf(true));
        rep.setRegistrationEmailAsUsername(Boolean.valueOf(true));
        rep.setEditUsernameAllowed(Boolean.valueOf(true));
        this.realm.update(rep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, (Matcher<String>)Matchers.nullValue(String.class), (Object)rep, ResourceType.REALM);
        rep = this.realm.toRepresentation();
        org.junit.Assert.assertEquals((long)123L, (long)rep.getSsoSessionIdleTimeout().intValue());
        org.junit.Assert.assertEquals((long)12L, (long)rep.getSsoSessionMaxLifespan().intValue());
        org.junit.Assert.assertEquals((long)1234L, (long)rep.getAccessCodeLifespanLogin().intValue());
        org.junit.Assert.assertEquals((Object)Boolean.TRUE, (Object)rep.isRegistrationAllowed());
        org.junit.Assert.assertEquals((Object)Boolean.TRUE, (Object)rep.isRegistrationEmailAsUsername());
        org.junit.Assert.assertEquals((Object)Boolean.TRUE, (Object)rep.isEditUsernameAllowed());
        rep.setRegistrationAllowed(Boolean.valueOf(false));
        rep.setRegistrationEmailAsUsername(Boolean.valueOf(false));
        rep.setEditUsernameAllowed(Boolean.valueOf(false));
        this.realm.update(rep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, (Matcher<String>)Matchers.nullValue(String.class), (Object)rep, ResourceType.REALM);
        rep = this.realm.toRepresentation();
        org.junit.Assert.assertEquals((Object)Boolean.FALSE, (Object)rep.isRegistrationAllowed());
        org.junit.Assert.assertEquals((Object)Boolean.FALSE, (Object)rep.isRegistrationEmailAsUsername());
        org.junit.Assert.assertEquals((Object)Boolean.FALSE, (Object)rep.isEditUsernameAllowed());
    }

    @Test
    public void updateRealmWithNewRepresentation() {
        RealmRepresentation rep = new RealmRepresentation();
        rep.setEditUsernameAllowed(Boolean.valueOf(true));
        rep.setSupportedLocales(new HashSet<String>(Arrays.asList("en", "de")));
        this.realm.update(rep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, (Matcher<String>)Matchers.nullValue(String.class), (Object)rep, ResourceType.REALM);
        rep = this.realm.toRepresentation();
        org.junit.Assert.assertEquals((Object)Boolean.TRUE, (Object)rep.isEditUsernameAllowed());
        org.junit.Assert.assertEquals((long)2L, (long)rep.getSupportedLocales().size());
        rep = new RealmRepresentation();
        rep.setEditUsernameAllowed(Boolean.valueOf(false));
        this.realm.update(rep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, (Matcher<String>)Matchers.nullValue(String.class), (Object)rep, ResourceType.REALM);
        rep = this.realm.toRepresentation();
        org.junit.Assert.assertEquals((Object)Boolean.FALSE, (Object)rep.isEditUsernameAllowed());
        org.junit.Assert.assertEquals((long)2L, (long)rep.getSupportedLocales().size());
    }

    @Test
    public void getRealmRepresentation() {
        RealmRepresentation rep = this.realm.toRepresentation();
        Assert.assertEquals((Object)"admin-client-test", (Object)rep.getRealm());
        org.junit.Assert.assertTrue((boolean)rep.isEnabled());
        org.junit.Assert.assertNull((Object)rep.getPrivateKey());
        org.junit.Assert.assertNull((Object)rep.getCodeSecret());
        org.junit.Assert.assertNotNull((Object)rep.getPublicKey());
        org.junit.Assert.assertNotNull((Object)rep.getCertificate());
    }

    @Test
    public void deleteDefaultRole() {
        RoleRepresentation role = new RoleRepresentation("test", "test", false);
        this.realm.roles().create(role);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.roleResourcePath("test"), (Object)role, ResourceType.REALM_ROLE);
        org.junit.Assert.assertNotNull((Object)this.realm.roles().get("test").toRepresentation());
        RealmRepresentation rep = this.realm.toRepresentation();
        rep.setDefaultRoles(new LinkedList());
        rep.getDefaultRoles().add("test");
        this.realm.update(rep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, (Matcher<String>)Matchers.nullValue(String.class), (Object)rep, ResourceType.REALM);
        this.realm.roles().deleteRole("test");
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.DELETE, AdminEventPaths.roleResourcePath("test"), ResourceType.REALM_ROLE);
        try {
            this.realm.roles().get("testsadfsadf").toRepresentation();
            org.junit.Assert.fail((String)"Expected NotFoundException");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void convertKeycloakClientDescription() throws IOException {
        ClientRepresentation description = new ClientRepresentation();
        description.setClientId("client-id");
        description.setRedirectUris(Collections.singletonList("http://localhost"));
        ClientRepresentation converted = this.realm.convertClientDescription(JsonSerialization.writeValueAsString((Object)description));
        org.junit.Assert.assertEquals((Object)"client-id", (Object)converted.getClientId());
        org.junit.Assert.assertEquals((Object)"http://localhost", converted.getRedirectUris().get(0));
    }

    @Test
    public void convertOIDCClientDescription() throws IOException {
        String description = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/client-descriptions/client-oidc.json"));
        ClientRepresentation converted = this.realm.convertClientDescription(description);
        org.junit.Assert.assertEquals((long)1L, (long)converted.getRedirectUris().size());
        org.junit.Assert.assertEquals((Object)"http://localhost", converted.getRedirectUris().get(0));
    }

    @Test
    public void convertSAMLClientDescription() throws IOException {
        String description = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/client-descriptions/saml-entity-descriptor.xml"));
        ClientRepresentation converted = this.realm.convertClientDescription(description);
        org.junit.Assert.assertEquals((Object)"loadbalancer-9.siroe.com", (Object)converted.getClientId());
        org.junit.Assert.assertEquals((long)1L, (long)converted.getRedirectUris().size());
        org.junit.Assert.assertEquals((Object)"https://LoadBalancer-9.siroe.com:3443/federation/Consumer/metaAlias/sp", converted.getRedirectUris().get(0));
    }

    public static void assertRealm(RealmRepresentation realm, RealmRepresentation storedRealm) {
        if (realm.getId() != null) {
            org.junit.Assert.assertEquals((Object)realm.getId(), (Object)storedRealm.getId());
        }
        if (realm.getRealm() != null) {
            org.junit.Assert.assertEquals((Object)realm.getRealm(), (Object)storedRealm.getRealm());
        }
        if (realm.isEnabled() != null) {
            org.junit.Assert.assertEquals((Object)realm.isEnabled(), (Object)storedRealm.isEnabled());
        }
        if (realm.isBruteForceProtected() != null) {
            org.junit.Assert.assertEquals((Object)realm.isBruteForceProtected(), (Object)storedRealm.isBruteForceProtected());
        }
        if (realm.getMaxFailureWaitSeconds() != null) {
            org.junit.Assert.assertEquals((Object)realm.getMaxFailureWaitSeconds(), (Object)storedRealm.getMaxFailureWaitSeconds());
        }
        if (realm.getMinimumQuickLoginWaitSeconds() != null) {
            org.junit.Assert.assertEquals((Object)realm.getMinimumQuickLoginWaitSeconds(), (Object)storedRealm.getMinimumQuickLoginWaitSeconds());
        }
        if (realm.getWaitIncrementSeconds() != null) {
            org.junit.Assert.assertEquals((Object)realm.getWaitIncrementSeconds(), (Object)storedRealm.getWaitIncrementSeconds());
        }
        if (realm.getQuickLoginCheckMilliSeconds() != null) {
            org.junit.Assert.assertEquals((Object)realm.getQuickLoginCheckMilliSeconds(), (Object)storedRealm.getQuickLoginCheckMilliSeconds());
        }
        if (realm.getMaxDeltaTimeSeconds() != null) {
            org.junit.Assert.assertEquals((Object)realm.getMaxDeltaTimeSeconds(), (Object)storedRealm.getMaxDeltaTimeSeconds());
        }
        if (realm.getFailureFactor() != null) {
            org.junit.Assert.assertEquals((Object)realm.getFailureFactor(), (Object)storedRealm.getFailureFactor());
        }
        if (realm.isRegistrationAllowed() != null) {
            org.junit.Assert.assertEquals((Object)realm.isRegistrationAllowed(), (Object)storedRealm.isRegistrationAllowed());
        }
        if (realm.isRegistrationEmailAsUsername() != null) {
            org.junit.Assert.assertEquals((Object)realm.isRegistrationEmailAsUsername(), (Object)storedRealm.isRegistrationEmailAsUsername());
        }
        if (realm.isRememberMe() != null) {
            org.junit.Assert.assertEquals((Object)realm.isRememberMe(), (Object)storedRealm.isRememberMe());
        }
        if (realm.isVerifyEmail() != null) {
            org.junit.Assert.assertEquals((Object)realm.isVerifyEmail(), (Object)storedRealm.isVerifyEmail());
        }
        if (realm.isResetPasswordAllowed() != null) {
            org.junit.Assert.assertEquals((Object)realm.isResetPasswordAllowed(), (Object)storedRealm.isResetPasswordAllowed());
        }
        if (realm.isEditUsernameAllowed() != null) {
            org.junit.Assert.assertEquals((Object)realm.isEditUsernameAllowed(), (Object)storedRealm.isEditUsernameAllowed());
        }
        if (realm.getSslRequired() != null) {
            org.junit.Assert.assertEquals((Object)realm.getSslRequired(), (Object)storedRealm.getSslRequired());
        }
        if (realm.getAccessCodeLifespan() != null) {
            org.junit.Assert.assertEquals((Object)realm.getAccessCodeLifespan(), (Object)storedRealm.getAccessCodeLifespan());
        }
        if (realm.getAccessCodeLifespanUserAction() != null) {
            org.junit.Assert.assertEquals((Object)realm.getAccessCodeLifespanUserAction(), (Object)storedRealm.getAccessCodeLifespanUserAction());
        }
        if (realm.getNotBefore() != null) {
            org.junit.Assert.assertEquals((Object)realm.getNotBefore(), (Object)storedRealm.getNotBefore());
        }
        if (realm.getAccessTokenLifespan() != null) {
            org.junit.Assert.assertEquals((Object)realm.getAccessTokenLifespan(), (Object)storedRealm.getAccessTokenLifespan());
        }
        if (realm.getAccessTokenLifespanForImplicitFlow() != null) {
            org.junit.Assert.assertEquals((Object)realm.getAccessTokenLifespanForImplicitFlow(), (Object)storedRealm.getAccessTokenLifespanForImplicitFlow());
        }
        if (realm.getSsoSessionIdleTimeout() != null) {
            org.junit.Assert.assertEquals((Object)realm.getSsoSessionIdleTimeout(), (Object)storedRealm.getSsoSessionIdleTimeout());
        }
        if (realm.getSsoSessionMaxLifespan() != null) {
            org.junit.Assert.assertEquals((Object)realm.getSsoSessionMaxLifespan(), (Object)storedRealm.getSsoSessionMaxLifespan());
        }
        if (realm.getRequiredCredentials() != null) {
            org.junit.Assert.assertNotNull((Object)storedRealm.getRequiredCredentials());
            for (String cred : realm.getRequiredCredentials()) {
                org.junit.Assert.assertTrue((boolean)storedRealm.getRequiredCredentials().contains(cred));
            }
        }
        if (realm.getLoginTheme() != null) {
            org.junit.Assert.assertEquals((Object)realm.getLoginTheme(), (Object)storedRealm.getLoginTheme());
        }
        if (realm.getAccountTheme() != null) {
            org.junit.Assert.assertEquals((Object)realm.getAccountTheme(), (Object)storedRealm.getAccountTheme());
        }
        if (realm.getAdminTheme() != null) {
            org.junit.Assert.assertEquals((Object)realm.getAdminTheme(), (Object)storedRealm.getAdminTheme());
        }
        if (realm.getEmailTheme() != null) {
            org.junit.Assert.assertEquals((Object)realm.getEmailTheme(), (Object)storedRealm.getEmailTheme());
        }
        if (realm.getPasswordPolicy() != null) {
            org.junit.Assert.assertEquals((Object)realm.getPasswordPolicy(), (Object)storedRealm.getPasswordPolicy());
        }
        if (realm.getDefaultRoles() != null) {
            org.junit.Assert.assertNotNull((Object)storedRealm.getDefaultRoles());
            for (String role : realm.getDefaultRoles()) {
                org.junit.Assert.assertTrue((boolean)storedRealm.getDefaultRoles().contains(role));
            }
        }
        if (realm.getSmtpServer() != null) {
            org.junit.Assert.assertEquals((Object)realm.getSmtpServer(), (Object)storedRealm.getSmtpServer());
        }
        if (realm.getBrowserSecurityHeaders() != null) {
            org.junit.Assert.assertEquals((Object)realm.getBrowserSecurityHeaders(), (Object)storedRealm.getBrowserSecurityHeaders());
        }
    }

    @Test
    public void uploadRealmKeys() throws Exception {
        String originalPublicKey = this.realm.toRepresentation().getPublicKey();
        RealmRepresentation rep = new RealmRepresentation();
        rep.setPrivateKey("INVALID");
        rep.setPublicKey(PUBLIC_KEY);
        try {
            this.realm.update(rep);
            org.junit.Assert.fail((String)"Expected BadRequestException");
        }
        catch (BadRequestException e) {
            this.assertAdminEvents.assertEmpty();
        }
        rep.setPrivateKey(PRIVATE_KEY);
        rep.setPublicKey("INVALID");
        try {
            this.realm.update(rep);
            org.junit.Assert.fail((String)"Expected BadRequestException");
        }
        catch (BadRequestException e) {
            this.assertAdminEvents.assertEmpty();
        }
        Assert.assertEquals((Object)originalPublicKey, (Object)this.realm.toRepresentation().getPublicKey());
        rep.setPublicKey(PUBLIC_KEY);
        this.realm.update(rep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, (Matcher<String>)Matchers.nullValue(String.class), (Object)rep, ResourceType.REALM);
        org.junit.Assert.assertEquals((Object)PUBLIC_KEY, (Object)rep.getPublicKey());
        String privateKey2048 = StreamUtil.readString((InputStream)this.getClass().getResourceAsStream("/keys/private2048.pem"));
        String publicKey2048 = StreamUtil.readString((InputStream)this.getClass().getResourceAsStream("/keys/public2048.pem"));
        rep.setPrivateKey(privateKey2048);
        try {
            this.realm.update(rep);
            org.junit.Assert.fail((String)"Expected BadRequestException");
        }
        catch (BadRequestException e) {
            this.assertAdminEvents.assertEmpty();
        }
        Assert.assertEquals((Object)PUBLIC_KEY, (Object)this.realm.toRepresentation().getPublicKey());
        rep.setPrivateKey("{}{}{}{}{}{}324re9gvj0r");
        rep.setPublicKey("{}{}{}{}{}{}324re9gvj0r");
        try {
            this.realm.update(rep);
            org.junit.Assert.fail((String)"Expected BadRequestException");
        }
        catch (BadRequestException e) {
            this.assertAdminEvents.assertEmpty();
        }
        Assert.assertEquals((Object)PUBLIC_KEY, (Object)this.realm.toRepresentation().getPublicKey());
        rep.setPrivateKey(privateKey2048);
        rep.setPublicKey(publicKey2048);
        this.realm.update(rep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, (Matcher<String>)Matchers.nullValue(String.class), (Object)rep, ResourceType.REALM);
        Assert.assertEquals((Object)publicKey2048, (Object)this.realm.toRepresentation().getPublicKey());
        String privateKey4096 = StreamUtil.readString((InputStream)this.getClass().getResourceAsStream("/keys/private4096.pem"));
        String publicKey4096 = StreamUtil.readString((InputStream)this.getClass().getResourceAsStream("/keys/public4096.pem"));
        rep.setPrivateKey(privateKey4096);
        rep.setPublicKey(publicKey4096);
        this.realm.update(rep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, (Matcher<String>)Matchers.nullValue(String.class), (Object)rep, ResourceType.REALM);
        Assert.assertEquals((Object)publicKey4096, (Object)this.realm.toRepresentation().getPublicKey());
    }

    @Test
    public void uploadCertificate() throws IOException {
        RealmRepresentation rep = new RealmRepresentation();
        rep.setCertificate(CERTIFICATE);
        this.realm.update(rep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, (Matcher<String>)Matchers.nullValue(String.class), (Object)rep, ResourceType.REALM);
        org.junit.Assert.assertEquals((Object)CERTIFICATE, (Object)rep.getCertificate());
        String certificate = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/keys/certificate.pem"));
        rep.setCertificate(certificate);
        this.realm.update(rep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, (Matcher<String>)Matchers.nullValue(String.class), (Object)rep, ResourceType.REALM);
        org.junit.Assert.assertEquals((Object)certificate, (Object)this.realm.toRepresentation().getCertificate());
        rep.setCertificate("{}{}{}{}{}{}324re9gvj0r");
        try {
            this.realm.update(rep);
            org.junit.Assert.fail((String)"Expected BadRequestException");
        }
        catch (BadRequestException e) {
            this.assertAdminEvents.assertEmpty();
        }
        rep.setCertificate("invalid");
        try {
            this.realm.update(rep);
            org.junit.Assert.fail((String)"Expected BadRequestException");
        }
        catch (BadRequestException e) {
            this.assertAdminEvents.assertEmpty();
        }
        org.junit.Assert.assertEquals((Object)certificate, (Object)this.realm.toRepresentation().getCertificate());
    }

    @Test
    public void clearRealmCache() {
        RealmRepresentation realmRep = this.realm.toRepresentation();
        org.junit.Assert.assertTrue((boolean)this.testingClient.testing().isCached("realms", realmRep.getId()));
        this.realm.clearRealmCache();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.ACTION, "clear-realm-cache", ResourceType.REALM);
        org.junit.Assert.assertFalse((boolean)this.testingClient.testing().isCached("realms", realmRep.getId()));
    }

    @Test
    public void clearUserCache() {
        UserRepresentation user = new UserRepresentation();
        user.setUsername("clearcacheuser");
        Response response = this.realm.users().create(user);
        String userId = ApiUtil.getCreatedId(response);
        response.close();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.userResourcePath(userId), (Object)user, ResourceType.USER);
        this.realm.users().get(userId).toRepresentation();
        org.junit.Assert.assertTrue((boolean)this.testingClient.testing().isCached("users", userId));
        this.realm.clearUserCache();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.ACTION, "clear-user-cache", ResourceType.REALM);
        org.junit.Assert.assertFalse((boolean)this.testingClient.testing().isCached("users", userId));
    }

    @Test
    public void pushNotBefore() {
        this.setupTestAppAndUser();
        int time = Time.currentTime() - 60;
        RealmRepresentation rep = this.realm.toRepresentation();
        rep.setNotBefore(Integer.valueOf(time));
        this.realm.update(rep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, (Matcher<String>)Matchers.nullValue(String.class), (Object)rep, ResourceType.REALM);
        GlobalRequestResult globalRequestResult = this.realm.pushRevocation();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.ACTION, "push-revocation", (Object)globalRequestResult, ResourceType.REALM);
        org.junit.Assert.assertEquals((long)1L, (long)globalRequestResult.getSuccessRequests().size());
        org.junit.Assert.assertEquals((Object)"http://localhost:8180/auth/realms/master/app/admin", globalRequestResult.getSuccessRequests().get(0));
        org.junit.Assert.assertNull((Object)globalRequestResult.getFailedRequests());
        PushNotBeforeAction adminPushNotBefore = this.testingClient.testApp().getAdminPushNotBefore();
        org.junit.Assert.assertEquals((long)time, (long)adminPushNotBefore.getNotBefore());
    }

    @Test
    public void logoutAll() {
        this.setupTestAppAndUser();
        Response response = this.realm.users().create(UserBuilder.create().username("user").build());
        String userId = ApiUtil.getCreatedId(response);
        response.close();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.userResourcePath(userId), ResourceType.USER);
        this.realm.users().get(userId).resetPassword(CredentialBuilder.create().password("password").build());
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.ACTION, AdminEventPaths.userResetPasswordPath(userId), ResourceType.USER);
        this.oauth.doLogin("user", "password");
        GlobalRequestResult globalRequestResult = this.realm.logoutAll();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.ACTION, "logout-all", (Object)globalRequestResult, ResourceType.REALM);
        org.junit.Assert.assertEquals((long)1L, (long)globalRequestResult.getSuccessRequests().size());
        org.junit.Assert.assertEquals((Object)"http://localhost:8180/auth/realms/master/app/admin", globalRequestResult.getSuccessRequests().get(0));
        org.junit.Assert.assertNull((Object)globalRequestResult.getFailedRequests());
        org.junit.Assert.assertNotNull((Object)this.testingClient.testApp().getAdminLogoutAction());
    }

    @Test
    public void deleteSession() {
        this.setupTestAppAndUser();
        this.oauth.doLogin("testuser", "password");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest((String)this.oauth.getCurrentQuery().get("code"), "secret");
        org.junit.Assert.assertEquals((long)200L, (long)tokenResponse.getStatusCode());
        EventRepresentation event = this.events.poll();
        org.junit.Assert.assertNotNull((Object)event);
        this.realm.deleteSession(event.getSessionId());
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.DELETE, AdminEventPaths.deleteSessionPath(event.getSessionId()), ResourceType.USER_SESSION);
        try {
            this.realm.deleteSession(event.getSessionId());
            org.junit.Assert.fail((String)"Expected 404");
        }
        catch (NotFoundException e) {
            this.assertAdminEvents.assertEmpty();
        }
        tokenResponse = this.oauth.doRefreshTokenRequest(tokenResponse.getRefreshToken(), "secret");
        org.junit.Assert.assertEquals((long)400L, (long)tokenResponse.getStatusCode());
        org.junit.Assert.assertEquals((Object)"Session not active", (Object)tokenResponse.getErrorDescription());
    }

    @Test
    public void clientSessionStats() {
        this.setupTestAppAndUser();
        List sessionStats = this.realm.getClientSessionStats();
        org.junit.Assert.assertTrue((boolean)sessionStats.isEmpty());
        System.out.println(sessionStats.size());
        this.oauth.doLogin("testuser", "password");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest((String)this.oauth.getCurrentQuery().get("code"), "secret");
        org.junit.Assert.assertEquals((long)200L, (long)tokenResponse.getStatusCode());
        sessionStats = this.realm.getClientSessionStats();
        org.junit.Assert.assertEquals((long)1L, (long)sessionStats.size());
        org.junit.Assert.assertEquals((Object)"test-app", ((Map)sessionStats.get(0)).get("clientId"));
        org.junit.Assert.assertEquals((Object)"1", ((Map)sessionStats.get(0)).get("active"));
    }

    private void setupTestAppAndUser() {
        this.testingClient.testApp().clearAdminActions();
        String redirectUri = this.oauth.getRedirectUri().replace("/master/", "/admin-client-test/");
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId("test-app");
        client.setAdminUrl(this.suiteContext.getAuthServerInfo().getContextRoot() + "/auth/realms/master/app/admin");
        client.setRedirectUris(Collections.singletonList(redirectUri));
        client.setSecret("secret");
        Response resp = this.realm.clients().create(client);
        String clientDbId = ApiUtil.getCreatedId(resp);
        resp.close();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.clientResourcePath(clientDbId), (Object)client, ResourceType.CLIENT);
        this.oauth.realm("admin-client-test");
        this.oauth.redirectUri(redirectUri);
        UserRepresentation userRep = UserBuilder.create().username("testuser").build();
        Response response = this.realm.users().create(userRep);
        String userId = ApiUtil.getCreatedId(response);
        response.close();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.userResourcePath(userId), (Object)userRep, ResourceType.USER);
        this.realm.users().get(userId).resetPassword(CredentialBuilder.create().password("password").build());
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.ACTION, AdminEventPaths.userResetPasswordPath(userId), ResourceType.USER);
        this.testingClient.testApp().clearAdminActions();
    }
}

