/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import com.google.common.base.Function;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.pages.AccountPasswordPage;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.UpdateAccountInformationPage;
import org.keycloak.testsuite.util.RealmBuilder;
import org.openqa.selenium.By;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;

public abstract class AbstractBrokerTest
extends AbstractKeycloakTest {
    @Page
    protected LoginPage accountLoginPage;
    @Page
    protected UpdateAccountInformationPage updateAccountInformationPage;
    @Page
    protected AccountPasswordPage accountPasswordPage;
    @Page
    protected ErrorPage errorPage;

    protected abstract RealmRepresentation createProviderRealm();

    protected abstract RealmRepresentation createConsumerRealm();

    protected abstract List<ClientRepresentation> createProviderClients();

    protected abstract List<ClientRepresentation> createConsumerClients();

    protected abstract IdentityProviderRepresentation setUpIdentityProvider();

    protected abstract String providerRealmName();

    protected abstract String consumerRealmName();

    protected abstract String getUserLogin();

    protected abstract String getUserPassword();

    protected abstract String getUserEmail();

    protected abstract String getIDPAlias();

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation providerRealm = this.createProviderRealm();
        RealmRepresentation consumerRealm = this.createConsumerRealm();
        testRealms.add(providerRealm);
        testRealms.add(consumerRealm);
    }

    @Before
    public void createUser() {
        this.log.debug((Object)("creating user for realm " + this.providerRealmName()));
        UserRepresentation user = new UserRepresentation();
        user.setUsername(this.getUserLogin());
        user.setEmail(this.getUserEmail());
        user.setEmailVerified(Boolean.valueOf(true));
        user.setEnabled(Boolean.valueOf(true));
        RealmResource realmResource = this.adminClient.realm(this.providerRealmName());
        String userId = ApiUtil.createUserWithAdminClient(realmResource, user);
        ApiUtil.resetUserPassword(realmResource.users().get(userId), this.getUserPassword(), false);
    }

    @Before
    public void addIdentityProviderToProviderRealm() {
        this.log.debug((Object)("adding identity provider to realm " + this.consumerRealmName()));
        RealmResource realm = this.adminClient.realm(this.consumerRealmName());
        realm.identityProviders().create(this.setUpIdentityProvider());
    }

    @Before
    public void addClients() {
        List<ClientRepresentation> clients = this.createProviderClients();
        if (clients != null) {
            RealmResource providerRealm = this.adminClient.realm(this.providerRealmName());
            for (ClientRepresentation client : clients) {
                this.log.debug((Object)("adding client " + client.getName() + " to realm " + this.providerRealmName()));
                providerRealm.clients().create(client);
            }
        }
        if ((clients = this.createConsumerClients()) != null) {
            RealmResource consumerRealm = this.adminClient.realm(this.consumerRealmName());
            for (ClientRepresentation client : clients) {
                this.log.debug((Object)("adding client " + client.getName() + " to realm " + this.consumerRealmName()));
                consumerRealm.clients().create(client);
            }
        }
    }

    protected String getAuthRoot() {
        return this.suiteContext.getAuthServerInfo().getContextRoot().toString();
    }

    protected IdentityProviderRepresentation createIdentityProvider(String alias, String providerId) {
        IdentityProviderRepresentation identityProviderRepresentation = new IdentityProviderRepresentation();
        identityProviderRepresentation.setAlias(alias);
        identityProviderRepresentation.setProviderId(providerId);
        identityProviderRepresentation.setEnabled(true);
        return identityProviderRepresentation;
    }

    @Test
    public void logInAsUserInIDP() {
        this.driver.navigate().to(this.getAccountUrl(this.consumerRealmName()));
        this.log.debug((Object)("Clicking social " + this.getIDPAlias()));
        this.accountLoginPage.clickSocial(this.getIDPAlias());
        this.waitForPage("log in to");
        Assert.assertTrue((String)"Driver should be on the provider realm page right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.providerRealmName() + "/"));
        this.log.debug((Object)"Logging in");
        this.accountLoginPage.login(this.getUserLogin(), this.getUserPassword());
        this.waitForPage("update account information");
        Assert.assertTrue((boolean)this.updateAccountInformationPage.isCurrent());
        Assert.assertTrue((String)"We must be on correct realm right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.consumerRealmName() + "/"));
        this.log.debug((Object)"Updating info on updateAccount page");
        this.updateAccountInformationPage.updateAccountInformation("Firstname", "Lastname");
        UsersResource consumerUsers = this.adminClient.realm(this.consumerRealmName()).users();
        int userCount = consumerUsers.count();
        Assert.assertTrue((String)"There must be at least one user", (userCount > 0 ? 1 : 0) != 0);
        List users = consumerUsers.search("", Integer.valueOf(0), Integer.valueOf(userCount));
        boolean isUserFound = false;
        for (UserRepresentation user : users) {
            if (!user.getUsername().equals(this.getUserLogin()) || !user.getEmail().equals(this.getUserEmail())) continue;
            isUserFound = true;
            break;
        }
        Assert.assertTrue((String)("There must be user " + this.getUserLogin() + " in realm " + this.consumerRealmName()), (boolean)isUserFound);
        this.testSingleLogout();
    }

    @Test
    public void loginWithExistingUser() {
        this.logInAsUserInIDP();
        Integer userCount = this.adminClient.realm(this.consumerRealmName()).users().count();
        this.driver.navigate().to(this.getAccountUrl(this.consumerRealmName()));
        this.log.debug((Object)("Clicking social " + this.getIDPAlias()));
        this.accountLoginPage.clickSocial(this.getIDPAlias());
        this.waitForPage("log in to");
        Assert.assertTrue((String)"Driver should be on the provider realm page right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.providerRealmName() + "/"));
        this.accountLoginPage.login(this.getUserLogin(), this.getUserPassword());
        org.junit.Assert.assertEquals((Object)(this.accountPage.buildUri().toASCIIString().replace("master", "consumer") + "/"), (Object)this.driver.getCurrentUrl());
        org.junit.Assert.assertEquals((Object)userCount, (Object)this.adminClient.realm(this.consumerRealmName()).users().count());
    }

    @Test
    public void loginWithExistingUserWithBruteForceEnabled() {
        this.adminClient.realm(this.consumerRealmName()).update(RealmBuilder.create().bruteForceProtected(true).failureFactor(2).build());
        this.loginWithExistingUser();
        this.driver.navigate().to(this.getAccountPasswordUrl(this.consumerRealmName()));
        this.accountPasswordPage.changePassword("password", "password");
        this.driver.navigate().to(this.getAuthRoot() + "/auth/realms/" + this.providerRealmName() + "/protocol/" + "openid-connect" + "/logout?redirect_uri=" + this.encodeUrl(this.getAccountUrl(this.providerRealmName())));
        this.driver.navigate().to(this.getAccountUrl(this.consumerRealmName()));
        try {
            this.waitForPage("log in to");
        }
        catch (TimeoutException e) {
            this.log.debug((Object)this.driver.getTitle());
            this.log.debug((Object)this.driver.getPageSource());
            Assert.fail((String)"Timeout while waiting for login page");
        }
        for (int i = 0; i < 3; ++i) {
            try {
                this.waitForElementEnabled("login");
            }
            catch (TimeoutException e) {
                Assert.fail((String)"Timeout while waiting for login element enabled");
            }
            this.accountLoginPage.login(this.getUserLogin(), "invalid");
        }
        org.junit.Assert.assertEquals((Object)"Invalid username or password.", (Object)this.accountLoginPage.getError());
        this.accountLoginPage.clickSocial(this.getIDPAlias());
        try {
            this.waitForPage("log in to");
        }
        catch (TimeoutException e) {
            this.log.debug((Object)this.driver.getTitle());
            this.log.debug((Object)this.driver.getPageSource());
            Assert.fail((String)"Timeout while waiting for login page");
        }
        Assert.assertTrue((String)"Driver should be on the provider realm page right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.providerRealmName() + "/"));
        this.accountLoginPage.login(this.getUserLogin(), this.getUserPassword());
        org.junit.Assert.assertEquals((Object)"Account is disabled, contact admin.", (Object)this.errorPage.getError());
    }

    private void testSingleLogout() {
        this.log.debug((Object)"Testing single log out");
        this.driver.navigate().to(this.getAccountUrl(this.providerRealmName()));
        Assert.assertTrue((String)"Should be logged in the account page", (boolean)this.driver.getTitle().endsWith("Account Management"));
        this.driver.navigate().to(this.getAuthRoot() + "/auth/realms/" + this.providerRealmName() + "/protocol/" + "openid-connect" + "/logout?redirect_uri=" + this.encodeUrl(this.getAccountUrl(this.providerRealmName())));
        this.waitForPage("log in to " + this.providerRealmName());
        Assert.assertTrue((String)("Should be on " + this.providerRealmName() + " realm"), (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.providerRealmName()));
        this.driver.navigate().to(this.getAccountUrl(this.consumerRealmName()));
        Assert.assertTrue((String)("Should be on " + this.consumerRealmName() + " realm on login page"), (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.consumerRealmName() + "/protocol/openid-connect/"));
    }

    private String getAccountUrl(String realmName) {
        return this.getAuthRoot() + "/auth/realms/" + realmName + "/account";
    }

    private String getAccountPasswordUrl(String realmName) {
        return this.getAuthRoot() + "/auth/realms/" + realmName + "/account/password";
    }

    private void waitForPage(final String title) {
        WebDriverWait wait = new WebDriverWait(this.driver, 5L);
        ExpectedCondition<Boolean> condition = new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver input) {
                return input.getTitle().toLowerCase().contains(title);
            }
        };
        wait.until((Function)condition);
    }

    private void waitForElementEnabled(final String elementName) {
        WebDriverWait wait = new WebDriverWait(this.driver, 5L);
        ExpectedCondition<Boolean> condition = new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver input) {
                List elements = input.findElements(By.name((String)elementName));
                if (elements.size() == 0) {
                    return false;
                }
                return ((WebElement)elements.get(0)).isEnabled();
            }
        };
        wait.until((Function)condition);
    }

    private String encodeUrl(String url) {
        String result;
        try {
            result = URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            result = url;
        }
        return result;
    }
}

