/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.broker.AbstractBrokerTest;

public class KcOidcBrokerTest
extends AbstractBrokerTest {
    @Override
    protected RealmRepresentation createProviderRealm() {
        RealmRepresentation realm = new RealmRepresentation();
        realm.setRealm("provider");
        realm.setEnabled(Boolean.valueOf(true));
        return realm;
    }

    @Override
    protected RealmRepresentation createConsumerRealm() {
        RealmRepresentation realm = new RealmRepresentation();
        realm.setRealm("consumer");
        realm.setEnabled(Boolean.valueOf(true));
        return realm;
    }

    @Override
    protected List<ClientRepresentation> createProviderClients() {
        ClientRepresentation client = new ClientRepresentation();
        client.setId("brokerapp");
        client.setName("brokerapp");
        client.setSecret("secret");
        client.setEnabled(Boolean.valueOf(true));
        client.setRedirectUris(Collections.singletonList(this.getAuthRoot() + "/auth/realms/" + "consumer" + "/broker/" + "kc-oidc-idp" + "/endpoint/*"));
        client.setAdminUrl(this.getAuthRoot() + "/auth/realms/" + "consumer" + "/broker/" + "kc-oidc-idp" + "/endpoint");
        return Collections.singletonList(client);
    }

    @Override
    protected List<ClientRepresentation> createConsumerClients() {
        return null;
    }

    @Override
    protected IdentityProviderRepresentation setUpIdentityProvider() {
        IdentityProviderRepresentation idp = this.createIdentityProvider("kc-oidc-idp", "keycloak-oidc");
        Map config = idp.getConfig();
        config.put("clientId", "brokerapp");
        config.put("clientSecret", "secret");
        config.put("prompt", "login");
        config.put("authorizationUrl", this.getAuthRoot() + "/auth/realms/" + "provider" + "/protocol/openid-connect/auth");
        config.put("tokenUrl", this.getAuthRoot() + "/auth/realms/" + "provider" + "/protocol/openid-connect/token");
        config.put("logoutUrl", this.getAuthRoot() + "/auth/realms/" + "provider" + "/protocol/openid-connect/logout");
        config.put("userInfoUrl", this.getAuthRoot() + "/auth/realms/" + "provider" + "/protocol/openid-connect/userinfo");
        config.put("defaultScope", "email profile");
        config.put("backchannelSupported", "true");
        return idp;
    }

    @Override
    protected String getUserLogin() {
        return "testuser";
    }

    @Override
    protected String getUserPassword() {
        return "password";
    }

    @Override
    protected String getUserEmail() {
        return "user@localhost.com";
    }

    @Override
    protected String providerRealmName() {
        return "provider";
    }

    @Override
    protected String consumerRealmName() {
        return "consumer";
    }

    @Override
    protected String getIDPAlias() {
        return "kc-oidc-idp";
    }
}

