/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Ignore;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.broker.AbstractBrokerTest;

@Ignore
public class KcSamlBrokerTest
extends AbstractBrokerTest {
    @Override
    protected RealmRepresentation createProviderRealm() {
        RealmRepresentation realm = new RealmRepresentation();
        realm.setEnabled(Boolean.valueOf(true));
        realm.setRealm("provider");
        return realm;
    }

    @Override
    protected RealmRepresentation createConsumerRealm() {
        RealmRepresentation realm = new RealmRepresentation();
        realm.setEnabled(Boolean.valueOf(true));
        realm.setRealm("consumer");
        return realm;
    }

    @Override
    protected List<ClientRepresentation> createProviderClients() {
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId(this.getAuthRoot() + "/auth/realms/" + "consumer");
        client.setEnabled(Boolean.valueOf(true));
        client.setProtocol("saml");
        client.setRedirectUris(Collections.singletonList(this.getAuthRoot() + "/auth/realms/" + "consumer" + "/broker/" + "kc-saml-idp" + "/endpoint"));
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("saml.authnstatement", "true");
        attributes.put("saml_single_logout_service_url_post", this.getAuthRoot() + "/auth/realms/" + "consumer" + "/broker/" + "kc-saml-idp" + "/endpoint");
        attributes.put("saml_assertion_consumer_url_post", this.getAuthRoot() + "/auth/realms/" + "consumer" + "/broker/" + "kc-saml-idp" + "/endpoint");
        attributes.put("saml_force_name_id_format", "true");
        attributes.put("saml_name_id_format", "username");
        attributes.put("saml.assertion.signature", "false");
        attributes.put("saml.server.signature", "false");
        attributes.put("saml.client.signature", "false");
        attributes.put("saml.encrypt", "false");
        client.setAttributes(attributes);
        ProtocolMapperRepresentation mapper = new ProtocolMapperRepresentation();
        mapper.setName("email");
        mapper.setProtocol("saml");
        mapper.setProtocolMapper("saml-user-property-mapper");
        mapper.setConsentRequired(false);
        Map mapperConfig = mapper.getConfig();
        mapperConfig.put("user.attribute", "email");
        mapperConfig.put("attribute.name", "urn:oid:1.2.840.113549.1.9.1");
        mapperConfig.put("attribute.nameformat", "urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
        mapperConfig.put("friendly.name", "email");
        client.setProtocolMappers(Collections.singletonList(mapper));
        return Collections.singletonList(client);
    }

    @Override
    protected List<ClientRepresentation> createConsumerClients() {
        return null;
    }

    @Override
    protected IdentityProviderRepresentation setUpIdentityProvider() {
        IdentityProviderRepresentation idp = this.createIdentityProvider("kc-saml-idp", "saml");
        idp.setTrustEmail(true);
        idp.setAddReadTokenRoleOnCreate(true);
        idp.setStoreToken(true);
        Map config = idp.getConfig();
        config.put("singleSignOnServiceUrl", this.getAuthRoot() + "/auth/realms/" + "provider" + "/protocol/saml");
        config.put("singleLogoutServiceUrl", this.getAuthRoot() + "/auth/realms/" + "provider" + "/protocol/saml");
        config.put("nameIDPolicyFormat", "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
        config.put("forceAuthn", "true");
        config.put("postBindingResponse", "true");
        config.put("postBindingAuthnRequest", "true");
        config.put("validateSignature", "false");
        config.put("wantAuthnRequestsSigned", "false");
        config.put("backchannelSupported", "true");
        return idp;
    }

    @Override
    protected String providerRealmName() {
        return "provider";
    }

    @Override
    protected String consumerRealmName() {
        return "consumer";
    }

    @Override
    protected String getUserLogin() {
        return "testuser";
    }

    @Override
    protected String getUserPassword() {
        return "password";
    }

    @Override
    protected String getUserEmail() {
        return "user@localhost.com";
    }

    @Override
    protected String getIDPAlias() {
        return "kc-saml-idp";
    }
}

