/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.client;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.NotFoundException;
import org.junit.After;
import org.junit.Before;
import org.keycloak.client.registration.Auth;
import org.keycloak.client.registration.ClientRegistration;
import org.keycloak.client.registration.ClientRegistrationException;
import org.keycloak.models.AdminRoles;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;

public abstract class AbstractClientRegistrationTest
extends AbstractKeycloakTest {
    static final String REALM_NAME = "test";
    ClientRegistration reg;

    @Before
    public void before() throws Exception {
        this.reg = ClientRegistration.create().url(this.suiteContext.getAuthServerInfo().getContextRoot() + "/auth", REALM_NAME).build();
    }

    @After
    public void after() throws Exception {
        this.reg.close();
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation rep = new RealmRepresentation();
        rep.setEnabled(Boolean.valueOf(true));
        rep.setRealm(REALM_NAME);
        rep.setUsers(new LinkedList());
        LinkedList<CredentialRepresentation> credentials = new LinkedList<CredentialRepresentation>();
        CredentialRepresentation password = new CredentialRepresentation();
        password.setType("password");
        password.setValue("password");
        credentials.add(password);
        UserRepresentation user = new UserRepresentation();
        user.setEnabled(Boolean.valueOf(true));
        user.setUsername("manage-clients");
        user.setCredentials(credentials);
        user.setClientRoles(Collections.singletonMap("realm-management", Collections.singletonList(AdminRoles.MANAGE_CLIENTS)));
        rep.getUsers().add(user);
        UserRepresentation user2 = new UserRepresentation();
        user2.setEnabled(Boolean.valueOf(true));
        user2.setUsername("create-clients");
        user2.setCredentials(credentials);
        user2.setClientRoles(Collections.singletonMap("realm-management", Collections.singletonList(AdminRoles.CREATE_CLIENT)));
        rep.getUsers().add(user2);
        UserRepresentation user3 = new UserRepresentation();
        user3.setEnabled(Boolean.valueOf(true));
        user3.setUsername("no-access");
        user3.setCredentials(credentials);
        rep.getUsers().add(user3);
        testRealms.add(rep);
    }

    public ClientRepresentation createClient(ClientRepresentation client) throws ClientRegistrationException {
        this.authManageClients();
        ClientRepresentation response = this.reg.create(client);
        this.reg.auth(null);
        return response;
    }

    public ClientRepresentation getClient(String clientId) {
        try {
            return this.adminClient.realm(REALM_NAME).clients().get(clientId).toRepresentation();
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    void authCreateClients() {
        this.reg.auth(Auth.token((String)this.getToken("create-clients", "password")));
    }

    void authManageClients() {
        this.reg.auth(Auth.token((String)this.getToken("manage-clients", "password")));
    }

    void authNoAccess() {
        this.reg.auth(Auth.token((String)this.getToken("no-access", "password")));
    }

    private String getToken(String username, String password) {
        try {
            return this.oauth.doGrantAccessTokenRequest(REALM_NAME, username, password, null, "admin-cli", null).getAccessToken();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

