/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.client;

import java.util.Collections;
import javax.ws.rs.NotFoundException;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.client.registration.Auth;
import org.keycloak.client.registration.ClientRegistration;
import org.keycloak.client.registration.ClientRegistrationException;
import org.keycloak.client.registration.HttpErrorException;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.testsuite.client.AbstractClientRegistrationTest;

public class ClientRegistrationTest
extends AbstractClientRegistrationTest {
    private static final String CLIENT_ID = "test-client";
    private static final String CLIENT_SECRET = "test-client-secret";

    private ClientRepresentation registerClient() throws ClientRegistrationException {
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId(CLIENT_ID);
        client.setSecret(CLIENT_SECRET);
        ClientRepresentation createdClient = this.reg.create(client);
        Assert.assertEquals((Object)CLIENT_ID, (Object)createdClient.getClientId());
        client = this.adminClient.realm("test").clients().get(createdClient.getId()).toRepresentation();
        Assert.assertEquals((Object)CLIENT_ID, (Object)client.getClientId());
        return client;
    }

    @Test
    public void registerClientAsAdmin() throws ClientRegistrationException {
        this.authManageClients();
        this.registerClient();
    }

    @Test
    public void registerClientInMasterRealm() throws Exception {
        ClientRegistration masterReg = ClientRegistration.create().url(this.suiteContext.getAuthServerInfo().getContextRoot() + "/auth", "master").build();
        String token = this.oauth.doGrantAccessTokenRequest("master", "admin", "admin", null, "admin-cli", null).getAccessToken();
        masterReg.auth(Auth.token((String)token));
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId(CLIENT_ID);
        client.setSecret(CLIENT_SECRET);
        ClientRepresentation createdClient = masterReg.create(client);
        Assert.assertNotNull((Object)createdClient);
        this.adminClient.realm("master").clients().get(createdClient.getId()).remove();
    }

    @Test
    public void registerClientAsAdminWithCreateOnly() throws ClientRegistrationException {
        this.authCreateClients();
        this.registerClient();
    }

    @Test
    public void registerClientAsAdminWithNoAccess() throws ClientRegistrationException {
        this.authNoAccess();
        try {
            this.registerClient();
            Assert.fail((String)"Expected 403");
        }
        catch (ClientRegistrationException e) {
            Assert.assertEquals((long)403L, (long)((HttpErrorException)e.getCause()).getStatusLine().getStatusCode());
        }
    }

    @Test
    public void getClientAsAdmin() throws ClientRegistrationException {
        this.registerClientAsAdmin();
        ClientRepresentation rep = this.reg.get(CLIENT_ID);
        Assert.assertNotNull((Object)rep);
    }

    @Test
    public void getClientAsAdminWithCreateOnly() throws ClientRegistrationException {
        this.registerClientAsAdmin();
        this.authCreateClients();
        try {
            this.reg.get(CLIENT_ID);
            Assert.fail((String)"Expected 403");
        }
        catch (ClientRegistrationException e) {
            Assert.assertEquals((long)403L, (long)((HttpErrorException)e.getCause()).getStatusLine().getStatusCode());
        }
    }

    @Test
    public void getClientAsAdminWithNoAccess() throws ClientRegistrationException {
        this.registerClientAsAdmin();
        this.authNoAccess();
        try {
            this.reg.get(CLIENT_ID);
            Assert.fail((String)"Expected 403");
        }
        catch (ClientRegistrationException e) {
            Assert.assertEquals((long)403L, (long)((HttpErrorException)e.getCause()).getStatusLine().getStatusCode());
        }
    }

    @Test
    public void getClientNotFound() throws ClientRegistrationException {
        this.authManageClients();
        Assert.assertNull((Object)this.reg.get("invalid"));
    }

    @Test
    public void getClientNotFoundNoAccess() throws ClientRegistrationException {
        this.authNoAccess();
        try {
            this.reg.get("invalid");
            Assert.fail((String)"Expected 403");
        }
        catch (ClientRegistrationException e) {
            Assert.assertEquals((long)403L, (long)((HttpErrorException)e.getCause()).getStatusLine().getStatusCode());
        }
    }

    private void updateClient() throws ClientRegistrationException {
        ClientRepresentation client = this.reg.get(CLIENT_ID);
        client.setRedirectUris(Collections.singletonList("http://localhost:8080/app"));
        this.reg.update(client);
        ClientRepresentation updatedClient = this.reg.get(CLIENT_ID);
        Assert.assertEquals((long)1L, (long)updatedClient.getRedirectUris().size());
        Assert.assertEquals((Object)"http://localhost:8080/app", updatedClient.getRedirectUris().get(0));
    }

    @Test
    public void updateClientAsAdmin() throws ClientRegistrationException {
        this.registerClientAsAdmin();
        this.authManageClients();
        this.updateClient();
    }

    @Test
    public void updateClientAsAdminWithCreateOnly() throws ClientRegistrationException {
        this.authCreateClients();
        try {
            this.updateClient();
            Assert.fail((String)"Expected 403");
        }
        catch (ClientRegistrationException e) {
            Assert.assertEquals((long)403L, (long)((HttpErrorException)e.getCause()).getStatusLine().getStatusCode());
        }
    }

    @Test
    public void updateClientAsAdminWithNoAccess() throws ClientRegistrationException {
        this.authNoAccess();
        try {
            this.updateClient();
            Assert.fail((String)"Expected 403");
        }
        catch (ClientRegistrationException e) {
            Assert.assertEquals((long)403L, (long)((HttpErrorException)e.getCause()).getStatusLine().getStatusCode());
        }
    }

    @Test
    public void updateClientNotFound() throws ClientRegistrationException {
        this.authManageClients();
        try {
            ClientRepresentation client = new ClientRepresentation();
            client.setClientId("invalid");
            this.reg.update(client);
            Assert.fail((String)"Expected 404");
        }
        catch (ClientRegistrationException e) {
            Assert.assertEquals((long)404L, (long)((HttpErrorException)e.getCause()).getStatusLine().getStatusCode());
        }
    }

    private void deleteClient(ClientRepresentation client) throws ClientRegistrationException {
        this.reg.delete(CLIENT_ID);
        try {
            this.adminClient.realm("test").clients().get(client.getId()).toRepresentation();
            Assert.fail((String)"Expected 403");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void deleteClientAsAdmin() throws ClientRegistrationException {
        this.authCreateClients();
        ClientRepresentation client = this.registerClient();
        this.authManageClients();
        this.deleteClient(client);
    }

    @Test
    public void deleteClientAsAdminWithCreateOnly() throws ClientRegistrationException {
        this.authManageClients();
        ClientRepresentation client = this.registerClient();
        try {
            this.authCreateClients();
            this.deleteClient(client);
            Assert.fail((String)"Expected 403");
        }
        catch (ClientRegistrationException e) {
            Assert.assertEquals((long)403L, (long)((HttpErrorException)e.getCause()).getStatusLine().getStatusCode());
        }
    }

    @Test
    public void deleteClientAsAdminWithNoAccess() throws ClientRegistrationException {
        this.authManageClients();
        ClientRepresentation client = this.registerClient();
        try {
            this.authNoAccess();
            this.deleteClient(client);
            Assert.fail((String)"Expected 403");
        }
        catch (ClientRegistrationException e) {
            Assert.assertEquals((long)403L, (long)((HttpErrorException)e.getCause()).getStatusLine().getStatusCode());
        }
    }
}

