/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.client;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientInitialAccessResource;
import org.keycloak.client.registration.Auth;
import org.keycloak.client.registration.ClientRegistrationException;
import org.keycloak.client.registration.HttpErrorException;
import org.keycloak.representations.idm.ClientInitialAccessCreatePresentation;
import org.keycloak.representations.idm.ClientInitialAccessPresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.testsuite.client.AbstractClientRegistrationTest;

public class InitialAccessTokenTest
extends AbstractClientRegistrationTest {
    private ClientInitialAccessResource resource;

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.resource = this.adminClient.realm("test").clientInitialAccess();
    }

    @Test
    public void create() throws ClientRegistrationException, InterruptedException {
        ClientInitialAccessPresentation response = this.resource.create(new ClientInitialAccessCreatePresentation());
        this.reg.auth(Auth.token((ClientInitialAccessPresentation)response));
        ClientRepresentation rep = new ClientRepresentation();
        this.setTimeOffset(10);
        ClientRepresentation created = this.reg.create(rep);
        Assert.assertNotNull((Object)created);
        try {
            this.reg.create(rep);
        }
        catch (ClientRegistrationException e) {
            Assert.assertEquals((long)401L, (long)((HttpErrorException)e.getCause()).getStatusLine().getStatusCode());
        }
    }

    @Test
    public void createMultiple() throws ClientRegistrationException {
        ClientInitialAccessPresentation response = this.resource.create(new ClientInitialAccessCreatePresentation(Integer.valueOf(0), Integer.valueOf(2)));
        this.reg.auth(Auth.token((ClientInitialAccessPresentation)response));
        ClientRepresentation rep = new ClientRepresentation();
        ClientRepresentation created = this.reg.create(rep);
        Assert.assertNotNull((Object)created);
        created = this.reg.create(rep);
        Assert.assertNotNull((Object)created);
        try {
            this.reg.create(rep);
        }
        catch (ClientRegistrationException e) {
            Assert.assertEquals((long)401L, (long)((HttpErrorException)e.getCause()).getStatusLine().getStatusCode());
        }
    }

    @Test
    public void createExpired() throws ClientRegistrationException, InterruptedException {
        ClientInitialAccessPresentation response = this.resource.create(new ClientInitialAccessCreatePresentation(Integer.valueOf(1), Integer.valueOf(1)));
        this.reg.auth(Auth.token((ClientInitialAccessPresentation)response));
        ClientRepresentation rep = new ClientRepresentation();
        this.setTimeOffset(10);
        try {
            this.reg.create(rep);
        }
        catch (ClientRegistrationException e) {
            Assert.assertEquals((long)401L, (long)((HttpErrorException)e.getCause()).getStatusLine().getStatusCode());
        }
    }

    @Test
    public void createDeleted() throws ClientRegistrationException, InterruptedException {
        ClientInitialAccessPresentation response = this.resource.create(new ClientInitialAccessCreatePresentation());
        this.reg.auth(Auth.token((ClientInitialAccessPresentation)response));
        this.resource.delete(response.getId());
        ClientRepresentation rep = new ClientRepresentation();
        try {
            this.reg.create(rep);
        }
        catch (ClientRegistrationException e) {
            Assert.assertEquals((long)401L, (long)((HttpErrorException)e.getCause()).getStatusLine().getStatusCode());
        }
    }
}

