/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.client;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.client.registration.Auth;
import org.keycloak.client.registration.ClientRegistrationException;
import org.keycloak.common.util.CollectionUtil;
import org.keycloak.representations.idm.ClientInitialAccessCreatePresentation;
import org.keycloak.representations.idm.ClientInitialAccessPresentation;
import org.keycloak.representations.oidc.OIDCClientRepresentation;
import org.keycloak.testsuite.client.AbstractClientRegistrationTest;

public class OIDCClientRegistrationTest
extends AbstractClientRegistrationTest {
    @Override
    @Before
    public void before() throws Exception {
        super.before();
        ClientInitialAccessPresentation token = this.adminClient.realm("test").clientInitialAccess().create(new ClientInitialAccessCreatePresentation(Integer.valueOf(0), Integer.valueOf(10)));
        this.reg.auth(Auth.token((ClientInitialAccessPresentation)token));
    }

    public OIDCClientRepresentation create() throws ClientRegistrationException {
        OIDCClientRepresentation client = new OIDCClientRepresentation();
        client.setClientName("RegistrationAccessTokenTest");
        client.setClientUri("http://root");
        client.setRedirectUris(Collections.singletonList("http://redirect"));
        OIDCClientRepresentation response = this.reg.oidc().create(client);
        return response;
    }

    @Test
    public void createClient() throws ClientRegistrationException {
        OIDCClientRepresentation response = this.create();
        Assert.assertNotNull((Object)response.getRegistrationAccessToken());
        Assert.assertNotNull((Object)response.getClientIdIssuedAt());
        Assert.assertNotNull((Object)response.getClientId());
        Assert.assertNull((Object)response.getClientSecretExpiresAt());
        Assert.assertNotNull((Object)response.getRegistrationClientUri());
        Assert.assertEquals((Object)"RegistrationAccessTokenTest", (Object)response.getClientName());
        Assert.assertEquals((Object)"http://root", (Object)response.getClientUri());
        Assert.assertEquals((long)1L, (long)response.getRedirectUris().size());
        Assert.assertEquals((Object)"http://redirect", response.getRedirectUris().get(0));
        Assert.assertEquals(Arrays.asList("code", "none"), (Object)response.getResponseTypes());
        Assert.assertEquals(Arrays.asList("authorization_code", "refresh_token"), (Object)response.getGrantTypes());
    }

    @Test
    public void getClient() throws ClientRegistrationException {
        OIDCClientRepresentation response = this.create();
        this.reg.auth(Auth.token((OIDCClientRepresentation)response));
        OIDCClientRepresentation rep = this.reg.oidc().get(response.getClientId());
        Assert.assertNotNull((Object)rep);
        Assert.assertNotEquals((Object)response.getRegistrationAccessToken(), (Object)rep.getRegistrationAccessToken());
        Assert.assertTrue((boolean)CollectionUtil.collectionEquals(Arrays.asList("code", "none"), (Collection)response.getResponseTypes()));
        Assert.assertTrue((boolean)CollectionUtil.collectionEquals(Arrays.asList("authorization_code", "refresh_token"), (Collection)response.getGrantTypes()));
    }

    @Test
    public void updateClient() throws ClientRegistrationException {
        OIDCClientRepresentation response = this.create();
        this.reg.auth(Auth.token((OIDCClientRepresentation)response));
        response.setRedirectUris(Collections.singletonList("http://newredirect"));
        response.setResponseTypes(Arrays.asList("code", "id_token token", "code id_token token"));
        response.setGrantTypes(Arrays.asList("authorization_code", "refresh_token", "password"));
        OIDCClientRepresentation updated = this.reg.oidc().update(response);
        Assert.assertTrue((boolean)CollectionUtil.collectionEquals(Collections.singletonList("http://newredirect"), (Collection)updated.getRedirectUris()));
        Assert.assertTrue((boolean)CollectionUtil.collectionEquals(Arrays.asList("authorization_code", "implicit", "refresh_token", "password"), (Collection)updated.getGrantTypes()));
        Assert.assertTrue((boolean)CollectionUtil.collectionEquals(Arrays.asList("code", "none", "id_token", "id_token token", "code id_token", "code token", "code id_token token"), (Collection)updated.getResponseTypes()));
    }

    @Test
    public void updateClientError() throws ClientRegistrationException {
        try {
            OIDCClientRepresentation response = this.create();
            this.reg.auth(Auth.token((OIDCClientRepresentation)response));
            response.setResponseTypes(Arrays.asList("code", "tokenn"));
            this.reg.oidc().update(response);
            Assert.fail((String)"Not expected to end with success");
        }
        catch (ClientRegistrationException clientRegistrationException) {
            // empty catch block
        }
    }

    @Test
    public void deleteClient() throws ClientRegistrationException {
        OIDCClientRepresentation response = this.create();
        this.reg.auth(Auth.token((OIDCClientRepresentation)response));
        this.reg.oidc().delete(response);
    }
}

