/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.client;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.client.registration.Auth;
import org.keycloak.client.registration.ClientRegistrationException;
import org.keycloak.representations.idm.ClientInitialAccessCreatePresentation;
import org.keycloak.representations.idm.ClientInitialAccessPresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.testsuite.client.AbstractClientRegistrationTest;

public class SAMLClientRegistrationTest
extends AbstractClientRegistrationTest {
    @Override
    @Before
    public void before() throws Exception {
        super.before();
        ClientInitialAccessPresentation token = this.adminClient.realm("test").clientInitialAccess().create(new ClientInitialAccessCreatePresentation(Integer.valueOf(0), Integer.valueOf(10)));
        this.reg.auth(Auth.token((ClientInitialAccessPresentation)token));
    }

    @Test
    public void createClient() throws ClientRegistrationException, IOException {
        String entityDescriptor = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/clientreg-test/saml-entity-descriptor.xml"));
        ClientRepresentation response = this.reg.saml().create(entityDescriptor);
        Assert.assertNotNull((Object)response.getRegistrationAccessToken());
        Assert.assertEquals((Object)"loadbalancer-9.siroe.com", (Object)response.getClientId());
        Assert.assertEquals((long)1L, (long)response.getRedirectUris().size());
        Assert.assertEquals((Object)"https://LoadBalancer-9.siroe.com:3443/federation/Consumer/metaAlias/sp", response.getRedirectUris().get(0));
    }
}

