/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.cluster;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Assert;
import org.junit.Before;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.arquillian.ContainerInfo;
import org.keycloak.testsuite.util.WaitUtils;

public abstract class AbstractClusterTest
extends AbstractKeycloakTest {
    @ArquillianResource
    protected ContainerController controller;
    protected Map<ContainerInfo, Keycloak> backendAdminClients = new HashMap<ContainerInfo, Keycloak>();
    private int currentFailNodeIndex = 0;

    public int getClusterSize() {
        return this.suiteContext.getAuthServerBackendsInfo().size();
    }

    protected void iterateCurrentFailNode() {
        ++this.currentFailNodeIndex;
        if (this.currentFailNodeIndex >= this.getClusterSize()) {
            this.currentFailNodeIndex = 0;
        }
        this.logFailoverSetup();
    }

    protected ContainerInfo getCurrentFailNode() {
        return this.backendNode(this.currentFailNodeIndex);
    }

    protected Set<ContainerInfo> getCurrentSurvivorNodes() {
        HashSet<ContainerInfo> survivors = new HashSet<ContainerInfo>(this.suiteContext.getAuthServerBackendsInfo());
        survivors.remove(this.getCurrentFailNode());
        return survivors;
    }

    protected void logFailoverSetup() {
        this.log.info((Object)"Current failover setup");
        boolean started = this.controller.isStarted(this.getCurrentFailNode().getQualifier());
        this.log.info((Object)("Fail node: " + this.getCurrentFailNode() + (started ? "" : " (stopped)")));
        for (ContainerInfo survivor : this.getCurrentSurvivorNodes()) {
            started = this.controller.isStarted(survivor.getQualifier());
            this.log.info((Object)("Survivor:  " + survivor + (started ? "" : " (stopped)")));
        }
    }

    public void failure() {
        this.log.info((Object)"Simulating failure");
        this.killBackendNode(this.getCurrentFailNode());
    }

    public void failback() {
        this.log.info((Object)"Bringing all backend nodes online");
        for (ContainerInfo node : this.suiteContext.getAuthServerBackendsInfo()) {
            this.startBackendNode(node);
        }
    }

    protected ContainerInfo frontendNode() {
        return this.suiteContext.getAuthServerInfo();
    }

    protected ContainerInfo backendNode(int i) {
        return (ContainerInfo)this.suiteContext.getAuthServerBackendsInfo().get(i);
    }

    protected void startBackendNode(ContainerInfo node) {
        if (!this.controller.isStarted(node.getQualifier())) {
            this.log.info((Object)("Starting backend node: " + node));
            this.controller.start(node.getQualifier());
            Assert.assertTrue((boolean)this.controller.isStarted(node.getQualifier()));
        }
        this.log.info((Object)("Backend node " + node + " is started"));
        if (!this.backendAdminClients.containsKey(node)) {
            this.backendAdminClients.put(node, this.createAdminClientFor(node));
        }
    }

    protected Keycloak createAdminClientFor(ContainerInfo node) {
        this.log.info((Object)("Initializing admin client for " + node.getContextRoot() + "/auth"));
        return Keycloak.getInstance((String)(node.getContextRoot() + "/auth"), (String)"master", (String)"admin", (String)"admin", (String)"admin-cli");
    }

    protected void killBackendNode(ContainerInfo node) {
        this.backendAdminClients.get(node).close();
        this.backendAdminClients.remove(node);
        this.log.info((Object)("Killing backend node: " + node));
        this.controller.kill(node.getQualifier());
    }

    protected Keycloak getAdminClientFor(ContainerInfo node) {
        return node.equals((Object)this.suiteContext.getAuthServerInfo()) ? this.adminClient : this.backendAdminClients.get(node);
    }

    @Before
    public void beforeClusterTest() {
        this.failback();
        this.logFailoverSetup();
        WaitUtils.pause((long)3000L);
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
    }
}

