/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.cluster;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.arquillian.ContainerInfo;
import org.keycloak.testsuite.cluster.AbstractClusterTest;

public abstract class AbstractInvalidationClusterTest<T, TR>
extends AbstractClusterTest {
    protected List<String> excludedComparisonFields = new ArrayList<String>();

    protected RealmRepresentation createTestRealmRepresentation() {
        RealmRepresentation testRealm = new RealmRepresentation();
        testRealm.setRealm("test_" + RandomStringUtils.randomAlphabetic((int)5));
        testRealm.setEnabled(Boolean.valueOf(true));
        return testRealm;
    }

    protected abstract T createTestEntityRepresentation();

    @Test
    public void crudWithoutFailover() {
        this.crud(false);
    }

    @Test
    public void crudWithFailover() {
        this.crud(true);
    }

    public void crud(boolean backendFailover) {
        T testEntity = this.createTestEntityRepresentation();
        testEntity = this.createEntityOnCurrentFailNode(testEntity);
        if (backendFailover) {
            this.failure();
        }
        this.assertEntityOnSurvivorNodesEqualsTo(testEntity);
        this.failback();
        this.iterateCurrentFailNode();
        testEntity = this.testEntityUpdates(testEntity, backendFailover);
        this.deleteEntityOnCurrentFailNode(testEntity);
        if (backendFailover) {
            this.failure();
        }
        this.assertEntityOnSurvivorNodesIsDeleted(testEntity);
    }

    protected abstract TR entityResource(T var1, ContainerInfo var2);

    protected abstract TR entityResource(String var1, ContainerInfo var2);

    protected abstract T createEntity(T var1, ContainerInfo var2);

    protected abstract T readEntity(T var1, ContainerInfo var2);

    protected abstract T updateEntity(T var1, ContainerInfo var2);

    protected abstract void deleteEntity(T var1, ContainerInfo var2);

    protected TR entityResourceOnCurrentFailNode(T testEntity) {
        return this.entityResource(testEntity, this.getCurrentFailNode());
    }

    protected String getEntityType(T entity) {
        return entity.getClass().getSimpleName().replace("Representation", "");
    }

    protected T createEntityOnCurrentFailNode(T entity) {
        this.log.info((Object)("Creating " + this.getEntityType(entity) + " on " + this.getCurrentFailNode()));
        return this.createEntity(entity, this.getCurrentFailNode());
    }

    protected T readEntityOnCurrentFailNode(T entity) {
        this.log.debug((Object)("Reading " + this.getEntityType(entity) + " on " + this.getCurrentFailNode()));
        return this.readEntity(entity, this.getCurrentFailNode());
    }

    protected T updateEntityOnCurrentFailNode(T entity) {
        return this.updateEntityOnCurrentFailNode(entity, "");
    }

    protected T updateEntityOnCurrentFailNode(T entity, String updateType) {
        this.log.info((Object)("Updating " + this.getEntityType(entity) + " " + updateType + " on " + this.getCurrentFailNode()));
        return this.updateEntity(entity, this.getCurrentFailNode());
    }

    protected void deleteEntityOnCurrentFailNode(T entity) {
        this.log.info((Object)("Creating " + this.getEntityType(entity) + " on " + this.getCurrentFailNode()));
        this.deleteEntity(entity, this.getCurrentFailNode());
    }

    protected abstract T testEntityUpdates(T var1, boolean var2);

    protected void verifyEntityUpdateDuringFailover(T testEntity, boolean backendFailover) {
        if (backendFailover) {
            this.failure();
        }
        this.assertEntityOnSurvivorNodesEqualsTo(testEntity);
        this.failback();
        this.iterateCurrentFailNode();
    }

    protected void assertEntityOnSurvivorNodesEqualsTo(T testEntityOnFailNode) {
        boolean entityDiffers = false;
        for (ContainerInfo survivorNode : this.getCurrentSurvivorNodes()) {
            T testEntityOnSurvivorNode = this.readEntity(testEntityOnFailNode, survivorNode);
            if (EqualsBuilder.reflectionEquals(testEntityOnSurvivorNode, testEntityOnFailNode, this.excludedComparisonFields)) {
                this.log.info((Object)String.format("Verification of %s on survivor %s PASSED", this.getEntityType(testEntityOnFailNode), survivorNode));
                continue;
            }
            entityDiffers = true;
            this.log.error((Object)String.format("Verification of %s on survivor %s FAILED", this.getEntityType(testEntityOnFailNode), survivorNode));
            String tf = ReflectionToStringBuilder.reflectionToString(testEntityOnFailNode, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
            String ts = ReflectionToStringBuilder.reflectionToString(testEntityOnSurvivorNode, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
            this.log.error((Object)String.format("\nEntity on fail node: \n%s\n\nEntity on survivor node: \n%s\n\nDifference: \n%s\n", tf, ts, StringUtils.difference((String)tf, (String)ts)));
        }
        Assert.assertFalse((boolean)entityDiffers);
    }

    private void assertEntityOnSurvivorNodesIsDeleted(T testEntityOnFailNode) {
        boolean entityExists = false;
        for (ContainerInfo survivorNode : this.getCurrentSurvivorNodes()) {
            T testEntityOnSurvivorNode = this.readEntity(testEntityOnFailNode, survivorNode);
            if (testEntityOnSurvivorNode == null) {
                this.log.info((Object)String.format("Verification of %s deletion on survivor %s PASSED", this.getEntityType(testEntityOnFailNode), survivorNode));
                continue;
            }
            entityExists = true;
            this.log.error((Object)String.format("Verification of %s deletion on survivor %s FAILED", this.getEntityType(testEntityOnFailNode), survivorNode));
        }
        Assert.assertFalse((boolean)entityExists);
    }
}

