/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.cluster;

import javax.ws.rs.NotFoundException;
import org.junit.Assert;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RealmsResource;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.arquillian.ContainerInfo;
import org.keycloak.testsuite.cluster.AbstractInvalidationClusterTest;

public class RealmInvalidationClusterTest
extends AbstractInvalidationClusterTest<RealmRepresentation, RealmResource> {
    @Override
    protected RealmRepresentation createTestEntityRepresentation() {
        return this.createTestRealmRepresentation();
    }

    protected RealmsResource realms(ContainerInfo node) {
        return this.getAdminClientFor(node).realms();
    }

    @Override
    protected RealmResource entityResource(RealmRepresentation realm, ContainerInfo node) {
        return this.entityResource(realm.getRealm(), node);
    }

    @Override
    protected RealmResource entityResource(String name, ContainerInfo node) {
        return this.getAdminClientFor(node).realm(name);
    }

    @Override
    protected RealmRepresentation createEntity(RealmRepresentation realm, ContainerInfo node) {
        this.realms(node).create(realm);
        return this.readEntity(realm, node);
    }

    @Override
    protected RealmRepresentation readEntity(RealmRepresentation realm, ContainerInfo node) {
        RealmRepresentation realmOnNode = null;
        try {
            realmOnNode = this.entityResource(realm, node).toRepresentation();
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return realmOnNode;
    }

    @Override
    protected RealmRepresentation updateEntity(RealmRepresentation realm, ContainerInfo node) {
        return this.updateEntity(realm.getRealm(), realm, node);
    }

    private RealmRepresentation updateEntity(String realmName, RealmRepresentation realm, ContainerInfo node) {
        this.entityResource(realmName, node).update(realm);
        return this.readEntity(realm, node);
    }

    @Override
    protected void deleteEntity(RealmRepresentation realm, ContainerInfo node) {
        this.entityResource(realm, node).remove();
        Assert.assertNull((Object)this.readEntity(realm, node));
    }

    @Override
    protected RealmRepresentation testEntityUpdates(RealmRepresentation realm, boolean backendFailover) {
        String originalName = realm.getRealm();
        realm.setRealm(realm.getRealm() + "_updated");
        realm = this.updateEntity(originalName, realm, this.getCurrentFailNode());
        this.verifyEntityUpdateDuringFailover(realm, backendFailover);
        realm.setEnabled(Boolean.valueOf(realm.isEnabled() == false));
        realm = this.updateEntityOnCurrentFailNode(realm, "enabled");
        this.verifyEntityUpdateDuringFailover(realm, backendFailover);
        realm.setPublicKey("GENERATE");
        realm = this.updateEntityOnCurrentFailNode(realm, "public key");
        Assert.assertNotEquals((Object)"GENERATE", (Object)realm.getPublicKey());
        this.verifyEntityUpdateDuringFailover(realm, backendFailover);
        realm.setSslRequired("all");
        realm = this.updateEntityOnCurrentFailNode(realm, "require ssl");
        this.verifyEntityUpdateDuringFailover(realm, backendFailover);
        realm.setBruteForceProtected(Boolean.valueOf(realm.isBruteForceProtected() == false));
        realm = this.updateEntityOnCurrentFailNode(realm, "brute force");
        this.verifyEntityUpdateDuringFailover(realm, backendFailover);
        realm.setBruteForceProtected(Boolean.valueOf(true));
        realm.setFailureFactor(Integer.valueOf(realm.getFailureFactor() + 1));
        realm = this.updateEntityOnCurrentFailNode(realm, "brute force failure factor");
        this.verifyEntityUpdateDuringFailover(realm, backendFailover);
        return realm;
    }
}

