/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.cluster;

import javax.ws.rs.NotFoundException;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.Assert;
import org.keycloak.admin.client.resource.RoleResource;
import org.keycloak.admin.client.resource.RolesResource;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.testsuite.arquillian.ContainerInfo;
import org.keycloak.testsuite.cluster.AbstractInvalidationClusterTestWithTestRealm;

public class RoleInvalidationClusterTest
extends AbstractInvalidationClusterTestWithTestRealm<RoleRepresentation, RoleResource> {
    @Override
    protected RoleRepresentation createTestEntityRepresentation() {
        RoleRepresentation role = new RoleRepresentation();
        role.setName("role_" + RandomStringUtils.randomAlphabetic((int)5));
        role.setComposite(false);
        role.setDescription("description of " + role.getName());
        return role;
    }

    protected RolesResource roles(ContainerInfo node) {
        return this.getAdminClientFor(node).realm(this.testRealmName).roles();
    }

    @Override
    protected RoleResource entityResource(RoleRepresentation role, ContainerInfo node) {
        return this.entityResource(role.getName(), node);
    }

    @Override
    protected RoleResource entityResource(String name, ContainerInfo node) {
        return this.roles(node).get(name);
    }

    @Override
    protected RoleRepresentation createEntity(RoleRepresentation role, ContainerInfo node) {
        this.roles(node).create(role);
        return this.readEntity(role, node);
    }

    @Override
    protected RoleRepresentation readEntity(RoleRepresentation role, ContainerInfo node) {
        RoleRepresentation u = null;
        try {
            u = this.entityResource(role, node).toRepresentation();
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return u;
    }

    @Override
    protected RoleRepresentation updateEntity(RoleRepresentation role, ContainerInfo node) {
        return this.updateEntity(role.getName(), role, node);
    }

    private RoleRepresentation updateEntity(String roleName, RoleRepresentation role, ContainerInfo node) {
        this.entityResource(roleName, node).update(role);
        return this.readEntity(role, node);
    }

    @Override
    protected void deleteEntity(RoleRepresentation role, ContainerInfo node) {
        this.entityResource(role, node).remove();
        Assert.assertNull((Object)this.readEntity(role, node));
    }

    @Override
    protected RoleRepresentation testEntityUpdates(RoleRepresentation role, boolean backendFailover) {
        role.setDescription(role.getDescription() + "_- updated");
        role = this.updateEntityOnCurrentFailNode(role, "description");
        this.verifyEntityUpdateDuringFailover(role, backendFailover);
        return role;
    }
}

