/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.cluster;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.cluster.AbstractClusterTest;
import org.keycloak.testsuite.page.AbstractPage;
import org.keycloak.testsuite.page.PageWithLogOutAction;
import org.keycloak.testsuite.util.URLAssert;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.Cookie;

public class SessionFailoverClusterTest
extends AbstractClusterTest {
    public static final String KEYCLOAK_SESSION_COOKIE = "KEYCLOAK_SESSION";
    public static final Integer SESSION_CACHE_OWNERS = Integer.parseInt(System.getProperty("session.cache.owners", "1"));
    public static final Integer OFFLINE_SESSION_CACHE_OWNERS = Integer.parseInt(System.getProperty("offline.session.cache.owners", "1"));
    public static final Integer LOGIN_FAILURES_CACHE_OWNERS = Integer.parseInt(System.getProperty("login.failure.cache.owners", "1"));
    public static final Integer REBALANCE_WAIT = Integer.parseInt(System.getProperty("rebalance.wait", "5000"));

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
    }

    @Before
    public void beforeSessionFailover() {
        this.log.info((Object)"Initial node failure");
        this.failure();
        WaitUtils.pause((long)REBALANCE_WAIT.intValue());
    }

    @Test
    public void sessionFailover() {
        boolean expectSuccessfulFailover = SESSION_CACHE_OWNERS >= this.getClusterSize();
        this.log.info((Object)("SESSION FAILOVER TEST: cluster size = " + this.getClusterSize() + ", session-cache owners = " + SESSION_CACHE_OWNERS + " --> Testsing for " + (expectSuccessfulFailover ? "" : "UN") + "SUCCESSFUL session failover."));
        Assert.assertEquals((long)2L, (long)this.getClusterSize());
        this.sessionFailover(expectSuccessfulFailover);
    }

    protected void sessionFailover(boolean expectSuccessfulFailover) {
        Cookie sessionCookie = this.login((AbstractPage)this.accountPage);
        this.switchFailedNode();
        if (expectSuccessfulFailover) {
            this.verifyLoggedIn((AbstractPage)this.accountPage, sessionCookie);
        } else {
            this.verifyLoggedOut((AbstractPage)this.accountPage);
        }
        this.switchFailedNode();
        if (expectSuccessfulFailover) {
            this.verifyLoggedIn((AbstractPage)this.accountPage, sessionCookie);
        } else {
            this.verifyLoggedOut((AbstractPage)this.accountPage);
            this.login((AbstractPage)this.accountPage);
        }
        this.logout((AbstractPage)this.accountPage);
        this.verifyLoggedOut((AbstractPage)this.accountPage);
        this.switchFailedNode();
        this.verifyLoggedOut((AbstractPage)this.accountPage);
    }

    protected void switchFailedNode() {
        Assert.assertFalse((boolean)this.controller.isStarted(this.getCurrentFailNode().getQualifier()));
        this.failback();
        WaitUtils.pause((long)REBALANCE_WAIT.intValue());
        this.iterateCurrentFailNode();
        this.failure();
        WaitUtils.pause((long)REBALANCE_WAIT.intValue());
        Assert.assertFalse((boolean)this.controller.isStarted(this.getCurrentFailNode().getQualifier()));
    }

    protected Cookie login(AbstractPage targetPage) {
        targetPage.navigateTo();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.loginPage);
        this.loginPage.form().login("admin", "admin");
        URLAssert.assertCurrentUrlStartsWith(targetPage);
        Cookie sessionCookie = this.driver.manage().getCookieNamed(KEYCLOAK_SESSION_COOKIE);
        Assert.assertNotNull((Object)sessionCookie);
        return sessionCookie;
    }

    protected void logout(AbstractPage targetPage) {
        if (!(targetPage instanceof PageWithLogOutAction)) {
            throw new IllegalArgumentException(targetPage.getClass().getSimpleName() + " must implement PageWithLogOutAction interface");
        }
        targetPage.navigateTo();
        URLAssert.assertCurrentUrlStartsWith(targetPage);
        ((PageWithLogOutAction)targetPage).logOut();
    }

    protected Cookie verifyLoggedIn(AbstractPage targetPage, Cookie sessionCookieForVerification) {
        this.masterRealmPage.navigateTo();
        Cookie sessionCookieOnRealmPath = this.driver.manage().getCookieNamed(KEYCLOAK_SESSION_COOKIE);
        Assert.assertNotNull((Object)sessionCookieOnRealmPath);
        Assert.assertEquals((Object)sessionCookieOnRealmPath.getValue(), (Object)sessionCookieForVerification.getValue());
        targetPage.navigateTo();
        URLAssert.assertCurrentUrlStartsWith(targetPage);
        Cookie sessionCookie = this.driver.manage().getCookieNamed(KEYCLOAK_SESSION_COOKIE);
        Assert.assertNotNull((Object)sessionCookie);
        Assert.assertEquals((Object)sessionCookie.getValue(), (Object)sessionCookieForVerification.getValue());
        return sessionCookie;
    }

    protected void verifyLoggedOut(AbstractPage targetPage) {
        targetPage.navigateTo();
        this.driver.navigate().refresh();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.loginPage);
        Cookie sessionCookie = this.driver.manage().getCookieNamed(KEYCLOAK_SESSION_COOKIE);
        Assert.assertNull((Object)sessionCookie);
    }
}

