/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.composites;

import java.util.List;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.composites.AbstractCompositeKeycloakTest;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.util.OAuthClient;

public class CompositeImportRoleTest
extends AbstractCompositeKeycloakTest {
    @Page
    protected LoginPage loginPage;

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation testRealm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testcomposite.json"), RealmRepresentation.class);
        testRealm.setId("test");
        testRealm.setPublicKey("MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCrVrCuTtArbgaZzL1hvh0xtL5mc7o0NqPVnYXkLvgcwiC3BjLGw1tGEGoJaXDuSaRllobm53JBhjx33UNv+5z/UMG4kytBWxheNVKnL6GgqlNabMaFfPLPCF8kAgKnsi79NMo+n6KnSY8YeUmec/p2vjO2NjsSAVcWEQMVhJ31LwIDAQAB");
        testRealm.setPrivateKey("MIICXAIBAAKBgQCrVrCuTtArbgaZzL1hvh0xtL5mc7o0NqPVnYXkLvgcwiC3BjLGw1tGEGoJaXDuSaRllobm53JBhjx33UNv+5z/UMG4kytBWxheNVKnL6GgqlNabMaFfPLPCF8kAgKnsi79NMo+n6KnSY8YeUmec/p2vjO2NjsSAVcWEQMVhJ31LwIDAQABAoGAfmO8gVhyBxdqlxmIuglbz8bcjQbhXJLR2EoS8ngTXmN1bo2L90M0mUKSdc7qF10LgETBzqL8jYlQIbt+e6TH8fcEpKCjUlyq0Mf/vVbfZSNaVycY13nTzo27iPyWQHK5NLuJzn1xvxxrUeXI6A2WFpGEBLbHjwpx5WQG9A+2scECQQDvdn9NE75HPTVPxBqsEd2z10TKkl9CZxu10Qby3iQQmWLEJ9LNmy3acvKrE3gMiYNWb6xHPKiIqOR1as7L24aTAkEAtyvQOlCvr5kAjVqrEKXalj0Tzewjweuxc0pskvArTI2Oo070h65GpoIKLc9jf+UA69cRtquwP93aZKtW06U8dQJAF2Y44ks/mK5+eyDqik3koCI08qaC8HYq2wVl7G2QkJ6sbAaILtcvD92ToOvyGyeE0flvmDZxMYlvaZnaQ0lcSQJBAKZU6umJi3/xeEbkJqMfeLclD27XGEFoPeNrmdx0q10Azp4NfJAY+Z8KRyQCR2BEG+oNitBOZ+YXF9KCpH3cdmECQHEigJhYg+ykOvr1aiZUMFT72HU0jnmQe2FVekuG+LJUt2Tm7GtMjTFoGpf0JwrVuZN39fOYAlo+nTixgeW7X8Y=");
        testRealms.add(testRealm);
    }

    @Test
    public void testAppCompositeUser() throws Exception {
        this.oauth.realm("test");
        this.oauth.clientId("APP_COMPOSITE_APPLICATION");
        this.oauth.doLogin("APP_COMPOSITE_USER", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"bearer", (Object)response.getTokenType());
        AccessToken token = this.oauth.verifyToken(response.getAccessToken());
        Assert.assertEquals((Object)this.getUserId("APP_COMPOSITE_USER"), (Object)token.getSubject());
        Assert.assertEquals((long)1L, (long)token.getResourceAccess("APP_ROLE_APPLICATION").getRoles().size());
        Assert.assertEquals((long)1L, (long)token.getRealmAccess().getRoles().size());
        Assert.assertTrue((boolean)token.getResourceAccess("APP_ROLE_APPLICATION").isUserInRole("APP_ROLE_1"));
        Assert.assertTrue((boolean)token.getRealmAccess().isUserInRole("REALM_ROLE_1"));
    }

    @Test
    public void testRealmAppCompositeUser() throws Exception {
        this.oauth.realm("test");
        this.oauth.clientId("APP_ROLE_APPLICATION");
        this.oauth.doLogin("REALM_APP_COMPOSITE_USER", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"bearer", (Object)response.getTokenType());
        AccessToken token = this.oauth.verifyToken(response.getAccessToken());
        Assert.assertEquals((Object)this.getUserId("REALM_APP_COMPOSITE_USER"), (Object)token.getSubject());
        Assert.assertEquals((long)1L, (long)token.getResourceAccess("APP_ROLE_APPLICATION").getRoles().size());
        Assert.assertTrue((boolean)token.getResourceAccess("APP_ROLE_APPLICATION").isUserInRole("APP_ROLE_1"));
    }

    @Test
    public void testRealmOnlyWithUserCompositeAppComposite() throws Exception {
        this.oauth.realm("test");
        this.oauth.clientId("REALM_COMPOSITE_1_APPLICATION");
        this.oauth.doLogin("REALM_COMPOSITE_1_USER", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"bearer", (Object)response.getTokenType());
        AccessToken token = this.oauth.verifyToken(response.getAccessToken());
        Assert.assertEquals((Object)this.getUserId("REALM_COMPOSITE_1_USER"), (Object)token.getSubject());
        Assert.assertEquals((long)2L, (long)token.getRealmAccess().getRoles().size());
        Assert.assertTrue((boolean)token.getRealmAccess().isUserInRole("REALM_COMPOSITE_1"));
        Assert.assertTrue((boolean)token.getRealmAccess().isUserInRole("REALM_ROLE_1"));
    }

    @Test
    public void testRealmOnlyWithUserCompositeAppRole() throws Exception {
        this.oauth.realm("test");
        this.oauth.clientId("REALM_ROLE_1_APPLICATION");
        this.oauth.doLogin("REALM_COMPOSITE_1_USER", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"bearer", (Object)response.getTokenType());
        AccessToken token = this.oauth.verifyToken(response.getAccessToken());
        Assert.assertEquals((Object)this.getUserId("REALM_COMPOSITE_1_USER"), (Object)token.getSubject());
        Assert.assertEquals((long)1L, (long)token.getRealmAccess().getRoles().size());
        Assert.assertTrue((boolean)token.getRealmAccess().isUserInRole("REALM_ROLE_1"));
    }

    @Test
    public void testRealmOnlyWithUserRoleAppComposite() throws Exception {
        this.oauth.realm("test");
        this.oauth.clientId("REALM_COMPOSITE_1_APPLICATION");
        this.oauth.doLogin("REALM_ROLE_1_USER", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"bearer", (Object)response.getTokenType());
        AccessToken token = this.oauth.verifyToken(response.getAccessToken());
        Assert.assertEquals((Object)this.getUserId("REALM_ROLE_1_USER"), (Object)token.getSubject());
        Assert.assertEquals((long)1L, (long)token.getRealmAccess().getRoles().size());
        Assert.assertTrue((boolean)token.getRealmAccess().isUserInRole("REALM_ROLE_1"));
    }
}

