/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.events;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.events.EventType;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.testsuite.events.AbstractEventsTest;

public class EventStoreProviderTest
extends AbstractEventsTest {
    @After
    public void after() {
        this.testing().clearEventStore();
    }

    @Test
    public void save() {
        this.testing().onEvent(this.create(EventType.LOGIN, "realmId", "clientId", "userId", "127.0.0.1", "error"));
    }

    @Test
    public void query() {
        long oldest = System.currentTimeMillis() - 30000L;
        long newest = System.currentTimeMillis() + 30000L;
        this.testing().onEvent(this.create(EventType.LOGIN, "realmId", "clientId", "userId", "127.0.0.1", "error"));
        this.testing().onEvent(this.create(newest, EventType.REGISTER, "realmId", "clientId", "userId", "127.0.0.1", "error"));
        this.testing().onEvent(this.create(newest, EventType.REGISTER, "realmId", "clientId", "userId2", "127.0.0.1", "error"));
        this.testing().onEvent(this.create(EventType.LOGIN, "realmId2", "clientId", "userId", "127.0.0.1", "error"));
        this.testing().onEvent(this.create(oldest, EventType.LOGIN, "realmId", "clientId2", "userId", "127.0.0.1", "error"));
        this.testing().onEvent(this.create(EventType.LOGIN, "realmId", "clientId", "userId2", "127.0.0.1", "error"));
        Assert.assertEquals((long)5L, (long)this.testing().queryEvents(null, null, "clientId", null, null, null, null, null, null).size());
        Assert.assertEquals((long)5L, (long)this.testing().queryEvents("realmId", null, null, null, null, null, null, null, null).size());
        Assert.assertEquals((long)4L, (long)this.testing().queryEvents(null, this.toList(new Enum[]{EventType.LOGIN}), null, null, null, null, null, null, null).size());
        Assert.assertEquals((long)6L, (long)this.testing().queryEvents(null, this.toList(new Enum[]{EventType.LOGIN, EventType.REGISTER}), null, null, null, null, null, null, null).size());
        Assert.assertEquals((long)4L, (long)this.testing().queryEvents(null, null, null, "userId", null, null, null, null, null).size());
        Assert.assertEquals((long)1L, (long)this.testing().queryEvents(null, this.toList(new Enum[]{EventType.REGISTER}), null, "userId", null, null, null, null, null).size());
        Assert.assertEquals((long)2L, (long)this.testing().queryEvents(null, null, null, null, null, null, null, null, Integer.valueOf(2)).size());
        Assert.assertEquals((long)1L, (long)this.testing().queryEvents(null, null, null, null, null, null, null, Integer.valueOf(5), null).size());
        Assert.assertEquals((long)newest, (long)((EventRepresentation)this.testing().queryEvents(null, null, null, null, null, null, null, null, Integer.valueOf(1)).get(0)).getTime());
        Assert.assertEquals((long)oldest, (long)((EventRepresentation)this.testing().queryEvents(null, null, null, null, null, null, null, Integer.valueOf(5), Integer.valueOf(1)).get(0)).getTime());
        this.testing().clearEventStore("realmId");
        this.testing().clearEventStore("realmId2");
        Assert.assertEquals((long)0L, (long)this.testing().queryEvents(null, null, null, null, null, null, null, null, null).size());
        String d1 = new String("2015-03-04");
        String d2 = new String("2015-03-05");
        String d3 = new String("2015-03-06");
        String d4 = new String("2015-03-07");
        String d5 = new String("2015-03-01");
        String d6 = new String("2015-03-03");
        String d7 = new String("2015-03-08");
        String d8 = new String("2015-03-10");
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date date1 = null;
        Date date2 = null;
        Date date3 = null;
        Date date4 = null;
        try {
            date1 = formatter.parse(d1);
            date2 = formatter.parse(d2);
            date3 = formatter.parse(d3);
            date4 = formatter.parse(d4);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        this.testing().onEvent(this.create(date1, EventType.LOGIN, "realmId", "clientId", "userId", "127.0.0.1", "error"));
        this.testing().onEvent(this.create(date1, EventType.LOGIN, "realmId", "clientId", "userId", "127.0.0.1", "error"));
        this.testing().onEvent(this.create(date2, EventType.REGISTER, "realmId", "clientId", "userId", "127.0.0.1", "error"));
        this.testing().onEvent(this.create(date2, EventType.REGISTER, "realmId", "clientId", "userId", "127.0.0.1", "error"));
        this.testing().onEvent(this.create(date3, EventType.CODE_TO_TOKEN, "realmId", "clientId", "userId2", "127.0.0.1", "error"));
        this.testing().onEvent(this.create(date3, EventType.LOGOUT, "realmId", "clientId", "userId2", "127.0.0.1", "error"));
        this.testing().onEvent(this.create(date4, EventType.UPDATE_PROFILE, "realmId2", "clientId2", "userId2", "127.0.0.1", "error"));
        this.testing().onEvent(this.create(date4, EventType.UPDATE_EMAIL, "realmId2", "clientId2", "userId2", "127.0.0.1", "error"));
        Assert.assertEquals((long)6L, (long)this.testing().queryEvents(null, null, "clientId", null, null, null, null, null, null).size());
        Assert.assertEquals((long)2L, (long)this.testing().queryEvents(null, null, "clientId2", null, null, null, null, null, null).size());
        Assert.assertEquals((long)6L, (long)this.testing().queryEvents("realmId", null, null, null, null, null, null, null, null).size());
        Assert.assertEquals((long)2L, (long)this.testing().queryEvents("realmId2", null, null, null, null, null, null, null, null).size());
        Assert.assertEquals((long)4L, (long)this.testing().queryEvents(null, null, null, "userId", null, null, null, null, null).size());
        Assert.assertEquals((long)4L, (long)this.testing().queryEvents(null, null, null, "userId2", null, null, null, null, null).size());
        Assert.assertEquals((long)2L, (long)this.testing().queryEvents(null, this.toList(new Enum[]{EventType.LOGIN}), null, null, null, null, null, null, null).size());
        Assert.assertEquals((long)2L, (long)this.testing().queryEvents(null, this.toList(new Enum[]{EventType.REGISTER}), null, null, null, null, null, null, null).size());
        Assert.assertEquals((long)4L, (long)this.testing().queryEvents(null, this.toList(new Enum[]{EventType.LOGIN, EventType.REGISTER}), null, null, null, null, null, null, null).size());
        Assert.assertEquals((long)1L, (long)this.testing().queryEvents(null, this.toList(new Enum[]{EventType.CODE_TO_TOKEN}), null, null, null, null, null, null, null).size());
        Assert.assertEquals((long)1L, (long)this.testing().queryEvents(null, this.toList(new Enum[]{EventType.LOGOUT}), null, null, null, null, null, null, null).size());
        Assert.assertEquals((long)1L, (long)this.testing().queryEvents(null, this.toList(new Enum[]{EventType.UPDATE_PROFILE}), null, null, null, null, null, null, null).size());
        Assert.assertEquals((long)1L, (long)this.testing().queryEvents(null, this.toList(new Enum[]{EventType.UPDATE_EMAIL}), null, null, null, null, null, null, null).size());
        Assert.assertEquals((long)8L, (long)this.testing().queryEvents(null, null, null, null, d1, null, null, null, null).size());
        Assert.assertEquals((long)8L, (long)this.testing().queryEvents(null, null, null, null, null, d4, null, null, null).size());
        Assert.assertEquals((long)4L, (long)this.testing().queryEvents(null, null, null, null, d3, null, null, null, null).size());
        Assert.assertEquals((long)4L, (long)this.testing().queryEvents(null, null, null, null, null, d2, null, null, null).size());
        Assert.assertEquals((long)0L, (long)this.testing().queryEvents(null, null, null, null, d7, null, null, null, null).size());
        Assert.assertEquals((long)0L, (long)this.testing().queryEvents(null, null, null, null, null, d6, null, null, null).size());
        Assert.assertEquals((long)8L, (long)this.testing().queryEvents(null, null, null, null, d1, d4, null, null, null).size());
        Assert.assertEquals((long)6L, (long)this.testing().queryEvents(null, null, null, null, d2, d4, null, null, null).size());
        Assert.assertEquals((long)4L, (long)this.testing().queryEvents(null, null, null, null, d1, d2, null, null, null).size());
        Assert.assertEquals((long)4L, (long)this.testing().queryEvents(null, null, null, null, d3, d4, null, null, null).size());
        Assert.assertEquals((long)0L, (long)this.testing().queryEvents(null, null, null, null, d5, d6, null, null, null).size());
        Assert.assertEquals((long)0L, (long)this.testing().queryEvents(null, null, null, null, d7, d8, null, null, null).size());
    }

    @Test
    public void clear() {
        this.testing().onEvent(this.create(System.currentTimeMillis() - 30000L, EventType.LOGIN, "realmId", "clientId", "userId", "127.0.0.1", "error"));
        this.testing().onEvent(this.create(System.currentTimeMillis() - 20000L, EventType.LOGIN, "realmId", "clientId", "userId", "127.0.0.1", "error"));
        this.testing().onEvent(this.create(System.currentTimeMillis(), EventType.LOGIN, "realmId", "clientId", "userId", "127.0.0.1", "error"));
        this.testing().onEvent(this.create(System.currentTimeMillis(), EventType.LOGIN, "realmId", "clientId", "userId", "127.0.0.1", "error"));
        this.testing().onEvent(this.create(System.currentTimeMillis() - 30000L, EventType.LOGIN, "realmId2", "clientId", "userId", "127.0.0.1", "error"));
        this.testing().clearEventStore("realmId");
        Assert.assertEquals((long)1L, (long)this.testing().queryEvents(null, null, null, null, null, null, null, null, null).size());
    }

    @Test
    public void lengthExceedLimit() {
        this.testing().onEvent(this.create(System.currentTimeMillis() - 30000L, EventType.LOGIN, "realmId", StringUtils.repeat((String)"clientId", (int)100), "userId", "127.0.0.1", "error"));
        this.testing().onEvent(this.create(System.currentTimeMillis() - 30000L, EventType.LOGIN, StringUtils.repeat((String)"realmId", (int)100), "clientId", "userId", "127.0.0.1", "error"));
        this.testing().onEvent(this.create(System.currentTimeMillis() - 30000L, EventType.LOGIN, "realmId", "clientId", StringUtils.repeat((String)"userId", (int)100), "127.0.0.1", "error"));
    }

    @Test
    public void maxLengthWithNull() {
        this.testing().onEvent(this.create(System.currentTimeMillis() - 30000L, EventType.LOGIN, null, null, null, "127.0.0.1", "error"));
    }

    @Test
    public void clearOld() {
        this.testing().onEvent(this.create(System.currentTimeMillis() - 30000L, EventType.LOGIN, "realmId", "clientId", "userId", "127.0.0.1", "error"));
        this.testing().onEvent(this.create(System.currentTimeMillis() - 20000L, EventType.LOGIN, "realmId", "clientId", "userId", "127.0.0.1", "error"));
        this.testing().onEvent(this.create(System.currentTimeMillis(), EventType.LOGIN, "realmId", "clientId", "userId", "127.0.0.1", "error"));
        this.testing().onEvent(this.create(System.currentTimeMillis(), EventType.LOGIN, "realmId", "clientId", "userId", "127.0.0.1", "error"));
        this.testing().onEvent(this.create(System.currentTimeMillis() - 30000L, EventType.LOGIN, "realmId2", "clientId", "userId", "127.0.0.1", "error"));
        this.testing().clearEventStore("realmId", System.currentTimeMillis() - 10000L);
        Assert.assertEquals((long)3L, (long)this.testing().queryEvents(null, null, null, null, null, null, null, null, null).size());
    }

    private EventRepresentation create(EventType event, String realmId, String clientId, String userId, String ipAddress, String error) {
        return this.create(System.currentTimeMillis(), event, realmId, clientId, userId, ipAddress, error);
    }

    private EventRepresentation create(Date date, EventType event, String realmId, String clientId, String userId, String ipAddress, String error) {
        return this.create(date.getTime(), event, realmId, clientId, userId, ipAddress, error);
    }

    private EventRepresentation create(long time, EventType event, String realmId, String clientId, String userId, String ipAddress, String error) {
        EventRepresentation e = new EventRepresentation();
        e.setTime(time);
        e.setType(event.toString());
        e.setRealmId(realmId);
        e.setClientId(clientId);
        e.setUserId(userId);
        e.setIpAddress(ipAddress);
        e.setError(error);
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("key1", "value1");
        details.put("key2", "value2");
        e.setDetails(details);
        return e;
    }
}

