/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.exportimport;

import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.regex.Matcher;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.exportimport.ExportImportConfig;
import org.keycloak.exportimport.dir.DirExportProvider;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.exportimport.AbstractExportImportTest;
import org.keycloak.testsuite.exportimport.ExportImportUtil;
import org.keycloak.testsuite.util.UserBuilder;

public class ExportImportTest
extends AbstractExportImportTest {
    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation testRealm1 = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        testRealm1.getUsers().add(this.makeUser("user1"));
        testRealm1.getUsers().add(this.makeUser("user2"));
        testRealm1.getUsers().add(this.makeUser("user3"));
        testRealms.add(testRealm1);
        RealmRepresentation testRealm2 = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/model/testrealm.json"), RealmRepresentation.class);
        testRealm2.setId("test-realm");
        testRealms.add(testRealm2);
    }

    private UserRepresentation makeUser(String userName) {
        return UserBuilder.create().username(userName).email(userName + "@test.com").password("password").build();
    }

    @After
    public void clearExportImportProps() throws LifecycleException {
        this.clearExportImportProperties();
    }

    @Test
    public void testDirFullExportImport() throws Throwable {
        ExportImportConfig.setProvider((String)"dir");
        String targetDirPath = ExportImportTest.getExportImportTestDirectory() + File.separator + "dirExport";
        DirExportProvider.recursiveDeleteDir((File)new File(targetDirPath));
        ExportImportConfig.setDir((String)targetDirPath);
        ExportImportConfig.setUsersPerFile((Integer)ExportImportConfig.DEFAULT_USERS_PER_FILE);
        this.testFullExportImport();
        Assert.assertEquals((long)6L, (long)new File(targetDirPath).listFiles().length);
    }

    @Test
    public void testDirRealmExportImport() throws Throwable {
        ExportImportConfig.setProvider((String)"dir");
        String targetDirPath = ExportImportTest.getExportImportTestDirectory() + File.separator + "dirRealmExport";
        DirExportProvider.recursiveDeleteDir((File)new File(targetDirPath));
        ExportImportConfig.setDir((String)targetDirPath);
        ExportImportConfig.setUsersPerFile((Integer)3);
        this.testRealmExportImport();
        File[] files = new File(targetDirPath).listFiles();
        Assert.assertEquals((long)4L, (long)files.length);
    }

    @Test
    public void testSingleFileFullExportImport() throws Throwable {
        ExportImportConfig.setProvider((String)"singleFile");
        String targetFilePath = ExportImportTest.getExportImportTestDirectory() + File.separator + "singleFile-full.json";
        ExportImportConfig.setFile((String)targetFilePath);
        this.testFullExportImport();
    }

    @Test
    public void testSingleFileRealmExportImport() throws Throwable {
        ExportImportConfig.setProvider((String)"singleFile");
        String targetFilePath = ExportImportTest.getExportImportTestDirectory() + File.separator + "singleFile-realm.json";
        ExportImportConfig.setFile((String)targetFilePath);
        this.testRealmExportImport();
    }

    @Test
    public void testSingleFileRealmWithoutBuiltinsImport() throws Throwable {
        this.removeRealm("test-realm");
        ExportImportConfig.setProvider((String)"singleFile");
        URL url = ExportImportTest.class.getResource("/model/testrealm.json");
        String targetFilePath = new File(url.getFile()).getAbsolutePath();
        ExportImportConfig.setFile((String)targetFilePath);
        ExportImportConfig.setAction((String)"import");
        this.testingClient.testing().runImport();
        RealmResource testRealmRealm = this.adminClient.realm("test-realm");
        ExportImportUtil.assertDataImportedInRealm(this.adminClient, this.testingClient, testRealmRealm.toRepresentation());
    }

    private void removeRealm(String realmName) {
        this.adminClient.realm(realmName).remove();
    }

    private void testFullExportImport() throws LifecycleException {
        ExportImportConfig.setAction((String)"export");
        ExportImportConfig.setRealmName(null);
        this.testingClient.testing().runExport();
        this.removeRealm("test");
        this.removeRealm("test-realm");
        Assert.assertEquals((long)1L, (long)this.adminClient.realms().findAll().size());
        this.assertNotAuthenticated("test", "test-user@localhost", "password");
        this.assertNotAuthenticated("test", "user1", "password");
        this.assertNotAuthenticated("test", "user2", "password");
        this.assertNotAuthenticated("test", "user3", "password");
        ExportImportConfig.setAction((String)"import");
        this.testingClient.testing().runImport();
        Assert.assertEquals((long)3L, (long)this.adminClient.realms().findAll().size());
        this.assertAuthenticated("test", "test-user@localhost", "password");
        this.assertAuthenticated("test", "user1", "password");
        this.assertAuthenticated("test", "user2", "password");
        this.assertAuthenticated("test", "user3", "password");
    }

    private void testRealmExportImport() throws LifecycleException {
        ExportImportConfig.setAction((String)"export");
        ExportImportConfig.setRealmName((String)"test");
        this.testingClient.testing().runExport();
        this.adminClient.realm("test").remove();
        Assert.assertEquals((long)2L, (long)this.adminClient.realms().findAll().size());
        this.assertNotAuthenticated("test", "test-user@localhost", "password");
        this.assertNotAuthenticated("test", "user1", "password");
        this.assertNotAuthenticated("test", "user2", "password");
        this.assertNotAuthenticated("test", "user3", "password");
        ExportImportConfig.setAction((String)"import");
        this.testingClient.testing().runImport();
        Assert.assertEquals((long)3L, (long)this.adminClient.realms().findAll().size());
        this.assertAuthenticated("test", "test-user@localhost", "password");
        this.assertAuthenticated("test", "user1", "password");
        this.assertAuthenticated("test", "user2", "password");
        this.assertAuthenticated("test", "user3", "password");
    }

    private void assertAuthenticated(String realmName, String username, String password) {
        this.assertAuth(true, realmName, username, password);
    }

    private void assertNotAuthenticated(String realmName, String username, String password) {
        this.assertAuth(false, realmName, username, password);
    }

    private void assertAuth(boolean expectedResult, String realmName, String username, String password) {
        Assert.assertEquals((Object)expectedResult, (Object)this.testingClient.testing().validCredentials(realmName, username, password));
    }

    private static String getExportImportTestDirectory() {
        String dirPath = null;
        String relativeDirExportImportPath = "testsuite" + File.separator + "integration-arquillian" + File.separator + "tests" + File.separator + "base" + File.separator + "target" + File.separator + "export-import";
        if (System.getProperties().containsKey("maven.home")) {
            dirPath = System.getProperty("user.dir").replaceFirst("testsuite.integration.*", Matcher.quoteReplacement(relativeDirExportImportPath));
        } else {
            for (String c : System.getProperty("java.class.path").split(File.pathSeparator)) {
                if (!c.contains(File.separator + "testsuite" + File.separator + "integration-arquillian" + File.separator)) continue;
                dirPath = c.replaceFirst("testsuite.integration-arquillian.*", Matcher.quoteReplacement(relativeDirExportImportPath));
            }
        }
        String absolutePath = new File(dirPath).getAbsolutePath();
        return absolutePath;
    }
}

