/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.exportimport;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientTemplateResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.ClientMappingsRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientTemplateRepresentation;
import org.keycloak.representations.idm.FederatedIdentityRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserFederationMapperRepresentation;
import org.keycloak.representations.idm.UserFederationProviderRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.client.KeycloakTestingClient;
import org.keycloak.testsuite.util.RealmRepUtil;

public class ExportImportUtil {
    public static void assertDataImportedInRealm(Keycloak adminClient, KeycloakTestingClient testingClient, RealmRepresentation realm) {
        Assert.assertTrue((boolean)realm.isVerifyEmail());
        Assert.assertEquals((Object)3600000, (Object)realm.getOfflineSessionIdleTimeout());
        Assert.assertEquals((Object)1500, (Object)realm.getAccessTokenLifespanForImplicitFlow());
        Set creds = realm.getRequiredCredentials();
        Assert.assertEquals((long)1L, (long)creds.size());
        String cred = (String)creds.iterator().next();
        Assert.assertEquals((Object)"password", (Object)cred);
        Assert.assertEquals((long)4L, (long)realm.getDefaultRoles().size());
        Assert.assertNotNull((Object)RealmRepUtil.findDefaultRole(realm, "foo"));
        Assert.assertNotNull((Object)RealmRepUtil.findDefaultRole(realm, "bar"));
        RealmResource realmRsc = adminClient.realm(realm.getRealm());
        UserRepresentation user = ExportImportUtil.findByUsername(realmRsc, "loginclient");
        Assert.assertNotNull((Object)user);
        UserResource userRsc = realmRsc.users().get(user.getId());
        Assert.assertEquals((long)0L, (long)userRsc.getFederatedIdentity().size());
        List resources = realmRsc.clients().findAll();
        Assert.assertEquals((long)8L, (long)resources.size());
        ClientRepresentation application = ApiUtil.findClientByClientId(realmRsc, "Application").toRepresentation();
        ClientRepresentation otherApp = ApiUtil.findClientByClientId(realmRsc, "OtherApp").toRepresentation();
        ClientRepresentation accountApp = ApiUtil.findClientByClientId(realmRsc, "account").toRepresentation();
        ClientResource nonExisting = ApiUtil.findClientByClientId(realmRsc, "NonExisting");
        Assert.assertNotNull((Object)application);
        Assert.assertNotNull((Object)otherApp);
        Assert.assertNull((Object)nonExisting);
        List clients = realmRsc.clients().findAll();
        Assert.assertEquals((long)8L, (long)clients.size());
        Assert.assertTrue((boolean)ExportImportUtil.hasClient(clients, application));
        Assert.assertTrue((boolean)ExportImportUtil.hasClient(clients, otherApp));
        Assert.assertTrue((boolean)ExportImportUtil.hasClient(clients, accountApp));
        Assert.assertEquals((Object)"Applicationn", (Object)application.getName());
        Assert.assertEquals((Object)50, (Object)application.getNodeReRegistrationTimeout());
        Map appRegisteredNodes = application.getRegisteredNodes();
        Assert.assertEquals((long)2L, (long)appRegisteredNodes.size());
        Assert.assertTrue((10 == (Integer)appRegisteredNodes.get("node1") ? 1 : 0) != 0);
        Assert.assertTrue((20 == (Integer)appRegisteredNodes.get("172.10.15.20") ? 1 : 0) != 0);
        Assert.assertEquals((Object)"client-secret", (Object)application.getClientAuthenticatorType());
        Assert.assertEquals((Object)"client-jwt", (Object)otherApp.getClientAuthenticatorType());
        Assert.assertNull((Object)ApiUtil.findClientResourceById(realmRsc, "982734"));
        Assert.assertEquals((Object)application.getId(), (Object)ApiUtil.findClientResourceById(realmRsc, application.getId()).toRepresentation().getId());
        UserRepresentation admin = ExportImportUtil.findByUsername(realmRsc, "admin");
        Assert.assertNull((Object)admin.getCreatedTimestamp());
        Set<RoleRepresentation> allRoles = ExportImportUtil.allRoles(realmRsc, admin);
        Assert.assertEquals((long)3L, (long)allRoles.size());
        Assert.assertTrue((boolean)ExportImportUtil.containsRole(allRoles, ExportImportUtil.findRealmRole(realmRsc, "admin")));
        Assert.assertTrue((boolean)ExportImportUtil.containsRole(allRoles, ExportImportUtil.findClientRole(realmRsc, application.getId(), "app-admin")));
        Assert.assertTrue((boolean)ExportImportUtil.containsRole(allRoles, ExportImportUtil.findClientRole(realmRsc, otherApp.getId(), "otherapp-admin")));
        Assert.assertTrue((boolean)ExportImportUtil.findClientRole(realmRsc, application.getId(), "app-admin").isScopeParamRequired());
        Assert.assertFalse((boolean)ExportImportUtil.findClientRole(realmRsc, otherApp.getId(), "otherapp-admin").isScopeParamRequired());
        Assert.assertFalse((boolean)ExportImportUtil.findClientRole(realmRsc, otherApp.getId(), "otherapp-user").isScopeParamRequired());
        UserRepresentation wburke = ExportImportUtil.findByUsername(realmRsc, "wburke");
        Assert.assertEquals((Object)new Long(123654L), (Object)wburke.getCreatedTimestamp());
        allRoles = ExportImportUtil.allRoles(realmRsc, wburke);
        Assert.assertEquals((long)2L, (long)allRoles.size());
        Assert.assertFalse((boolean)ExportImportUtil.containsRole(allRoles, ExportImportUtil.findRealmRole(realmRsc, "admin")));
        Assert.assertTrue((boolean)ExportImportUtil.containsRole(allRoles, ExportImportUtil.findClientRole(realmRsc, application.getId(), "app-user")));
        Assert.assertTrue((boolean)ExportImportUtil.containsRole(allRoles, ExportImportUtil.findClientRole(realmRsc, otherApp.getId(), "otherapp-user")));
        Assert.assertNull((Object)realmRsc.users().get(wburke.getId()).roles().getAll().getRealmMappings());
        UserRepresentation loginclient = ExportImportUtil.findByUsername(realmRsc, "loginclient");
        Assert.assertEquals((Object)new Long(123655L), (Object)loginclient.getCreatedTimestamp());
        List<RoleRepresentation> realmRoles = ExportImportUtil.realmRolesForUser(realmRsc, admin);
        Assert.assertEquals((long)1L, (long)realmRoles.size());
        Assert.assertEquals((Object)"admin", (Object)realmRoles.iterator().next().getName());
        List<RoleRepresentation> appRoles = ExportImportUtil.clientRolesForUser(realmRsc, application, admin);
        Assert.assertEquals((long)1L, (long)appRoles.size());
        Assert.assertEquals((Object)"app-admin", (Object)appRoles.iterator().next().getName());
        Map attrs = wburke.getAttributesAsListValues();
        Assert.assertEquals((long)1L, (long)attrs.size());
        List attrVals = (List)attrs.get("email");
        Assert.assertEquals((long)1L, (long)attrVals.size());
        Assert.assertEquals((Object)"bburke@redhat.com", attrVals.get(0));
        attrs = admin.getAttributesAsListValues();
        Assert.assertEquals((long)2L, (long)attrs.size());
        attrVals = (List)attrs.get("key1");
        Assert.assertEquals((long)1L, (long)attrVals.size());
        Assert.assertEquals((Object)"val1", attrVals.get(0));
        attrVals = (List)attrs.get("key2");
        Assert.assertEquals((long)2L, (long)attrVals.size());
        Assert.assertTrue((attrVals.contains("val21") && attrVals.contains("val22") ? 1 : 0) != 0);
        ClientResource oauthClient = ApiUtil.findClientResourceByClientId(realmRsc, "oauthclient");
        ClientRepresentation oauthClientRep = oauthClient.toRepresentation();
        Assert.assertEquals((Object)"clientpassword", (Object)oauthClient.getSecret().getValue());
        Assert.assertTrue((boolean)oauthClientRep.isEnabled());
        Assert.assertNotNull((Object)oauthClientRep);
        Set<RoleRepresentation> allScopes = ExportImportUtil.allScopeMappings(oauthClient);
        Assert.assertEquals((long)2L, (long)allScopes.size());
        Assert.assertTrue((boolean)ExportImportUtil.containsRole(allScopes, ExportImportUtil.findRealmRole(realmRsc, "admin")));
        Assert.assertTrue((boolean)ExportImportUtil.containsRole(allScopes, ExportImportUtil.findClientRole(realmRsc, application.getId(), "app-user")));
        List<RoleRepresentation> realmScopes = ExportImportUtil.realmScopeMappings(oauthClient);
        Assert.assertTrue((boolean)ExportImportUtil.containsRole(realmScopes, ExportImportUtil.findRealmRole(realmRsc, "admin")));
        List<RoleRepresentation> appScopes = ExportImportUtil.clientScopeMappings(oauthClient);
        Assert.assertTrue((boolean)ExportImportUtil.containsRole(appScopes, ExportImportUtil.findClientRole(realmRsc, application.getId(), "app-user")));
        UserResource socialUser = realmRsc.users().get(ExportImportUtil.findByUsername(realmRsc, "mySocialUser").getId());
        List socialLinks = socialUser.getFederatedIdentity();
        Assert.assertEquals((long)3L, (long)socialLinks.size());
        boolean facebookFound = false;
        boolean googleFound = false;
        boolean twitterFound = false;
        FederatedIdentityRepresentation facebookIdentityRep = null;
        for (FederatedIdentityRepresentation federatedIdentityRep : socialLinks) {
            if ("facebook1".equals(federatedIdentityRep.getIdentityProvider())) {
                facebookFound = true;
                facebookIdentityRep = federatedIdentityRep;
                Assert.assertEquals((Object)"facebook1", (Object)federatedIdentityRep.getUserId());
                Assert.assertEquals((Object)"fbuser1", (Object)federatedIdentityRep.getUserName());
                continue;
            }
            if ("google1".equals(federatedIdentityRep.getIdentityProvider())) {
                googleFound = true;
                Assert.assertEquals((Object)"google1", (Object)federatedIdentityRep.getUserId());
                Assert.assertEquals((Object)"mysocialuser@gmail.com", (Object)federatedIdentityRep.getUserName());
                continue;
            }
            if (!"twitter1".equals(federatedIdentityRep.getIdentityProvider())) continue;
            twitterFound = true;
            Assert.assertEquals((Object)"twitter1", (Object)federatedIdentityRep.getUserId());
            Assert.assertEquals((Object)"twuser1", (Object)federatedIdentityRep.getUserName());
        }
        Assert.assertTrue((facebookFound && twitterFound && googleFound ? 1 : 0) != 0);
        UserRepresentation foundSocialUser = testingClient.testing().getUserByFederatedIdentity(realm.getRealm(), "facebook1", "facebook1", "fbuser1");
        Assert.assertEquals((Object)foundSocialUser.getUsername(), (Object)socialUser.toRepresentation().getUsername());
        Assert.assertNull((Object)testingClient.testing().getUserByFederatedIdentity(realm.getRealm(), "facebook", "not-existing", "not-existing"));
        Assert.assertEquals((Object)"facebook1", (Object)facebookIdentityRep.getUserId());
        Assert.assertEquals((Object)"fbuser1", (Object)facebookIdentityRep.getUserName());
        Assert.assertEquals((Object)"facebook1", (Object)facebookIdentityRep.getIdentityProvider());
        socialUser.removeFederatedIdentity("facebook1");
        Assert.assertEquals((long)2L, (long)socialUser.getFederatedIdentity().size());
        socialUser.addFederatedIdentity("facebook1", facebookIdentityRep);
        Assert.assertEquals((long)3L, (long)socialUser.getFederatedIdentity().size());
        Map smtpConfig = realm.getSmtpServer();
        Assert.assertTrue((smtpConfig.size() == 3 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"auto@keycloak.org", smtpConfig.get("from"));
        Assert.assertEquals((Object)"localhost", smtpConfig.get("host"));
        Assert.assertEquals((Object)"3025", smtpConfig.get("port"));
        List identityProviders = realm.getIdentityProviders();
        Assert.assertEquals((long)3L, (long)identityProviders.size());
        IdentityProviderRepresentation google = null;
        for (IdentityProviderRepresentation idpRep : identityProviders) {
            if (!idpRep.getAlias().equals("google1")) continue;
            google = idpRep;
        }
        Assert.assertNotNull(google);
        Assert.assertEquals((Object)"google1", (Object)google.getAlias());
        Assert.assertEquals((Object)"google", (Object)google.getProviderId());
        Assert.assertTrue((boolean)google.isEnabled());
        Assert.assertEquals((Object)"googleId", google.getConfig().get("clientId"));
        Assert.assertEquals((Object)"googleSecret", google.getConfig().get("clientSecret"));
        List fedProviders = realm.getUserFederationProviders();
        Assert.assertTrue((fedProviders.size() == 2 ? 1 : 0) != 0);
        UserFederationProviderRepresentation ldap1 = (UserFederationProviderRepresentation)fedProviders.get(0);
        Assert.assertEquals((Object)"MyLDAPProvider1", (Object)ldap1.getDisplayName());
        Assert.assertEquals((Object)"ldap", (Object)ldap1.getProviderName());
        Assert.assertEquals((long)1L, (long)ldap1.getPriority());
        Assert.assertEquals((Object)"ldap://foo", ldap1.getConfig().get("connectionUrl"));
        UserFederationProviderRepresentation ldap2 = (UserFederationProviderRepresentation)fedProviders.get(1);
        Assert.assertEquals((Object)"MyLDAPProvider2", (Object)ldap2.getDisplayName());
        Assert.assertEquals((Object)"ldap://bar", ldap2.getConfig().get("connectionUrl"));
        List fedMappers1 = realmRsc.userFederation().get(ldap1.getId()).getMappers();
        Assert.assertTrue((fedMappers1.size() == 1 ? 1 : 0) != 0);
        UserFederationMapperRepresentation fullNameMapper = (UserFederationMapperRepresentation)fedMappers1.iterator().next();
        Assert.assertEquals((Object)"FullNameMapper", (Object)fullNameMapper.getName());
        Assert.assertEquals((Object)"full-name-ldap-mapper", (Object)fullNameMapper.getFederationMapperType());
        Assert.assertEquals((Object)"cn", fullNameMapper.getConfig().get("ldap.full.name.attribute"));
        List fedMappers2 = realmRsc.userFederation().get(ldap2.getId()).getMappers();
        Assert.assertTrue((fedMappers2.size() > 3 ? 1 : 0) != 0);
        List allMappers = realm.getUserFederationMappers();
        Assert.assertEquals((long)allMappers.size(), (long)(fedMappers1.size() + fedMappers2.size()));
        Assert.assertNull((Object)testingClient.testing().getUserByUsernameFromFedProviderFactory(realm.getRealm(), "wburke"));
        AuthenticationFlowRepresentation clientFlow = testingClient.testing().getClientAuthFlow(realm.getRealm());
        Assert.assertEquals((Object)"clients", (Object)clientFlow.getAlias());
        Assert.assertNotNull((Object)realmRsc.flows().getFlow(clientFlow.getId()));
        Assert.assertTrue((realmRsc.flows().getExecutions(clientFlow.getAlias()).size() > 0 ? 1 : 0) != 0);
        AuthenticationFlowRepresentation resetFlow = testingClient.testing().getResetCredFlow(realm.getRealm());
        Assert.assertEquals((Object)"reset credentials", (Object)resetFlow.getAlias());
        Assert.assertNotNull((Object)realmRsc.flows().getFlow(resetFlow.getId()));
        Assert.assertTrue((realmRsc.flows().getExecutions(resetFlow.getAlias()).size() > 0 ? 1 : 0) != 0);
        List applicationMappers = application.getProtocolMappers();
        Assert.assertNotNull((Object)ExportImportUtil.findMapperByName(applicationMappers, "openid-connect", "username"));
        Assert.assertNotNull((Object)ExportImportUtil.findMapperByName(applicationMappers, "openid-connect", "email"));
        Assert.assertNotNull((Object)ExportImportUtil.findMapperByName(applicationMappers, "openid-connect", "given name"));
        Assert.assertNull((Object)ExportImportUtil.findMapperByName(applicationMappers, "openid-connect", "gss delegation credential"));
        Assert.assertEquals((long)1L, (long)otherApp.getProtocolMappers().size());
        List otherAppMappers = otherApp.getProtocolMappers();
        Assert.assertNull((Object)ExportImportUtil.findMapperByName(otherAppMappers, "openid-connect", "username"));
        ProtocolMapperRepresentation gssCredentialMapper = ExportImportUtil.findMapperByName(otherAppMappers, "openid-connect", "gss delegation credential");
        ExportImportUtil.assertGssProtocolMapper(gssCredentialMapper);
        List clientTemplates = realmRsc.clientTemplates().findAll();
        Assert.assertEquals((long)1L, (long)clientTemplates.size());
        ClientTemplateRepresentation clientTemplate = (ClientTemplateRepresentation)clientTemplates.get(0);
        Assert.assertEquals((Object)"foo-template", (Object)clientTemplate.getName());
        Assert.assertEquals((Object)"foo-template-desc", (Object)clientTemplate.getDescription());
        Assert.assertEquals((Object)"openid-connect", (Object)clientTemplate.getProtocol());
        Assert.assertEquals((long)1L, (long)clientTemplate.getProtocolMappers().size());
        List clientTemplateMappers = clientTemplate.getProtocolMappers();
        ProtocolMapperRepresentation templateGssCredentialMapper = ExportImportUtil.findMapperByName(clientTemplateMappers, "openid-connect", "gss delegation credential");
        ExportImportUtil.assertGssProtocolMapper(templateGssCredentialMapper);
        Set<RoleRepresentation> allClientTemplateScopes = ExportImportUtil.allScopeMappings(realmRsc.clientTemplates().get(clientTemplate.getId()));
        Assert.assertEquals((long)3L, (long)allClientTemplateScopes.size());
        Assert.assertTrue((boolean)ExportImportUtil.containsRole(allClientTemplateScopes, ExportImportUtil.findRealmRole(realmRsc, "admin")));
        Assert.assertTrue((boolean)ExportImportUtil.containsRole(allClientTemplateScopes, ExportImportUtil.findClientRole(realmRsc, application.getId(), "app-user")));
        Assert.assertTrue((boolean)ExportImportUtil.containsRole(allClientTemplateScopes, ExportImportUtil.findClientRole(realmRsc, application.getId(), "app-admin")));
        List<RoleRepresentation> clientTemplateRealmScopes = ExportImportUtil.realmScopeMappings(realmRsc.clientTemplates().get(clientTemplate.getId()));
        Assert.assertTrue((boolean)ExportImportUtil.containsRole(clientTemplateRealmScopes, ExportImportUtil.findRealmRole(realmRsc, "admin")));
        List<RoleRepresentation> clientTemplateAppScopes = ExportImportUtil.clientScopeMappings(realmRsc.clientTemplates().get(clientTemplate.getId()));
        Assert.assertTrue((boolean)ExportImportUtil.containsRole(clientTemplateAppScopes, ExportImportUtil.findClientRole(realmRsc, application.getId(), "app-user")));
        Assert.assertTrue((boolean)ExportImportUtil.containsRole(clientTemplateAppScopes, ExportImportUtil.findClientRole(realmRsc, application.getId(), "app-admin")));
        UserResource adminRsc = realmRsc.users().get(admin.getId());
        List consents = adminRsc.getConsents();
        Assert.assertEquals((long)2L, (long)consents.size());
        Map<String, Object> appAdminConsent = ExportImportUtil.findConsentByClientId(consents, application.getClientId());
        Assert.assertEquals((long)2L, (long)ExportImportUtil.calcNumberGrantedRoles(appAdminConsent));
        Assert.assertTrue((ExportImportUtil.getGrantedProtocolMappers(appAdminConsent) == null || ExportImportUtil.getGrantedProtocolMappers(appAdminConsent).isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)ExportImportUtil.isRealmRoleGranted(appAdminConsent, "admin"));
        Assert.assertTrue((boolean)ExportImportUtil.isClientRoleGranted(appAdminConsent, application.getClientId(), "app-admin"));
        Map<String, Object> otherAppAdminConsent = ExportImportUtil.findConsentByClientId(consents, otherApp.getClientId());
        Assert.assertEquals((long)1L, (long)ExportImportUtil.calcNumberGrantedRoles(otherAppAdminConsent));
        Assert.assertEquals((long)1L, (long)ExportImportUtil.getGrantedProtocolMappers(otherAppAdminConsent).size());
        Assert.assertTrue((boolean)ExportImportUtil.isRealmRoleGranted(otherAppAdminConsent, "admin"));
        Assert.assertFalse((boolean)ExportImportUtil.isClientRoleGranted(otherAppAdminConsent, application.getClientId(), "app-admin"));
        Assert.assertTrue((boolean)ExportImportUtil.isProtocolMapperGranted(otherAppAdminConsent, gssCredentialMapper));
        Assert.assertTrue((boolean)application.isStandardFlowEnabled());
        Assert.assertTrue((boolean)application.isImplicitFlowEnabled());
        Assert.assertTrue((boolean)application.isDirectAccessGrantsEnabled());
        Assert.assertFalse((boolean)otherApp.isStandardFlowEnabled());
        Assert.assertFalse((boolean)otherApp.isImplicitFlowEnabled());
        Assert.assertFalse((boolean)otherApp.isDirectAccessGrantsEnabled());
        Assert.assertFalse((boolean)application.isServiceAccountsEnabled());
        Assert.assertTrue((boolean)otherApp.isServiceAccountsEnabled());
        Assert.assertNull((Object)testingClient.testing().getUserByServiceAccountClient(realm.getRealm(), application.getClientId()));
        UserRepresentation linked = testingClient.testing().getUserByServiceAccountClient(realm.getRealm(), otherApp.getClientId());
        Assert.assertNotNull((Object)linked);
        Assert.assertEquals((Object)"my-service-user", (Object)linked.getUsername());
    }

    private static boolean isProtocolMapperGranted(Map<String, Object> consent, ProtocolMapperRepresentation mapperRep) {
        Map grantedMappers = (Map)consent.get("grantedProtocolMappers");
        if (grantedMappers == null) {
            return false;
        }
        List mappers = (List)grantedMappers.get(mapperRep.getProtocol());
        if (mappers == null) {
            return false;
        }
        return mappers.contains(mapperRep.getName());
    }

    private static boolean isRealmRoleGranted(Map<String, Object> consent, String roleName) {
        if (consent.get("grantedRealmRoles") == null) {
            return false;
        }
        return ((List)consent.get("grantedRealmRoles")).contains(roleName);
    }

    private static boolean isClientRoleGranted(Map<String, Object> consent, String clientId, String roleName) {
        if (consent.get("grantedClientRoles") == null) {
            return false;
        }
        Map grantedClientRoles = (Map)consent.get("grantedClientRoles");
        List rolesForClient = (List)grantedClientRoles.get(clientId);
        if (rolesForClient == null) {
            return false;
        }
        return rolesForClient.contains(roleName);
    }

    private static Map<String, List<String>> getGrantedProtocolMappers(Map<String, Object> consent) {
        return (Map)consent.get("grantedProtocolMappers");
    }

    private static int calcNumberGrantedRoles(Map<String, Object> consent) {
        Map clientRoles;
        int numGranted = 0;
        List realmRoles = (List)consent.get("grantedRealmRoles");
        if (realmRoles != null) {
            numGranted += realmRoles.size();
        }
        if ((clientRoles = (Map)consent.get("grantedClientRoles")) != null) {
            numGranted += clientRoles.size();
        }
        return numGranted;
    }

    private static Map<String, Object> findConsentByClientId(List<Map<String, Object>> consents, String clientId) {
        for (Map<String, Object> consent : consents) {
            if (!clientId.equals(consent.get("clientId"))) continue;
            return consent;
        }
        return null;
    }

    private static void assertGssProtocolMapper(ProtocolMapperRepresentation gssCredentialMapper) {
        Assert.assertEquals((Object)"gss delegation credential", (Object)gssCredentialMapper.getName());
        Assert.assertEquals((Object)"openid-connect", (Object)gssCredentialMapper.getProtocol());
        Assert.assertEquals((Object)"oidc-usersessionmodel-note-mapper", (Object)gssCredentialMapper.getProtocolMapper());
        String includeInAccessToken = (String)gssCredentialMapper.getConfig().get("access.token.claim");
        String includeInIdToken = (String)gssCredentialMapper.getConfig().get("id.token.claim");
        Assert.assertTrue((boolean)includeInAccessToken.equalsIgnoreCase("true"));
        Assert.assertTrue((includeInIdToken == null || !Boolean.parseBoolean(includeInIdToken) ? 1 : 0) != 0);
    }

    private static ProtocolMapperRepresentation findMapperByName(List<ProtocolMapperRepresentation> mappers, String type, String name) {
        for (ProtocolMapperRepresentation mapper : mappers) {
            if (!mapper.getProtocol().equals(type) || !mapper.getName().equals(name)) continue;
            return mapper;
        }
        return null;
    }

    private static boolean hasClient(List<ClientRepresentation> clients, ClientRepresentation client) {
        for (ClientRepresentation clientRep : clients) {
            if (!client.getId().equals(clientRep.getId())) continue;
            return true;
        }
        return false;
    }

    private static UserRepresentation findByUsername(RealmResource realmRsc, String username) {
        for (UserRepresentation user : realmRsc.users().search(null, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE))) {
            if (!user.getUsername().equalsIgnoreCase(username)) continue;
            return user;
        }
        return null;
    }

    private static Set<RoleRepresentation> allScopeMappings(ClientResource client) {
        HashSet<RoleRepresentation> allRoles = new HashSet<RoleRepresentation>();
        List<RoleRepresentation> realmRoles = ExportImportUtil.realmScopeMappings(client);
        if (realmRoles != null) {
            allRoles.addAll(realmRoles);
        }
        allRoles.addAll(ExportImportUtil.clientScopeMappings(client));
        return allRoles;
    }

    private static Set<RoleRepresentation> allScopeMappings(ClientTemplateResource client) {
        HashSet<RoleRepresentation> allRoles = new HashSet<RoleRepresentation>();
        List<RoleRepresentation> realmRoles = ExportImportUtil.realmScopeMappings(client);
        if (realmRoles != null) {
            allRoles.addAll(realmRoles);
        }
        allRoles.addAll(ExportImportUtil.clientScopeMappings(client));
        return allRoles;
    }

    private static List<RoleRepresentation> clientScopeMappings(ClientResource client) {
        LinkedList<RoleRepresentation> clientScopeMappings = new LinkedList<RoleRepresentation>();
        Map clientRoles = client.getScopeMappings().getAll().getClientMappings();
        if (clientRoles == null) {
            return clientScopeMappings;
        }
        for (String clientKey : clientRoles.keySet()) {
            List clientRoleScopeMappings = ((ClientMappingsRepresentation)clientRoles.get(clientKey)).getMappings();
            if (clientRoleScopeMappings == null) continue;
            clientScopeMappings.addAll(clientRoleScopeMappings);
        }
        return clientScopeMappings;
    }

    private static List<RoleRepresentation> clientScopeMappings(ClientTemplateResource client) {
        LinkedList<RoleRepresentation> clientScopeMappings = new LinkedList<RoleRepresentation>();
        Map clientRoles = client.getScopeMappings().getAll().getClientMappings();
        if (clientRoles == null) {
            return clientScopeMappings;
        }
        for (String clientKey : clientRoles.keySet()) {
            List clientRoleScopeMappings = ((ClientMappingsRepresentation)clientRoles.get(clientKey)).getMappings();
            if (clientRoleScopeMappings == null) continue;
            clientScopeMappings.addAll(clientRoleScopeMappings);
        }
        return clientScopeMappings;
    }

    private static List<RoleRepresentation> realmScopeMappings(ClientResource client) {
        return client.getScopeMappings().realmLevel().listAll();
    }

    private static List<RoleRepresentation> realmScopeMappings(ClientTemplateResource client) {
        return client.getScopeMappings().realmLevel().listAll();
    }

    private static Set<RoleRepresentation> allRoles(RealmResource realmRsc, UserRepresentation user) {
        UserResource userRsc = realmRsc.users().get(user.getId());
        HashSet<RoleRepresentation> roles = new HashSet<RoleRepresentation>();
        List realmRoles = userRsc.roles().getAll().getRealmMappings();
        if (realmRoles != null) {
            roles.addAll(realmRoles);
        }
        roles.addAll(ExportImportUtil.allClientRolesForUser(realmRsc, user));
        return roles;
    }

    private static List<RoleRepresentation> realmRolesForUser(RealmResource realmRsc, UserRepresentation user) {
        return realmRsc.users().get(user.getId()).roles().getAll().getRealmMappings();
    }

    private static List<RoleRepresentation> allClientRolesForUser(RealmResource realmRsc, UserRepresentation user) {
        UserResource userRsc = realmRsc.users().get(user.getId());
        LinkedList<RoleRepresentation> roles = new LinkedList<RoleRepresentation>();
        for (String client : userRsc.roles().getAll().getClientMappings().keySet()) {
            List clientRoles = ((ClientMappingsRepresentation)userRsc.roles().getAll().getClientMappings().get(client)).getMappings();
            if (clientRoles == null) continue;
            roles.addAll(clientRoles);
        }
        return roles;
    }

    private static List<RoleRepresentation> clientRolesForUser(RealmResource realmRsc, ClientRepresentation client, UserRepresentation user) {
        UserResource userRsc = realmRsc.users().get(user.getId());
        return userRsc.roles().clientLevel(client.getId()).listAll();
    }

    private static RoleRepresentation findRealmRole(RealmResource realmRsc, String roleName) {
        return realmRsc.roles().get(roleName).toRepresentation();
    }

    private static RoleRepresentation findClientRole(RealmResource realmRsc, String clientDbId, String roleName) {
        return realmRsc.clients().get(clientDbId).roles().get(roleName).toRepresentation();
    }

    private static boolean containsRole(Collection<RoleRepresentation> roles, RoleRepresentation role) {
        for (RoleRepresentation setRole : roles) {
            if (!setRole.getId().equals(role.getId())) continue;
            return true;
        }
        return false;
    }
}

