/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.exportimport;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.keycloak.Config;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.exportimport.ExportImportConfig;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ImpersonationConstants;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.testsuite.exportimport.AbstractExportImportTest;

public class LegacyImportTest
extends AbstractExportImportTest {
    @After
    public void after() {
        this.clearExportImportProperties();
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
    }

    @Ignore
    @Test
    public void importFrom11() throws LifecycleException {
        ExportImportConfig.setProvider((String)"singleFile");
        URL url = LegacyImportTest.class.getResource("/exportimport-test/kc11-exported-realm.json");
        String targetFilePath = new File(url.getFile()).getAbsolutePath();
        ExportImportConfig.setFile((String)targetFilePath);
        ExportImportConfig.setAction((String)"import");
        this.restartServer();
        ClientResource foo11AdminConsoleClient = this.adminClient.realm("foo11").clients().get("a9ca4217-74a8-4658-92c8-c2f9ed48a474");
        this.assertLocaleMapperPresent(foo11AdminConsoleClient);
        ClientResource masterAdminConsoleClient = this.adminClient.realm(Config.getAdminRealm()).clients().get("22ed594d-8c21-43f0-a080-c8879a411f94");
        this.assertLocaleMapperPresent(masterAdminConsoleClient);
        ClientResource foo11RealmManagementClient = this.adminClient.realm("foo11").clients().get("c7a9cf59-feeb-44a4-a467-e008e157efa2");
        List roles = foo11RealmManagementClient.roles().list();
        this.assertRolesAvailable(roles);
        Set realmAdminComposites = foo11RealmManagementClient.roles().get(AdminRoles.REALM_ADMIN).getRoleComposites();
        this.assertRolesAvailable(realmAdminComposites);
        ClientResource foo11MasterAdminClient = this.adminClient.realm(Config.getAdminRealm()).clients().get("c9c3bd5f-b69d-4640-8b27-45d4f3866a36");
        roles = foo11MasterAdminClient.roles().list();
        this.assertRolesAvailable(roles);
        Set masterAdminComposites = this.adminClient.realm(Config.getAdminRealm()).roles().get(AdminRoles.ADMIN).getRoleComposites();
        this.assertRolesAvailable(masterAdminComposites);
    }

    private void assertLocaleMapperPresent(ClientResource client) {
        List protMappers = client.getProtocolMappers().getMappersPerProtocol("openid-connect");
        for (ProtocolMapperRepresentation protMapper : protMappers) {
            if (!protMapper.getName().equals("locale")) continue;
            return;
        }
        Assert.fail((String)"Locale mapper not found for client");
    }

    private void assertRolesAvailable(Collection<RoleRepresentation> roles) {
        this.assertRoleAvailable(roles, AdminRoles.VIEW_IDENTITY_PROVIDERS);
        this.assertRoleAvailable(roles, AdminRoles.MANAGE_IDENTITY_PROVIDERS);
        this.assertRoleAvailable(roles, AdminRoles.CREATE_CLIENT);
        this.assertRoleAvailable(roles, ImpersonationConstants.IMPERSONATION_ROLE);
    }

    private RoleRepresentation assertRoleAvailable(Collection<RoleRepresentation> roles, String roleName) {
        for (RoleRepresentation role : roles) {
            if (!role.getName().equals(roleName)) continue;
            return role;
        }
        Assert.fail((String)("Role " + roleName + " not found"));
        return null;
    }
}

